/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.materialplan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.ControlUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MaterialPlanEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String DYNAMIC_CYCLE = "dynamiccycle";
    private static final String FIXED_PERIOD = "fixedperiod";
    private static final String SPEC_PERIOD = "specifiedperiod";
    private static final String POLICY = "lotpolicy";
    private static final String USERORG = "useorg";
    private static final String PAGECACHE_USEORG = "createOrg";
    private static final String MATERIAL_ATTR = "materialattr";
    private static final String PLAN_ISLOG = "plan_islog";
    public static final String OPENFROMMATERIAL = "openFromMaterial";
    public static final String PROP_SHOWCREATEORG = "showcreateorg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit operatorEdit = (BasedataEdit)this.getView().getControl("operator");
        operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        if (this.getView().getControl("masterid") != null) {
            BasedataEdit masterBeaseEdit = (BasedataEdit)this.getView().getControl("masterid");
            masterBeaseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getView().getControl("materialplan") != null) {
            BasedataEdit materialplanEdit = (BasedataEdit)this.getView().getControl("materialplan");
            materialplanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit entryOperator = (BasedataEdit)this.getView().getControl("entry_operator");
        entryOperator.addBeforeF7SelectListener(this::entryOperatorBeforeF7Select);
        BasedataEdit entrySupplyNetwork = (BasedataEdit)this.getView().getControl("entry_supplynetwork");
        entrySupplyNetwork.addBeforeF7SelectListener(this::entrySupplyNetworkBeforeF7Select);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        String key = basedataEdit.getKey();
        if ("operator".equals(key)) {
            HashSet<Long> set = new HashSet<Long>();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id,entryentity.operator operator", (QFilter[])this.getOperatorF7Filters().toArray(new QFilter[0]));
            for (DynamicObject obj : col) {
                set.add(obj.get("operator") == null ? 0L : obj.getLong("operator"));
            }
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter filter = new QFilter("id", "in", set);
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("masterid".equals(key)) {
            QFilter configpropertiesFilter = new QFilter("configproperties", "!=", (Object)Character.valueOf('3'));
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(configpropertiesFilter);
        } else if ("materialplan".equals(key)) {
            DynamicObject masterid = (DynamicObject)this.getModel().getValue("masterid");
            if (masterid == null) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"MaterialPlanEditPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter notIdFilter = new QFilter("id", "!=", masterid.getPkValue());
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(notIdFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isSuccess;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (op == null) {
            return;
        }
        String key = op.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"save")) {
            op.getOption().setVariableValue(PLAN_ISLOG, PLAN_ISLOG);
        }
        if ((StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"save") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"submit")) && !(isSuccess = this.handlePlanScopeEntryChangedSave())) {
            args.setCancel(true);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject mat;
        super.afterImportData(e);
        String importtype = (String)e.getOption().get("importtype");
        IDataModel model = this.getModel();
        long id = (Long)model.getDataEntity().getPkValue();
        boolean fromDatabase = model.getDataEntity().getDataEntityState().getFromDatabase();
        if (id != 0L && fromDatabase && ("overridenew".equals(importtype) || "override".equals(importtype)) && (mat = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)model.getDataEntity().getDataEntityType().getName())) != null && mat.get("masterid") != null) {
            Long oldMasterid = this.getDataId(mat.get("masterid"));
            DynamicObject material = model.getDataEntity().getDynamicObject("masterid");
            String number = material.getString("number");
            Long newMasterid = this.getDataId(material);
            if (!newMasterid.equals(oldMasterid)) {
                String error = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801%s\u524d\u540e\u4e0d\u4e00\u6837\uff0c\u8bf7\u4fdd\u6301\u7269\u6599\u4e00\u6837\u3002", (String)"MaterialPlanEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number);
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), error);
            }
        }
    }

    public Long getDataId(Object object) {
        Long dataid = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject data = (DynamicObject)object;
            dataid = data.getLong("id");
        } else if (object instanceof Long) {
            dataid = (Long)object;
        }
        return dataid;
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{SPEC_PERIOD});
        FormShowParameter lsp = this.getView().getFormShowParameter();
        if (lsp == null) {
            return;
        }
        if (lsp.getCustomParam(OPENFROMMATERIAL) instanceof Boolean) {
            boolean openFromMaterial = (Boolean)lsp.getCustomParam(OPENFROMMATERIAL);
            if (!openFromMaterial) {
                return;
            }
            this.setInitializeData(lsp);
        }
    }

    private void setInitializeData(FormShowParameter lsp) {
        Object useOrgId = lsp.getCustomParam(USERORG);
        this.getPageCache().put(PAGECACHE_USEORG, useOrgId.toString());
        this.getModel().beginInit();
        this.getModel().setValue(PROP_SHOWCREATEORG, useOrgId);
        this.getModel().endInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadMaterialScopeInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        HashSet<String> refreshMaterialPlanScopeOpSet = new HashSet<String>(4);
        refreshMaterialPlanScopeOpSet.add("audit");
        refreshMaterialPlanScopeOpSet.add("unaudit");
        refreshMaterialPlanScopeOpSet.add("submit");
        refreshMaterialPlanScopeOpSet.add("unsubmit");
        String operateKey = args.getOperateKey();
        if (refreshMaterialPlanScopeOpSet.contains(operateKey)) {
            this.loadMaterialScopeInfo();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        ArrayList<String> list = new ArrayList<String>();
        list.add(DYNAMIC_CYCLE);
        list.add(FIXED_PERIOD);
        list.add(SPEC_PERIOD);
        String name = e.getProperty().getName().toLowerCase();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (list.remove(name) && !this.isEmpty(newValue = e.getChangeSet()[0].getNewValue()).booleanValue()) {
            boolean cleared = false;
            for (String s : list) {
                Object value = model.getValue(s);
                if (!this.isEmpty(value).booleanValue()) {
                    cleared = true;
                }
                model.setValue(s, null);
            }
            if (cleared) {
                view.showTipNotification(ResManager.loadKDString((String)"\u52a8\u6001\u5468\u671f\u3001\u56fa\u5b9a\u5468\u671f\u3001\u6307\u5b9a\u5468\u671f\u4e09\u8005\u53ea\u5141\u8bb8\u586b\u4e00\u4e2a\u3002", (String)"MaterialPlanEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        }
        block5 : switch (name) {
            case "lotpolicy": {
                String newValue2 = (String)e.getChangeSet()[0].getNewValue();
                view.setEnable(Boolean.valueOf("C".equals(newValue2)), new String[]{SPEC_PERIOD, DYNAMIC_CYCLE, FIXED_PERIOD});
                model.setValue(SPEC_PERIOD, null);
                model.setValue("partitionbase", null);
                model.setValue("batchqty", null);
                break;
            }
            case "masterid": {
                DynamicObject material = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject createorg = (DynamicObject)this.getModel().getValue("createorg");
                QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
                QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
                QFilter qFilterMaterials = new QFilter("masterid", "=", material.getPkValue());
                QFilter qFilterCreateorg = new QFilter("createorg", "=", createorg.getPkValue());
                QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterials, qFilterCreateorg};
                Map materialmftinfos = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)"id,masterid,materialattr,createorg", (QFilter[])filters);
                for (DynamicObject materialmftinfo : materialmftinfos.values()) {
                    DynamicObject mftmaterial = materialmftinfo.getDynamicObject("masterid");
                    DynamicObject mftCreateorg = materialmftinfo.getDynamicObject("createorg");
                    if (!material.getPkValue().equals(mftmaterial.getPkValue()) || !createorg.getPkValue().equals(mftCreateorg.getPkValue())) continue;
                    this.getModel().setValue(MATERIAL_ATTR, (Object)materialmftinfo.getString(MATERIAL_ATTR));
                    break block5;
                }
                break;
            }
            case "materialattr": {
                this.setEntrySupplyNetworkVisibleAndLock();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List<String> propertiesSrc = Arrays.asList("entry_planscope_name", "entry_plantype", "entry_operator", "entry_supplynetwork", "entry_is_used", "entry_matplanscopid", "entry_planscopeid");
        ControlUtil.setEntryFieldBizChanged((DynamicObject)dataEntity, (String)"entry", propertiesSrc);
    }

    private Boolean isEmpty(Object newValue) {
        if (newValue == null) {
            return true;
        }
        if (newValue instanceof BigDecimal) {
            return ((BigDecimal)newValue).compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    private void loadMaterialScopeInfo() {
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        DynamicObject material = (DynamicObject)this.getModel().getValue("masterid");
        if (createOrg != null && material != null) {
            this.getModel().deleteEntryData("entry");
            QFilter[] filters = new QFilter[]{new QFilter("createorg", "=", createOrg.getPkValue()), new QFilter("material", "=", material.getPkValue()), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
            String select = "id,entrymatplanscop.planscope.id planscopeid,entrymatplanscop.planscope.name planscope_name,entrymatplanscop.plantype plantype,entrymatplanscop.operator operator,entrymatplanscop.supplynetwork supplynetwork,entrymatplanscop.reorder reorder,entrymatplanscop.max max,entrymatplanscop.min min,entrymatplanscop.consexterneeds consexterneeds,entrymatplanscop.start_useing start_useing";
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[]{"seq", "entry_planscope_name", "entry_plantype", "entry_operator", "entry_supplynetwork", "entry_is_used", "entry_matplanscopid", "entry_reorder", "entry_max", "entry_min", "entry_consexterneeds", "entry_planscopeid"});
            int seq = 1;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"msplan_matplanscop", (String)select, (QFilter[])filters, null);){
                for (Row row : dataSet) {
                    vs.addRow(new Object[]{seq++, row.get("planscope_name"), row.get("plantype"), row.get("operator"), row.get("supplynetwork"), row.get("start_useing"), row.get("id"), row.get("reorder"), row.get("max"), row.get("min"), row.get("consexterneeds"), row.get("planscopeid")});
                }
            }
            model.batchCreateNewEntryRow("entry", vs);
            model.endInit();
            this.getView().updateView("entry");
            this.setEntrySupplyNetworkVisibleAndLock();
        }
    }

    private void setEntrySupplyNetworkVisibleAndLock() {
        String materialAttr = (String)this.getModel().getValue(MATERIAL_ATTR);
        this.getView().updateView("entry");
        if ("10060".equals(materialAttr)) {
            DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entry");
            for (int i = 0; i < entry.size(); ++i) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"entry_supplynetwork"});
            }
        } else {
            DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entry");
            for (int i = 0; i < entry.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"entry_supplynetwork"});
                this.getModel().setValue("entry_supplynetwork", null, i);
            }
        }
    }

    private boolean handlePlanScopeEntryChangedSave() {
        Map<String, String> modifiableFieldMap = this.getModifiableMaterialPlanScopeFieldMap();
        int size = this.getModel().getEntryRowCount("entry");
        if (size <= 0) {
            return true;
        }
        long materialPlanScopeId = (Long)this.getModel().getValue("entry_matplanscopid", 0);
        if (materialPlanScopeId <= 0L || !QueryServiceHelper.exists((String)"msplan_matplanscop", (Object)materialPlanScopeId)) {
            return true;
        }
        DynamicObject materialPlanScope = BusinessDataServiceHelper.loadSingle((Object)materialPlanScopeId, (String)"msplan_matplanscop");
        DynamicObjectCollection materialPlanScopeEntry = materialPlanScope.getDynamicObjectCollection("entrymatplanscop");
        boolean isChange = false;
        for (int i = 0; i < size; ++i) {
            long planScopeId = (Long)this.getModel().getValue("entry_planscopeid", i);
            for (DynamicObject row : materialPlanScopeEntry) {
                long rowPlanScopeId = row.getLong("planscope_id");
                if (rowPlanScopeId != planScopeId) continue;
                for (Map.Entry<String, String> fieldEntry : modifiableFieldMap.entrySet()) {
                    Object newValue = this.getModel().getValue(fieldEntry.getKey(), i);
                    String materialPlanScopeField = fieldEntry.getValue();
                    Object oldValue = row.get(materialPlanScopeField);
                    if (Objects.equals(oldValue, newValue)) continue;
                    row.set(materialPlanScopeField, newValue);
                    isChange = true;
                }
            }
        }
        if (isChange) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("updateByMaterialPlan", "true");
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)"msplan_matplanscop", (DynamicObject[])new DynamicObject[]{materialPlanScope}, (OperateOption)operateOption);
            if (saveResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7269\u6599\u4e0e\u8ba1\u5212\u8303\u56f4\u5173\u7cfb\u8868\u540c\u6b65\u4fee\u6539\u6210\u529f\u3002", (String)"MaterialPlanEditPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                String errMsg = saveResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining("\n"));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u4e0e\u8ba1\u5212\u8303\u56f4\u5173\u7cfb\u8868\u540c\u6b65\u4fee\u6539\u5931\u8d25\uff1a\n%s", (String)"MaterialPlanEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errMsg));
                return false;
            }
        }
        return true;
    }

    private Map<String, String> getModifiableMaterialPlanScopeFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(4);
        fieldMap.put("entry_plantype", "plantype");
        fieldMap.put("entry_operator", "operator");
        fieldMap.put("entry_supplynetwork", "supplynetwork");
        fieldMap.put("entry_is_used", "start_useing");
        fieldMap.put("entry_reorder", "reorder");
        fieldMap.put("entry_max", "max");
        fieldMap.put("entry_min", "min");
        fieldMap.put("entry_consexterneeds", "consexterneeds");
        return fieldMap;
    }

    private List<QFilter> getOperatorF7Filters() {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        QFilter qFilter = new QFilter("createorg", ">", (Object)0L);
        if (createOrg != null) {
            qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)createOrg.getLong("id"));
        }
        QFilter qFilter1 = new QFilter("operatorgrouptype", "=", (Object)"JHZ");
        QFilter qFilter2 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter qFilter3 = new QFilter("entryentity.invalid", "=", (Object)false);
        qFilterList.add(qFilter);
        qFilterList.add(qFilter1);
        qFilterList.add(qFilter2);
        qFilterList.add(qFilter3);
        return qFilterList;
    }

    private void entryOperatorBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObjectCollection value = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"entryentity.operator.id", (QFilter[])this.getOperatorF7Filters().toArray(new QFilter[0]));
        List operatorIdList = value.stream().map(v -> v.getLong("entryentity.operator.id")).collect(Collectors.toList());
        e.addCustomQFilter(new QFilter("id", "in", operatorIdList));
    }

    private void entrySupplyNetworkBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        if (createOrg != null) {
            long id = createOrg.getLong("id");
            QFilter qFilter = new QFilter("createorg", "=", (Object)id);
            e.addCustomQFilter(qFilter);
        }
    }
}

