/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.materialplan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.MaterialStandardUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.TemplateGroupBaseDataPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MaterialPlanTreeListPlugin
extends TemplateGroupBaseDataPlugin {
    private static Log logger = LogFactory.getLog(MaterialPlanTreeListPlugin.class);
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String PROP_STANDARDLST = "cmbstandardlst";
    private static final String NO_GROUP = "1";
    private static final String PROP_STANDARD = "standard";
    private static final String ENTITY_MATERIAL = "bd_material";
    private static final String ENTITY_GROUP = "group";
    private static final String ENTITY_GROUPSTANDARD = "groupstandard";
    private static final String ENTITY_GROUPDETAIL = "groupdetail";
    private static final String PROP_PARENT = "parent";
    private static final String PROP_MATERIAL = "material";
    private static final String PROP_GROUP = "group";
    public static final String PROP_ID = "id";
    private static final String MASTERID = "masterid";
    public static final String PROP_LONGNUMBER = "longnumber";
    public static final String PROP_ENABLE = "enable";
    public static final String DEFGROUPSTANDARD = "730148448254487552";
    public static final String ORG = "org";
    public static final String AP_BILL_LIST = "billlistap";
    public static final String FLAG_COLSELOWER = "false";
    public static final String CP_GROUPSTANDARD = "groupStandard";
    public static final String PARAM_INIT_GROUP_ID = "initGROUPId";
    private static final String USEORG_FILEDNAME = "useorg.id";
    private static final String OP_OPEN = "btn_open";
    private static final String PGCACHE_CREATEORG = "createOrg";
    public static final String PGCACHE_CREATEORGS = "createOrgs";
    public static final String PGCACHE_PARENTCREATEORG = "orgs";
    public static final String TEXTFORMAT_NAME = "{name}";
    public static final String TEXTFORMAT_CODE = "{code}";
    public static final String ISSHOWALLNOORG = "isShowAllNoOrg";
    public static final String ISSHOWALLNOORG_TRUE = "true";
    public static final String ENTITY_MATERIALGROUP = "bd_materialgroup";
    private static final String BATCHUPDFIELD = "batchupdfield";
    private static final String BATCHUPDFIELDIDS = "batchupdfieldids";
    private static final String MPDM_BATCHUPDFIELD = "mpdm_batchupdfield";
    private static final String MPDM_PLANUPT_DATELOG = "mpdm_planupt_datelog";
    private static final String UPDATELOG = "updatelog";

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (BATCHUPDFIELD.equals(args.getOperateKey()) && result != null && result.isSuccess()) {
            List successPkIds = result.getSuccessPkIds();
            if (successPkIds == null || successPkIds.isEmpty()) {
                return;
            }
            this.batchUpdFieldData(successPkIds);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        DynamicObject org;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (op == null) {
            return;
        }
        String useOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        Long useOrgId = StringUtils.isNotBlank((CharSequence)useOrg) ? Long.parseLong(useOrg) : 0L;
        String orgName = "";
        if (useOrgId > 0L && (org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)useOrgId)})) != null) {
            orgName = org.getString("name");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)(key = op.getOperateKey()), (CharSequence)BATCHUPDFIELD)) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u3002", (String)"MaterialPlanTreeListPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[]{orgName});
            this.checkCreateOrgIsCurrentOrg(e, msg, useOrgId, orgName);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)UPDATELOG)) {
            this.beforeUpdateLog(e);
        }
    }

    private void checkCreateOrgIsCurrentOrg(BeforeDoOperationEventArgs args, String msg, Long useOrgId, String orgName) {
        DynamicObject[] dyCols;
        BillList billList = (BillList)this.getView().getControl(AP_BILL_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        String billFormId = billList.getEntityId();
        HashMap<Long, String> errmsg = new HashMap<Long, String>(16);
        HashMap<Long, String> idNumberMap = new HashMap<Long, String>(16);
        ArrayList<Object> ids = new ArrayList<Object>(rows.size());
        ArrayList<Object> successPkIds = new ArrayList<Object>(rows.size());
        int m = 0;
        int n = 0;
        for (ListSelectedRow row : rows) {
            long createOrgId = row.getMainOrgId();
            String number = row.getNumber();
            Long id = Long.valueOf(row.getPrimaryKeyValue().toString());
            ids.add(row.getPrimaryKeyValue());
            idNumberMap.put(id, number);
            if (createOrgId != useOrgId) {
                errmsg.put(id, number.concat("\uff1a").concat(msg));
                args.setCancel(true);
                ++m;
                continue;
            }
            successPkIds.add(row.getPrimaryKeyValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter(PROP_ID, "in", ids)};
        for (DynamicObject dyCol : dyCols = BusinessDataServiceHelper.load((String)billFormId, (String)"id,enable", (QFilter[])filters)) {
            Long id = dyCol.getLong(PROP_ID);
            Boolean enable = dyCol.getBoolean(PROP_ENABLE);
            String number = (String)idNumberMap.get(id);
            if (enable.booleanValue()) continue;
            successPkIds.remove(id);
            String error = String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u72b6\u6001\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u3002", (String)"MaterialPlanTreeListPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number);
            String err = errmsg.getOrDefault(id, "");
            errmsg.put(id, err.concat(error));
            args.setCancel(true);
            ++n;
        }
        String idsStr = SerializationUtils.toJsonString(successPkIds);
        this.getPageCache().put(BATCHUPDFIELDIDS, idsStr);
        if (errmsg.size() == rows.size() && errmsg.size() <= 1) {
            String error = "";
            for (String errorvalue : errmsg.values()) {
                error = error.concat(errorvalue);
            }
            this.getView().showErrorNotification(error);
            return;
        }
        if (errmsg.size() == rows.size() && errmsg.size() >= 1) {
            StringBuilder errStr = new StringBuilder();
            for (String err : errmsg.values()) {
                errStr.append(err).append("\r\n");
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u5931\u8d25", (String)"MaterialPlanTreeListPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errStr.toString(), MessageTypes.Default);
            return;
        }
        if (errmsg.size() != rows.size() && errmsg.size() >= 1) {
            StringBuilder errStr = new StringBuilder();
            if (n > 0) {
                errStr.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u72b6\u6001\u4e3a\u7981\u7528\u7684\u6570\u636e", (String)"MaterialPlanTreeListPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), n));
            }
            if (m > 0 && n > 0) {
                errStr.append("\uff0c");
            }
            if (m > 0) {
                errStr.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728%1$s\u6761\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7", (String)"MaterialPlanTreeListPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), m, orgName));
            }
            errStr.append(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\u6279\u91cf\u4fee\u6539\u5176\u4ed6\u6570\u636e?", (String)"MaterialPlanTreeListPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\uff0c"));
            this.getView().showConfirm(errStr.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BATCHUPDFIELD, (IFormPlugin)this));
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BATCHUPDFIELD.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String idsStr = this.getPageCache().get(BATCHUPDFIELDIDS);
            List ids = (List)SerializationUtils.fromJsonString((String)idsStr, List.class);
            this.batchUpdFieldData(ids);
        }
    }

    private void beforeUpdateLog(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MaterialPlanTreeListPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        IFormView view = this.getView();
        ArrayList<Long> planinfoIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            planinfoIds.add(Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        filters.add(new QFilter("planinfoid", "in", planinfoIds));
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(MPDM_PLANUPT_DATELOG);
        view.showForm((FormShowParameter)listShowParameter);
    }

    private void batchUpdFieldData(List<Object> successPkIds) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        BillList billList = (BillList)this.getControl(AP_BILL_LIST);
        String billFormId = billList.getEntityId();
        customParams.put(BATCHUPDFIELD, successPkIds);
        customParams.put("entitynumber", billFormId);
        String useOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        customParams.put("useorg", useOrg);
        this.showView(MPDM_BATCHUPDFIELD, customParams, BATCHUPDFIELD, ShowType.Modal, null);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String key = event.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)BATCHUPDFIELD, (CharSequence)key) && event.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MaterialPlanTreeListPlugin_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            this.getView().invokeOperation("refresh");
            BillList list = (BillList)this.getView().getControl(AP_BILL_LIST);
            list.putSelectedRows(selectedRows);
            list.activeView(this.getView().getPageId());
        }
    }

    private void showView(String formId, Map<String, Object> customParams, String callBackKey, ShowType type, String CALLBACK) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        showParameter.getOpenStyle().setShowType(type);
        if (CALLBACK != null) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK));
        }
        this.getView().showForm(showParameter);
    }

    private QFilter genRefreshFilter(String nodeId) {
        Object value;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = ENTITY_MATERIAL;
        String groupStandardPK = "";
        if (entity.equals(ENTITY_MATERIAL)) {
            groupStandardPK = DEFGROUPSTANDARD;
        }
        if ((value = this.getModel().getValue(PROP_STANDARDLST)) == null) {
            value = Long.valueOf(groupStandardPK);
        } else if (StringUtils.isBlank((Object)value)) {
            return new QFilter(PROP_ID, "in", new ArrayList());
        }
        QFilter qFilter = null;
        Set<Long> useOrgs = this.getUseOrgs(param, entity, value.toString());
        if (!param.isLookUp() && useOrgs.isEmpty()) {
            return new QFilter(PROP_ID, "in", new ArrayList());
        }
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = ROOTNODEID;
        }
        Set<Long> orgs = this.getorgAndParentOrg(entity, useOrgs);
        String isShowAllNoOrg = (String)param.getCustomParam(ISSHOWALLNOORG);
        if (orgs.size() <= 0) {
            isShowAllNoOrg = ISSHOWALLNOORG_TRUE;
        }
        if (!ROOTNODEID.equals(nodeId)) {
            QFilter groupFilter;
            Object iscontainlower = null;
            if (param.isLookUp()) {
                iscontainlower = this.getModel().getValue("iscontainlower");
            }
            if (StringUtils.isNotBlank(iscontainlower) && FLAG_COLSELOWER.equals(iscontainlower)) {
                groupFilter = new QFilter("group", "=", (Object)Long.valueOf(nodeId));
            } else {
                List groupIds = !ISSHOWALLNOORG_TRUE.equals(isShowAllNoOrg) ? MaterialStandardUtils.queryGroupsByGroupId((String)entity, (Object)value, (Object)nodeId, orgs) : MaterialStandardUtils.queryGroupsByGroupId((String)entity, (Object)value, (Object)nodeId);
                groupFilter = new QFilter("group", "in", (Object)groupIds);
            }
            DynamicObjectCollection col = QueryServiceHelper.query((String)(entity + ENTITY_GROUPDETAIL), (String)PROP_MATERIAL, (QFilter[])new QFilter[]{groupFilter});
            ArrayList<Object> ids = new ArrayList<Object>(col.size());
            for (int i = 0; i < col.size(); ++i) {
                ids.add(((DynamicObject)col.get(i)).get(PROP_MATERIAL));
            }
            qFilter = new QFilter(MASTERID, "in", ids);
        }
        return qFilter;
    }

    private List<Map<String, Object>> getComData() {
        Map bizMap;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String isShowAllNoOrg = (String)param.getCustomParam(ISSHOWALLNOORG);
        String defGroupStandard = this.getDefGroupStandard(param, ENTITY_MATERIAL);
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        Set<Long> createOrgs = this.getCreateOrgs(param, ENTITY_MATERIAL, defGroupStandard, createOrg);
        this.getPageCache().put(PGCACHE_CREATEORGS, SerializationUtils.toJsonString(createOrgs));
        Set orgs = MaterialStandardUtils.getGroupOrgId((String)ENTITY_MATERIAL, createOrgs);
        this.getPageCache().put(PGCACHE_PARENTCREATEORG, SerializationUtils.toJsonString((Object)orgs));
        Set<Long> groupStandard = new HashSet<Long>();
        if (StringUtils.isBlank((CharSequence)defGroupStandard)) {
            if (!createOrgs.isEmpty()) {
                groupStandard = MaterialStandardUtils.getGroupStandard((String)ENTITY_MATERIAL, createOrgs, (boolean)true);
                if (groupStandard == null || groupStandard.size() == 0) {
                    return new ArrayList<Map<String, Object>>(0);
                }
            } else {
                isShowAllNoOrg = ISSHOWALLNOORG_TRUE;
            }
        } else {
            groupStandard.add(Long.parseLong(defGroupStandard));
        }
        if (groupStandard == null || groupStandard.size() == 0) {
            groupStandard.add(730148448254487552L);
        }
        QFilter idFilter = new QFilter(PROP_ID, "in", groupStandard);
        QFilter[] filters = new QFilter[]{idFilter};
        if (ISSHOWALLNOORG_TRUE.equals(isShowAllNoOrg)) {
            QFilter f2 = new QFilter(PROP_ENABLE, "=", (Object)NO_GROUP);
            filters = new QFilter[]{f2};
        }
        if ((bizMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupstandard", (String)"id,number,name", (QFilter[])filters)) == null || bizMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> listStandard = new ArrayList<Map<String, Object>>(bizMap.size());
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject dyStandard = (DynamicObject)entry.getValue();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PROP_ID, dyStandard.get(PROP_ID).toString());
            map.put("name", dyStandard.get("name").toString());
            listStandard.add(map);
        }
        return listStandard;
    }

    private String getDefGroupStandard(ListShowParameter param, String entity) {
        String defGroupStandard = "";
        if (!param.isLookUp()) {
            return defGroupStandard;
        }
        if (param.getCustomParam(CP_GROUPSTANDARD) != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam(CP_GROUPSTANDARD).toString())) {
            defGroupStandard = param.getCustomParam(CP_GROUPSTANDARD).toString();
            boolean exists = QueryServiceHelper.exists((String)(entity + ENTITY_GROUPSTANDARD), (Object)defGroupStandard);
            if (!exists) {
                defGroupStandard = "";
            }
        }
        return defGroupStandard;
    }

    private Set<Long> getCreateOrgs(ListShowParameter param, String entity, String defGroupStandard, String createOrg) {
        HashSet<Long> createOrgs = null;
        if (param.isLookUp()) {
            long createOrgId;
            Map customParams = param.getCustomParams();
            List creates = (List)customParams.get("useOrgs");
            if (creates != null && !creates.isEmpty()) {
                createOrgs = new HashSet(creates);
            }
            if (StringUtils.isBlank((CharSequence)(createOrg = (String)customParams.get("useOrg"))) && (createOrgId = ((ListShowParameter)this.getView().getFormShowParameter()).getUseOrgId()) != 0L) {
                createOrg = createOrgId + "";
            }
        } else if (StringUtils.isBlank((CharSequence)createOrg)) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String appNumber = listShowParameter.getAppId();
            String entityNumber = listShowParameter.getBillFormId();
            DynamicObjectCollection col = MaterialStandardUtils.getMaterialOrg((String)entityNumber, (String)appNumber);
            createOrg = this.getDefaultUseOrg(col);
        }
        if (createOrgs == null || createOrgs.isEmpty()) {
            createOrgs = new HashSet<Long>();
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                return createOrgs;
            }
            createOrgs.add(Long.valueOf(createOrg));
        }
        return createOrgs;
    }

    public void search(SearchEnterEvent evt) {
        List<Object> treeNodes;
        String searchText = evt.getText();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = param.getBillFormId();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = this.getSearchGroup(searchText, entity);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"MaterialPlanTreeListPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        } else {
            TreeView treeView = this.getTreeListView().getTreeView();
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    String parentId = treeNode.getParentid();
                    List<String> parentIds = new ArrayList<String>();
                    if (ROOTNODEID.equals(parentId)) {
                        parentIds.add("0");
                    } else {
                        parentIds = this.getParentGroupId(parentId, parentIds, entity);
                    }
                    if (parentIds.size() <= 1) {
                        treeView.showNode(treeNodes.get(indexCache).getParentid());
                        treeView.focusNode(treeNodes.get(indexCache));
                        treeView.treeNodeClick(treeNodes.get(indexCache).getParentid(), treeNodes.get(indexCache).getId());
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    } else {
                        for (int i = parentIds.size(); i >= 1; --i) {
                            if (i == 1) {
                                treeView.showNode(parentIds.get(i - 1));
                                treeView.focusNode(treeNodes.get(indexCache));
                                treeView.treeNodeClick(treeNodes.get(indexCache).getParentid(), treeNodes.get(indexCache).getId());
                                break;
                            }
                            treeView.showNode(parentIds.get(i - 1));
                            treeView.treeNodeClick(parentIds.get(i - 1), parentIds.get(i - 2));
                        }
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22", (String)"MaterialPlanTreeListPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                treeView.treeNodeClick(treeNodes.get(0).getParentid(), treeNodes.get(0).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    private List<TreeNode> getSearchGroup(String searchText, String entity) {
        String value = (String)this.getModel().getValue(PROP_STANDARDLST);
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        QFilter qFilter = new QFilter(PROP_STANDARD, "=", (Object)Long.valueOf(value));
        QFilter qFilter2 = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        QFilter qFilter3 = new QFilter(PROP_ENABLE, "=", (Object)NO_GROUP);
        Set<Long> useOrgs = this.getUseOrgs(param, entity, value);
        Set<Long> orgs = this.getorgAndParentOrg(entity, useOrgs);
        QFilter qFilter4 = new QFilter("createorg", "in", orgs);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)ENTITY_MATERIALGROUP, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter3, qFilter4}, (String)"number");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(loadFromCache.size());
        for (DynamicObject group : loadFromCache.values()) {
            if (group.getPkValue() == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getPkValue().toString());
            treeNode.setParentid(group.get(PROP_PARENT) == null ? ROOTNODEID : group.getDynamicObject(PROP_PARENT).getPkValue().toString());
            treeNode.setLongNumber(group.getString(PROP_LONGNUMBER));
            treeNode = this.getLocaleStringName(group, "", treeNode);
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    protected TreeNode getLocaleStringName(DynamicObject group, String textFormat, TreeNode treeNode) {
        String name = group.getLocaleString("name").getLocaleValue();
        String number = group.getString("number");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = group.getString("name");
        }
        String text = textFormat;
        if (StringUtils.isNotBlank((CharSequence)textFormat)) {
            if (textFormat.contains(TEXTFORMAT_NAME) && StringUtils.isNotBlank((CharSequence)name)) {
                text = text.replace(TEXTFORMAT_NAME, name);
            }
            if (textFormat.contains(TEXTFORMAT_CODE) && StringUtils.isNotBlank((CharSequence)number)) {
                text = text.replace(TEXTFORMAT_CODE, number);
            }
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            treeNode.setText(name);
        } else {
            treeNode.setText(text);
        }
        return treeNode;
    }

    protected Set<Long> getorgAndParentOrg(String entity, Set<Long> useOrgs) {
        Set<Long> orgs = new HashSet<Long>();
        String orgsStr = this.getPageCache().get(PGCACHE_PARENTCREATEORG);
        if (StringUtils.isNotBlank((CharSequence)orgsStr)) {
            orgs = (Set)SerializationUtils.fromJsonString((String)orgsStr, orgs.getClass());
        }
        if (orgs == null) {
            orgs = MaterialStandardUtils.getGroupOrgId((String)entity, useOrgs);
            this.getPageCache().put(PGCACHE_PARENTCREATEORG, SerializationUtils.toJsonString(orgs));
        }
        return orgs;
    }

    protected Set<Long> getUseOrgs(ListShowParameter param, String entity, String standard) {
        Set<Long> useOrgs = null;
        String useOrgsStr = this.getPageCache().get(PGCACHE_CREATEORGS);
        if (StringUtils.isNotBlank((CharSequence)useOrgsStr)) {
            useOrgs = (Set<Long>)SerializationUtils.fromJsonString((String)useOrgsStr, Set.class);
        }
        if (useOrgs == null) {
            String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
            useOrgs = this.getCreateOrgs(param, entity, standard, createOrg);
            this.getPageCache().put(PGCACHE_CREATEORGS, SerializationUtils.toJsonString(useOrgs));
        }
        return useOrgs;
    }

    private List<String> getParentGroupId(String groupId, List<String> parentIds, String entity) {
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(groupId), (String)ENTITY_MATERIALGROUP, (String)PROP_LONGNUMBER);
        String longNumberDlm = ".";
        MainEntityType dataEntityType = (MainEntityType)group.getDataEntityType();
        DynamicProperty property = dataEntityType.getProperty(PROP_PARENT);
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        String longnumber = group.getString(PROP_LONGNUMBER);
        String[] numbers = longnumber.split(longNumberDlm);
        Map groups = BusinessDataServiceHelper.loadFromCache((String)ENTITY_MATERIALGROUP, (String)PROP_ID, (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)numbers)});
        for (DynamicObject parent : groups.values()) {
            String parentId = parent.getString(PROP_ID);
            if (parentIds.contains(groupId)) continue;
            parentIds.add(parentId);
        }
        return parentIds;
    }

    private String getDefaultUseOrg(DynamicObjectCollection col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(((DynamicObject)col.get(0)).get(PROP_ID));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (DynamicObject obj : col) {
            if (longinOrg != obj.getLong(PROP_ID)) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    private void setComboEdit(List<Map<String, Object>> orgDataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(PROP_STANDARDLST);
        this.setComboValue(combo, this.setComboItems(orgDataList));
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private Map<String, LocaleString> setComboItems(List<Map<String, Object>> orgModelList) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>();
        if (orgModelList != null) {
            for (Map<String, Object> map : orgModelList) {
                String id = (String)map.get(PROP_ID);
                String fName = (String)map.get("name");
                comboItems.put(id, new LocaleString(fName));
            }
        }
        return comboItems;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        if (NO_GROUP.equals(nodeId)) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel;
        String nodeId;
        if (this.getModel().getValue(PROP_STANDARDLST) == null) {
            ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
            List<Map<String, Object>> standardLists = this.getComData();
            this.setComboEdit(standardLists);
            String groupStandard = "";
            if (param.getCustomParam(CP_GROUPSTANDARD) != null && StringUtils.isNotBlank((CharSequence)param.getCustomParam(CP_GROUPSTANDARD).toString())) {
                groupStandard = param.getCustomParam(CP_GROUPSTANDARD).toString();
            }
            ArrayList<String> standardIds = new ArrayList<String>();
            if (standardLists != null && standardLists.size() > 0) {
                for (Map<String, Object> standardMap : standardLists) {
                    standardIds.add(standardMap.get(PROP_ID).toString());
                }
            }
            if (standardIds.size() > 0 && !standardIds.contains(DEFGROUPSTANDARD)) {
                groupStandard = (String)standardIds.get(0);
            }
            if (!StringUtils.isBlank((CharSequence)groupStandard)) {
                this.getModel().setValue(PROP_STANDARDLST, (Object)groupStandard);
            } else {
                this.getModel().setValue(PROP_STANDARDLST, (Object)DEFGROUPSTANDARD);
            }
            this.getView().updateView(PROP_STANDARDLST);
        }
        if (NO_GROUP.equalsIgnoreCase(nodeId = e.getNodeId().toString())) {
            e.setChildNodes(new ArrayList());
            return;
        }
        String isOpenAll = this.getPageCache().get("isOpenAll");
        boolean flag = false;
        if (isOpenAll != null && ISSHOWALLNOORG_TRUE.equals(isOpenAll)) {
            flag = true;
        }
        String textFormat = "";
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            textFormat = treeListModel.getTextFormat();
        }
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, flag, flag, textFormat);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId, boolean isGetAllSub, boolean isOpen, String textFormat) {
        String standard = (String)this.getModel().getValue(PROP_STANDARDLST);
        String defStandard = DEFGROUPSTANDARD;
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        if (StringUtils.isBlank((CharSequence)standard)) {
            standard = defStandard;
        }
        Set<Long> useOrgs = this.getUseOrgs(param, ENTITY_MATERIAL, standard);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entityNumber = listShowParameter.getBillFormId();
        Set<Long> orgs = this.getorgAndParentOrg(entityNumber, useOrgs);
        QFilter qFilter = new QFilter(PROP_STANDARD, "=", (Object)Long.valueOf(standard));
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = "0";
        }
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.valueOf(nodeId));
        QFilter qFilter3 = new QFilter(PROP_ENABLE, "=", (Object)NO_GROUP);
        QFilter qFilter4 = new QFilter("createorg", "in", orgs);
        List<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters = this.addQFilters(qFilters, qFilter, qFilter2, qFilter3);
        String isShowAllNoOrg = (String)param.getCustomParam(ISSHOWALLNOORG);
        if (orgs == null || orgs.size() <= 0) {
            isShowAllNoOrg = ISSHOWALLNOORG_TRUE;
        }
        if (!ISSHOWALLNOORG_TRUE.equals(isShowAllNoOrg)) {
            qFilters.add(qFilter4);
        }
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)ENTITY_MATERIALGROUP, (String)"id,number,name,parent,longnumber", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(loadFromCache.size());
        HashSet<Long> parentIds = new HashSet<Long>(loadFromCache.size());
        for (DynamicObject group : loadFromCache.values()) {
            if (group == null) continue;
            parentIds.add(group.getLong(PROP_ID));
        }
        QFilter qFilterParent = new QFilter(PROP_PARENT, "in", parentIds);
        List<QFilter> parentQFilters = new ArrayList<QFilter>(2);
        parentQFilters = this.addQFilters(parentQFilters, qFilterParent);
        if (!ISSHOWALLNOORG_TRUE.equals(isShowAllNoOrg)) {
            parentQFilters.add(qFilter4);
        }
        Map parentCache = BusinessDataServiceHelper.loadFromCache((String)ENTITY_MATERIALGROUP, (String)PROP_PARENT, (QFilter[])parentQFilters.toArray(new QFilter[0]));
        parentIds = new HashSet(parentCache.size());
        for (DynamicObject group : parentCache.values()) {
            if (group == null || group.getDynamicObject(PROP_PARENT) == null) continue;
            parentIds.add(group.getDynamicObject(PROP_PARENT).getLong(PROP_ID));
        }
        for (DynamicObject group : loadFromCache.values()) {
            if (group.getPkValue() == null) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getPkValue().toString());
            treeNode.setParentid(group.get(PROP_PARENT) == null ? ROOTNODEID : group.get(PROP_PARENT).toString());
            String name = group.getLocaleString("name").getLocaleValue();
            String number = group.getString("number");
            if (StringUtils.isBlank((CharSequence)name)) {
                name = group.getString("name");
            }
            String text = textFormat;
            if (StringUtils.isNotBlank((CharSequence)textFormat)) {
                if (textFormat.contains(TEXTFORMAT_NAME) && StringUtils.isNotBlank((CharSequence)name)) {
                    text = text.replace(TEXTFORMAT_NAME, name);
                }
                if (textFormat.contains(TEXTFORMAT_CODE) && StringUtils.isNotBlank((CharSequence)number)) {
                    text = text.replace(TEXTFORMAT_CODE, number);
                }
            }
            if (StringUtils.isBlank((CharSequence)text)) {
                treeNode.setText(name);
            } else {
                treeNode.setText(text);
            }
            treeNode.setLongNumber(group.getString(PROP_LONGNUMBER));
            if (parentIds.contains(group.getLong(PROP_ID))) {
                if (isGetAllSub) {
                    treeNode.addChildren(this.getTreeChildren(group.getPkValue().toString(), isGetAllSub, isOpen, textFormat));
                } else {
                    treeNode.addChildren(new ArrayList());
                }
            }
            if (isOpen) {
                treeNode.setIsOpened(isOpen);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private List<QFilter> addQFilters(List<QFilter> parentQFilters, QFilter ... qFilters) {
        for (QFilter qFilter : qFilters) {
            parentQFilters.add(qFilter);
        }
        return parentQFilters;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node == null) {
            return;
        }
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        List qFilters = e.getQFilters();
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            if (StringUtils.isBlank((CharSequence)property)) continue;
            if ("group".equals(property)) {
                iterator.remove();
                continue;
            }
            if (!property.contains(ENTITY_GROUPDETAIL)) continue;
            iterator.remove();
        }
        QFilter filter = this.genRefreshFilter(nodeId);
        if (filter != null) {
            qFilters.add(filter);
        }
        String orderBy = ",";
        e.setOrderBy(orderBy);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (PROP_STANDARDLST.equals(propertyName)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFiterList = (List)filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String orgId = null;
        HashSet<String> standardIds = null;
        for (Map customFiter : customFiterList) {
            TreeNode root;
            TreeView treeView;
            String createOrg;
            List orgIds;
            List fieldNames = (List)customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = (List)customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            if (orgId.equals(createOrg = this.getPageCache().get(PGCACHE_CREATEORG))) {
                return;
            }
            this.getPageCache().put(PGCACHE_CREATEORG, orgId);
            List<Map<String, Object>> standardLists = this.getComData();
            this.setComboEdit(standardLists);
            String groupStandard = "";
            if (standardLists != null && standardLists.size() > 0) {
                standardIds = new HashSet<String>(standardLists.size());
                for (Map<String, Object> standardMap : standardLists) {
                    standardIds.add(standardMap.get(PROP_ID).toString());
                }
            }
            if (standardIds == null || standardIds.size() == 0) {
                treeView = this.getTreeListView().getTreeView();
                root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                } else {
                    this.treeListView.getTreeView().deleteAllNodes();
                    treeView.addNode(root);
                    this.getModel().setValue(PROP_STANDARDLST, (Object)"");
                    treeView.treeNodeClick("", root.getId());
                }
                return;
            }
            if (!standardIds.contains(DEFGROUPSTANDARD)) {
                groupStandard = (String)standardIds.iterator().next();
            }
            if (!StringUtils.isBlank((CharSequence)groupStandard)) {
                this.getModel().setValue(PROP_STANDARDLST, (Object)groupStandard);
            } else {
                this.getModel().setValue(PROP_STANDARDLST, (Object)DEFGROUPSTANDARD);
            }
            treeView = this.getTreeListView().getTreeView();
            root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.clearPageCache();
            break;
        }
    }

    private void clearPageCache() {
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        this.getPageCache().remove(searchNodesCacheKey);
        this.getPageCache().remove(matchNodesCacheKey);
        this.getPageCache().remove(oldSearchTextCacheKey);
        this.getPageCache().remove(searchIndexCacheKey);
    }
}

