/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.materialplan;

import java.time.LocalDate;
import java.util.Date;
import java.util.EventObject;
import kd.bd.mpdm.common.enums.CycleUnitEnum;
import kd.bd.mpdm.common.enums.DateTypeEnum;
import kd.bd.mpdm.common.utils.ControlUtil;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bd.mpdm.common.utils.LocalDateUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;

public class MergeCycleEdit
extends AbstractBillPlugIn {
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String CYCLE_UNIT = "cycleunit";
    private static final String CYCLE_NUM = "cyclenum";
    private static final String MERGE_DATE_TYPE = "mergedatetype";
    private static final String OFFSET_DAYS = "offsetdays";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_START_DATE = "entrystartdate";
    private static final String ENTRY_END_DATE = "entryenddate";
    private static final String ENTRY_MERGE_DATE = "entrymergedate";
    private static final String ENTRY_KEY = "entrykey";

    public void afterCopyData(EventObject e) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entrys != null && !entrys.isEmpty()) {
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                entry.set(ENTRY_KEY, (Object)"00");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName = event.getProperty().getName();
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            DynamicObject propertyValueCDDE = changeData.getDataEntity();
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)START_DATE) || StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)END_DATE)) {
                this.startOrEndDateChange(propertyName, oldObject, newObject, propertyValueCDDE);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)CYCLE_UNIT)) {
                this.showTimeOrDate(String.valueOf(newObject));
                this.updateEntry();
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)CYCLE_NUM)) {
                this.updateEntry();
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)MERGE_DATE_TYPE) && !StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)OFFSET_DAYS)) continue;
            this.dateTypeOrOffsetDaysChange(propertyName, oldObject, newObject);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String mergeDateType = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)MERGE_DATE_TYPE);
        this.setOffsetDaysIsMustInput(mergeDateType);
        String cycleUnit = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)CYCLE_UNIT);
        this.showTimeOrDate(cycleUnit);
    }

    private void showTimeOrDate(String cycleUnit) {
        if ("D".equals(cycleUnit)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ENTRY_START_DATE, ENTRY_END_DATE, ENTRY_MERGE_DATE, START_DATE, END_DATE, OFFSET_DAYS});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrystarttime", "entryendtime", "entrymergetime", "entryoffsetday"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_START_DATE, ENTRY_END_DATE, ENTRY_MERGE_DATE, START_DATE, END_DATE, OFFSET_DAYS});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrystarttime", "entryendtime", "entrymergetime", "entryoffsetday"});
        }
    }

    private void dateTypeOrOffsetDaysChange(String propertyName, Object oldObject, Object newObject) {
        String cycleUnit = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)CYCLE_UNIT);
        int cycleNum = DynamicObjDataUtil.getDataModelIntegerData((IDataModel)this.getModel(), (String)CYCLE_NUM);
        if (StringUtils.equalsIgnoreCase((CharSequence)"D", (CharSequence)cycleUnit)) {
            this.timeUnit(cycleNum);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)MERGE_DATE_TYPE)) {
            String dateType = newObject instanceof String ? (String)newObject : null;
            this.setOffsetDaysIsMustInput(dateType);
        }
        String mergeDateType = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)MERGE_DATE_TYPE);
        int offsetDays = DynamicObjDataUtil.getDataModelIntegerData((IDataModel)this.getModel(), (String)OFFSET_DAYS);
        this.updateEntryMergeDate(mergeDateType, offsetDays);
    }

    private void setOffsetDaysIsMustInput(String dateType) {
        if (StringUtils.equalsIgnoreCase((CharSequence)DateTypeEnum.FIXED_DATE.getValue(), (CharSequence)dateType)) {
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)OFFSET_DAYS, (String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u533a\u95f4\u5408\u5e76\u504f\u79fb\u5929\u6570", (String)"MergeCycleEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (boolean)true);
        } else {
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)OFFSET_DAYS, (String)"", (boolean)false);
        }
    }

    private void startOrEndDateChange(String propertyName, Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        Date endDate;
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        Date propertyValueDate = newObject instanceof Date ? (Date)newObject : null;
        Date startDate = propertyName.equalsIgnoreCase(START_DATE) ? propertyValueDate : DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)START_DATE);
        Date date = endDate = propertyName.equalsIgnoreCase(END_DATE) ? propertyValueDate : DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)END_DATE);
        if (startDate == null) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeCycleEdit_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)oldObject);
            return;
        }
        if (endDate == null) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u675f\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MergeCycleEdit_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)oldObject);
            return;
        }
        if (startDate.after(endDate)) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u201c\u5f00\u59cb\u65e5\u671f\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"MergeCycleEdit_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)propertyName, (Object)oldObject);
            return;
        }
        this.updateEntry();
    }

    private void updateEntry() {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        Date startDate = DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)START_DATE);
        Date endDate = DynamicObjDataUtil.getDataModelDateData((IDataModel)dm, (String)END_DATE);
        String cycleUnit = DynamicObjDataUtil.getDataModelStringData((IDataModel)dm, (String)CYCLE_UNIT);
        int cycleNum = DynamicObjDataUtil.getDataModelIntegerData((IDataModel)dm, (String)CYCLE_NUM);
        dm.deleteEntryData(ENTRY_ENTITY);
        if (startDate != null && endDate != null && cycleUnit != null && cycleNum > 0) {
            if (StringUtils.equalsIgnoreCase((CharSequence)CycleUnitEnum.DAY.getValue(), (CharSequence)cycleUnit)) {
                this.dayUnit(startDate, endDate, cycleNum);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)CycleUnitEnum.MONTH.getValue(), (CharSequence)cycleUnit)) {
                this.monthUnit(startDate, endDate, cycleNum);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)CycleUnitEnum.YEAR.getValue(), (CharSequence)cycleUnit)) {
                this.yearUnit(startDate, endDate, cycleNum);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"D", (CharSequence)cycleUnit)) {
                this.timeUnit(cycleNum);
            }
        }
        fv.updateView(ENTRY_ENTITY);
    }

    private void yearUnit(Date startDate, Date endDate, int cycleNum) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        LocalDate startLocalDate = LocalDateUtil.date2LocalDate((Date)startDate);
        LocalDate endLocalDate = LocalDateUtil.date2LocalDate((Date)endDate);
        int year1 = startLocalDate.getYear();
        int year2 = endLocalDate.getYear();
        int year = year2 - year1 + 1;
        int n = (int)Math.ceil((double)year / ((double)cycleNum * 1.0));
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField(ENTRY_START_DATE, new Object[0]);
        vs.addField(ENTRY_END_DATE, new Object[0]);
        vs.addField(ENTRY_MERGE_DATE, new Object[0]);
        vs.addField(ENTRY_KEY, new Object[0]);
        String mergeDateType = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)MERGE_DATE_TYPE);
        int offsetDays = DynamicObjDataUtil.getDataModelIntegerData((IDataModel)this.getModel(), (String)OFFSET_DAYS);
        LocalDate localDate = LocalDate.of(startLocalDate.getYear(), 1, 1);
        for (int i = 1; i <= n; ++i) {
            LocalDate start = localDate;
            LocalDate end = start.plusYears(cycleNum).minusDays(1L);
            if (i == 1) {
                start = startLocalDate;
            }
            if (endLocalDate.isBefore(end) || i == n) {
                end = endLocalDate;
            }
            Date mergeDate = this.getMergeDate(start, end, mergeDateType, offsetDays);
            vs.addRow(new Object[]{i, LocalDateUtil.localDate2Date((LocalDate)start), LocalDateUtil.localDate2Date((LocalDate)end), mergeDate, "00"});
            localDate = end.plusDays(1L);
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void monthUnit(Date startDate, Date endDate, int cycleNum) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        LocalDate startLocalDate = LocalDateUtil.date2LocalDate((Date)startDate);
        LocalDate endLocalDate = LocalDateUtil.date2LocalDate((Date)endDate);
        int year1 = startLocalDate.getYear();
        int year2 = endLocalDate.getYear();
        int month1 = startLocalDate.getMonthValue();
        int month2 = endLocalDate.getMonthValue();
        int month = (year2 - year1) * 12 + (month2 - month1) + 1;
        int n = (int)Math.ceil((double)month / ((double)cycleNum * 1.0));
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField(ENTRY_START_DATE, new Object[0]);
        vs.addField(ENTRY_END_DATE, new Object[0]);
        vs.addField(ENTRY_MERGE_DATE, new Object[0]);
        vs.addField(ENTRY_KEY, new Object[0]);
        String mergeDateType = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)MERGE_DATE_TYPE);
        int offsetDays = DynamicObjDataUtil.getDataModelIntegerData((IDataModel)this.getModel(), (String)OFFSET_DAYS);
        LocalDate localDate = LocalDate.of(startLocalDate.getYear(), startLocalDate.getMonth(), 1);
        for (int i = 1; i <= n; ++i) {
            LocalDate start = localDate;
            LocalDate end = start.plusMonths(cycleNum).minusDays(1L);
            if (i == 1) {
                start = startLocalDate;
            }
            if (endLocalDate.isBefore(end) || i == n) {
                end = endLocalDate;
            }
            Date mergeDate = this.getMergeDate(start, end, mergeDateType, offsetDays);
            vs.addRow(new Object[]{i, LocalDateUtil.localDate2Date((LocalDate)start), LocalDateUtil.localDate2Date((LocalDate)end), mergeDate, "00"});
            localDate = end.plusDays(1L);
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void dayUnit(Date startDate, Date endDate, int cycleNum) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        LocalDate startLocalDate = LocalDateUtil.date2LocalDate((Date)startDate);
        LocalDate endLocalDate = LocalDateUtil.date2LocalDate((Date)endDate);
        long day1 = startLocalDate.toEpochDay();
        long day2 = endLocalDate.toEpochDay();
        long day = day2 - day1 + 1L;
        long n = (long)Math.ceil((double)day / ((double)cycleNum * 1.0));
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField(ENTRY_START_DATE, new Object[0]);
        vs.addField(ENTRY_END_DATE, new Object[0]);
        vs.addField(ENTRY_MERGE_DATE, new Object[0]);
        vs.addField(ENTRY_KEY, new Object[0]);
        String mergeDateType = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)MERGE_DATE_TYPE);
        int offsetDays = DynamicObjDataUtil.getDataModelIntegerData((IDataModel)this.getModel(), (String)OFFSET_DAYS);
        LocalDate localDate = startLocalDate;
        int i = 1;
        while ((long)i <= n) {
            LocalDate start = localDate;
            LocalDate end = start.plusDays((long)cycleNum - 1L);
            if (endLocalDate.isBefore(end) || (long)i == n) {
                end = endLocalDate;
            }
            Date mergeDate = this.getMergeDate(start, end, mergeDateType, offsetDays);
            vs.addRow(new Object[]{i, LocalDateUtil.localDate2Date((LocalDate)start), LocalDateUtil.localDate2Date((LocalDate)end), mergeDate, "00"});
            localDate = end.plusDays(1L);
            ++i;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void timeUnit(int cycleNum) {
        if (cycleNum > 1440) {
            this.getModel().setValue(CYCLE_NUM, (Object)0);
            String msg = ResManager.loadKDString((String)"\u5f53\u5468\u671f\u5355\u4f4d\u7b49\u4e8e\u201c\u65f6\u5206\u201d\u65f6\uff0c\u5468\u671f\u503c\u4e3a\u5206\u949f\uff0c\u4e0d\u80fd\u5927\u4e8e1440\uff08\u537324*60\uff09\u5206\u949f\u3002", (String)"MergeCycleEdit_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            this.getView().updateView(CYCLE_NUM);
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        int n = 0;
        if (cycleNum != 0) {
            n = 1440 / cycleNum;
            if (1440 % cycleNum > 0) {
                ++n;
            }
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("entrystarttime", new Object[0]);
        vs.addField("entryendtime", new Object[0]);
        vs.addField("entrymergetime", new Object[0]);
        vs.addField("entryoffsetday", new Object[0]);
        vs.addField(ENTRY_KEY, new Object[0]);
        String mergeDateType = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)MERGE_DATE_TYPE);
        int start = 0;
        int end = 0;
        for (int i = 1; i <= n; ++i) {
            end = start + cycleNum * 60;
            end = Math.min(end, 86400);
            int merge = "C".equalsIgnoreCase(mergeDateType) ? end : start;
            int offset = 0;
            if (merge == 86400) {
                merge = 0;
                ++offset;
            }
            vs.addRow(new Object[]{i, start, end, merge, offset, "00"});
            start = end;
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private Date getMergeDate(LocalDate startDate, LocalDate endDate, String mergeDateType, int offsetDays) {
        if (StringUtils.isBlank((CharSequence)mergeDateType) || startDate == null || endDate == null) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DateTypeEnum.FIXED_DATE.getValue(), (CharSequence)mergeDateType)) {
            LocalDate localDate = startDate.plusDays(offsetDays);
            return localDate.isAfter(endDate) ? LocalDateUtil.localDate2Date((LocalDate)endDate) : LocalDateUtil.localDate2Date((LocalDate)localDate);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DateTypeEnum.EARLY_CYCLE.getValue(), (CharSequence)mergeDateType)) {
            return LocalDateUtil.localDate2Date((LocalDate)startDate);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)DateTypeEnum.LATEST_CYCLE.getValue(), (CharSequence)mergeDateType)) {
            return LocalDateUtil.localDate2Date((LocalDate)endDate);
        }
        return null;
    }

    private void updateEntryMergeDate(String mergeDateType, int offsetDays) {
        if (StringUtils.isBlank((CharSequence)mergeDateType)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (entrys != null && !entrys.isEmpty()) {
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                Date startDate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)entry, (String)ENTRY_START_DATE);
                Date endDate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)entry, (String)ENTRY_END_DATE);
                Date mergeDate = this.getMergeDate(LocalDateUtil.date2LocalDate((Date)startDate), LocalDateUtil.date2LocalDate((Date)endDate), mergeDateType, offsetDays);
                this.getModel().setValue(ENTRY_MERGE_DATE, (Object)mergeDate, i);
            }
        }
    }
}

