/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.metastatstool;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.DyObjUtils;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class MetaStatsToolFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MetaStatsToolFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar mbar = (Toolbar)this.getView().getControl("toolbarap");
        mbar.addItemClickListener((ItemClickListener)this);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getView().getControl("entitynum");
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPropCombox();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (oprKey = source.getOperateKey()) {
            case "serachinfo": {
                OperationResult res = args.getOperationResult();
                if (res != null && !res.isSuccess()) {
                    throw new KDBizException(this.getOperationResultError(res));
                }
                this.doSearch();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName;
        switch (propName = evt.getProperty().getName()) {
            case "entitynum": {
                MulBasedataDynamicObjectCollection mulbasedataapp = (MulBasedataDynamicObjectCollection)this.getModel().getValue("mulbasedataapp");
                List appidLst = DyObjUtils.getMulBasedataIdLst((MulBasedataDynamicObjectCollection)mulbasedataapp);
                if (appidLst.isEmpty()) break;
                QFilter qFilter = new QFilter("bizappid", "in", (Object)appidLst);
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    private void doSearch() {
        IDataModel md = this.getModel();
        IFormView fv = this.getView();
        List<Map<String, String>> pagesInfoMaps = this.getPagesInfoMaps(md);
        DynamicObjectCollection rlMatch = md.getEntryEntity("entryentity_rule");
        Map<String, List<DynamicObject>> rlMap = rlMatch.stream().filter(p -> p.getString("rl_proptype") != null).collect(Collectors.groupingBy(p -> p.getString("rl_proptype")));
        Map<String, String[]> propMap = this.getPropTypeMap();
        md.beginInit();
        md.deleteEntryData("entryentity");
        for (Map<String, String> pagesInfo : pagesInfoMaps) {
            String pageNumber = pagesInfo.get("pageNumber");
            try {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)pageNumber);
                Map mapEntrys = mainEntityType.getAllEntities();
                for (Map.Entry entry : mapEntrys.entrySet()) {
                    EntityType entityType = (EntityType)entry.getValue();
                    DataEntityPropertyCollection props = entityType.getProperties();
                    for (int i = 0; i < props.size(); ++i) {
                        IDataEntityProperty prop = (IDataEntityProperty)props.get(i);
                        try {
                            this.setEntryRow(md, rlMap, pagesInfo, prop, propMap);
                            continue;
                        }
                        catch (Exception ex) {
                            logger.error((Throwable)ex);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        md.endInit();
        fv.updateView("entryentity");
    }

    private void setEntryRow(IDataModel md, Map<String, List<DynamicObject>> rlMap, Map<String, String> pagesInfo, IDataEntityProperty prop, Map<String, String[]> propMap) {
        String pageNumber = pagesInfo.get("pageNumber");
        String cloudId = pagesInfo.get("cloudId");
        String appId = pagesInfo.get("appId");
        String propclassName = prop.getClass().getSimpleName().toLowerCase();
        List<DynamicObject> propMatchRLLst = rlMap.get(propclassName);
        List<DynamicObject> alltypeRLLst = rlMap.get("alltype");
        if (alltypeRLLst != null) {
            ArrayList<DynamicObject> propMatchRLLstNew = new ArrayList<DynamicObject>(16);
            if (propMatchRLLst == null) {
                propMatchRLLst = propMatchRLLstNew;
            }
            for (DynamicObject alltypeRL : alltypeRLLst) {
                DynamicObject alltypeRLClone = (DynamicObject)OrmUtils.clone((IDataEntityBase)alltypeRL, (boolean)false, (boolean)true);
                alltypeRLClone.set("rl_proptype", (Object)propclassName);
                propMatchRLLst.add(alltypeRLClone);
            }
            propMatchRLLst.addAll(propMatchRLLstNew);
        }
        LocaleString dispName = prop.getDisplayName();
        String propCaption = "";
        if (dispName != null) {
            propCaption = dispName.getLocaleValue();
        }
        if (propMatchRLLst == null || prop.getName() != null && prop.getName().contains("_id") && StringUtils.isBlank((CharSequence)propCaption)) {
            return;
        }
        boolean matchFlag = false;
        for (DynamicObject propMatcRL : propMatchRLLst) {
            String cmptype = propMatcRL.getString("cmptype");
            String comp = propMatcRL.getString("comp");
            String propVal = propMatcRL.getString("prop_val");
            if (StringUtils.isBlank((CharSequence)propVal)) {
                propVal = "";
            }
            String cuMatchVal = this.getCurMatchVal(prop, cmptype);
            if ("bytype".equals(cmptype)) {
                propVal = prop.getClass().getSimpleName().toLowerCase();
                comp = "1";
            }
            matchFlag = false;
            switch (comp) {
                case "1": {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)cuMatchVal, (CharSequence)propVal)) break;
                    matchFlag = true;
                    break;
                }
                case "2": {
                    if (!cuMatchVal.contains(propVal)) break;
                    matchFlag = true;
                    break;
                }
                case "3": {
                    if (cuMatchVal.contains(propVal)) break;
                    matchFlag = true;
                    break;
                }
            }
            if (matchFlag) continue;
            break;
        }
        if (!matchFlag) {
            return;
        }
        int[] indexrowsOne = md.batchCreateNewEntryRow("entryentity", 1);
        int indexRow = indexrowsOne[0];
        md.setValue("prop_key", (Object)prop.getName(), indexRow);
        md.setValue("prop_name", (Object)propCaption, indexRow);
        md.setValue("ischeck", (Object)matchFlag, indexRow);
        md.setValue("entitynumber", (Object)pageNumber, indexRow);
        md.setValue("cloud", (Object)cloudId, indexRow);
        md.setValue("app", (Object)appId, indexRow);
        String[] propTypeAraay = propMap.get(propclassName);
        if (propTypeAraay != null) {
            md.setValue("propname", (Object)String.format("%s&&%s", propTypeAraay[0], propTypeAraay[1]), indexRow);
        } else {
            md.setValue("propname", (Object)propclassName, indexRow);
        }
    }

    private String getCurMatchVal(IDataEntityProperty prop, String cmptype) {
        String matchVal = "";
        switch (cmptype) {
            case "byname": {
                LocaleString dispName = prop.getDisplayName();
                if (dispName == null) break;
                matchVal = dispName.getLocaleValue();
                break;
            }
            case "bykey": {
                matchVal = prop.getName();
                break;
            }
            case "bytype": {
                matchVal = prop.getClass().getSimpleName().toLowerCase();
                break;
            }
        }
        return matchVal;
    }

    private List<Map<String, String>> getPagesInfoMaps(IDataModel dataModel) {
        MulBasedataDynamicObjectCollection mulbasedataapp = (MulBasedataDynamicObjectCollection)dataModel.getValue("mulbasedataapp");
        MulBasedataDynamicObjectCollection entitynumCol = (MulBasedataDynamicObjectCollection)dataModel.getValue("entitynum");
        Boolean ismenu = DynamicObjDataUtil.getDataModelBooleanData((IDataModel)dataModel, (String)"ismenu");
        ArrayList<Object> appIdList = new ArrayList<Object>(16);
        ArrayList<Object> entitidLst = new ArrayList<Object>(16);
        for (DynamicObject dynamicObject : mulbasedataapp) {
            appIdList.add(dynamicObject.get("fbasedataid_id"));
            if (!ismenu.booleanValue()) continue;
            AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataById((String)dynamicObject.getString("fbasedataid_id"), (boolean)false);
            List menuElements = metadata.getAppMenus();
            for (AppMenuElement menuElement : menuElements) {
                if (menuElement.getFormNumber() == null) continue;
                entitidLst.add(menuElement.getFormNumber());
            }
        }
        if (entitynumCol.size() > 0) {
            entitidLst.clear();
        }
        for (DynamicObject dynamicObject : entitynumCol) {
            Object entitNum = dynamicObject.get("fbasedataid_id");
            if (entitidLst.contains(String.valueOf(entitNum))) continue;
            entitidLst.add(entitNum);
        }
        List<Map<String, String>> pagesInfoList = this.getPagesInfo(appIdList.toArray(), entitidLst.toArray());
        return pagesInfoList;
    }

    private List<Map<String, String>> getPagesInfo(Object[] appIdArray, Object[] entitidLst) {
        StringBuilder sqlStr = new StringBuilder("select a.fdentityid pageId ,a.fid pageNumber, b.fid appId, b.fnumber appNumber, c.fid cloudId, c.fnumber cloudNumber from t_meta_mainentityinfo a inner join t_meta_bizapp b on a.fbizappid = b.fid inner join t_meta_bizcloud c on b.fbizcloudid = c.fid where ");
        if (appIdArray != null && appIdArray.length > 0) {
            sqlStr.append("b.fid in ('");
            sqlStr.append(StringUtils.join((Object[])appIdArray, (String)"','")).append("')");
            if (entitidLst.length > 0) {
                sqlStr.append(" and a.fid in ('");
                sqlStr.append(StringUtils.join((Object[])entitidLst, (String)"','")).append("')");
            }
        }
        sqlStr.append(" order by c.fnumber,b.fnumber,a.fid");
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys.meta"), (String)sqlStr.toString(), rs -> {
            ArrayList list = new ArrayList(16);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("pageId", rs.getString(1));
                map.put("pageNumber", rs.getString(2));
                map.put("appId", rs.getString(3));
                map.put("appNumber", rs.getString(4));
                map.put("cloudId", rs.getString(5));
                map.put("cloudNumber", rs.getString(6));
                list.add(map);
            }
            return list;
        });
    }

    private void setPropCombox() {
        List<String[]> propComboList = this.getPropTypeLst();
        ArrayList<ComboItem> curComboList = new ArrayList<ComboItem>(16);
        ArrayList<ValueMapItem> curComboModelList = new ArrayList<ValueMapItem>(16);
        for (String[] item : propComboList) {
            String itemStr = item[0];
            String itemName = item[1];
            String itemNameStr = itemName + "(" + itemStr + ")";
            ComboItem comItem = new ComboItem();
            LocaleString setItemName = new LocaleString(itemNameStr);
            comItem.setValue(itemStr);
            comItem.setCaption(setItemName);
            curComboList.add(comItem);
            ValueMapItem valueMapItem = new ValueMapItem();
            valueMapItem.setValue(itemStr);
            valueMapItem.setName(setItemName);
            curComboModelList.add(valueMapItem);
        }
        ComboEdit biztypeCombo = (ComboEdit)this.getView().getControl("rl_proptype");
        biztypeCombo.setComboItems(curComboList);
        ComboProp property = (ComboProp)this.getModel().getProperty("rl_proptype");
        property.setComboItems(curComboModelList);
    }

    private List<String[]> getPropTypeLst() {
        ArrayList<String[]> propComboList = new ArrayList<String[]>();
        propComboList.add(new String[]{"textprop", ResManager.loadKDString((String)"\u6587\u672c", (String)"MetaStatsToolFormPlugin_0", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"mulilangtextprop", ResManager.loadKDString((String)"\u591a\u8bed\u8a00\u6587\u672c", (String)"MetaStatsToolFormPlugin_10", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"qtyprop", ResManager.loadKDString((String)"\u6570\u91cf", (String)"MetaStatsToolFormPlugin_1", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"amountprop", ResManager.loadKDString((String)"\u91d1\u989d", (String)"MetaStatsToolFormPlugin_2", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"priceprop", ResManager.loadKDString((String)"\u5355\u4ef7", (String)"MetaStatsToolFormPlugin_3", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"unitprop", ResManager.loadKDString((String)"\u5355\u4f4d", (String)"MetaStatsToolFormPlugin_9", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"datetimeprop", ResManager.loadKDString((String)"\u65f6\u95f4", (String)"MetaStatsToolFormPlugin_4", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"createdateprop", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"MetaStatsToolFormPlugin_5", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"datetimeprop", ResManager.loadKDString((String)"\u5ba1\u6838\u65f6\u95f4", (String)"MetaStatsToolFormPlugin_6", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"modifydateprop", ResManager.loadKDString((String)"\u4fee\u6539\u65f6\u95f4", (String)"MetaStatsToolFormPlugin_7", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        propComboList.add(new String[]{"alltype", ResManager.loadKDString((String)"\u6240\u6709\u7c7b\u578b", (String)"MetaStatsToolFormPlugin_8", (String)"mmc-pom-formplugin", (Object[])new Object[0])});
        return propComboList;
    }

    private Map<String, String[]> getPropTypeMap() {
        List<String[]> propTypeList = this.getPropTypeLst();
        HashMap<String, String[]> propTypeMap = new HashMap<String, String[]>(16);
        for (String[] propTypeArray : propTypeList) {
            propTypeMap.put(propTypeArray[0], propTypeArray);
        }
        return propTypeMap;
    }

    private String getOperationResultError(OperationResult opRes) {
        StringBuilder sbErr = new StringBuilder();
        List errorInfos = opRes.getAllErrorOrValidateInfo();
        if (!errorInfos.isEmpty()) {
            for (IOperateInfo errInfo : errorInfos) {
                String errStrLine = String.format("%s", errInfo.getMessage());
                sbErr.append(errStrLine);
                sbErr.append("\r\n");
            }
        } else if (!opRes.isSuccess()) {
            String errStrLine;
            String string = errStrLine = opRes.getMessage() == null ? "" : opRes.getMessage();
            if (errStrLine.length() > 0) {
                sbErr.append(errStrLine);
                sbErr.append("\r\n");
            }
        }
        return sbErr.toString();
    }
}

