/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.BatchMaintainHelper;
import kd.bd.mpdm.common.ext.IMftStockListBatchMaintainFilterMapper;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.ManuFactureTraceUtils;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ManufactureStockList
extends AbstractListPlugin {
    private static final int LIMIT = Integer.getInteger("mmc.batchmaintain.stock.limit", 2000);
    public static final String MPDM_BATCHMAINTAIN_VIEW_C = "mpdm_batchmaintain_view_c";
    public static final String CONTENT = "content";
    private static Log logger = LogFactory.getLog(ManufactureStockList.class);
    private static final String BILLLISTAP = "billlistap";
    private static final String UPDATE_STOCK_OP_KEY = "updatestock";
    private static final String UPDATE_STOCK_OPEN = "updatestockopendialog";
    private static final String UPDATE_STOCK_FORM_ID = "pom_updatestock_dialog";
    private static final String BATCH_MAINTAIN = "batchmaintain";
    private static final String BATCH_MAINTAIN_FORM = "pom_stockbatchmaintain";

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        String billFormId;
        String on = System.getProperty("mmc.batchmaintain.saveuser.lock", "true");
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)e.getHyperLinkClickEvent();
        ListSelectedRow currentRow = event.getCurrentRow();
        String entityName = "pom_mftstock";
        if (this.getView() instanceof AbstractListView && StringUtils.isNotEmpty((CharSequence)(billFormId = ((AbstractListView)this.getView()).getBillFormId()))) {
            entityName = billFormId;
        }
        if (Boolean.parseBoolean(on) && "billno".equals(event.getFieldName()) && currentRow != null && currentRow.getPrimaryKeyValue() != null && "A".equals(currentRow.getBillStatus())) {
            StringBuilder errMsg = new StringBuilder();
            boolean sameUserLocked = BatchMaintainHelper.checkLockedForSameUser((String)this.getView().getPageId(), (String)entityName, (String)String.valueOf(currentRow.getPrimaryKeyValue()), (StringBuilder)errMsg);
            if (sameUserLocked) {
                e.setCancel(true);
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(MPDM_BATCHMAINTAIN_VIEW_C);
                fsp.setCustomParam(CONTENT, (Object)errMsg.toString());
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_dealbiz"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        if (StringUtils.equals((CharSequence)UPDATE_STOCK_OPEN, (CharSequence)evt.getItemKey())) {
            if (selects == null || selects.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ManufactureStockList_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(UPDATE_STOCK_FORM_ID);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void initialize() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && "no".equals(isshowtoolbarap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setHasRight(true);
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("istmctracebillop");
        if (null != isshowtoolbarap && "yes".equals(isshowtoolbarap)) {
            List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            commonFilterColumns.clear();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        if ("change".equals(key) || "omchange".equals(key)) {
            ArrayList<Object> stockidList = new ArrayList<Object>();
            for (int i = 0; i < selects.size(); ++i) {
                Object stockid = selects.get(i).getPrimaryKeyValue();
                if (stockidList.contains(stockid)) continue;
                stockidList.add(stockid);
            }
            QFilter[] stockidfilter = new QFilter[]{new QFilter("id", "in", stockidList)};
            DynamicObject[] stocks = "change".equals(key) ? BusinessDataServiceHelper.load((String)"pom_mftstock", (String)"billno,transactiontypeid,ischanged,orderentryid,billstatus", (QFilter[])stockidfilter) : BusinessDataServiceHelper.load((String)"om_componentlist", (String)"billno,transactiontypeid,ischanged,orderentryid,billstatus", (QFilter[])stockidfilter);
            StringBuilder err = new StringBuilder();
            if (stocks != null) {
                for (int i = 0; i < stocks.length; ++i) {
                    err.append(this.changeaddva(stocks[i], key));
                }
            }
            if (err.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25", (String)"ManufactureStockList_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), err.toString(), null);
                e.setCancel(true);
            }
        } else if ("submit".equals(key) && !StringUtils.equals((CharSequence)"om_componentlist", (CharSequence)billList.getEntityId())) {
            this.checkDemandDate(e);
        } else if (UPDATE_STOCK_OP_KEY.equals(key)) {
            OperateOption option = op.getOption();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object expendBomTime = formShowParameter.getCustomParams().get("expendbomtime");
            option.setVariableValue("expendbomtime", expendBomTime != null ? expendBomTime.toString() : null);
        } else if (BATCH_MAINTAIN.equals(key)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(BATCH_MAINTAIN_FORM);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (selects != null) {
                if (selects.size() > LIMIT) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6700\u5927\u6279\u91cf\u7ef4\u62a4\u6570\u91cf\u4e3a%s\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ManufactureStockList_71", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), LIMIT));
                    return;
                }
                HashSet<Long> orgIds = new HashSet<Long>(2);
                HashSet<Long> headIds = new HashSet<Long>(selects.size());
                HashSet<Long> entryIds = new HashSet<Long>(selects.size());
                HashMap<String, String> billStatus = new HashMap<String, String>(4);
                billStatus.put("A", ResManager.loadKDString((String)"\u6682\u5b58", (String)"ManufactureStockList_75", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                PluginProxy extPlugin = PluginProxy.create(null, IMftStockListBatchMaintainFilterMapper.class, (String)"POM_MFTSTOCK_BATCHMAINTAIN_BILLSTATUSFILTER_EXT", null);
                extPlugin.callReplace(p -> {
                    p.changeBatchMaintainBillStatus(billStatus);
                    return null;
                });
                for (ListSelectedRow listSelectedRow : selects) {
                    if (!billStatus.containsKey(listSelectedRow.getBillStatus())) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e%1$s\u72b6\u6001\u4e0d\u4e3a%2$s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ManufactureStockList_72", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), listSelectedRow.getBillNo(), billStatus.values()));
                        return;
                    }
                    Object pkValue = listSelectedRow.getEntryPrimaryKeyValue();
                    if (null == pkValue) continue;
                    entryIds.add(Long.parseLong(pkValue.toString()));
                    headIds.add(Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString()));
                    orgIds.add(listSelectedRow.getMainOrgId());
                }
                if (orgIds.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ManufactureStockList_73", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                fsp.setCustomParam("head_ids", (Object)headIds.stream().map(Object::toString).collect(Collectors.joining(",")));
                fsp.setCustomParam("entry_ids", (Object)entryIds.stream().map(Object::toString).collect(Collectors.joining(",")));
                fsp.setCustomParam("org_id", orgIds.size() == 0 ? null : ((Long)orgIds.iterator().next()).toString());
            }
            this.getView().showForm(fsp);
        }
    }

    private void checkDemandDate(BeforeDoOperationEventArgs e) {
        FormOperate source = (FormOperate)e.getSource();
        RefObject afterConfirm = new RefObject();
        if (source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            return;
        }
        Long startdate = System.currentTimeMillis();
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5217\u8868\u63d0\u4ea4\uff1a\u5f00\u59cb\u68c0\u67e5\u9700\u6c42\u65e5\u671f");
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        String entityName = billList.getEntityId();
        ArrayList<Integer> demanddateList = new ArrayList<Integer>();
        ArrayList<Integer> demandDateNullList = new ArrayList<Integer>();
        ListSelectedRowCollection selectsOld = billList.getSelectedRows();
        ListSelectedRowCollection selects = new ListSelectedRowCollection();
        for (int i = 0; i < selectsOld.size(); ++i) {
            boolean numLabel = false;
            for (int j = 0; j < selects.size(); ++j) {
                if (!selects.get(j).getPrimaryKeyValue().equals(selectsOld.get(i).getPrimaryKeyValue())) continue;
                numLabel = true;
            }
            if (numLabel) continue;
            selects.add((Object)selectsOld.get(i));
        }
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"om_xxcomponentlist")) {
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> errMsgDateNullList = new ArrayList<String>();
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5217\u8868\u63d0\u4ea4\uff1a\u5f00\u59cb\u67e5\u8be2\u7ec4\u4ef6\u6e05\u5355\uff0c\u603b\u8017\u65f6" + (System.currentTimeMillis() - startdate) + "ms");
        Map<Object, DynamicObject> stockMap = this.loadStockMap(selects, entityName);
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5217\u8868\u63d0\u4ea4\uff1a\u7ed3\u675f\u67e5\u8be2\u7ec4\u4ef6\u6e05\u5355\uff0c\u603b\u8017\u65f6" + (System.currentTimeMillis() - startdate) + "ms");
        HashMap calendarInfoMap = new HashMap(16);
        for (int i = 0; i < selects.size(); ++i) {
            demanddateList.clear();
            demandDateNullList.clear();
            DynamicObject obj = stockMap.get(selects.get(i).getPrimaryKeyValue());
            if (obj == null || !"A".equals(obj.getString("billstatus"))) continue;
            DynamicObjectCollection stockCol = obj.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < stockCol.size(); ++j) {
                DynamicObject org;
                Date workDate;
                Date planbeginime;
                DynamicObject stockDym = (DynamicObject)stockCol.get(j);
                Date demanddate = stockDym.getDate("demanddate");
                DynamicObject orderdym = obj.getDynamicObject("orderentryid");
                if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_xmftstock")) {
                    orderdym = stockDym.getDynamicObject("entryorderentryid");
                } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_mftstock")) {
                    orderdym = obj.getDynamicObject("orderentryid");
                }
                if (orderdym == null) continue;
                Date planendtime = orderdym.getDate("planendtime") == null ? TimeServiceHelper.now() : orderdym.getDate("planendtime");
                Date date = planbeginime = orderdym.getDate("planbegintime") == null ? TimeServiceHelper.now() : orderdym.getDate("planbegintime");
                if (demanddate == null) {
                    demanddate = planbeginime;
                }
                if (demanddate.after(planendtime)) {
                    demanddate = planendtime;
                }
                if (null == (workDate = CalendarUtils.getRecentleWorkDateNew((DynamicObject)(org = obj.getDynamicObject("org")), (Date)demanddate, calendarInfoMap))) {
                    demandDateNullList.add(j + 1);
                    continue;
                }
                if (!CalendarUtils.compateDateAccurateDay((Date)demanddate, (Date)workDate)) {
                    demanddateList.add(j + 1);
                    continue;
                }
                stockDym.set("demanddate", (Object)demanddate);
            }
            if (!demanddateList.isEmpty()) {
                String info = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c", (String)"ManufactureStockList_76", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(demanddateList));
                errMsgList.add(obj.getString("billno") + info);
            }
            if (demandDateNullList.isEmpty()) continue;
            String info = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c", (String)"ManufactureStockList_76", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\u3001").join(demandDateNullList));
            errMsgDateNullList.add(obj.getString("billno") + info);
        }
        Collection<DynamicObject> values = stockMap.values();
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5217\u8868\u63d0\u4ea4\uff1a\u7ed3\u675f\u68c0\u67e5\u7ec4\u4ef6\u6e05\u5355\u9700\u6c42\u65e5\u671f\uff0c\u603b\u8017\u65f6" + (System.currentTimeMillis() - startdate) + "ms");
        SaveServiceHelper.update((DynamicObject[])values.toArray(new DynamicObject[values.size()]));
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u5217\u8868\u63d0\u4ea4\uff1a\u7ed3\u675f\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355\uff0c\u603b\u8017\u65f6" + (System.currentTimeMillis() - startdate) + "ms");
        ArrayList<String> infoList = new ArrayList<String>(10);
        if (!errMsgDateNullList.isEmpty()) {
            String nullDateInfo = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e%1$s\u672a\u627e\u5230\u751f\u4ea7\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u751f\u4ea7\u65e5\u5386\u6216\u9700\u6c42\u65e5\u671f\u4e0d\u5728\u65e5\u5386\u8bbe\u7f6e\u4e2d\u65e5\u5386\u7684\u6709\u6548\u671f\u8303\u56f4\u5185", (String)"ManufactureStockList_78", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\uff0c").join(errMsgDateNullList)) + "\n";
            infoList.add(nullDateInfo);
        }
        if (!errMsgList.isEmpty()) {
            String info = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e%1$s\u7684\u9700\u6c42\u65e5\u671f\u4e0d\u5728\u5de5\u4f5c\u65e5\u5185", (String)"ManufactureStockList_79", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\uff0c").join(errMsgList)) + "\n";
            infoList.add(info);
        }
        if (!infoList.isEmpty() && !source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            String info = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"ManufactureStockList_80", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\uff0c").join(infoList));
            errMsg.append(info);
            ConfirmCallBackListener listener = new ConfirmCallBackListener("checkDemandDate", (IFormPlugin)this);
            this.getView().showConfirm(errMsg.toString(), MessageBoxOptions.YesNo, listener);
            e.setCancel(true);
            return;
        }
    }

    private Map<Object, DynamicObject> loadStockMap(ListSelectedRowCollection selects, String entityName) {
        String selectPro = "billstatus,orderentryid,billno,org,stockentry.demanddate";
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_xmftstock")) {
            selectPro = "billstatus,orderentryid,billno,org,stockentry.demanddate,entryorderentryid";
        }
        HashSet<Object> pks = new HashSet<Object>(selects.size());
        for (ListSelectedRow select : selects) {
            pks.add(select.getPrimaryKeyValue());
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)entityName, (String)selectPro, (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        HashMap<Object, DynamicObject> stockMaps = new HashMap<Object, DynamicObject>(load.length);
        for (DynamicObject stock : load) {
            stockMaps.put(stock.getPkValue(), stock);
        }
        return stockMaps;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        if ("checkDemandDate".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    private String changeaddva(DynamicObject stock, String key) {
        String billstatus;
        boolean s;
        StringBuilder err = new StringBuilder();
        DynamicObject tran = (DynamicObject)stock.get("transactiontypeid");
        if (tran != null && !(s = tran.getBoolean("isstockchange"))) {
            if (StringUtils.equals((CharSequence)"mpdm_transactout", (CharSequence)tran.getDataEntityType().getName())) {
                err.append(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u672a\u542f\u7528\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u3002", (String)"ManufactureStockList_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                err.append(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u672a\u542f\u7528\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u3002", (String)"ManufactureStockList_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        }
        if ("change".equals(key)) {
            String bizstatus;
            DynamicObject orderentryid = (DynamicObject)stock.get("orderentryid");
            QFilter closestatus = new QFilter("treeentryentity.id", "=", orderentryid.getPkValue());
            DynamicObject manuorder = BusinessDataServiceHelper.loadSingle((String)"pom_mftorder", (String)"id,name,billno,treeentryentity,treeentryentity.bizstatus,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.pickstatus", (QFilter[])new QFilter[]{closestatus});
            if (manuorder != null) {
                orderentryid = MPDMMftGenStocksUtils.getManuEntryByEntryID((DynamicObject)manuorder, (String)orderentryid.getPkValue().toString());
            }
            if (!"A".equals(bizstatus = orderentryid.getString("bizstatus"))) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u201c\u6b63\u5e38\u201d\u3002", (String)"ManufactureStockList_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        }
        if (!"C".equals(billstatus = (String)stock.get("billstatus"))) {
            err.append(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\u3002", (String)"ManufactureStockList_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (err.length() > 0) {
            err.insert(0, stock.getString("billno"));
            err.append("\r\n");
        }
        return err.toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        BillList billList;
        String key = e.getOperateKey();
        if ("trackorder".equals(key)) {
            ListShowParameter showParameter;
            billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selects = billList.getSelectedRows();
            ArrayList<Long> orderidList = new ArrayList<Long>();
            for (int i = 0; i < selects.size(); ++i) {
                ListSelectedRow row = selects.get(i);
                Object stockid = row.getPrimaryKeyValue();
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)stockid, (String)billList.getEntityId(), (String)"orderid");
                if (orderidList.contains(Long.parseLong(stock.getString("orderid")))) continue;
                orderidList.add(Long.parseLong(stock.getString("orderid")));
            }
            ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
            QFilter orderidqfilter = new QFilter("id", "in", orderidList);
            qfilterList.add(orderidqfilter);
            if (orderidList.size() == 1) {
                showParameter = ManuFactureTraceUtils.createBillShowParam((String)EntityNameUtils.getEntityName((int)1, (int)0, (String)billList.getEntityId()), orderidList.get(0));
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                showParameter = ManuFactureTraceUtils.createShowParam((String)EntityNameUtils.getEntityName((int)1, (int)0, (String)billList.getEntityId()), qfilterList);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
        if (UPDATE_STOCK_OP_KEY.equals(key) || "invrefresh".equals(key)) {
            billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.refresh();
        }
    }
}

