/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.BatchMaintainHelper;
import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bd.mpdm.business.lotmain.MftOrderSelectLotMain;
import kd.bd.mpdm.common.enums.OrderStatusEnum;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.MetaDataHelper;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.helper.WarehouseQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.utils.DyObjUtils;
import kd.bd.mpdm.formplugin.mftorder.ManufstockTplHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class ManufstockTplEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(ManufstockTplEdit.class);
    protected static final String[] f7Keys = new String[]{"materialunitid", "outwarehousefield", "outlocationfield", "warehousefield", "locationfield", "org", "supplyorgfield", "supplierfield", "bomreversion", "entryconfiguredcode"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        for (String f7Key : f7Keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(f7Key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"batchno"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "outwarehousefield": {
                this.outwareHouseFieldBeforeF7Select(e);
                break;
            }
            case "outlocationfield": {
                this.outlocationFieldBeforeF7Select(e);
                break;
            }
            case "warehousefield": {
                this.warehouseFieldBeforeF7Select(e);
                break;
            }
            case "locationfield": {
                this.locationFieldBeforeF7Select(e);
                break;
            }
            case "supplyorgfield": {
                this.supplyOrgFieldBeforeF7Select(e);
                break;
            }
            case "supplierfield": {
                this.supplierFieldBeforeF7Select(e);
                break;
            }
            case "bomreversion": {
                this.bomReVersionBeforeF7Select(e);
                break;
            }
            case "org": {
                e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                break;
            }
            case "entryconfiguredcode": {
                this.bomReVersionBeforeF7Select(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!"A".equals(this.getModel().getValue("billstatus"))) {
            this.getView().getModel().setDataChanged(false);
        }
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get("isIgnoreChangeMftstock")) && !"unissueqty".equals(key) && !"supplyorgid".equals(key)) {
            return;
        }
        this.getPageCache().put("isIgnoreChangeMftstock", "true");
        Object newObj = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int changeIndex = e.getChangeSet()[0].getRowIndex();
        int currentSelectIndex = this.getSelectEntryRowIndex();
        if (currentSelectIndex > -1) {
            this.setEntryDownFieldValue(key, newObj, currentSelectIndex);
        } else {
            this.showEntryDetial(null);
            currentSelectIndex = changeIndex;
            if (changeIndex == -1) {
                this.getPageCache().put("isIgnoreChangeMftstock", "false");
                return;
            }
        }
        boolean isShow = this.getIsShow(changeIndex);
        switch (key) {
            case "backflushfield": {
                MPDMMftGenStocksUtils.setbackflush((Object)newObj, (int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                break;
            }
            case "materialid": {
                String name = this.getModel().getDataEntityType().getName();
                if (EntityNameUtils.getAllStockChangeName().contains(name)) {
                    String stockno = (String)this.getModel().getValue("stockno");
                    if (newObj != null && (null == stockno || "".equals(stockno))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u6e05\u5355\u7f16\u53f7\u3002", (String)"ManufstockTplEdit_24", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                        this.getModel().setValue("materialid", null, changeIndex);
                        break;
                    }
                }
                this.change4material(newObj, "materialunitid", true, changeIndex, currentSelectIndex);
                this.change4material(newObj, changeIndex, currentSelectIndex);
                this.setDefault(changeIndex, currentSelectIndex, newObj);
                this.setAuxpropLock(newObj, changeIndex, currentSelectIndex);
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                MPDMMftGenStocksUtils.change4qtyRes((String)"qtynumerator", (BigDecimal)((BigDecimal)this.getModel().getValue("qtynumerator", changeIndex)), (IDataModel)this.getModel(), (int)changeIndex, (int)currentSelectIndex, (IFormView)this.getView());
                break;
            }
            case "supplymodefield": {
                if (StringUtils.isBlank((Object)newObj)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d27\u4e3b\u7c7b\u578b\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"ManufstockTplEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("supplymodefield", oldValue);
                    this.getModel().setValue("supplymode", oldValue);
                    this.setSupplyorgfield("mustinput", currentSelectIndex);
                    break;
                }
                if (StringUtils.isBlank((Object)oldValue)) break;
                this.setSupplyorgfield("", currentSelectIndex);
                break;
            }
            case "supplyorgid": {
                this.setMaterialInvInfo(changeIndex);
                this.getModel().setValue("batchno", null, changeIndex);
                this.getModel().setValue("lot", null, changeIndex);
                break;
            }
            case "supplierfield": {
                this.setSupplyorgfield("mustinput", currentSelectIndex);
                break;
            }
            case "supplyorgfield": {
                this.setSupplyorgfield("", currentSelectIndex);
                this.getModel().setValue("warehousefield", null);
                this.getModel().setValue("warehouseid", null, currentSelectIndex);
                this.getModel().setValue("locationfield", null);
                this.getModel().setValue("location", null, currentSelectIndex);
                this.getView().setEnable(Boolean.FALSE, new String[]{"locationfield"});
                break;
            }
            case "isstockallotfield": {
                this.isstockallotChange(currentSelectIndex, currentSelectIndex);
                break;
            }
            case "outorgunitfield": {
                Boolean isstock = (Boolean)this.getModel().getValue("isstockallot", currentSelectIndex);
                if (!isstock.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"outwarehousefield"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"outwarehousefield"});
                }
                this.getModel().setValue("outwarehousefield", null);
                this.getModel().setValue("outwarehouseid", null, currentSelectIndex);
                this.getModel().setValue("outlocationfield", null);
                this.getModel().setValue("outlocation", null, currentSelectIndex);
                this.getView().setEnable(Boolean.FALSE, new String[]{"outlocationfield"});
                break;
            }
            case "useratio": {
                this.changeUseratio(changeIndex, currentSelectIndex);
            }
            case "qtynumerator": 
            case "qtydenominator": {
                BigDecimal qtydenominator;
                if ("qtydenominator".equals(key) && BigDecimal.ZERO.compareTo(qtydenominator = (BigDecimal)newObj) >= 0) {
                    this.getModel().setValue("qtydenominator", oldValue);
                    break;
                }
            }
            case "fixscrap": 
            case "wastagerateformula": 
            case "scraprate": {
                BigDecimal newDecimal = BigDecimal.ONE;
                if (!key.equals("wastagerateformula")) {
                    newDecimal = (BigDecimal)newObj;
                }
                if (!this.checkEntryMust(key.toLowerCase(), changeIndex)) break;
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                MPDMMftGenStocksUtils.change4qtyRes((String)key.toLowerCase().trim(), (BigDecimal)newDecimal, (IDataModel)this.getModel(), (int)changeIndex, (int)currentSelectIndex, (IFormView)this.getView());
                break;
            }
            case "overissuecontrlfield": {
                String overfield = (String)this.getModel().getValue("overissuecontrlfield");
                if ("B".equals(overfield)) {
                    this.getPageCache().put("isIgnoreChangeMftstock", "true");
                    MPDMMftGenStocksUtils.calHighQty((int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                    MPDMMftGenStocksUtils.calLowQty((int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                } else if ("A".equals(overfield)) {
                    this.clearLimitQty(currentSelectIndex, currentSelectIndex, "overissuecontrlfield");
                }
                MPDMMftGenStocksUtils.aculCanSendQty((int)currentSelectIndex, (IDataModel)this.getModel(), (boolean)true);
                break;
            }
            case "qtytype": {
                this.getModel().setValue("qtydenominator", (Object)BigDecimal.ONE, changeIndex);
                this.getModel().setValue("qtynumerator", (Object)BigDecimal.ZERO, changeIndex);
                this.getModel().setValue("standqty", (Object)BigDecimal.ZERO, changeIndex);
                this.getModel().setValue("demandqty", (Object)BigDecimal.ZERO, changeIndex);
                this.getModel().setValue("unissueqty", (Object)BigDecimal.ZERO, changeIndex);
                this.getModel().setValue("useqty", (Object)BigDecimal.ZERO, changeIndex);
                this.getModel().setValue("wipqty", (Object)BigDecimal.ZERO, changeIndex);
                this.getModel().setValue("useqtyfield", (Object)BigDecimal.ZERO);
                this.getModel().setValue("wipqtyfield", (Object)BigDecimal.ZERO);
                break;
            }
            case "iscannegative": {
                this.clearLimitQty(changeIndex, currentSelectIndex, "iscannegative");
                this.changeColor();
                break;
            }
            case "unissueqty": {
                MPDMMftGenStocksUtils.aculCanSendQty((int)changeIndex, (IDataModel)this.getModel(), (boolean)isShow);
                break;
            }
            case "issinhighlimitfield": {
                MPDMMftGenStocksUtils.calHighQty((int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                MPDMMftGenStocksUtils.aculCanSendQty((int)currentSelectIndex, (IDataModel)this.getModel(), (boolean)true);
                break;
            }
            case "extraratioqtyfield": {
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                MPDMMftGenStocksUtils.calHighLimit((int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
                MPDMMftGenStocksUtils.aculCanSendQty((int)currentSelectIndex, (IDataModel)this.getModel(), (boolean)true);
                break;
            }
            case "extraratioqty": {
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                MPDMMftGenStocksUtils.aculCanSendQty((int)changeIndex, (IDataModel)this.getModel(), (boolean)isShow);
                break;
            }
            case "issinlowlimitfield": {
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                MPDMMftGenStocksUtils.calLowQty((int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                break;
            }
            case "lackraitioqtyfield": {
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                MPDMMftGenStocksUtils.calLowLimit((int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "warehousefield": {
                this.getModel().setValue("warehouseid", newObj, currentSelectIndex);
                this.getModel().setValue("locationfield", null);
                this.getModel().setValue("location", null, currentSelectIndex);
                this.lockLocationField(newObj, currentSelectIndex);
                break;
            }
            case "outwarehousefield": {
                this.getModel().setValue("outwarehouseid", newObj, currentSelectIndex);
                this.getModel().setValue("outlocationfield", null);
                this.getModel().setValue("outlocation", null, currentSelectIndex);
                this.lockOutLocationField(newObj, currentSelectIndex);
                break;
            }
            case "batchno": {
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity("stockentry", changeIndex);
                String lotnumber = dynamicObject.getString("batchno");
                if (lotnumber != null) {
                    lotnumber = lotnumber.replaceAll("\u3000", " ").trim();
                    this.getModel().setValue("batchno", (Object)lotnumber, changeIndex);
                }
                this.getModel().setValue("lot", null, changeIndex);
                this.getPageCache().put("isIgnoreChangeMftstock", "false");
                break;
            }
        }
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"stockentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("stockentry", this.getSelectEntryRowIndex());
            this.showEntryDetial(entryentity);
            this.showEntryDetial(entryentity, this.getSelectEntryRowIndex());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject orderEntry = (DynamicObject)this.getModel().getValue("orderentryid");
        if (orderEntry != null && !EntityNameUtils.getAllStockChangeName().contains(this.getModel().getDataEntityType().getName())) {
            String stockName = this.getModel().getDataEntityType().getName();
            if (StringUtils.equals((CharSequence)stockName, (CharSequence)"om_componentlist")) {
                QFilter closestatus = new QFilter("billentry.id", "=", orderEntry.getPkValue());
                DynamicObject manuorder = BusinessDataServiceHelper.loadSingle((String)"pm_om_purorderbill", (String)"id,name,billno,billstatus", (QFilter[])new QFilter[]{closestatus});
                if (manuorder != null) {
                    String billstatus = manuorder.get("billstatus") == null ? "" : manuorder.getString("billstatus");
                    this.getModel().setValue("orderstatus", (Object)OrderStatusEnum.getName((String)billstatus));
                    this.getView().getModel().setDataChanged(false);
                }
            } else if (StringUtils.equals((CharSequence)stockName, (CharSequence)"om_mftstockplan")) {
                QFilter purApplybillid = new QFilter("id", "=", orderEntry.getPkValue());
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)ManufstockTplEdit.class.getName(), (String)"pm_purapplybill", (String)"id,billno,billstatus", (QFilter[])purApplybillid.toArray(), null);){
                    String billstatus = null;
                    for (Row row : ds) {
                        billstatus = row.get("billstatus") == null ? "" : row.getString("billstatus");
                    }
                    this.getModel().setValue("orderstatus", (Object)OrderStatusEnum.getName(billstatus));
                    this.getView().getModel().setDataChanged(false);
                }
            } else {
                MPDMMftGenStocksUtils.setOrderStatus((IDataModel)this.getModel(), (IFormView)this.getView());
            }
        }
        this.setControlState(false);
        this.getModel().clearNoDataRow();
        this.getModel().forceClearNoDataRow();
        MPDMMftGenStocksUtils.setUseratioEnable((IDataModel)this.getModel(), (IFormView)this.getView());
        this.lockJumpLevelRowData();
        String billstatus = this.getModel().getValue("billstatus").toString();
        if (!"A".equals(billstatus)) {
            return;
        }
        MPDMMftGenStocksUtils.setMaterialEnable((IDataModel)this.getModel(), (IFormView)this.getView());
        logger.info("\u63a7\u5236\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u53ef\u4fee\u6539\u5b57\u6bb5");
        this.lockPushEntryRow();
        this.getView().setEnable(Boolean.valueOf(!BatchMaintainHelper.checkLockedByBatchOp((String)this.getModel().getDataEntityType().getName(), (String)String.valueOf(this.getModel().getDataEntity().getPkValue()), (StringBuilder)new StringBuilder())), new String[]{"bar_modify"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String name = this.getModel().getDataEntityType().getName();
        if (this.getSelectEntryRowIndex() != -1 && StringUtils.equals((CharSequence)"deleteentry", (CharSequence)op.getOperateKey()) && !EntityNameUtils.getAllStockChangeName().contains(name)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Integer> errBOMList = new ArrayList<Integer>(selectRows.length);
            ArrayList<Integer> errPushList = new ArrayList<Integer>(selectRows.length);
            for (int j = 0; j < selectRows.length; ++j) {
                int i = selectRows[j];
                Boolean isbomextend = (Boolean)this.getModel().getValue("isbomextend", i);
                Boolean isRecipe = "F".equals(this.getModel().getValue("sourcetype", i));
                DynamicObject stockEntry = this.getModel().getEntryRowEntity("stockentry", i);
                boolean isPush = BFTrackerServiceHelper.isPush((String)name, (String)"stockentry", (Long)Long.parseLong(stockEntry.getPkValue().toString()));
                if (isbomextend.booleanValue() || isRecipe.booleanValue()) {
                    errBOMList.add(i + 1);
                    continue;
                }
                if (!isPush) continue;
                errPushList.add(i + 1);
            }
            if (!errBOMList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0d\u662f\u624b\u5de5\u65b0\u589e\u3002", (String)"ManufstockTplEdit_40", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errBOMList.stream().map(String::valueOf).collect(Collectors.joining(","))));
                e.cancel = true;
                return;
            }
            if (!errPushList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"ManufstockTplEdit_41", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errPushList.stream().map(String::valueOf).collect(Collectors.joining(","))));
                e.cancel = true;
                return;
            }
        }
        int rowcount = this.getModel().getEntryRowCount("stockentry");
        if (StringUtils.equals((CharSequence)"save", (CharSequence)op.getOperateKey()) || StringUtils.equals((CharSequence)"submit", (CharSequence)op.getOperateKey()) || "updatesave".equals(op.getOperateKey())) {
            this.saveaddva(rowcount, e, op.getOperateKey());
        } else if (StringUtils.equals((CharSequence)"change", (CharSequence)op.getOperateKey()) || StringUtils.equals((CharSequence)"omchange", (CharSequence)op.getOperateKey())) {
            this.changeaddva(e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"save", (CharSequence)messageBoxClosedEvent.getCallBackId()) || StringUtils.equals((CharSequence)"submit", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("afterconfirm", "true");
                this.getView().invokeOperation(messageBoxClosedEvent.getCallBackId(), operateOption);
            } else {
                this.updateDemandDate();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        DynamicObject entry;
        EntryGrid entryGrid;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        if (!entryEntity.isEmpty()) {
            IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
        if ("updatestock".equals(e.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)e.getOperateKey())) {
            entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            if (entryGrid.getSelectRows().length == 0) {
                this.showEntryDetial(null);
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            entry = this.getModel().getEntryRowEntity("stockentry", rowIndex);
            this.showEntryDetial(entry);
        }
        if (StringUtils.equals((CharSequence)"newentry", (CharSequence)e.getOperateKey())) {
            entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            if (entryGrid.getSelectRows().length == 0) {
                this.showEntryDetial(null);
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            String entityName = this.getModel().getDataEntityType().getName();
            DynamicObject orderEntry = (DynamicObject)this.getModel().getValue("orderentryid");
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_mftstock") && orderEntry != null) {
                this.getModel().setValue("demanddate", orderEntry.get("planbegintime"), rowIndex);
            }
            DynamicObject entry2 = this.getModel().getEntryRowEntity("stockentry", rowIndex);
            this.showEntryDetial(entry2);
        }
        if ("trackorder".equals(e.getOperateKey())) {
            String orderid = (String)this.getModel().getValue("orderid");
            BillShowParameter showParameter = new BillShowParameter();
            QFilter[] searchFilterList = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(orderid))};
            DynamicObject ds = null;
            String name = this.getModel().getDataEntityType().getName();
            showParameter.setFormId(EntityNameUtils.getEntityName((int)1, (int)0, (String)name));
            ds = BusinessDataServiceHelper.loadSingle((String)EntityNameUtils.getEntityName((int)1, (int)0, (String)name), (String)"id", (QFilter[])searchFilterList);
            if (ds != null) {
                showParameter.setPkId(ds.get(0));
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)"draw", (CharSequence)e.getOperateKey())) {
            entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            if (entryGrid.getSelectRows().length == 0) {
                this.showEntryDetial(null);
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            entry = this.getModel().getEntryRowEntity("stockentry", rowIndex);
            this.showEntryDetial(entry);
        }
        if ("unaudit".equals(e.getOperateKey()) || "unsubmit".equals(e.getOperateKey())) {
            int selectEntryRowIndex = this.getSelectEntryRowIndex();
            DynamicObject entryentity = this.getModel().getEntryRowEntity("stockentry", selectEntryRowIndex);
            this.showEntryDetial(entryentity);
            this.showEntryDetial(entryentity, this.getSelectEntryRowIndex());
        }
        if ("unaudit".equals(e.getOperateKey()) || "unsubmit".equals(e.getOperateKey())) {
            MPDMMftGenStocksUtils.setMaterialEnable((IDataModel)this.getModel(), (IFormView)this.getView());
            this.lockPushEntryRow();
        }
        if ("submit".equals(e.getOperateKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("stockentry");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("stockentry", rowIndex);
            this.showEntryDetial(entryRowEntity);
            this.getView().updateView();
        }
    }

    public void afterLoadData(EventObject e) {
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
        FieldEdit fe = (FieldEdit)this.getView().getControl("wastagerateformula");
        DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontypeid");
        if (null != tran) {
            boolean s = tran.getBoolean("isconsiderloss");
            if (s) {
                fe.setMustInput(true);
            } else {
                fe.setMustInput(false);
            }
        }
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("stockentry");
        grid.setCollapse(false);
        DynamicObjectCollection stockentry = (DynamicObjectCollection)this.getModel().getValue("stockentry");
        if (!stockentry.isEmpty()) {
            for (int i = 0; i < stockentry.size(); ++i) {
                Boolean iscancel = (Boolean)((DynamicObject)stockentry.get(i)).get("iscannegative");
                String redColor = "#000000";
                if (iscancel.booleanValue()) {
                    redColor = "#ff0000";
                }
                this.setColumsColor(redColor, this.getView(), "demandqty", i);
                this.setColumsColor(redColor, this.getView(), "actissueqty", i);
            }
        }
    }

    private void showEntryDetial(DynamicObject stockEntry, int i) {
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] billEntry2 = MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt);
        String[] billEntry4 = this.getDifferentFromString(billEntry2, ManufstockTplHelper.xentryfields);
        if (stockEntry == null) {
            return;
        }
        MPDMMftGenStocksUtils.setUseratioEnable((IDataModel)this.getModel(), (IFormView)this.getView());
        MPDMMftGenStocksUtils.setMaterialEnable((IDataModel)this.getModel(), (IFormView)this.getView());
        boolean isPush = BFTrackerServiceHelper.isPush((String)this.getModel().getDataEntityType().getName(), (String)"stockentry", (Long)Long.parseLong(stockEntry.getPkValue().toString()));
        if (isPush) {
            this.getView().setEnable(Boolean.FALSE, billEntry4);
        }
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    private void lockPushEntryRow() {
        if (!this.getModel().getDataEntity().getDataEntityState().getFromDatabase()) {
            return;
        }
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u975e\u65b0\u5efa");
        if (this.getModel().getDataEntity().getPkValue() == null) {
            return;
        }
        if (EntityNameUtils.getAllStockChangeName().contains(this.getModel().getDataEntityType().getName())) {
            return;
        }
        Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u63a7\u5236\u5b57\u6bb5\u9501\u5b9a" + pkId);
        List linkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)this.getModel().getDataEntityType().getName(), (Long[])new Long[]{pkId}, (OperateOption)OperateOption.create());
        if (linkDownNodes == null || linkDownNodes.isEmpty()) {
            return;
        }
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u975e\u65b0\u5efa");
        HashSet<Long> entryIdsExistLink = new HashSet<Long>(linkDownNodes.size());
        for (BFRowLinkDownNode node : linkDownNodes) {
            if (Long.compare(pkId, node.getRowId().getBillId()) != 0) continue;
            entryIdsExistLink.add(node.getRowId().getEntryId());
        }
        DynamicObjectCollection stockDymcol = (DynamicObjectCollection)this.getModel().getValue("stockentry");
        for (int i = 0; i < stockDymcol.size(); ++i) {
            DynamicObject stockEntry = (DynamicObject)stockDymcol.get(i);
            boolean isPush = entryIdsExistLink.contains((Long)stockEntry.getPkValue());
            if (!isPush) continue;
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u6709\u4e0b\u6e38\u5355\u636e" + i);
            this.getView().setEnable(Boolean.FALSE, i, ManufstockTplHelper.entryLockfields);
        }
    }

    private void setColumsColor(String redColor, IFormView view, String redColumn, int index) {
        EntryGrid grid = (EntryGrid)view.getControl("stockentry");
        ArrayList<CellStyle> rowStyle = new ArrayList<CellStyle>();
        CellStyle val = new CellStyle();
        val.setForeColor(redColor);
        val.setFieldKey(redColumn);
        val.setRow(index);
        val.setStyles();
        rowStyle.add(val);
        grid.setCellStyle(rowStyle);
    }

    private void changeColor() {
        int currentRow;
        int index = currentRow = this.getSelectEntryRowIndex();
        Boolean value = (Boolean)this.getModel().getValue("iscannegative", currentRow);
        String redColor = "#000000";
        if (value != null && value.booleanValue()) {
            redColor = "#ff0000";
        }
        this.setColumsColor(redColor, this.getView(), "demandqty", index);
        this.setColumsColor(redColor, this.getView(), "actissueqty", index);
    }

    private void updateDemandDate() {
        int rowcount = this.getModel().getEntryRowCount("stockentry");
        IDataModel model = this.getModel();
        HashMap calendarInfoMap = new HashMap(16);
        for (int index = 0; index < rowcount; ++index) {
            Date demanddate = (Date)model.getValue("demanddate", index);
            DynamicObject orderdym = (DynamicObject)model.getValue("orderentryid");
            if (EntityNameUtils.getAllStockChangeName().contains(model.getDataEntityType().getName())) {
                orderdym = (DynamicObject)model.getValue("entryorderentryid", index);
            }
            Date planbegintime = orderdym.getDate("planbegintime");
            DynamicObject org = (DynamicObject)model.getValue("org");
            Date workDate = CalendarUtils.getRecentleWorkDateNew((DynamicObject)org, (Date)demanddate, calendarInfoMap);
            if (CalendarUtils.compateDateAccurateDay((Date)demanddate, (Date)workDate)) continue;
            this.getModel().setValue("demanddate", (Object)planbegintime, index);
            this.updateDemandDateView();
        }
    }

    private void changeaddva(BeforeDoOperationEventArgs e) {
        String billstatus;
        StringBuilder err = new StringBuilder();
        DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontypeid");
        boolean s = tran.getBoolean("isstockchange");
        if (!s) {
            if (StringUtils.equals((CharSequence)"mpdm_transactout", (CharSequence)tran.getDataEntityType().getName())) {
                err.append(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u672a\u542f\u7528\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u3002", (String)"ManufstockTplEdit_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else if (StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)this.getModel().getDataEntityType().getName())) {
                err.append(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u672a\u542f\u7528\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u3002", (String)"ManufstockTplEdit_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                err.append(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u672a\u542f\u7528\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u3002", (String)"ManufstockTplEdit_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"pom_mftstock")) {
            String bizstatus;
            DynamicObject orderentryid = (DynamicObject)this.getModel().getValue("orderentryid");
            QFilter closestatus = new QFilter("treeentryentity.id", "=", orderentryid.getPkValue());
            DynamicObject manuorder = BusinessDataServiceHelper.loadSingle((String)"pom_mftorder", (String)"id,name,billno,treeentryentity,treeentryentity.bizstatus,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.pickstatus", (QFilter[])new QFilter[]{closestatus});
            if (manuorder != null) {
                orderentryid = MPDMMftGenStocksUtils.getManuEntryByEntryID((DynamicObject)manuorder, (String)orderentryid.getPkValue().toString());
            }
            if (!"A".equals(bizstatus = orderentryid.getString("bizstatus"))) {
                err.append(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u3002", (String)"ManufstockTplEdit_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        }
        if (!"C".equals(billstatus = (String)this.getModel().getValue("billstatus"))) {
            err.append(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\u3002", (String)"ManufstockTplEdit_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (err.length() > 0) {
            this.getView().showTipNotification(err.toString());
            e.setCancel(true);
        }
    }

    private void saveaddva(int rowcount, BeforeDoOperationEventArgs e, String saveorsubmit) {
        String info;
        IDataModel model = this.getModel();
        FormOperate op = (FormOperate)e.getSource();
        RefObject afterConfirm = new RefObject();
        if (op.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            return;
        }
        ArrayList<Integer> materialList = new ArrayList<Integer>();
        ArrayList<Integer> locationList = new ArrayList<Integer>();
        ArrayList<Integer> backflushtimeList = new ArrayList<Integer>();
        ArrayList<Integer> overissuecontrlList = new ArrayList<Integer>();
        ArrayList<Integer> demanddateList = new ArrayList<Integer>();
        ArrayList<Integer> demandDateNullList = new ArrayList<Integer>();
        ArrayList<Integer> outorgunit = new ArrayList<Integer>();
        ArrayList<Integer> wastagerateList = new ArrayList<Integer>();
        ArrayList<Integer> supplierList = new ArrayList<Integer>();
        ArrayList<Integer> supplyorgList = new ArrayList<Integer>();
        ArrayList<Integer> isbackflushList = new ArrayList<Integer>();
        ArrayList<Integer> issuemodeList = new ArrayList<Integer>();
        List<Object> replaceList = new ArrayList();
        List<Object> equalsMainList = new ArrayList();
        String stockName = model.getDataEntityType().getName();
        if (!EntityNameUtils.getAllStockChangeName().contains(stockName)) {
            replaceList = this.getReplaceList();
        }
        DynamicObject transactionType = (DynamicObject)model.getValue("transactiontypeid");
        String bizBomType = "";
        boolean checkMain = false;
        if (transactionType != null) {
            if ("mpdm_transactout".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("feedtype");
                checkMain = !"E".equals(bizBomType);
            } else if ("mpdm_transactproduct".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("stockmaterials");
                boolean bl = checkMain = !"B".equals(bizBomType);
                if (TransactionTypeQueryHelper.isReworkTransType((DynamicObject)transactionType)) {
                    checkMain = false;
                }
            }
        }
        if (checkMain) {
            equalsMainList = this.getEqualsMainList(model.getDataEntityType().getName());
        }
        HashMap calendarInfoMap = new HashMap(16);
        for (int index = 0; index < rowcount; ++index) {
            DynamicObject org;
            Date workDate;
            DynamicObject supplyorg;
            String wastagerate;
            DynamicObject tran;
            boolean s;
            Object outorg;
            Boolean isstockallot;
            String overissuecontrl;
            String backflushtime;
            String isbackflush;
            DynamicObject materialMft = (DynamicObject)model.getValue("materialid", index);
            if (materialMft == null) {
                materialList.add(index + 1);
            }
            if (!("A".equals(isbackflush = (String)model.getValue("isbackflush", index)) || "B".equals(isbackflush) || "C".equals(isbackflush))) {
                isbackflushList.add(index + 1);
            }
            String issuemode = (String)model.getValue("issuemode", index);
            DynamicObject warehouse = (DynamicObject)model.getValue("warehouseid", index);
            if ("B".equals(isbackflush) && ("A".equals(issuemode) || "B".equals(issuemode)) && !"A".equals(backflushtime = (String)model.getValue("backflushtime", index)) && !"B".equals(backflushtime)) {
                backflushtimeList.add(index + 1);
            }
            if (!"A".equals(overissuecontrl = (String)model.getValue("overissuecontrl", index)) && !"B".equals(overissuecontrl) && ("A".equals(issuemode) || "B".equals(issuemode))) {
                overissuecontrlList.add(index + 1);
            }
            if (warehouse != null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                Boolean isopenlocation = warehouse.getBoolean("isopenlocation");
                if ("B".equals(isbackflush) && isopenlocation.booleanValue() && model.getValue("location", index) == null) {
                    locationList.add(index + 1);
                }
            }
            if ((isstockallot = (Boolean)model.getValue("isstockallot", index)).booleanValue() && StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)stockName) && (outorg = model.getValue("outorgunitid", index)) == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                outorgunit.add(index + 1);
            }
            if ((s = (tran = (DynamicObject)this.getModel().getValue("transactiontypeid")).getBoolean("isconsiderloss")) && !"A".equals(wastagerate = (String)this.getModel().getValue("wastagerateformula", index)) && !"B".equals(wastagerate)) {
                wastagerateList.add(index + 1);
            }
            String supplyfield = (String)this.getModel().getValue("supplymode", index);
            DynamicObject supply = (DynamicObject)this.getModel().getValue("supplierid", index);
            if ("bos_org".equals(supplyfield) && supply == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                supplierList.add(index + 1);
            }
            if ((supplyorg = (DynamicObject)model.getValue("supplyorgid", index)) == null && ("A".equals(issuemode) || "B".equals(issuemode))) {
                supplyorgList.add(index + 1);
            }
            if (!("A".equals(issuemode) || "B".equals(issuemode) || "C".equals(issuemode))) {
                issuemodeList.add(index + 1);
            }
            Date demanddate = (Date)model.getValue("demanddate", index);
            DynamicObject orderdym = (DynamicObject)model.getValue("orderentryid");
            if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"om_componentlist") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"om_xxcomponentlist") || (orderdym = EntityNameUtils.getAllStockChangeName().contains(model.getDataEntityType().getName()) ? (DynamicObject)model.getValue("entryorderentryid", index) : (DynamicObject)model.getValue("orderentryid")) == null) continue;
            Date planendtime = orderdym.getDate("planendtime");
            Date planbeginime = orderdym.getDate("planbegintime");
            if (demanddate == null) {
                demanddate = planbeginime;
            }
            if (demanddate.after(planendtime)) {
                demanddate = planendtime;
            }
            if (null == (workDate = CalendarUtils.getRecentleWorkDateNew((DynamicObject)(org = (DynamicObject)model.getValue("org")), (Date)demanddate, calendarInfoMap))) {
                this.getModel().setValue("demanddate", (Object)demanddate, index);
                demandDateNullList.add(index + 1);
                continue;
            }
            if (!CalendarUtils.compateDateAccurateDay((Date)demanddate, (Date)workDate)) {
                this.getModel().setValue("demanddate", (Object)demanddate, index);
                demanddateList.add(index + 1);
                continue;
            }
            this.getModel().setValue("demanddate", (Object)demanddate, index);
            this.updateDemandDateView();
        }
        StringBuilder err = new StringBuilder();
        StringBuilder confirmstr = new StringBuilder();
        if (!equalsMainList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(equalsMainList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u7ec4\u4ef6\u7f16\u7801\u7b49\u4e8e\u4ea7\u54c1\u7f16\u7801\u3002", (String)"ManufstockTplEdit_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!replaceList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(replaceList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u66ff\u4ee3\u5173\u7cfb\u4f7f\u7528\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u7b49\u4e8e100%\u3002", (String)"ManufstockTplEdit_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!materialList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(materialList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7ec4\u4ef6\u7f16\u7801\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!locationList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(locationList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u4e3a\u5012\u51b2\u7ec4\u4ef6\uff0c\u4e14\u4f9b\u8d27\u4ed3\u5e93\u542f\u7528\u4e86\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u586b\u5199\u201c\u4f9b\u8d27\u4ed3\u4f4d\u201d\u3002", (String)"ManufstockTplEdit_36", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!backflushtimeList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(backflushtimeList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u5012\u51b2\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\uff0c\u5012\u51b2\u65f6\u673a\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_14", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!overissuecontrlList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(overissuecontrlList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u8d85\u53d1\u63a7\u5236\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_15", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!outorgunit.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(outorgunit.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u7269\u6599\u542f\u7528\u5907\u6599\u8c03\u62e8\uff0c\u8c03\u51fa\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_16", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!wastagerateList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(wastagerateList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u635f\u8017\u8ba1\u7b97\u516c\u5f0f\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_17", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!supplierList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(supplierList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u8d27\u4e3b\u7c7b\u578b\u4e3a\u4e1a\u52a1\u5355\u5143\uff0c\u8d27\u4e3b\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_18", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!supplyorgList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(supplyorgList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u4f9b\u8d27\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_19", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!isbackflushList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(isbackflushList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u5012\u51b2\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_20", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (!issuemodeList.isEmpty()) {
            err.append(ResManager.loadKDString((String)"\u7b2c", (String)"ManufstockTplEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            err.append(issuemodeList.stream().map(String::valueOf).collect(Collectors.joining(",")));
            err.append(ResManager.loadKDString((String)"\u884c\u5206\u5f55\u9886\u9001\u6599\u65b9\u5f0f\u5fc5\u586b\u3002", (String)"ManufstockTplEdit_21", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> infoList = new ArrayList<String>(10);
        if (!demandDateNullList.isEmpty()) {
            info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u672a\u627e\u5230\u751f\u4ea7\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u751f\u4ea7\u65e5\u5386\u6216\u9700\u6c42\u65e5\u671f\u4e0d\u5728\u65e5\u5386\u8bbe\u7f6e\u4e2d\u65e5\u5386\u7684\u6709\u6548\u671f\u8303\u56f4\u5185", (String)"ManufstockTplEdit_42", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\uff0c").join(demandDateNullList));
            infoList.add(info);
        }
        if (!demanddateList.isEmpty()) {
            info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u9700\u6c42\u65e5\u671f\u4e0d\u5728\u5de5\u4f5c\u65e5\u5185", (String)"ManufstockTplEdit_43", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\uff0c").join(demanddateList));
            infoList.add(info);
        }
        if (CollectionUtils.isNotEmpty(infoList)) {
            info = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ManufstockTplEdit_44", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), Joiner.on((String)"\uff0c").join(infoList));
            confirmstr.append(info);
        }
        if (err.length() > 0) {
            this.getView().showTipNotification(err.toString());
            e.setCancel(true);
        } else if (confirmstr.length() > 0 && !op.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(saveorsubmit, (IFormPlugin)this);
            String confirmTip = confirmstr.toString();
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            e.setCancel(true);
        }
    }

    private List<Integer> getEqualsMainList(String entityName) {
        ArrayList<Integer> equalsMainList = new ArrayList<Integer>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        if (EntityNameUtils.getAllStockChangeName().contains(entityName)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                String changeType = entry.getString("entrychangetype");
                if (!"A".equals(changeType)) continue;
                String productId = "";
                DynamicObject productDym = entry.getDynamicObject("productno");
                if (productDym != null) {
                    productId = productDym.getPkValue().toString();
                }
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        } else if (entityName.equals("om_componentlist")) {
            String productId = "";
            DynamicObject productDym = (DynamicObject)this.getModel().getValue("productid");
            if (productDym != null) {
                productId = productDym.getDynamicObject("masterid").getPkValue().toString();
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getDynamicObject("masterid").getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        } else {
            String productId = "";
            DynamicObject productDym = (DynamicObject)this.getModel().getValue("productid");
            if (productDym != null) {
                productId = productDym.getPkValue().toString();
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        }
        return equalsMainList;
    }

    private List<Integer> getReplaceList() {
        ArrayList<Integer> replaceList = new ArrayList<Integer>();
        DynamicObjectCollection stockRows = this.getModel().getEntryEntity("stockentry");
        Map<String, List<DynamicObject>> groupedPlanId = stockRows.stream().filter(stockEntry -> stockEntry.getDynamicObject("replaceplan") != null).collect(Collectors.groupingBy(entry -> {
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            String planId = replacePlan.getPkValue().toString();
            String planGroupId = entry.getString("replacegroupid");
            String plan = planId + planGroupId;
            return plan;
        }));
        for (Map.Entry<String, List<DynamicObject>> entry2 : groupedPlanId.entrySet()) {
            List<DynamicObject> sameGroup = entry2.getValue();
            BigDecimal sum = BigDecimal.ZERO;
            HashSet<Integer> seenPriorities = new HashSet<Integer>();
            int parentIndex = -1;
            for (DynamicObject item : sameGroup) {
                int priority = item.getInt("priority");
                if ("0".equals(item.getString("pid")) && item.getBoolean("ismainreplace")) {
                    parentIndex = item.getInt("seq");
                    sum = sum.add(item.getBigDecimal("useratio"));
                }
                if ("0".equals(item.getString("pid")) || !seenPriorities.add(priority)) continue;
                sum = sum.add(item.getBigDecimal("useratio"));
            }
            if (sum.compareTo(new BigDecimal(100)) == 0 || parentIndex == -1) continue;
            replaceList.add(parentIndex);
        }
        return replaceList;
    }

    private void updateDemandDateView() {
        Object seqf = this.getModel().getValue("seqfield");
        if (seqf != null) {
            int i = (Integer)seqf;
            Date demand = (Date)this.getModel().getValue("demanddate", i - 1);
            this.getModel().setValue("demanddatefield", (Object)demand);
        }
    }

    private void setControlState(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bomversionfield", "auxpropertyfield", "supplymodefield", "supplierfield", "supplyorgfield", "warehousefield", "locationfield", "outorgunitfield", "outwarehousefield", "outlocationfield", "issuemodefield", "backflushfield", "backflushtimefield", "iskeypartfield", "considerminbatchfield", "overissuecontrlfield", "issinhighlimitfield", "extraratioqtyfield", "issinlowlimitfield", "lackraitioqtyfield", "leadtimefield", "demanddatefield", "setuplocationfield", "childremarksfield", "rejectedqtyfield", "feedingqtyfield", "scrapqtyfield", "wipqtyfield", "useqtyfield", "cansendqtyfield", "isstockallotfield", "isbulkmaterialfield"});
    }

    private void change4material(Object newObj, String destObject, boolean isEntry, int changeIndex, int currentSelectIndex) {
        if (newObj == null) {
            if (isEntry) {
                this.getModel().setValue(destObject, null, changeIndex);
                this.getModel().setValue("materialunitidfield", null);
                this.getModel().setValue("batchno", null, changeIndex);
                this.getModel().setValue("lot", null, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("batchnofield", null);
                }
            } else {
                this.getModel().setValue(destObject, null);
            }
        } else {
            DynamicObject mateMft = (DynamicObject)newObj;
            DynamicObject material = mateMft.getDynamicObject("masterid");
            DynamicObject baseunit = (material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue())).getDynamicObject("baseunit");
            if (baseunit != null && isEntry) {
                this.getModel().setValue(destObject, null, changeIndex);
                this.getModel().setValue(destObject, (Object)baseunit, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("materialunitidfield", null);
                    this.getModel().setValue("materialunitidfield", baseunit.get("id"));
                }
            }
        }
    }

    private void change4material(Object newObj, int changeIndex, int currentSelectIndex) {
        this.getModel().setValue("entryconfiguredcode", null, changeIndex);
        if (newObj == null) {
            this.getModel().setValue("isbackflush", (Object)"A", changeIndex);
            this.getModel().setValue("iskeypart", (Object)Boolean.FALSE, changeIndex);
            this.getModel().setValue("considerminbatch", (Object)Boolean.FALSE, changeIndex);
            this.getModel().setValue("overissuecontrl", (Object)"B", changeIndex);
            this.getModel().setValue("issinhighlimit", (Object)BigDecimal.ZERO, changeIndex);
            this.getModel().setValue("extraratioqty", (Object)BigDecimal.ZERO, changeIndex);
            this.getModel().setValue("issinlowlimit", (Object)BigDecimal.ZERO, changeIndex);
            this.getModel().setValue("lackraitioqty", (Object)BigDecimal.ZERO, changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getModel().setValue("materielfield", null);
                this.getModel().setValue("backflushfield", (Object)Boolean.FALSE);
                this.getModel().setValue("iskeypartfield", (Object)Boolean.FALSE);
                this.getModel().setValue("considerminbatchfield", (Object)Boolean.FALSE);
                this.getModel().setValue("overissuecontrlfield", (Object)"B");
                this.getModel().setValue("issinhighlimitfield", (Object)BigDecimal.ZERO);
                this.getModel().setValue("extraratioqtyfield", (Object)BigDecimal.ZERO);
                this.getModel().setValue("issinlowlimitfield", (Object)BigDecimal.ZERO);
                this.getModel().setValue("lackraitioqtyfield", (Object)BigDecimal.ZERO);
            }
        } else {
            String changetype = "A";
            if (StringUtils.equals((CharSequence)changetype, (CharSequence)"A")) {
                String isquotacontrol;
                DynamicObject mtfmaterial = (DynamicObject)newObj;
                this.getModel().setValue("isbackflush", mtfmaterial.get("isbackflush"), changeIndex);
                this.getModel().setValue("iskeypart", mtfmaterial.get("iskeypart"), changeIndex);
                this.getModel().setValue("considerminbatch", mtfmaterial.get("considerminbatch"), changeIndex);
                BigDecimal issinhighlimit = mtfmaterial.get("issinhighlimit") == null ? BigDecimal.ZERO : mtfmaterial.getBigDecimal("issinhighlimit");
                this.getModel().setValue("issinhighlimit", (Object)issinhighlimit, changeIndex);
                BigDecimal demandQty = (BigDecimal)this.getModel().getValue("demandqty");
                BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.add(issinhighlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
                this.getModel().setValue("extraratioqty", (Object)extraratioqty, changeIndex);
                BigDecimal issinlowlimit = mtfmaterial.get("issinlowlimit") == null ? BigDecimal.ZERO : mtfmaterial.getBigDecimal("issinlowlimit");
                this.getModel().setValue("issinlowlimit", (Object)issinlowlimit, changeIndex);
                BigDecimal lackraitioqty = demandQty.multiply(BigDecimal.ONE.subtract(issinlowlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
                this.getModel().setValue("lackraitioqty", (Object)lackraitioqty, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("materielfield", (Object)mtfmaterial);
                    this.getModel().setValue("backflushfield", mtfmaterial.get("isbackflush"));
                    this.getModel().setValue("iskeypartfield", mtfmaterial.get("iskeypart"));
                    this.getModel().setValue("considerminbatchfield", mtfmaterial.get("considerminbatch"));
                    this.getModel().setValue("issinhighlimitfield", (Object)issinhighlimit);
                    this.getModel().setValue("extraratioqtyfield", (Object)extraratioqty);
                    this.getModel().setValue("issinlowlimitfield", (Object)issinlowlimit);
                    this.getModel().setValue("lackraitioqtyfield", (Object)lackraitioqty);
                }
                String string = isquotacontrol = mtfmaterial.get("isquotacontrol") == null ? "" : mtfmaterial.getString("isquotacontrol");
                if (StringUtils.equals((CharSequence)isquotacontrol, (CharSequence)"true")) {
                    this.getModel().setValue("overissuecontrl", (Object)"B", changeIndex);
                    if (changeIndex == currentSelectIndex) {
                        this.getModel().setValue("overissuecontrlfield", (Object)"B");
                    }
                } else {
                    this.getModel().setValue("overissuecontrl", (Object)"A", changeIndex);
                    if (changeIndex == currentSelectIndex) {
                        this.getModel().setValue("overissuecontrlfield", (Object)"A");
                    }
                }
            }
        }
    }

    private boolean checkFieldValueNull(String fieldname) {
        Object value = this.getModel().getValue(fieldname);
        if (value != null) {
            String valuestr;
            if (value instanceof DynamicObject) {
                DynamicObject doValue = (DynamicObject)value;
                return doValue.getLong("id") <= 0L;
            }
            return value instanceof String && (StringUtils.isEmpty((CharSequence)(valuestr = (String)value)) || StringUtils.equalsIgnoreCase((CharSequence)valuestr, (CharSequence)"none"));
        }
        return true;
    }

    private void showEntryDetial(DynamicObject entryentity) {
        logger.info("----------------\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355 \u70b9\u51fb\u5206\u5f55\u5f00\u59cb\u52a0\u8f7d\u5206\u5f55-----------------------------");
        this.getPageCache().put("isIgnoreChangeMftstock", "true");
        IDataModel model = this.getModel();
        String name = this.getModel().getDataEntityType().getName();
        if (entryentity != null && this.getSelectEntryRowIndex() != -1) {
            if (StringUtils.equals((CharSequence)this.getModel().getValue("billstatus").toString(), (CharSequence)"A") && !this.isJumpLevel(entryentity)) {
                this.setControlState(true);
            } else {
                this.setControlState(false);
            }
            DynamicObject material = entryentity.getDynamicObject("materialid");
            DynamicObject baseunit = entryentity.getDynamicObject("materialunitid");
            model.setValue("seqfield", entryentity.get("seq"));
            model.setValue("materielfield", material == null ? null : material.getPkValue());
            model.setValue("materialunitidfield", null);
            model.setValue("materialunitidfield_qty", null);
            model.setValue("materialunitidfield", (Object)baseunit);
            model.setValue("materialunitidfield_qty", (Object)baseunit);
            model.setValue("bomversionfield", entryentity.get("childbomversion"));
            DynamicObject auxproperty = (DynamicObject)entryentity.get("childauxpropertyid");
            model.setValue("auxpropertyfield", (Object)auxproperty);
            model.setValue("isbulkmaterialfield", entryentity.get("isbulkmaterial"));
            model.setValue("isstockallotfield", entryentity.get("isstockallot"));
            model.setValue("supplymodefield", entryentity.get("supplymode"));
            model.setValue("supplierfield", entryentity.get("supplierid"));
            model.setValue("supplyorgfield", (Object)entryentity.getDynamicObject("supplyorgid"));
            model.setValue("warehousefield", (Object)entryentity.getDynamicObject("warehouseid"));
            this.lockLocationField(entryentity.getDynamicObject("warehouseid"), this.getSelectEntryRowIndex());
            model.setValue("locationfield", (Object)entryentity.getDynamicObject("location"));
            model.setValue("outorgunitfield", (Object)entryentity.getDynamicObject("outorgunitid"));
            model.setValue("outwarehousefield", (Object)entryentity.getDynamicObject("outwarehouseid"));
            this.lockOutLocationField(entryentity.getDynamicObject("outwarehouseid"), this.getSelectEntryRowIndex());
            model.setValue("outlocationfield", (Object)entryentity.getDynamicObject("outlocation"));
            model.setValue("issuemodefield", entryentity.get("issuemode"));
            model.setValue("backflushfield", entryentity.get("isbackflush"));
            model.setValue("backflushtimefield", entryentity.get("backflushtime"));
            model.setValue("iskeypartfield", (Object)entryentity.getBoolean("iskeypart"));
            model.setValue("considerminbatchfield", (Object)entryentity.getBoolean("considerminbatch"));
            model.setValue("overissuecontrlfield", entryentity.get("overissuecontrl"));
            model.setValue("issinhighlimitfield", entryentity.get("issinhighlimit"));
            model.setValue("extraratioqtyfield", entryentity.get("extraratioqty"));
            model.setValue("issinlowlimitfield", entryentity.get("issinlowlimit"));
            model.setValue("lackraitioqtyfield", entryentity.get("lackraitioqty"));
            model.setValue("leadtimefield", entryentity.get("leadtime"));
            model.setValue("demanddatefield", (Object)entryentity.getDate("demanddate"));
            model.setValue("setuplocationfield", entryentity.get("setuplocation"));
            model.setValue("childremarksfield", entryentity.get("childremarks"));
            model.setValue("seqfield_qty", entryentity.get("seq"));
            model.setValue("materielfield_qty", material == null ? null : material.getPkValue());
            model.setValue("standqtyfield_qty", (Object)entryentity.getBigDecimal("standqty"));
            model.setValue("demandqtyfield", (Object)entryentity.getBigDecimal("demandqty"));
            model.setValue("actissueqtyfield", (Object)entryentity.getBigDecimal("actissueqty"));
            model.setValue("allotqtyfield", (Object)entryentity.getBigDecimal("allotqty"));
            model.setValue("rejectedqtyfield", (Object)entryentity.getBigDecimal("rejectedqty"));
            model.setValue("feedingqtyfield", (Object)entryentity.getBigDecimal("feedingqty"));
            model.setValue("scrapqtyfield", (Object)entryentity.getBigDecimal("scrapqty"));
            model.setValue("wipqtyfield", (Object)entryentity.getBigDecimal("wipqty"));
            model.setValue("useqtyfield", (Object)entryentity.getBigDecimal("useqty"));
            model.setValue("cansendqtyfield", (Object)entryentity.getBigDecimal("cansendqty"));
            DynamicObject trandym = (DynamicObject)this.getModel().getValue("transactiontypeid");
            this.setAuxpropLock(material, this.getSelectEntryRowIndex(), this.getSelectEntryRowIndex());
            if (StringUtils.equals((CharSequence)"mpdm_transactout", (CharSequence)trandym.getDataEntityType().getName())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"backflushtimefield"});
            } else if (trandym != null) {
                if ("B".equals(entryentity.get("isbackflush"))) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"backflushtimefield"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"backflushtimefield"});
                }
            }
            if ("pom_mftstock".equals(name) || "pom_xmftstock".equals(name)) {
                model.setValue("beginworkbffield", entryentity.get("beginworkbf"));
            }
        } else {
            model.setValue("seqfield", null);
            model.setValue("materielfield", null);
            model.setValue("materialunitidfield", null);
            model.setValue("bomversionfield", null);
            model.setValue("auxpropertyfield", null);
            model.setValue("supplymodefield", null);
            model.setValue("supplierfield", null);
            model.setValue("supplyorgfield", null);
            model.setValue("warehousefield", null);
            model.setValue("locationfield", null);
            model.setValue("outorgunitfield", null);
            model.setValue("outwarehousefield", null);
            model.setValue("outlocationfield", null);
            model.setValue("issuemodefield", null);
            model.setValue("backflushfield", null);
            model.setValue("backflushtimefield", null);
            model.setValue("iskeypartfield", (Object)Boolean.FALSE);
            model.setValue("considerminbatchfield", (Object)Boolean.FALSE);
            model.setValue("overissuecontrlfield", null);
            model.setValue("issinhighlimitfield", null);
            model.setValue("extraratioqtyfield", null);
            model.setValue("issinlowlimitfield", null);
            model.setValue("lackraitioqtyfield", null);
            model.setValue("leadtimefield", null);
            model.setValue("demanddatefield", null);
            model.setValue("setuplocationfield", null);
            model.setValue("childremarksfield", null);
            model.setValue("seqfield_qty", null);
            model.setValue("materielfield_qty", null);
            model.setValue("materialunitidfield_qty", null);
            model.setValue("standqtyfield_qty", null);
            model.setValue("demandqtyfield", null);
            model.setValue("actissueqtyfield", null);
            model.setValue("allotqtyfield", null);
            model.setValue("rejectedqtyfield", (Object)BigDecimal.ZERO);
            model.setValue("feedingqtyfield", (Object)BigDecimal.ZERO);
            model.setValue("scrapqtyfield", (Object)BigDecimal.ZERO);
            model.setValue("wipqtyfield", (Object)BigDecimal.ZERO);
            model.setValue("useqtyfield", (Object)BigDecimal.ZERO);
            model.setValue("cansendqtyfield", (Object)BigDecimal.ZERO);
            if ("pom_mftstock".equals(name) || "pom_xmftstock".equals(name)) {
                model.setValue("beginworkbffield", (Object)false);
            }
            this.setControlState(false);
        }
        if (this.getSelectEntryRowIndex() > -1) {
            this.setSupplyorgfield("mustinput", this.getSelectEntryRowIndex());
        }
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
        logger.info("----------------\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355 \u52a0\u8f7d\u5206\u5f55\u7ed3\u675f-----------------------------------");
    }

    private int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    private void setEntryDownFieldValue(String key, Object newObj, int currentSelectIndex) {
        String entryFieldName = ManufstockTplHelper.getEntryFieldName(key);
        if (StringUtils.isNotEmpty((CharSequence)entryFieldName) && currentSelectIndex >= 0) {
            if (newObj instanceof LocaleDynamicObjectCollection) {
                LocaleDynamicObjectCollection locales = (LocaleDynamicObjectCollection)newObj;
                String str = locales.size() > 0 ? ((DynamicObject)locales.get(0)).getString(key) : "";
                this.getModel().setValue(entryFieldName, (Object)str, currentSelectIndex);
            } else {
                this.getModel().setValue(entryFieldName, newObj, currentSelectIndex);
            }
        }
    }

    private boolean getIsShow(int currentIndex) {
        return currentIndex == this.getSelectEntryRowIndex() && currentIndex != -1;
    }

    private void changeUseratio(int changeIndex, int currentSelectIndex) {
        DynamicObject firstDym = (DynamicObject)this.getModel().getValue("replaceplan", changeIndex);
        if (firstDym == null) {
            return;
        }
        String pId = this.getModel().getValue("pid", changeIndex).toString();
        long replaceGroupId = (Long)this.getModel().getValue("replacegroupid", changeIndex);
        int priority = (Integer)this.getModel().getValue("priority", changeIndex);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || changeIndex == i || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || !pId.equals(entry.getString("pid")) || priority != entry.getInt("priority") || replaceGroupId != entry.getLong("replacegroupid")) continue;
            this.getModel().setValue("useratio", this.getModel().getValue("useratio", changeIndex), i);
            this.getPageCache().put("isIgnoreChangeMftstock", "true");
            MPDMMftGenStocksUtils.change4qtyRes((String)"useratio", (BigDecimal)BigDecimal.ONE, (IDataModel)this.getModel(), (int)i, (int)currentSelectIndex, (IFormView)this.getView());
            this.getPageCache().put("isIgnoreChangeMftstock", "false");
        }
        this.changeParentUseratio(changeIndex, currentSelectIndex);
    }

    private void changeParentUseratio(int changeIndex, int currentSelectIndex) {
        DynamicObject firstDym = (DynamicObject)this.getModel().getValue("replaceplan", changeIndex);
        if (firstDym == null) {
            return;
        }
        String pId = this.getModel().getValue("pid", changeIndex).toString();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        if (pId.equals("0")) {
            return;
        }
        BigDecimal childUseratio = BigDecimal.ZERO;
        int parentIndex = -1;
        ArrayList<Integer> childList = new ArrayList<Integer>();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null) continue;
            if (entry.getPkValue().toString().equals(pId)) {
                parentIndex = i;
            }
            if (!replacePlan.getPkValue().equals(firstDym.getPkValue()) || !pId.equals(entry.getString("pid"))) continue;
            boolean isUsed = false;
            Integer childPriority = entry.getInt("priority");
            for (int j = 0; j < childList.size(); ++j) {
                if (!childPriority.equals(childList.get(j))) continue;
                isUsed = true;
            }
            if (isUsed) continue;
            childUseratio = childUseratio.add(entry.getBigDecimal("useratio"));
            childList.add(childPriority);
        }
        if (parentIndex == -1) {
            return;
        }
        if (childUseratio.compareTo(new BigDecimal(100)) <= 0) {
            this.getModel().setValue("useratio", (Object)new BigDecimal(100).subtract(childUseratio), parentIndex);
            this.getPageCache().put("isIgnoreChangeMftstock", "true");
            MPDMMftGenStocksUtils.change4qtyRes((String)"useratio", (BigDecimal)BigDecimal.ONE, (IDataModel)this.getModel(), (int)parentIndex, (int)changeIndex, (IFormView)this.getView());
            this.changeParentUseratioByChild(parentIndex, new BigDecimal(100).subtract(childUseratio));
        } else {
            this.getModel().setValue("useratio", (Object)0, parentIndex);
            this.getPageCache().put("isIgnoreChangeMftstock", "true");
            MPDMMftGenStocksUtils.change4qtyRes((String)"useratio", (BigDecimal)BigDecimal.ONE, (IDataModel)this.getModel(), (int)parentIndex, (int)changeIndex, (IFormView)this.getView());
            this.changeParentUseratioByChild(parentIndex, BigDecimal.ONE);
        }
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
    }

    private void changeParentUseratioByChild(int currentIndex, BigDecimal childUseratio) {
        DynamicObject firstDym = (DynamicObject)this.getModel().getValue("replaceplan", currentIndex);
        if (firstDym == null) {
            return;
        }
        String pId = this.getModel().getValue("pid", currentIndex).toString();
        long replaceGroupId = (Long)this.getModel().getValue("replacegroupid", currentIndex);
        int priority = (Integer)this.getModel().getValue("priority", currentIndex);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || currentIndex == i || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || !pId.equals(entry.getString("pid")) || priority != entry.getInt("priority") || replaceGroupId != entry.getLong("replacegroupid")) continue;
            this.getModel().setValue("useratio", (Object)childUseratio, i);
            this.getPageCache().put("isIgnoreChangeMftstock", "true");
            MPDMMftGenStocksUtils.change4qtyRes((String)"useratio", (BigDecimal)BigDecimal.ONE, (IDataModel)this.getModel(), (int)i, (int)currentIndex, (IFormView)this.getView());
            this.getPageCache().put("isIgnoreChangeMftstock", "false");
        }
    }

    private void clearLimitQty(int changeIndex, int currentSelectIndex, String key) {
        Object demandqty = this.getModel().getValue("demandqty", changeIndex);
        this.getModel().setValue("issinhighlimit", (Object)BigDecimal.ZERO, changeIndex);
        this.getModel().setValue("extraratioqty", demandqty, changeIndex);
        this.getModel().setValue("issinlowlimit", (Object)BigDecimal.ZERO, changeIndex);
        this.getModel().setValue("lackraitioqty", demandqty, changeIndex);
        this.getModel().setValue("overissuecontrl", (Object)"A", changeIndex);
        boolean isShow = false;
        if (changeIndex == currentSelectIndex) {
            isShow = true;
            this.getModel().setValue("issinhighlimitfield", (Object)BigDecimal.ZERO);
            this.getModel().setValue("extraratioqtyfield", demandqty);
            this.getModel().setValue("issinlowlimitfield", (Object)BigDecimal.ZERO);
            this.getModel().setValue("lackraitioqtyfield", demandqty);
        }
        this.getModel().setValue("overissuecontrlfield", (Object)"A");
        this.lockLimitQty(changeIndex, currentSelectIndex);
        if (key.equals("iscannegative")) {
            if (((Boolean)this.getModel().getValue("iscannegative", changeIndex)).booleanValue()) {
                this.getModel().setValue("actissueqty", this.getModel().getValue("demandqty", changeIndex), changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("actissueqtyfield", this.getModel().getValue("demandqty", changeIndex));
                }
            } else {
                this.getModel().setValue("actissueqty", (Object)BigDecimal.ZERO, changeIndex);
                if (changeIndex == currentSelectIndex) {
                    this.getModel().setValue("actissueqtyfield", (Object)BigDecimal.ZERO);
                }
            }
        }
        MPDMMftGenStocksUtils.aculCanSendQty((int)changeIndex, (IDataModel)this.getModel(), (boolean)isShow);
        DynamicObject stockEntry = this.getModel().getEntryRowEntity("stockentry", changeIndex);
        DynamicObject orderEntry = EntityNameUtils.getAllStockChangeName().contains(this.getModel().getDataEntityType().getName()) ? (DynamicObject)this.getModel().getValue("entryorderentryid", changeIndex) : (DynamicObject)this.getModel().getValue("orderentryid");
        if (orderEntry == null) {
            return;
        }
        DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontypeid");
        this.getModel().setValue("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry), changeIndex);
        String modelName = this.getModel().getDataEntityType().getName();
        String ordername = "";
        ordername = EntityNameUtils.getAllStockChangeName().contains(modelName) ? EntityNameUtils.getEntityName((int)3, (int)0, (String)modelName) : EntityNameUtils.getEntityName((int)1, (int)0, (String)modelName);
        stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty((DynamicObject)stockEntry, (Object)orderEntry.getPkValue(), (DynamicObject)transactiontype, (String)ordername));
        this.getModel().setValue("useqty", stockEntry.get("useqty"), changeIndex);
        if (changeIndex == currentSelectIndex) {
            this.getModel().setValue("useqtyfield", stockEntry.get("useqty"));
        }
        stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry));
        this.getModel().setValue("wipqty", stockEntry.get("wipqty"), changeIndex);
        if (changeIndex == currentSelectIndex) {
            this.getModel().setValue("wipqtyfield", stockEntry.get("wipqty"));
        }
    }

    private void lockLocationField(Object newObj, int changeIndex) {
        Long dyObjId = DyObjUtils.getDyObjId((Object)newObj);
        if (!DyObjUtils.isEmptyId((Long)dyObjId)) {
            long warehouseId = dyObjId;
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !this.isJumpLevel(changeIndex)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"locationfield"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"locationfield"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"locationfield"});
        }
    }

    private void lockOutLocationField(Object newObj, int changeIndex) {
        if (newObj != null) {
            long warehouseId = (Long)((DynamicObject)newObj).getPkValue();
            DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if (isopenlocation && !this.isJumpLevel(changeIndex)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"outlocationfield"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"outlocationfield"});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"outlocationfield"});
        }
    }

    private boolean checkEntryMust(String field, int currentRow) {
        String stockId;
        DynamicObject mtfmaterial = (DynamicObject)this.getModel().getValue("materialid", currentRow);
        if (mtfmaterial == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u3002", (String)"ManufstockTplEdit_23", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String entityName = this.getModel().getDataEntityType().getName();
        if (EntityNameUtils.getAllStockChangeName().contains(entityName) && ("0".equals(stockId = this.getModel().getValue("stockid", currentRow).toString()) || "".equals(stockId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u6e05\u5355\u7f16\u53f7\u3002", (String)"ManufstockTplEdit_24", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject unit = (DynamicObject)this.getModel().getValue("materialunitid", currentRow);
        if (unit == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"ManufstockTplEdit_25", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(field, null, currentRow);
            return false;
        }
        String qtyType = (String)this.getModel().getValue("qtytype", currentRow);
        if (StringUtils.isEmpty((CharSequence)qtyType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7528\u91cf\u7c7b\u578b\u201d\u3002", (String)"ManufstockTplEdit_26", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(field, null, currentRow);
            return false;
        }
        return true;
    }

    private void setAuxpropLock(Object materialMft, int changeIndex, int currentSelectIndex) {
        if (this.isJumpLevel(changeIndex)) {
            return;
        }
        Boolean isbomextend = (Boolean)this.getModel().getValue("isbomextend", changeIndex);
        Boolean isProgramme = "F".equals(this.getModel().getValue("sourcetype", changeIndex));
        if (changeIndex == currentSelectIndex) {
            if (materialMft != null && !isbomextend.booleanValue() && !isProgramme.booleanValue()) {
                DynamicObject mateMft = (DynamicObject)materialMft;
                DynamicObject material = mateMft.getDynamicObject("masterid");
                material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
                this.getView().setEnable(Boolean.TRUE, new String[]{"isstockallotfield"});
                if (material != null) {
                    boolean isuseauxpty = material.getBoolean("isuseauxpty");
                    if (isuseauxpty) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"auxpropertyfield"});
                    } else {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"auxpropertyfield"});
                    }
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"auxpropertyfield"});
                if (!StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)this.getModel().getDataEntityType().getName())) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"isstockallotfield"});
                }
            }
            BigDecimal canqty = (BigDecimal)this.getModel().getValue("cansendqty", changeIndex);
            if (canqty.compareTo(BigDecimal.ZERO) < 0) {
                this.getModel().setValue("cansendqtyfield", (Object)0);
            }
        }
        this.isstockallotChange(changeIndex, currentSelectIndex);
        this.lockLimitQty(changeIndex, currentSelectIndex);
    }

    private void lockLimitQty(int changeIndex, int currentSelectIndex) {
        if (((Boolean)this.getModel().getValue("iscannegative", changeIndex)).booleanValue()) {
            this.getModel().setValue("issuemode", (Object)"C", changeIndex);
            this.getModel().setValue("isbackflush", (Object)"A", changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"overissuecontrlfield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"issuemodefield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"backflushfield"});
                this.getModel().setValue("issuemodefield", (Object)"C");
                this.getModel().setValue("backflushfield", (Object)"A");
            }
        } else if (changeIndex == currentSelectIndex) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"overissuecontrlfield"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"issuemodefield"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"backflushfield"});
        }
    }

    private void isstockallotChange(int changeIndex, int currentSelectIndex) {
        Boolean isstockallot = (Boolean)this.getModel().getValue("isstockallot", changeIndex);
        Boolean isbomextend = (Boolean)this.getModel().getValue("isbomextend", changeIndex);
        if (changeIndex == currentSelectIndex) {
            if (isstockallot.booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"outorgunitfield"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"outwarehousefield"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"outorgunitfield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"outwarehousefield"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"outlocationfield"});
            }
        }
        if (ObjectUtils.isEmpty((Object)isstockallot) || ObjectUtils.isEmpty((Object)isbomextend)) {
            return;
        }
        if (!isbomextend.booleanValue() && !isstockallot.booleanValue()) {
            this.getModel().setValue("outorgunitid", null, changeIndex);
            this.getModel().setValue("outwarehouseid", null, changeIndex);
            this.getModel().setValue("outlocation", null, changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getModel().setValue("outorgunitfield", null);
                this.getModel().setValue("outwarehousefield", null);
                this.getModel().setValue("outlocationfield", null);
            }
        }
    }

    private void setDefault(int changeIndex, int currentSelectIndex, Object newObj) {
        if (newObj != null) {
            DynamicObject material = (DynamicObject)newObj;
            DynamicObject materialinfo = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
            DynamicObject masterid = materialinfo.getDynamicObject("masterid");
            this.getModel().setValue("materielmasterid", (Object)masterid, changeIndex);
            QFilter filter = new QFilter("masterid", "=", masterid.getPkValue());
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
            if (mtfOrg == null) {
                return;
            }
            DynamicObject loadSingle = MaterialPlanQueryHelper.getDataCacheByMaterialID((Long)masterid.getLong("id"), (Long)mtfOrg.getLong("id"), null);
            String wastagerateformula = "B";
            DynamicObject tran = (DynamicObject)this.getModel().getValue("transactiontypeid");
            boolean s = false;
            if (tran != null) {
                s = tran.getBoolean("isconsiderloss");
            }
            if (loadSingle != null) {
                wastagerateformula = loadSingle.getString("wastagerateformula");
            } else if (!s) {
                wastagerateformula = "";
            }
            this.getModel().setValue("wastagerateformula", (Object)wastagerateformula, changeIndex);
            this.getPageCache().put("isIgnoreChangeMftstock", "true");
            this.getModel().setValue("isbulkmaterial", materialinfo.get("isbulkmaterial"), changeIndex);
            this.getModel().setValue("isstockallot", materialinfo.get("isstockallot"), changeIndex);
            String modestring = MPDMMftGenStocksUtils.getIssuemode((Object)materialinfo.get("issuemode"));
            this.getModel().setValue("issuemode", (Object)modestring, changeIndex);
            this.getModel().setValue("batchno", null, changeIndex);
            this.getModel().setValue("lot", null, changeIndex);
            this.getModel().setValue("isbackflush", materialinfo.get("isbackflush"), changeIndex);
            String entityName = this.getModel().getDataEntityType().getName();
            DynamicObject orderEntry = null;
            orderEntry = !EntityNameUtils.getAllStockChangeName().contains(entityName) ? (DynamicObject)this.getModel().getValue("orderentryid") : (DynamicObject)this.getModel().getValue("entryorderentryid", changeIndex);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject stockEntry = this.getModel().getEntryRowEntity("stockentry", changeIndex);
            CreateStockUtils.getStockWareHouse((DynamicObject)stockEntry, (DynamicObject)orderEntry, (DynamicObject)org, (String)entityName);
            this.getModel().setValue("supplyorgid", stockEntry.get("supplyorgid"), changeIndex);
            this.getModel().setValue("warehouseid", stockEntry.get("warehouseid"), changeIndex);
            this.getModel().setValue("location", stockEntry.get("location"), changeIndex);
            this.getModel().setValue("outorgunitid", stockEntry.get("outorgunitid"), changeIndex);
            this.getModel().setValue("outwarehouseid", stockEntry.get("outwarehouseid"), changeIndex);
            this.getModel().setValue("outlocation", stockEntry.get("outlocation"), changeIndex);
            this.setMaterialInvInfo(changeIndex);
            DynamicObject product = (DynamicObject)this.getModel().getValue("productid");
            if (EntityNameUtils.getAllStockChangeName().contains(this.getModel().getDataEntityType().getName())) {
                product = (DynamicObject)this.getModel().getValue("productno", changeIndex);
            }
            this.getModel().setValue("rework", (Object)"false", changeIndex);
            if (material != null && product != null && material.getPkValue().equals(product.getPkValue())) {
                this.getModel().setValue("rework", (Object)"true", changeIndex);
            }
            MPDMMftGenStocksUtils.setbackflush((Object)materialinfo.get("isbackflush"), (int)changeIndex, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
            this.setSupplyorgfield("", changeIndex);
            if (changeIndex == currentSelectIndex) {
                this.getPageCache().put("isIgnoreChangeMftstock", "true");
                this.getModel().setValue("supplyorgfield", this.getModel().getValue("supplyorgid", changeIndex));
                this.getModel().setValue("isbulkmaterialfield", materialinfo.get("isbulkmaterial"));
                this.getModel().setValue("isstockallotfield", materialinfo.get("isstockallot"));
                this.getModel().setValue("warehousefield", this.getModel().getValue("warehouseid", changeIndex));
                this.lockLocationField(this.getModel().getValue("warehouseid", changeIndex), changeIndex);
                this.getModel().setValue("locationfield", this.getModel().getValue("location", changeIndex));
                this.getModel().setValue("outorgunitfield", this.getModel().getValue("outorgunitid", changeIndex));
                this.getModel().setValue("outwarehousefield", this.getModel().getValue("outwarehouseid", changeIndex));
                this.lockOutLocationField(this.getModel().getValue("outwarehouseid", changeIndex), changeIndex);
                this.getModel().setValue("outlocationfield", this.getModel().getValue("outlocation", changeIndex));
                this.getModel().setValue("issuemodefield", (Object)modestring);
                this.getModel().setValue("backflushfield", materialinfo.get("isbackflush"));
            }
        }
    }

    private void setMaterialInvInfo(int changeIndex) {
        DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("supplyorgid", changeIndex);
        DynamicObject materialMft = (DynamicObject)this.getModel().getValue("materialid", changeIndex);
        if (materialMft != null) {
            this.getModel().setValue("materielinv", (Object)MaterialInvInfoHelper.getMaterialInvInfo((DynamicObject)mtfOrg, (DynamicObject)materialMft.getDynamicObject("masterid")), changeIndex);
        }
    }

    private void setSupplyorgfield(String string, int currentSelectIndex) {
        int currentIndex = this.getSelectEntryRowIndex();
        String supplyfield = (String)this.getModel().getValue("supplymode", currentSelectIndex);
        FieldEdit s = (FieldEdit)this.getView().getControl("supplierfield");
        DynamicObject sypplyorgfield = (DynamicObject)this.getModel().getValue("supplyorgid", currentSelectIndex);
        if ("bos_org".equals(supplyfield)) {
            if (currentIndex != -1) {
                s.setMustInput(true);
            }
            if (!"mustinput".equals(string) && sypplyorgfield != null) {
                ArrayList<Object> array = new ArrayList<Object>();
                Long orgId = (Long)sypplyorgfield.getPkValue();
                List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
                array.addAll(ownerArray);
                if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                    array.add(sypplyorgfield.getPkValue());
                }
                if (!array.isEmpty()) {
                    if (currentIndex != -1) {
                        this.getModel().setValue("supplierfield", array.get(0));
                    }
                    this.getModel().setValue("supplierid", array.get(0), currentSelectIndex);
                } else {
                    if (currentIndex != -1) {
                        this.getModel().setValue("supplierfield", null);
                    }
                    this.getModel().setValue("supplierid", null, currentSelectIndex);
                }
            }
        } else if (currentIndex != -1) {
            s.setMustInput(false);
        }
    }

    private void bomReVersionBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materialid");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u7ec4\u4ef6\u7f16\u7801\u201d\u3002", (String)"ManufstockTplEdit_38", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String materialstr = material.getDynamicObject("masterid").getPkValue().toString();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("material.id", "=", (Object)Long.parseLong(materialstr)));
    }

    private void supplierFieldBeforeF7Select(BeforeF7SelectEvent e) {
        String supplyfield = (String)this.getModel().getValue("supplymodefield");
        DynamicObject sypplyorgfield = (DynamicObject)this.getModel().getValue("supplyorgfield");
        if ("bos_org".equals(supplyfield) && sypplyorgfield != null) {
            ArrayList<Object> array = new ArrayList<Object>();
            Long orgId = (Long)sypplyorgfield.getPkValue();
            List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
            array.addAll(ownerArray);
            if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                array.add(sypplyorgfield.get("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", array));
        }
    }

    private void supplyOrgFieldBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("org");
        if (supplyOrg != null) {
            List idList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)Long.valueOf(supplyOrg.getPkValue().toString()), (boolean)true);
            e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
        }
    }

    private void locationFieldBeforeF7Select(BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>();
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehousefield");
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4f9b\u8d27\u4ed3\u5e93\u201d\u3002", (String)"ManufstockTplEdit_37", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouse.getPkValue(), (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            DynamicObject location = (DynamicObject)obj.get("location");
            if (location == null) continue;
            locationList.add(location.getPkValue());
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationList);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void warehouseFieldBeforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("supplyorgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u4f9b\u8d27\u7ec4\u7ec7\u201d\u3002", (String)"ManufstockTplEdit_30", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long[] warehouseids = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)Long.parseLong(org.getPkValue().toString()));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Long warehouseid : warehouseids) {
            if (warehouseid == null) continue;
            ids.add(warehouseid);
        }
        if (!ids.isEmpty()) {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", ids);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", (Object)Long.valueOf("0"));
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void outlocationFieldBeforeF7Select(BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>();
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("outwarehousefield");
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u8c03\u51fa\u4ed3\u5e93\u201d\u3002", (String)"ManufstockTplEdit_31", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouse.getPkValue(), (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject obj = (DynamicObject)col.get(i);
            DynamicObject location = (DynamicObject)obj.get("location");
            if (location == null) continue;
            locationList.add(location.getPkValue());
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationList);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void outwareHouseFieldBeforeF7Select(BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("outorgunitfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u8c03\u51fa\u7ec4\u7ec7\u201d\u3002", (String)"ManufstockTplEdit_32", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long[] warehouseids = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)Long.parseLong(org.getPkValue().toString()));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Long warehouseid : warehouseids) {
            if (warehouseid == null) continue;
            ids.add(warehouseid);
        }
        if (!ids.isEmpty()) {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", ids);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "=", (Object)Long.valueOf("0"));
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "batchno": {
                IDataModel model = this.getModel();
                MftOrderSelectLotMain.showPageLotMainfileList((IFormPlugin)this, (IFormView)this.getView(), (IDataModel)model, (String)"stockentry");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if ("mpdm_selectlot".equals(actionId) && returnData instanceof Map) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("stockentry");
            Map lotAttr = (Map)returnData;
            String lotidfield = (String)lotAttr.get("lotidfield");
            model.setValue("batchno", lotAttr.get("lotnumber"), rowIndex);
            model.setValue(lotidfield, lotAttr.get("lotid"), rowIndex);
        }
    }

    public boolean isJumpLevel(int rowIndex) {
        if (rowIndex == -1) {
            return false;
        }
        return (Boolean)this.getModel().getValue("isjumplevel", rowIndex);
    }

    public boolean isJumpLevel(DynamicObject stockEntry) {
        return stockEntry.getBoolean("isjumplevel");
    }

    public void lockJumpLevelRowData() {
        DynamicObject stockEntry;
        int i;
        String entityName = this.getModel().getDataEntityType().getName();
        boolean setParentSeq = "om_mftstock".equalsIgnoreCase(entityName) || "pom_mftstock".equalsIgnoreCase(entityName) || "prop_mftstock".equalsIgnoreCase(entityName);
        DynamicObjectCollection stockDymcol = (DynamicObjectCollection)this.getModel().getValue("stockentry");
        int size = stockDymcol.size();
        HashMap<Long, Integer> seqMap = new HashMap<Long, Integer>(size);
        boolean needLoop = false;
        HashSet<Integer> updateSeqSet = new HashSet<Integer>(16);
        DataEntityPropertyCollection treeEntryProperties = stockDymcol.getDynamicObjectType().getProperties();
        IDataEntityProperty property = null;
        if (setParentSeq) {
            property = (IDataEntityProperty)treeEntryProperties.get((Object)"parentseq");
        }
        this.getModel().beginInit();
        for (i = 0; i < size; ++i) {
            stockEntry = (DynamicObject)stockDymcol.get(i);
            if (this.isJumpLevel(stockEntry)) {
                this.getView().setEnable(Boolean.FALSE, i, ManufstockTplHelper.entryLockfields);
                this.getView().setEnable(Boolean.FALSE, i, ManufstockTplHelper.entryfields);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"batchno"});
            }
            if (!setParentSeq) continue;
            stockEntry.set("parentseq", (Object)0);
            Long stockId = (Long)stockEntry.getPkValue();
            Long parentStockId = stockEntry.getLong("pstockentryid");
            int seq = stockEntry.getInt("seq");
            seqMap.put(stockId, seq);
            if (parentStockId == null || parentStockId.equals(0L)) continue;
            if (seqMap.containsKey(parentStockId)) {
                this.getModel().setValue("parentseq", seqMap.get(parentStockId), i);
                updateSeqSet.add(i);
                if (property == null) continue;
                stockEntry.getDataEntityState().setBizChanged(property.getOrdinal(), false);
                continue;
            }
            needLoop = true;
        }
        if (needLoop) {
            for (i = 0; i < size; ++i) {
                stockEntry = (DynamicObject)stockDymcol.get(i);
                Long parentStockId = stockEntry.getLong("pstockentryid");
                if (parentStockId == null || parentStockId.equals(0L) || !updateSeqSet.add(i)) continue;
                this.getModel().setValue("parentseq", seqMap.get(parentStockId), i);
                if (property == null) continue;
                stockEntry.getDataEntityState().setBizChanged(property.getOrdinal(), false);
            }
        }
        this.getModel().endInit();
        if (!updateSeqSet.isEmpty()) {
            Iterator iterator = updateSeqSet.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                this.getView().updateView("parentseq", i2);
            }
        }
    }
}

