/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bd.mpdm.business.lotmain.MftOrderSelectLotMain;
import kd.bd.mpdm.business.manuversion.AutoSetManuVersionParamHelper;
import kd.bd.mpdm.business.mftorder.MftOrderModTimeUtils;
import kd.bd.mpdm.business.mftorder.OrderCommonService;
import kd.bd.mpdm.business.mftorder.OrderQualityOrgService;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.business.mftorder.validate.OrderSplitValidateService;
import kd.bd.mpdm.common.enums.DomainEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillProductTypeEnum;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bd.mpdm.common.mftorder.utils.ConfigBomToStockUtils;
import kd.bd.mpdm.common.mftorder.utils.ManuFactureTraceUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.mftorder.utils.PlanScopeHelper;
import kd.bd.mpdm.common.query.helper.BomVersionQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.helper.WarehouseQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsManuVersionQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bd.mpdm.common.utils.DomainIgnoreValSeUtil;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class MftOrderEditTpl
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MftOrderEditTpl.class);
    private static final String SUSPEND = "suspend";
    private static final String MASTERID = "masterid";
    private static final String SELECTLOT = "mpdm_selectlot";
    private static Set<String> bizOp = Sets.newHashSet((Object[])new String[]{"keep", "cancel", "multransmit", "hold", "error", "transmit", "untransmit", "beginwork", "unbeginwork", "endwork", "unendwork", "hangup", "unhangup", "shut", "unshut", "calmaterial"});
    private static final String[] HEADFIELDS = new String[]{"entryoutputoperation", "entryauxproperty", "entryinwardept", "entrywarehouse", "entrylocation", "entryiscontrolqty", "entryrcvinhighlimit", "entryrcvinlowlimit", "entryyieldrate"};

    public void registerListener(EventObject e) {
        BasedataEdit qualityorg;
        BasedataEdit bom;
        BasedataEdit tracknumber;
        BasedataEdit configuredcode;
        BasedataEdit entryopration;
        BasedataEdit entryinwardept;
        BasedataEdit org;
        BasedataEdit producedept;
        BasedataEdit manuversion;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit otherLocation = (BasedataEdit)this.getView().getControl("entrylocation");
        otherLocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit unit = (BasedataEdit)this.getView().getControl("unit");
        unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"batchno"});
        BasedataEdit otherwarehouse = (BasedataEdit)this.getView().getControl("entrywarehouse");
        otherwarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit processroute = (BasedataEdit)this.getView().getControl("processroute");
        processroute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit routereplace = (BasedataEdit)this.getView().getControl("routereplace");
        if (routereplace != null) {
            routereplace.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((manuversion = (BasedataEdit)this.getView().getControl("manuversion")) != null) {
            manuversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((producedept = (BasedataEdit)this.getView().getControl("producedept")) != null) {
            producedept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((org = (BasedataEdit)this.getView().getControl("org")) != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryinwardept = (BasedataEdit)this.getView().getControl("entryinwardept")) != null) {
            entryinwardept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryopration = (BasedataEdit)this.getView().getControl("entryoutputoperation")) != null) {
            entryopration.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredcode = (BasedataEdit)this.getView().getControl("configuredcode")) != null) {
            configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tracknumber = (BasedataEdit)this.getView().getControl("tracknumber")) != null) {
            tracknumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bom = (BasedataEdit)this.getView().getControl("bomid")) != null) {
            bom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((qualityorg = (BasedataEdit)this.getView().getControl("qualityorg")) != null) {
            qualityorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "batchno": {
                IDataModel model = this.getModel();
                MftOrderSelectLotMain.showPageLotMainfileList((IFormPlugin)this, (IFormView)this.getView(), (IDataModel)model, (String)"treeentryentity");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (SELECTLOT.equals(actionId) && returnData instanceof Map) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("treeentryentity");
            Map lotAttr = (Map)returnData;
            model.setValue("batchno", lotAttr.get("lotnumber"), rowIndex);
            model.setItemValueByID("lot", lotAttr.get("lotid"), rowIndex);
        }
        if (null != e.getReturnData() && ("modCloseTime".equals(e.getActionId()) || "modTransmitTime".equals(e.getActionId()) || "modBookDate".equals(e.getActionId()))) {
            Object modTypeObj;
            Map returnDataMap = (Map)e.getReturnData();
            String timeStr = MftOrderModTimeUtils.closedCallBackInvokeParams((Map)returnDataMap);
            OperateOption submitOption = OperateOption.create();
            String jsonString = this.getPageCache().get("billAndSelectRowMapList");
            submitOption.setVariableValue("modCloseTimeOp", timeStr);
            submitOption.setVariableValue("billAndSelectRowMapList", jsonString);
            if ("modCloseTime".equals(e.getActionId())) {
                this.getView().invokeOperation("modCloseTimeOp", submitOption);
            } else if ("modTransmitTime".equals(e.getActionId())) {
                this.getView().invokeOperation("modTransmitTimeOp", submitOption);
            } else if ("modBookDate".equals(e.getActionId()) && null != (modTypeObj = returnDataMap.get("modtype"))) {
                String modType;
                switch (modType = String.valueOf(modTypeObj)) {
                    case "A": {
                        this.getView().invokeOperation("modbeginbookdateOp", submitOption);
                        this.getView().invokeOperation("refresh");
                        break;
                    }
                    case "B": {
                        this.getView().invokeOperation("modclosebookdateOp", submitOption);
                        break;
                    }
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        ORM orm = ORM.create();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("treeentryentity");
        String entityName = dataEntity.getDataEntityType().getName();
        long[] genLongIds = null;
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Long rowid = dynamicObject.getLong("id");
            if (rowid != 0L) continue;
            if (genLongIds == null) {
                genLongIds = orm.genLongIds(entityName + ".treeentryentity", dynamicObjectCollection.size());
            }
            dynamicObject.set("id", (Object)((long)genLongIds[i]));
        }
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        boolean usePlanscope;
        EntryGrid entryGrid;
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String propertyName = e.getProperty().getName();
        if ("transactiontype".equals(propertyName)) {
            this.propChangeTransactionType(e.getChangeSet()[0]);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntites = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (int i = 0; i < entryEntites.size(); ++i) {
                DynamicObject entryEntity = (DynamicObject)entryEntites.get(i);
                DynamicObject material = entryEntity.getDynamicObject("material");
                String productType = entryEntity.getString("producttype");
                if (!"C".equals(productType) || material == null) continue;
                DynamicObject manuversion = (DynamicObject)this.getModel().getValue("manuversion", i);
                this.setECNVersionByExpandDate(i, material.getDynamicObject(MASTERID), manuversion);
                if (e.getChangeSet()[0].getNewValue() == null) continue;
                this.autoCreateEntryByBOM(i);
            }
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("treeentryentity")).getSelectRows().length == 0 && !"planbegintime".equals(propertyName)) {
            return;
        }
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = cd.getRowIndex();
        if (this.isHeadField(propertyName) && (rowIndex = entryGrid.getSelectRows()[0]) == -1) {
            return;
        }
        this.getPageCache().put("checkDataChange", "true");
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        if ("expendbomtime".equals(propertyName)) {
            this.propChangeExpandBOMTime(cd);
            this.setManuVersion(rowIndex);
        }
        if ("qty".equals(propertyName)) {
            this.propChangeQty(cd);
            this.setManuVersion(rowIndex);
        }
        if ("baseqty".equals(propertyName)) {
            this.propChangeBaseQty(cd);
        }
        if ("auxptyqty".equals(propertyName)) {
            this.propChangeAuxptQty(cd);
        }
        if ("entryauxproperty".equals(propertyName)) {
            this.getModel().setValue("auxproperty", newValue, rowIndex);
            if (null != newValue && null != oldValue && !((DynamicObject)newValue).getString("id").equals(((DynamicObject)oldValue).getString("id"))) {
                this.queryBomAndSet(rowIndex);
            }
            this.setManuVersion(rowIndex);
        }
        if ("entryinwardept".equals(propertyName)) {
            this.getModel().setValue("inwardept", newValue, rowIndex);
            this.getModel().setValue("entrywarehouse", null);
        }
        if ("entrywarehouse".equals(propertyName) && !(usePlanscope = PlanScopeHelper.isUsePlanscope())) {
            this.getModel().setValue("warehouse", newValue, rowIndex);
            this.getModel().setValue("entrylocation", null);
            if (newValue != null) {
                long warehouseId = (Long)((DynamicObject)newValue).getPkValue();
                DynamicObject warehouse = WarehouseQueryHelper.getDataCacheByID((Object)warehouseId);
                int isopenlocation = warehouse.getBoolean("isopenlocation");
                if (isopenlocation != 0) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"entrylocation"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
                }
            }
        }
        if ("entrylocation".equals(propertyName)) {
            this.getModel().setValue("location", newValue, rowIndex);
        }
        if ("entryiscontrolqty".equals(propertyName)) {
            this.getModel().setValue("iscontrolqty", newValue, rowIndex);
            if (Boolean.TRUE.equals(newValue)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"entryrcvinhighlimit", "entryrcvinlowlimit"});
                DynamicObject material = (DynamicObject)this.getModel().getValue("material");
                if (material == null) {
                    return;
                }
                DynamicObject mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
                this.getModel().setValue("rcvinhighlimit", mftmaterial.get("rcvinhighlimit"), rowIndex);
                this.getModel().setValue("entryrcvinhighlimit", mftmaterial.get("rcvinhighlimit"));
                this.getModel().setValue("rcvinlowlimit", mftmaterial.get("rcvinlowlimit"), rowIndex);
                this.getModel().setValue("entryrcvinlowlimit", mftmaterial.get("rcvinlowlimit"));
                this.calHighQty(rowIndex);
                this.calLowQty(rowIndex);
            } else {
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmax", "entryinwarmin", "entryrcvinhighlimit", "entryrcvinlowlimit"});
                BigDecimal baseqty = (BigDecimal)this.getModel().getValue("baseqty", rowIndex);
                this.getModel().setValue("entryinwarmax", (Object)baseqty);
                this.getModel().setValue("entryinwarmin", (Object)baseqty);
                this.getModel().setValue("entryrcvinhighlimit", null);
                this.getModel().setValue("entryrcvinlowlimit", null);
                this.getModel().setValue("inwarmax", (Object)baseqty);
                this.getModel().setValue("inwarmin", (Object)baseqty);
                this.getModel().setValue("rcvinhighlimit", null);
                this.getModel().setValue("rcvinlowlimit", null);
                this.getPageCache().put("isIgnoreChangeListener", "false");
            }
        }
        if ("entryrcvinhighlimit".equals(propertyName)) {
            if (!this.calHighQty(rowIndex)) {
                this.getModel().setValue("entryrcvinhighlimit", oldValue);
                this.getModel().setValue("rcvinhighlimit", oldValue, rowIndex);
            } else {
                this.getModel().setValue("rcvinhighlimit", newValue, rowIndex);
            }
        }
        if ("entryrcvinlowlimit".equals(propertyName)) {
            if (!this.calLowQty(rowIndex)) {
                this.getModel().setValue("entryrcvinlowlimit", oldValue);
                this.getModel().setValue("rcvinlowlimit", oldValue, rowIndex);
            } else {
                this.getModel().setValue("rcvinlowlimit", newValue, rowIndex);
            }
        }
        if ("entryoutputoperation".equals(propertyName)) {
            this.getModel().setValue("outputoperation", newValue, rowIndex);
        }
        if ("producttype".equals(propertyName)) {
            this.getModel().setValue("material", null, rowIndex);
            if ("C".equals(newValue.toString())) {
                this.getModel().setValue("entryoutputoperation", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"entryoutputoperation"});
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"processroute"});
            } else {
                DomainIgnoreValSeUtil.setValue((IDataModel)this.getModel(), (String)"processroute", null, (int)rowIndex, (String[])new String[]{DomainEnum.PROP.getName()});
                this.getView().setEnable(Boolean.TRUE, new String[]{"entryoutputoperation"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"processroute"});
            }
        }
        if ("material".equals(propertyName)) {
            this.propChangeMaterial(cd);
            this.setManuVersion(rowIndex);
        }
        if ("bomid".equals(propertyName)) {
            this.propChangeBOM(cd);
        }
        if ("unit".equals(propertyName)) {
            this.propChangeUnit(cd);
        }
        if (newValue == null && "processroute".equals(propertyName)) {
            this.getModel().setValue("routereplace", null, rowIndex);
        }
        if ("planbegintime".equals(propertyName)) {
            if (entryGrid.getSelectRows().length != 0) {
                this.calPlanEndTime(rowIndex);
                this.autoChangeCoproduct(rowIndex, "planbegintime");
            } else {
                String planbegintimeentrySeqList = this.getView().getPageCache().get("planbegintimeentrySeqList");
                if (StringUtils.isNotBlank((CharSequence)planbegintimeentrySeqList)) {
                    String[] split;
                    for (String s : split = planbegintimeentrySeqList.split(",")) {
                        this.calPlanEndTime(Integer.parseInt(s));
                        this.autoChangeCoproduct(Integer.parseInt(s), "planbegintime");
                    }
                    this.getView().getPageCache().put("planbegintimeentrySeqList", "");
                }
            }
        }
        if ("planscope".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, propertyName);
        }
        if ("supplyrule".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, propertyName);
        }
        if ("workcenter".equals(propertyName)) {
            if (newValue == null) {
                return;
            }
            this.autoChangeCoproduct(rowIndex, "workcenter");
            this.setManuVersion(rowIndex);
            Object mObj = this.getModel().getValue("manuversion", rowIndex);
            Object cObj = this.getModel().getValue("workcenter", rowIndex);
            Long manuCenterId = 0L;
            Long centerId = 0L;
            if (mObj != null) {
                manuCenterId = (Long)((DynamicObject)this.getModel().getValue("manuversion", rowIndex)).get("workcenter.id");
            }
            if (cObj != null) {
                centerId = (Long)((DynamicObject)this.getModel().getValue("workcenter", rowIndex)).get("id");
            }
        }
        if ("planendtime".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "planendtime");
        }
        if ("processroute".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "processroute");
            if (newValue != null) {
                DynamicObject route = (DynamicObject)newValue;
                if (route != null) {
                    route = MsProcessRouteQueryHelper.getDataCacheByID((Object)route.getPkValue());
                }
                this.getModel().setValue("routereplace", route.get("routereplace"), rowIndex);
            }
        }
        if ("routereplace".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "routereplace");
        }
        if ("producedept".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "producedept");
        }
        if ("tracknumber".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "tracknumber");
        }
        if ("inwardept".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "inwardept");
            this.setMaterialInvInfo(rowIndex);
        }
        if ("srcbillno".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "srcbillno");
        }
        if ("entryyieldrate".equals(propertyName)) {
            IDataModel model = this.getModel();
            int entryRowIndex = model.getEntryCurrentRowIndex("treeentryentity");
            model.setValue("yieldrate", newValue, entryRowIndex);
            this.setYieldrateQty(rowIndex, DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"qty", (int)entryRowIndex), DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"yieldrate", (int)entryRowIndex));
        }
        if ("manuversion".equals(propertyName)) {
            this.propChangeManuVersion(cd);
        }
        if ("configuredcode".equals(propertyName)) {
            this.propChangeConfigCode(newValue, rowIndex);
            this.setManuVersion(rowIndex);
            this.setBom(rowIndex);
        }
        if ("billstatus".equals(propertyName)) {
            this.setEnableViseble(e.getChangeSet()[0].getNewValue());
        }
        if ("batchno".equals(propertyName)) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
            String lotnumber = dynamicObject.getString("batchno");
            if (lotnumber != null) {
                lotnumber = lotnumber.replaceAll("\u3000", "").trim();
                this.getModel().setValue("batchno", (Object)lotnumber, rowIndex);
            }
            this.getModel().setValue("lot", null, rowIndex);
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
        if ("qualityorg".equals(propertyName)) {
            this.propChangeQualityorg(cd);
        }
        if ("bdproject".equals(propertyName)) {
            this.autoChangeCoproduct(rowIndex, "bdproject");
        }
        this.getPageCache().put("isIgnoreChangeListener", "false");
        block8: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            switch (propertyName) {
                case "auxptyunit": {
                    this.auxPtyUnitChange(changeData);
                    continue block8;
                }
            }
        }
    }

    private void setBom(int rowIndex) {
        DynamicObject configcode;
        Date expendbomtime = (Date)this.getModel().getValue("expendbomtime", rowIndex);
        if (expendbomtime == null) {
            expendbomtime = new Date();
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Set<Long> bomTypeIDSet = this.getBomTypeIDSet();
        String selectProperties = "number,enable,id,ecn,type,version,yieldrate";
        String orderByStr = "";
        DynamicObject manuversion = (DynamicObject)this.getModel().getValue("manuversion", rowIndex);
        if (manuversion != null) {
            manuversion = MsManuVersionQueryHelper.getDataCacheByID((Object)manuversion.getPkValue());
        }
        Long configcodeId = (configcode = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex)) == null ? 0L : Long.parseLong(configcode.getPkValue().toString());
        DynamicObject master = (DynamicObject)this.getModel().getValue("materielmasterid", rowIndex);
        DynamicObject auxproprtty = (DynamicObject)this.getModel().getValue("auxproperty", rowIndex);
        DynamicObject bom = MsBomQueryHelper.getBomFromCache((DynamicObject)master, (Long)org.getLong("id"), (DynamicObject)manuversion, bomTypeIDSet, (Date)expendbomtime, (String)selectProperties, (String)orderByStr, (DynamicObject)auxproprtty, (Long)configcodeId);
        this.getModel().setValue("bomid", (Object)bom, rowIndex);
    }

    private Set<Long> getBomTypeIDSet() {
        DynamicObjectCollection bomtypes;
        HashSet<Long> bomTypeIDSet = new HashSet<Long>(16);
        DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
        if (transactiontype != null && CollectionUtils.isNotEmpty((Collection)(bomtypes = transactiontype.getDynamicObjectCollection("bomtypes")))) {
            bomTypeIDSet = new HashSet(16);
            for (DynamicObject dyn : bomtypes) {
                bomTypeIDSet.add(dyn.getLong("fbasedataid_id"));
            }
        }
        return bomTypeIDSet;
    }

    private void setManuVersion(int rowIndex) {
        DynamicObject auxPropertyDyn;
        DynamicObject configureDyn;
        DynamicObject workCenterDyn;
        Date expBomDat;
        IDataModel thModel = this.getModel();
        DynamicObject manuVersionDyn = (DynamicObject)thModel.getValue("transactiontype");
        if (manuVersionDyn == null) {
            return;
        }
        boolean isVersionReq = manuVersionDyn.getBoolean("versionreq");
        boolean isEnablePlanScope = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanScopeService", (String)"isEnablePlanScope", (Object[])new Object[0]);
        if (!isEnablePlanScope && !isVersionReq) {
            return;
        }
        DynamicObject org = (DynamicObject)thModel.getValue("org");
        DynamicObject materialInfoDyn = (DynamicObject)thModel.getValue("material", rowIndex);
        if (materialInfoDyn == null) {
            thModel.setValue("manuversion", null, rowIndex);
            return;
        }
        DynamicObject materialDyn = (DynamicObject)thModel.getValue("materielmasterid", rowIndex);
        if (materialDyn == null) {
            thModel.setValue("manuversion", null, rowIndex);
            return;
        }
        BigDecimal qtyDec = (BigDecimal)thModel.getValue("baseqty", rowIndex);
        if ("0E-10".equals(qtyDec.toString()) || "0.0000".equals(qtyDec.toString())) {
            qtyDec = BigDecimal.valueOf(0L);
        }
        if ((expBomDat = (Date)thModel.getValue("expendbomtime", rowIndex)) == null) {
            thModel.setValue("manuversion", null, rowIndex);
            return;
        }
        ArrayList params = new ArrayList(16);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("bizorg", org.getPkValue());
        map.put("materialInfo", materialInfoDyn.getPkValue());
        map.put("material", materialDyn.getPkValue());
        map.put("bomdate", expBomDat);
        if (!this.getView().getEntityId().equals("prop_mftorder") && (workCenterDyn = (DynamicObject)thModel.getValue("workcenter", rowIndex)) != null) {
            map.put("workcenter", workCenterDyn.getPkValue());
        }
        if ((configureDyn = (DynamicObject)thModel.getValue("configuredcode", rowIndex)) != null) {
            map.put("configure", configureDyn.getPkValue());
        }
        if ((auxPropertyDyn = (DynamicObject)thModel.getValue("auxproperty", rowIndex)) != null) {
            map.put("auxproperty", auxPropertyDyn.getPkValue());
        }
        map.put("qty", qtyDec);
        PluginProxy newExtPlugin = AutoSetManuVersionParamHelper.genExtPluginxy();
        if (newExtPlugin != null) {
            newExtPlugin.callReplace(p -> {
                p.setFilterManuVersionParam(map, thModel, rowIndex);
                return null;
            });
        }
        params.add(map);
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IAutoSetManuVersionService", (String)"getBatchManuVersion", (Object[])new Object[]{params});
        if (!resMap.isEmpty()) {
            Map materailAndVersionDyn = (Map)resMap.get(org.getPkValue());
            logger.info("materailAndVersionDyn size = " + materailAndVersionDyn.size());
            Set versions = (Set)materailAndVersionDyn.get(materialDyn.getPkValue());
            if (versions != null && versions.size() > 0) {
                DynamicObject version = (DynamicObject)versions.toArray()[0];
                Object pkValue = version.get("id");
                logger.info("versionId = " + pkValue);
                DynamicObject versionDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"pdm_manuversion");
                thModel.setValue("manuversion", (Object)versionDyn, rowIndex);
                DynamicObject scheduler = (DynamicObject)thModel.getValue("scheduler", rowIndex);
                if (scheduler == null) {
                    if (versionDyn.get("person") != null) {
                        DynamicObject dynScheduler = (DynamicObject)versionDyn.get("person");
                        thModel.setValue("scheduler", (Object)dynScheduler, rowIndex);
                    } else {
                        this.setSchedulerForPropChange(thModel, rowIndex);
                    }
                }
            }
        } else {
            this.setSchedulerForPropChange(thModel, rowIndex);
            thModel.setValue("manuversion", null, rowIndex);
        }
    }

    private void setSchedulerForPropChange(IDataModel thModel, int rowIndex) {
        DynamicObject materialManu = (DynamicObject)thModel.getValue("material", rowIndex);
        if (materialManu != null && materialManu.get("person") != null) {
            DynamicObject person = (DynamicObject)materialManu.get("person");
            thModel.setValue("scheduler", (Object)person, rowIndex);
        }
    }

    private void propChangeConfigCode(Object newValue, int rowIndex) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
        DynamicObject bom = dynamicObject.getDynamicObject("bomid");
        if (null == bom) {
            return;
        }
        boolean issuperBom = ConfigBomToStockUtils.chkIsSuperBomType((DynamicObject)bom);
        if (issuperBom) {
            return;
        }
        DynamicObject configuredcode = bom.getDynamicObject("configuredcode");
        if (null == configuredcode) {
            this.getModel().setValue("bomid", null, rowIndex);
            return;
        }
        if (null == newValue) {
            return;
        }
        Object newPkvalue = ((DynamicObject)newValue).getPkValue();
        if (!((Long)newPkvalue).equals((Long)configuredcode.getPkValue())) {
            this.getModel().setValue("bomid", null, rowIndex);
        }
    }

    private void setEnableViseble(Object val) {
        if ("D".equals(val)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanelflex", "pagepanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del", "bar_save", "bar_submit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_refresh"});
        }
        if ("A".equals(val)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"contentpanelflex", "pagepanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_refresh"});
        }
    }

    private void propChangeTransactionType(ChangeData cd) {
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        DynamicObject transactiontype = (DynamicObject)newValue;
        if (transactiontype != null) {
            DynamicObject producedept;
            DynamicObjectCollection oldbomtype;
            long transId = (Long)transactiontype.getPkValue();
            transactiontype = TransactionTypeQueryHelper.getDataCacheByID((Object)transId);
            DynamicObject bizType = (DynamicObject)transactiontype.get("transactiontype");
            String bizTypeName = "";
            if (bizType != null) {
                bizTypeName = bizType.getString("name");
            }
            this.getModel().setValue("biztype", (Object)bizTypeName);
            DynamicObjectCollection newbomtype = transactiontype.getDynamicObjectCollection("bomtypes");
            String stockmaterials = transactiontype.getString("stockmaterials");
            if (CollectionUtils.isEmpty((Collection)newbomtype) && "A".equals(stockmaterials)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\uff08%1$s \uff09\u7684\u7528\u6599\u6e05\u5355\u4e3a\u6309BOM\u5c55\u5f00\uff0cBOM\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftOrderEditTpl_57", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), transactiontype.getString("name")));
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.getModel().setValue("transactiontype", oldValue);
                this.getPageCache().put("isIgnoreChangeListener", "false");
                return;
            }
            if (oldValue != null && (CollectionUtils.isEmpty((Collection)(oldbomtype = ((DynamicObject)oldValue).getDynamicObjectCollection("bomtypes"))) && CollectionUtils.isNotEmpty((Collection)newbomtype) || CollectionUtils.isNotEmpty((Collection)oldbomtype) && CollectionUtils.isEmpty((Collection)newbomtype) || CollectionUtils.isNotEmpty((Collection)oldbomtype) && CollectionUtils.isNotEmpty((Collection)newbomtype) && !this.compareBomtypes(oldbomtype, newbomtype))) {
                this.clearEntryBOM(newbomtype);
            }
            if ((producedept = transactiontype.getDynamicObject("producedept")) != null && this.queryProducedeptBoolean((Long)producedept.getPkValue())) {
                for (int i = 0; i < this.getModel().getEntryEntity("treeentryentity").size(); ++i) {
                    this.getModel().setValue("producedept", (Object)producedept, i);
                }
            } else {
                this.resetProducedeptByMftinfo();
            }
        } else {
            this.getModel().setValue("biztype", null);
            this.resetProducedeptByMftinfo();
        }
    }

    private void resetProducedeptByMftinfo() {
        for (int i = 0; i < this.getModel().getEntryEntity("treeentryentity").size(); ++i) {
            DynamicObject departmentorg;
            DynamicObject mftmaterial;
            this.getModel().setValue("producedept", null, i);
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", i);
            if (material == null || (mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue())) == null || (departmentorg = (DynamicObject)mftmaterial.get("departmentorgid")) == null || !this.queryProducedeptBoolean((Long)departmentorg.getPkValue())) continue;
            this.getModel().setValue("producedept", (Object)departmentorg, i);
        }
    }

    private boolean compareBomtypes(DynamicObjectCollection oldbomtypes, DynamicObjectCollection newbomtypes) {
        List newBomtypePks = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)newbomtypes);
        for (DynamicObject oldBomType : oldbomtypes) {
            if (newBomtypePks.contains(oldBomType.getLong("fbasedataid_id"))) continue;
            return false;
        }
        return true;
    }

    private void propChangeExpandBOMTime(ChangeData cd) {
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        int rowIndex = cd.getRowIndex();
        DynamicObject bom = (DynamicObject)this.getModel().getValue("bomid", rowIndex);
        if (bom == null || newValue == null) {
            return;
        }
        DynamicObject bomversion = (DynamicObject)(bom = MsBomQueryHelper.getDataCacheByID((Object)bom.getPkValue())).get("version");
        if (bomversion == null) {
            return;
        }
        bomversion = BusinessDataServiceHelper.loadSingleFromCache((Object)bomversion.getPkValue(), (String)"bd_bomversion");
        Date effectdate = bomversion.getDate("effectdate");
        Date invaliddate = bomversion.getDate("invaliddate");
        Date expendbomtime = (Date)newValue;
        if (expendbomtime.compareTo(effectdate) < 0 || expendbomtime.compareTo(invaliddate) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c55\u5f00\u65f6\u95f4\u4fee\u6539\u540e\u4e0d\u5728BOM\u6709\u6548\u671f\u5185\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u3002", (String)"MftOrderEditTpl_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("expendbomtime", oldValue, rowIndex);
        }
        this.autoChangeCoproduct(rowIndex, "expendbomtime");
    }

    private void propChangeMaterial(ChangeData cd) {
        Object newValue = cd.getNewValue();
        Object oldValue = cd.getOldValue();
        int rowIndex = cd.getRowIndex();
        Object otransactype = this.getModel().getValue("transactiontype");
        if (otransactype == null) {
            return;
        }
        DynamicObject material = (DynamicObject)newValue;
        DynamicObject oldmaterial = (DynamicObject)oldValue;
        if (material != null) {
            DynamicObject dept;
            if (oldmaterial == null || !material.getPkValue().equals(oldmaterial.getPkValue())) {
                this.getModel().setValue("entryyieldrate", null);
                this.getModel().setValue("yieldrate", (Object)0, rowIndex);
                this.getModel().setValue("estscrapqty", (Object)0, rowIndex);
                this.getModel().setValue("entryestscrapqty", null);
                this.getModel().setValue("manuversion", null, rowIndex);
                DomainIgnoreValSeUtil.setValue((IDataModel)this.getModel(), (String)"processroute", null, (int)rowIndex, (String[])new String[]{DomainEnum.PROP.getName()});
                this.getModel().setValue("unit", null, rowIndex);
                this.getModel().setValue("configuredcode", null, rowIndex);
                this.getModel().setValue("tracknumber", null, rowIndex);
            }
            long deptId = (dept = (DynamicObject)this.getModel().getValue("org")) == null ? 0L : (Long)dept.getPkValue();
            DynamicObject mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
            this.getModel().setValue("entrymaterial", (Object)material);
            material = (DynamicObject)mftmaterial.get(MASTERID);
            this.getModel().setValue("materielmasterid", (Object)material, rowIndex);
            material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
            this.setAuxpropLock(material);
            this.getModel().setValue("unit", mftmaterial.get("mftunit"), rowIndex);
            Object pid = this.getModel().getValue("pid", rowIndex);
            if (pid != null && Long.parseLong(pid.toString()) != 0L) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
                for (DynamicObject entryObj : entryEntity) {
                    Long id = entryObj.getLong("id");
                    if (!pid.equals(id)) continue;
                    Object deparOrg = this.getModel().getValue("producedept", entryObj.getInt("seq") - 1);
                    this.getModel().setValue("producedept", deparOrg, rowIndex);
                    break;
                }
            } else {
                DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
                DynamicObject producedept = transactiontype.getDynamicObject("producedept");
                if (producedept != null && this.queryProducedeptBoolean((Long)producedept.getPkValue())) {
                    this.getModel().setValue("producedept", (Object)producedept, rowIndex);
                } else {
                    DynamicObject departmentorg = (DynamicObject)mftmaterial.get("departmentorgid");
                    if (departmentorg != null && this.queryProducedeptBoolean((Long)departmentorg.getPkValue())) {
                        this.getModel().setValue("producedept", (Object)departmentorg, rowIndex);
                    } else {
                        this.getModel().setValue("producedept", null, rowIndex);
                    }
                }
            }
            this.getModel().setValue("iscontrolqty", mftmaterial.get("isstoragelimit"), rowIndex);
            this.getModel().setValue("entryiscontrolqty", mftmaterial.get("isstoragelimit"));
            this.getModel().setValue("rcvinhighlimit", mftmaterial.get("rcvinhighlimit"), rowIndex);
            this.getModel().setValue("entryrcvinhighlimit", mftmaterial.get("rcvinhighlimit"));
            this.getModel().setValue("rcvinlowlimit", mftmaterial.get("rcvinlowlimit"), rowIndex);
            this.getModel().setValue("entryrcvinlowlimit", mftmaterial.get("rcvinlowlimit"));
            this.getModel().setValue("isconreportqty", mftmaterial.get("isreportlimit"));
            this.getModel().setValue("repmaxrate", mftmaterial.get("rpthighlimit"));
            this.getModel().setValue("repminrate", mftmaterial.get("rptlowlimit"));
            this.setMaterialInvInfo(rowIndex);
            DynamicObject processroute = this.getProcessRoute(mftmaterial, dept);
            if (processroute != null) {
                DomainIgnoreValSeUtil.setValue((IDataModel)this.getModel(), (String)"processroute", (Object)processroute.getPkValue(), (int)rowIndex, (String[])new String[]{DomainEnum.PROP.getName()});
            }
            DynamicObject manuversion = (DynamicObject)this.getModel().getValue("manuversion", rowIndex);
            this.setECNVersionByExpandDate(rowIndex, mftmaterial.getDynamicObject(MASTERID), manuversion);
            this.setYieldrateAll(rowIndex);
            this.calPlanEndTime(rowIndex);
            DynamicObject qualityorg = (DynamicObject)this.getModel().getValue("qualityorg", rowIndex);
            long qualityorgId = qualityorg == null ? 0L : (Long)qualityorg.getPkValue();
            boolean isinspection = OrderQualityOrgService.getMaterialQCInfo((DynamicObject)mftmaterial, (long)qualityorgId);
            this.getModel().setValue("isinspection", (Object)isinspection, rowIndex);
            this.changeQtyOrUnit("qty", this.getModel().getValue("qty", rowIndex), rowIndex);
        } else {
            this.getModel().setValue("materielmasterid", null, rowIndex);
            this.getModel().setValue("bomid", null, rowIndex);
            DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
            DynamicObject producedept = transactiontype.getDynamicObject("producedept");
            if (producedept != null && this.queryProducedeptBoolean((Long)producedept.getPkValue())) {
                this.getModel().setValue("producedept", (Object)producedept, rowIndex);
            } else {
                this.getModel().setValue("producedept", null, rowIndex);
            }
            this.getModel().setValue("unit", null, rowIndex);
            DomainIgnoreValSeUtil.setValue((IDataModel)this.getModel(), (String)"processroute", null, (int)rowIndex, (String[])new String[]{DomainEnum.PROP.getName()});
            this.getModel().setValue("entrymaterial", null);
            this.getModel().setValue("entryauxproperty", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryauxproperty"});
            this.getModel().setValue("entryyieldrate", null);
            this.getModel().setValue("yieldrate", (Object)0, rowIndex);
            this.getModel().setValue("estscrapqty", (Object)0, rowIndex);
            this.getModel().setValue("entryestscrapqty", null);
            this.getModel().setValue("entryinwardept", null);
            this.getModel().setValue("inwardept", null, rowIndex);
            this.getModel().setValue("entrywarehouse", null);
            this.getModel().setValue("warehouse", null, rowIndex);
            this.getModel().setValue("isinspection", null, rowIndex);
            this.getModel().setValue("isconreportqty", null, rowIndex);
            this.getModel().setValue("repmaxrate", null, rowIndex);
            this.getModel().setValue("repminrate", null, rowIndex);
            this.getModel().setValue("configuredcode", null, rowIndex);
            this.getModel().setValue("tracknumber", null, rowIndex);
        }
    }

    private void propChangeQualityorg(ChangeData cd) {
        Object newValue = cd.getNewValue();
        int rowIndex = cd.getRowIndex();
        long qualityorgId = 0L;
        DynamicObject mftmaterial = null;
        Object mftmaterialObj = this.getModel().getValue("material", rowIndex);
        if (null != mftmaterialObj) {
            mftmaterial = (DynamicObject)mftmaterialObj;
        }
        if (newValue != null) {
            DynamicObject qualityorg = (DynamicObject)newValue;
            qualityorgId = qualityorg == null ? 0L : (Long)qualityorg.getPkValue();
        }
        boolean isinspection = OrderQualityOrgService.getMaterialQCInfo((DynamicObject)mftmaterial, (long)qualityorgId);
        this.getModel().setValue("isinspection", (Object)isinspection, rowIndex);
    }

    private boolean calHighQty(int index) {
        boolean flag = false;
        BigDecimal demandQty = (BigDecimal)this.getModel().getValue("baseqty", index);
        BigDecimal highlimit = (BigDecimal)this.getModel().getValue("entryrcvinhighlimit");
        DynamicObject baseunit = (DynamicObject)this.getModel().getValue("baseunit", index);
        if (baseunit == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7b2c%1$s\u884c\u5206\u5f55\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"MftOrderEditTpl_58", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), index + 1));
            return flag;
        }
        int baseprecision = baseunit.getInt("precision");
        String baseprecisionaccount = baseunit.getString("precisionaccount");
        int basepresisiondeal = UnitPrecisionUtils.getPrecisionDeal((String)baseprecisionaccount);
        BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.add(highlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
        extraratioqty = extraratioqty.setScale(baseprecision, basepresisiondeal);
        this.getModel().setValue("entryinwarmax", (Object)extraratioqty);
        this.getModel().setValue("inwarmax", (Object)extraratioqty, index);
        flag = true;
        return flag;
    }

    private boolean calLowQty(int index) {
        boolean flag = false;
        BigDecimal demandQty = (BigDecimal)this.getModel().getValue("baseqty", index);
        BigDecimal highlimit = (BigDecimal)this.getModel().getValue("entryrcvinlowlimit");
        DynamicObject baseunit = (DynamicObject)this.getModel().getValue("baseunit", index);
        if (baseunit == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7b2c%1$s\u884c\u5206\u5f55\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"MftOrderEditTpl_58", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), index + 1));
            return flag;
        }
        int baseprecision = baseunit.getInt("precision");
        String baseprecisionaccount = baseunit.getString("precisionaccount");
        int basepresisiondeal = UnitPrecisionUtils.getPrecisionDeal((String)baseprecisionaccount);
        BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.subtract(highlimit.divide(BigDecimal.valueOf(100L), 4, 4)));
        extraratioqty = extraratioqty.setScale(baseprecision, basepresisiondeal);
        this.getModel().setValue("entryinwarmin", (Object)extraratioqty);
        this.getModel().setValue("inwarmin", (Object)extraratioqty, index);
        flag = true;
        return flag;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        DynamicObject mftOrg;
        DynamicObject entry;
        EntryGrid entryGrid;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String key = e.getOperateKey();
        if ("viewstock".equals(key)) {
            List stockIDList;
            String keyEntity;
            ListShowParameter listShowParameter = new ListShowParameter();
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            boolean validateOrgPermission = this.validateOrgPermission(listShowParameter, filters, keyEntity = StockChangeUtils.getEntityName((int)0, (int)1, (String)this.getView().getEntityId(), (String)"pom_mftstock"));
            if (!validateOrgPermission) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u83b7\u53d6\u201c\u7ec4\u4ef6\u6e05\u5355\u201d\u67e5\u770b\u6743\u9650\u3002", (String)"MftOrderEditTpl_22", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl("treeentryentity");
            ArrayList<Object> idList = new ArrayList<Object>();
            if (entryGrid2.getSelectRows().length == 0) {
                DynamicObject manuBill = this.getModel().getDataEntity();
                DynamicObjectCollection entryCol = manuBill.getDynamicObjectCollection("treeentryentity");
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject entry2 = (DynamicObject)entryCol.get(i);
                    idList.add(entry2.getPkValue());
                }
            } else {
                for (int i = 0; i < entryGrid2.getSelectRows().length; ++i) {
                    DynamicObject entry3 = this.getModel().getEntryRowEntity("treeentryentity", entryGrid2.getSelectRows()[i]);
                    String producttype = entry3.getString("producttype");
                    if (!ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) continue;
                    idList.add(entry3.getPkValue());
                }
            }
            if ((stockIDList = OrderOpUtils.queryStockIdByOrderEntrys(idList, (String)keyEntity)).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u6e38\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftOrderEditTpl_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (stockIDList.size() == 1) {
                BillShowParameter showParameter = ManuFactureTraceUtils.createBillShowParam((String)keyEntity, stockIDList.get(0));
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                QFilter qfilter = new QFilter("id", "in", (Object)stockIDList);
                qfilterList.add(qfilter);
                ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam((String)keyEntity, qfilterList);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
        if ("viewtechnics".equals(e.getOperateKey())) {
            List technicsIDList;
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            ArrayList<Object> idList = new ArrayList<Object>();
            if (entryGrid.getSelectRows().length == 0) {
                DynamicObject manuBill = this.getModel().getDataEntity();
                DynamicObjectCollection entryCol = manuBill.getDynamicObjectCollection("treeentryentity");
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject entry4 = (DynamicObject)entryCol.get(i);
                    idList.add(entry4.getPkValue());
                }
            } else {
                for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    DynamicObject entry5 = this.getModel().getEntryRowEntity("treeentryentity", i);
                    String producttype = entry5.getString("producttype");
                    if (!ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) continue;
                    idList.add(entry5.getPkValue());
                }
            }
            if ((technicsIDList = OrderOpUtils.queryManuTechIdByOrderEntrys(idList, (String)"sfc_manftech")).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212\u3002", (String)"MftOrderEditTpl_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (technicsIDList.size() == 1) {
                BillShowParameter showParameter = ManuFactureTraceUtils.createBillShowParam((String)"sfc_manftech", technicsIDList.get(0));
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                QFilter qfilter = new QFilter("id", "in", (Object)technicsIDList);
                qfilterList.add(qfilter);
                ListShowParameter showParameter = ManuFactureTraceUtils.createShowParam((String)"sfc_manftech", qfilterList);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
        if ("newentry".equals(e.getOperateKey())) {
            DynamicObject obj;
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            if (this.getModel().getValue("org") != null && (obj = (DynamicObject)this.getModel().getValue("org")).getBoolean("fisinventory")) {
                this.getModel().setValue("inwardept", (Object)obj, rowIndex);
            }
            entry = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
            int index = this.getModel().getEntryCurrentRowIndex("treeentryentity");
            this.getModel().setValue("producttype", (Object)ManuBillProductTypeEnum.MAIN.getValue(), index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"producttype"});
            this.setYieldrate(rowIndex, BigDecimal.ONE);
            this.showOtherInfo(entry, rowIndex);
            this.setSomeControl(entry);
            mftOrg = (DynamicObject)this.getModel().getValue("org");
            this.fillEntryQualityorg(entry, mftOrg, rowIndex);
        }
        if ("insertentry".equals(e.getOperateKey())) {
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            entry = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
            this.setYieldrate(rowIndex, BigDecimal.ONE);
            this.showOtherInfo(entry, rowIndex);
            this.setSomeControl(entry);
            int parentIndex = this.getParentRowIndex(rowIndex);
            if (parentIndex != -1) {
                this.autoChangeCoproduct(parentIndex, "srcbillno");
                this.autoChangeCoproduct(parentIndex, "planscope");
                this.autoChangeCoproduct(parentIndex, "supplyrule");
            }
            mftOrg = (DynamicObject)this.getModel().getValue("org");
            this.fillEntryQualityorg(entry, mftOrg, rowIndex);
        }
        if ("deleteentry".equals(e.getOperateKey())) {
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            entry = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
            this.showOtherInfo(entry, rowIndex);
            this.setSomeControl(entry);
        }
        if (MftOrderEditTpl.isBizOperation(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.showOtherInfo(null, -1);
            this.setSomeControl(null);
            this.getView().updateView();
            this.getView().invokeOperation("refresh");
            this.refreshOrderF7();
        }
        if (("save".equals(e.getOperateKey()) || "submit".equals(e.getOperateKey())) && e.getOperationResult().isSuccess()) {
            this.lockMaterialAfterSave();
            this.refreshOrderF7();
            if ("submit".equals(e.getOperateKey())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_refresh"});
                this.getView().invokeOperation("refresh");
            }
        }
        if (("audit".equals(e.getOperateKey()) || "unaudit".equals(e.getOperateKey())) && e.getOperationResult().isSuccess()) {
            this.refreshOrderF7();
            this.getView().invokeOperation("refresh");
        }
        if ("ordersplit".equals(e.getOperateKey()) && (isSuccess = e.getOperationResult().isSuccess())) {
            this.ordersplitAfterOp(operate);
        }
        if ("ordersplitlog".equals(key)) {
            String orderSplitLogEntity = operate.getOption().getVariableValue("orderSplitLogEntity", "pom_mftorder_splitlog");
            TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
            int[] selectRows = orderEntry.getSelectRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"MftOrderEditTpl_39", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Object> entryPkValues = new ArrayList<Object>(10);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treeentryentity", selectRows[i]);
                entryPkValues.add(entryRowEntity.getPkValue());
            }
            if (entryPkValues.size() > 0) {
                Set result = OrderSplitValidateService.querySplitBillInSplitLogs(entryPkValues, null, (String)orderSplitLogEntity);
                if (result.size() > 0) {
                    ListShowParameter showParam = new ListShowParameter();
                    showParam.setBillFormId(orderSplitLogEntity);
                    ArrayList<QFilter> qfilterList = new ArrayList<QFilter>();
                    qfilterList.add(new QFilter("orderentryid", "in", entryPkValues));
                    showParam.getListFilterParameter().setQFilters(qfilterList);
                    showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    DynamicObject obj = (DynamicObject)this.getModel().getValue("org");
                    ArrayList<String> orgPkValues = new ArrayList<String>();
                    orgPkValues.add(obj.getPkValue().toString());
                    showParam.setCustomParam("billFormId", (Object)orderSplitLogEntity);
                    showParam.setCustomParam("useorgIdFilter", orgPkValues);
                    this.getView().showForm((FormShowParameter)showParam);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u65e0\u62c6\u5206\u65e5\u5fd7\u3002", (String)"MftOrderEditTpl_40", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (StringUtils.equals((CharSequence)"genlotnum", (CharSequence)e.getOperateKey())) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            this.checkSaveBill(dataEntity);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("entryfield", "treeentryentity");
            paramMap.put("material", "material");
            paramMap.put("lotmap", "batchno");
            long begin = System.currentTimeMillis();
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getLotCode", (Object[])new Object[]{dataEntity, paramMap});
            long end = System.currentTimeMillis();
            logger.info("\u83b7\u53d6\u6279\u53f7\u603b\u65f6\u95f4\uff1a" + (end - begin) + "ms");
            String lotKey = (String)paramMap.get("lotmap");
            StringBuilder sb = new StringBuilder();
            this.getView().getModel().beginInit();
            ArrayList<Integer> index = new ArrayList<Integer>(12);
            for (Map.Entry entry6 : map.entrySet()) {
                Integer seq = (Integer)entry6.getKey();
                String value = (String)entry6.getValue();
                if (value.startsWith("ERROR")) {
                    sb.append(value.substring("ERROR".length()));
                    sb.append("\n");
                    continue;
                }
                this.getView().getModel().setValue(lotKey, (Object)value, seq - 1);
                index.add(seq - 1);
            }
            this.getView().getModel().endInit();
            index.forEach(p -> this.getView().updateView(lotKey, p.intValue()));
            if (sb.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u5f02\u5e38", (String)"MftOrderEditTpl_43", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
                return;
            }
            this.handleLotMainFile(dataEntity, dataEntity.getDynamicObjectCollection("treeentryentity"), e.getOperateKey(), "treeentryentity.lot", "batchno");
        }
        if (StringUtils.equals((CharSequence)"modclosetime", (CharSequence)e.getOperateKey())) {
            isSuccess = e.getOperationResult().isSuccess();
            if (isSuccess) {
                this.modclosetime();
            }
        } else if (StringUtils.equals((CharSequence)"modtransmittime", (CharSequence)e.getOperateKey())) {
            isSuccess = e.getOperationResult().isSuccess();
            if (isSuccess) {
                this.modtransmittime();
            }
        } else if (StringUtils.equals((CharSequence)"modbookdate", (CharSequence)e.getOperateKey()) && (isSuccess = e.getOperationResult().isSuccess())) {
            this.modBookDate();
        }
    }

    private void ordersplit(FormOperate operate, BeforeDoOperationEventArgs e) {
        TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = orderEntry.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"MftOrderEditTpl_39", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ArrayList<Long> billSelectRowList = new ArrayList<Long>(10);
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", orderEntry.getSelectRows()[i]);
            billSelectRowList.add(entry.getLong("id"));
        }
        if (billSelectRowList.size() <= 0) {
            e.setCancel(true);
            return;
        }
        String jsonString = SerializationUtils.toJsonString(billSelectRowList);
        operate.getOption().setVariableValue("billSelectRowList", jsonString);
        operate.getOption().setVariableValue("isFromMftOrderBill", "true");
    }

    private void ordersplitAfterOp(FormOperate operate) {
        FormShowParameter showParameter = OrderSpliteService.splitOrderShowForm((String)ResManager.loadKDString((String)"\u62c6\u5206\u5de5\u5355", (String)"MftOrderEditTpl_41", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (IFormPlugin)this, (String)"ordersplit");
        showParameter.setCustomParam("isFromMftOrderBill", (Object)"true");
        String billSelectRowList = operate.getOption().getVariableValue("billSelectRowList");
        showParameter.setCustomParam("billSelectRowList", (Object)billSelectRowList);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            long mainOrgId = org.getLong("id");
            showParameter.setCustomParam("mainOrgId", (Object)mainOrgId);
        }
        this.getView().showForm(showParameter);
    }

    private void handleLotMainFile(DynamicObject bill, DynamicObjectCollection entryEntity, String operate, String lotidField, String lotnumber) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"saveLotMainFileByBillOperate", (Object[])new Object[]{operate, bill, entryEntity, lotidField});
        StringBuilder sb = new StringBuilder();
        Set entrySet = result.entrySet();
        String[] paramNodes = lotidField.split("\\.");
        String lotIDKey = paramNodes.length > 1 ? paramNodes[paramNodes.length - 1] : lotidField;
        for (Map.Entry entry : entrySet) {
            Integer seq = (Integer)entry.getKey();
            String msg = (String)entry.getValue();
            if (msg.startsWith("ERROR")) {
                if (msg.startsWith("ERRORLOTNUMBERCLEAR")) {
                    sb.append(msg.substring("ERRORLOTNUMBERCLEAR".length())).append('\n');
                    this.getView().getModel().setValue(lotnumber, (Object)"", seq - 1);
                    continue;
                }
                sb.append(msg.substring("ERROR".length())).append('\n');
                continue;
            }
            this.getView().getModel().setValue(lotIDKey, (Object)msg, seq - 1);
        }
        this.getView().getModel().endInit();
        this.getView().updateView(entryEntity.getDynamicObjectType().getName());
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u4e3b\u6863\u5f02\u5e38\u3002", (String)"MftOrderEditTpl_44", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        }
    }

    private void checkSaveBill(DynamicObject bill) {
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        Object pkValue = bill.getPkValue();
        if (pkValue == null || pkValue.equals(0L) || !isFromDataBase) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u751f\u6210\u6279\u53f7\u3002", (String)"MftOrderEditTpl_45", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void refreshOrderF7() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        if (!entryEntity.isEmpty()) {
            IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject mftOrg;
        int rowcount;
        DynamicObject obj;
        super.afterCreateNewData(e);
        this.lockSomeControls();
        this.setDefaultTrans();
        if (this.getModel().getValue("org") != null && (obj = (DynamicObject)this.getModel().getValue("org")).getBoolean("fisinventory")) {
            for (int i = 0; i < this.getModel().getEntryRowCount("treeentryentity"); ++i) {
                this.getModel().setValue("inwardept", (Object)obj, i);
            }
        }
        if ((rowcount = this.getModel().getEntryRowCount("treeentryentity")) > 0) {
            DynamicObject producedept;
            int rowIndex = 0;
            DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
            entry.set("producttype", (Object)ManuBillProductTypeEnum.MAIN.getValue());
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"producttype"});
            DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
            if (transactiontype != null && (producedept = transactiontype.getDynamicObject("producedept")) != null && this.queryProducedeptBoolean((Long)producedept.getPkValue())) {
                entry.set("producedept", (Object)producedept);
            }
        }
        this.setEnableViseble("A");
        String entityId = this.getView().getEntityId();
        if (("pom_mftorder".equals(entityId) || "om_mftorder".equals(entityId)) && null != (mftOrg = (DynamicObject)this.getModel().getValue("org"))) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("treeentryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entryentity = (DynamicObject)entrys.get(i);
                this.fillEntryQualityorg(entryentity, mftOrg, i);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        DynamicObject mftOrg;
        super.afterCopyData(e);
        this.lockSomeControls();
        String entityId = this.getView().getEntityId();
        if (("pom_mftorder".equals(entityId) || "om_mftorder".equals(entityId)) && null != (mftOrg = (DynamicObject)this.getModel().getValue("org"))) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("treeentryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                Date begintime;
                Date preparetime;
                DynamicObject entryentity = (DynamicObject)entrys.get(i);
                DynamicObject qualityorg = entryentity.getDynamicObject("qualityorg");
                long initOrgId = 0L;
                if (null != qualityorg) {
                    initOrgId = qualityorg.getLong("id");
                }
                if ((preparetime = (Date)this.getModel().getValue("planpreparetime", i)).compareTo(begintime = (Date)this.getModel().getValue("planbegintime", i)) > 0) {
                    this.getModel().setValue("planpreparetime", (Object)begintime, i);
                }
                boolean isinspection = OrderQualityOrgService.getMaterialQCInfo((DynamicObject)entryentity.getDynamicObject("material"), (long)initOrgId);
                this.getModel().setValue("isinspection", (Object)isinspection, i);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.lockSomeControls();
        this.lockMaterialAfterSave();
        if ("D".equals(this.getModel().getValue("billstatus"))) {
            this.setEnableViseble("D");
        }
        TreeEntryGrid control = (TreeEntryGrid)this.getControl("treeentryentity");
        control.setCollapse(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmax"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmin"});
        DynamicObjectCollection orderEntrys = this.getModel().getEntryEntity("treeentryentity");
        for (DynamicObject dynamicObject : orderEntrys) {
            long orderEntryId = Long.parseLong(dynamicObject.getPkValue().toString());
            Map map = BFTrackerServiceHelper.findSourceBills((String)this.getView().getEntityId(), (Long[])new Long[]{orderEntryId});
            if (map != null && map.size() > 0) {
                this.getView().setEnable(Boolean.valueOf(false), dynamicObject.getInt("seq") - 1, new String[]{"producttype"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), dynamicObject.getInt("seq") - 1, new String[]{"producttype"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String checkDataChange = this.getPageCache().get("checkDataChange");
        if ("true".equals(checkDataChange)) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            e.setCheckDataChange(false);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("treeentryentity".equals(entryGrid.getKey())) {
            if (entryGrid.getSelectRows().length > 0) {
                int rowIndex = entryGrid.getSelectRows()[0];
                DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", rowIndex);
                this.showOtherInfo(entry, rowIndex);
                this.setSomeControl(entry);
            } else {
                this.showOtherInfo(null, -1);
                this.setSomeControl(null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("submit".equals(key)) {
            this.checkPlanDate(e);
        }
        if ("copy".equals(key)) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("treeentryentity");
            for (DynamicObject entryrow : entry) {
                String enable;
                DynamicObject bom = entryrow.getDynamicObject("bomid");
                if (bom == null || !"0".equals(enable = (bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bom.getPkValue(), (String)"pdm_mftbom", (String)"enable")).getString("enable"))) continue;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"MftOrderEditTpl_60", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), bom.getString("number")));
                e.setCancel(true);
            }
        }
        if ("deleteentry".equals(key)) {
            ArrayList<Object> entryIds = new ArrayList<Object>(10);
            HashMap<Object, String> entryIdAndSeqMap = new HashMap<Object, String>(16);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                int index = entryGrid.getSelectRows()[i];
                DynamicObject orderEntryDym = this.getModel().getEntryRowEntity("treeentryentity", index);
                if (null == orderEntryDym) continue;
                entryIds.add(orderEntryDym.getPkValue());
                entryIdAndSeqMap.put(orderEntryDym.getPkValue(), orderEntryDym.getString("seq"));
            }
            if (entryIds.size() > 0) {
                String seqIn;
                Set result = OrderSplitValidateService.querySplitBillInSplitLogs(entryIds, null);
                StringBuilder seqInfoBuilder = new StringBuilder();
                for (Long pkValue : result) {
                    if (null == pkValue) continue;
                    seqInfoBuilder.append((String)entryIdAndSeqMap.get(pkValue));
                    seqInfoBuilder.append(",");
                }
                String string = seqIn = StringUtils.isBlank((CharSequence)seqInfoBuilder) ? "" : seqInfoBuilder.substring(0, seqInfoBuilder.length() - 1);
                if (StringUtils.isNotBlank((CharSequence)seqIn)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u884c\u5931\u8d25\uff0c\u7b2c%1$s\u884c\u5206\u5f55\u5b58\u5728\u62c6\u5206\u751f\u4ea7\u5de5\u5355\u3002", (String)"MftOrderEditTpl_61", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), seqIn));
                    e.setCancel(true);
                    return;
                }
            }
        }
        FormOperate operate = (FormOperate)e.getSource();
        if ("ordersplit".equals(key)) {
            this.ordersplit(operate, e);
        }
        StringBuilder sb = new StringBuilder();
        if ("donothing".equalsIgnoreCase(operate.getType())) {
            int[] allSelectRows;
            IDataModel model = this.getView().getModel();
            String billno = (String)model.getValue("billno");
            EntryGrid entrygrid = (EntryGrid)this.getView().getControl("treeentryentity");
            for (int rowIndex : allSelectRows = entrygrid.getSelectRows()) {
                Object entryPK = ((DynamicObject)this.getModel().getEntryEntity("treeentryentity").get(rowIndex)).getPkValue();
                sb.append(billno).append(',').append(entryPK).append("@@@");
            }
        }
        if (key.equalsIgnoreCase("beginwork")) {
            operate.getOption().setVariableValue("ishandbeginwork", "1");
        }
        operate.getOption().setVariableValue("operateOption", sb.toString());
        operate.getOption().setVariableValue("operatePageId", this.getView().getPageId());
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter qfilter1;
        ListShowParameter listShowParameter;
        DynamicObject org;
        ListShowParameter listShowParameter2;
        DynamicObject material;
        DynamicObject mftmaterial;
        EntryGrid entryGrid;
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("entrylocation".equals(source)) {
            ArrayList<Object> locationList = new ArrayList<Object>();
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("entrywarehouse");
            if (warehouse != null) {
                warehouse = BusinessDataServiceHelper.loadSingleFromCache((Object)warehouse.getPkValue(), (String)"bd_warehouse");
                DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject obj = (DynamicObject)col.get(i);
                    DynamicObject location = (DynamicObject)obj.get("location");
                    if (location == null) continue;
                    locationList.add(location.getPkValue());
                }
            }
            ListShowParameter listShowParameter3 = (ListShowParameter)evt.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", locationList);
            listShowParameter3.getListFilterParameter().getQFilters().add(qfilter);
        }
        if ("unit".equals(source)) {
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (mftmaterial == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MftOrderEditTpl_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)mftmaterial.getPkValue());
            material = (DynamicObject)mftmaterial.get(MASTERID);
            material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
            DynamicObject baseunitDO = material.getDynamicObject("baseunit");
            Long mid = material.getLong("id");
            Long buid = baseunitDO == null ? 0L : baseunitDO.getLong("id");
            List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)buid, (String)"1", (Boolean)Boolean.FALSE);
            listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            QFilter fixconFilter = new QFilter("id", "in", (Object)fixconunitlist);
            listShowParameter2.getListFilterParameter().getQFilters().add(fixconFilter);
        }
        if ("bomid".equals(source)) {
            this.setBOMF7Filter(evt);
        }
        if ("entrywarehouse".equals(source)) {
            QFilter qfilter;
            org = (DynamicObject)this.getModel().getValue("entryinwardept");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5165\u5e93\u7ec4\u7ec7\u201d\u3002", (String)"MftOrderEditTpl_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)Long.parseLong(org.getPkValue().toString()));
            ArrayList<DynamicObject> ids = new ArrayList<DynamicObject>();
            for (DynamicObject warehouseid : warehouseids) {
                if (warehouseid == null) continue;
                ids.add(warehouseid);
            }
            if (!ids.isEmpty()) {
                listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                qfilter = new QFilter("id", "in", ids);
                listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
            } else {
                listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                qfilter = new QFilter("id", "=", (Object)Long.valueOf("0"));
                listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
            }
        }
        if ("material".equals(source)) {
            this.setMaterialF7Filter(evt);
        }
        if ("processroute".equals(source)) {
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
            if (dept == null || "0".equals(dept.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u3002", (String)"MftOrderEditTpl_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject mftmaterial2 = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (mftmaterial2 == null || "0".equals(mftmaterial2.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MftOrderEditTpl_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qfilter1 = this.getProcessRouteFilter(mftmaterial2, dept);
            ListShowParameter listShowParameter4 = (ListShowParameter)evt.getFormShowParameter();
            if (qfilter1 != null) {
                listShowParameter4.getListFilterParameter().getQFilters().add(qfilter1);
            }
        }
        if ("routereplace".equals(source)) {
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (mftmaterial == null || "0".equals(mftmaterial.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MftOrderEditTpl_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            material = mftmaterial.getDynamicObject(MASTERID);
            qfilter1 = new QFilter("material", "=", material.getPkValue());
            DynamicObject route = (DynamicObject)this.getModel().getValue("processroute");
            if (route != null) {
                DynamicObject routereplace = route.getDynamicObject("routereplace");
                if (routereplace != null) {
                    qfilter1.and(new QFilter("routereplace", "=", routereplace.getPkValue()));
                } else {
                    qfilter1.and(new QFilter("1", "!=", (Object)Long.valueOf("1")));
                }
            }
            DynamicObjectCollection col = QueryServiceHelper.query((String)"pdm_route", (String)"id,routereplace.id", (QFilter[])new QFilter[]{qfilter1});
            HashSet<Long> idSet = new HashSet<Long>(col.size());
            for (int i = 0; i < col.size(); ++i) {
                DynamicObject obj = (DynamicObject)col.get(i);
                idSet.add(Long.valueOf(obj.getString("routereplace.id")));
            }
            listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter2.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
        }
        if ("manuversion".equals(source)) {
            this.setManuversionF7Filter(evt);
        }
        if ("producedept".equals(source)) {
            Set<Long> idSet = this.queryProducedeptList();
            ListShowParameter listShowParameter5 = (ListShowParameter)evt.getFormShowParameter();
            if (!idSet.isEmpty()) {
                listShowParameter5.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            }
            listShowParameter5.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter5.setMultiSelect(false);
        }
        if ("org".equals(source)) {
            ListShowParameter listShowParameter6 = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter6.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
        if ("entryinwardept".equals(source)) {
            DynamicObject entrustdept;
            entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
            if (mftmaterial == null || "0".equals(mftmaterial.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MftOrderEditTpl_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            DynamicObject org2 = (DynamicObject)this.getModel().getValue("org");
            DynamicObjectType ObjectType = this.getModel().getDataEntity().getDynamicObjectType();
            DataEntityPropertyCollection properties = ObjectType.getProperties();
            ArrayList<Long> inwareOrgFilter = new ArrayList<Long>(16);
            if (properties.containsKey((Object)"entrustdept") && (entrustdept = (DynamicObject)this.getModel().getValue("entrustdept")) != null) {
                inwareOrgFilter.addAll(this.getInwareOrgFilter((Long)entrustdept.getPkValue()));
            }
            String supplyrule = "";
            if (properties.containsKey((Object)"supplyrule")) {
                supplyrule = (String)this.getModel().getValue("supplyrule", rowIndex);
            }
            if (!"C".equals(supplyrule) && org2 != null) {
                inwareOrgFilter.addAll(this.getInwareOrgFilter((Long)org2.getPkValue()));
            }
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", inwareOrgFilter));
        }
        if ("entryoutputoperation".equals(source)) {
            org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workprocedure", (Long)org.getLong("id"));
            baseDataFilter.and(new QFilter("status", "=", (Object)"C"));
            baseDataFilter.and(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(baseDataFilter);
        }
        if ("configuredcode".equals(source)) {
            this.configuredCodeBeforeF7Select(evt);
        }
        if ("qualityorg".equals(source)) {
            this.filterQualityOrg(evt);
        }
    }

    private void configuredCodeBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"MftOrderEditTpl_47", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long materialId = material.getDynamicObject(MASTERID).getLong("id");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("material.id", "=", (Object)materialId));
    }

    private boolean checkManuVersionBOMType(DynamicObject versionBom) {
        DynamicObject transtype = (DynamicObject)this.getModel().getValue("transactiontype");
        DynamicObject transtypeload = TransactionTypeQueryHelper.getDataCacheByID((Object)transtype.getPkValue());
        DynamicObjectCollection transbomtypes = transtypeload.getDynamicObjectCollection("bomtypes");
        if (CollectionUtils.isEmpty((Collection)transbomtypes)) {
            return false;
        }
        DynamicObject bomload = MsBomQueryHelper.getDataCacheByID((Object)versionBom.getPkValue());
        DynamicObject bomtype = bomload.getDynamicObject("type");
        return bomtype != null && MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)transbomtypes).contains(bomtype.getPkValue());
    }

    private boolean checkManuVersionRoute(DynamicObject versionRoute, QFilter routeFilter) {
        if (versionRoute == null) {
            return true;
        }
        QFilter qFilter = new QFilter("id", "=", versionRoute.getPkValue());
        return QueryServiceHelper.exists((String)"pdm_route", (QFilter[])new QFilter[]{qFilter, routeFilter});
    }

    public static boolean isBizOperation(String key) {
        if (bizOp.contains(key)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void showOtherInfo(DynamicObject entry, int rowIndex) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        if (entry == null) {
            this.getModel().setValue("entrymaterial", null);
            this.getModel().setValue("entryauxproperty", null);
            this.getModel().setValue("entryyieldrate", null);
            this.getModel().setValue("entryestscrapqty", null);
            this.getModel().setValue("entryinwardept", null);
            this.getModel().setValue("entrywarehouse", null);
            this.getModel().setValue("entrylocation", null);
            this.getModel().setValue("entryiscontrolqty", null);
            this.getModel().setValue("entryinwarmax", null);
            this.getModel().setValue("entryinwarmin", null);
            this.getModel().setValue("entryrcvinhighlimit", null);
            this.getModel().setValue("entryrcvinlowlimit", null);
            this.getModel().setValue("entryoutputoperation", null);
            this.getModel().setValue("entryrptqty", null);
            this.getModel().setValue("entryreportqty", null);
            this.getModel().setValue("entryworkwasteqty", null);
            this.getModel().setValue("entrymtlcostqty", null);
            this.getModel().setValue("entryqualifiedqty", null);
            this.getModel().setValue("entryunqualifiedqty", null);
            this.getModel().setValue("entryscrapqty", null);
            this.getModel().setValue("entryrepairqty", null);
            this.getModel().setValue("entryreworkqty", null);
            this.getModel().setValue("entrypickingpairs", null);
            this.getModel().setValue("entrystockqty", null);
            this.getModel().setValue("entryquainwaqty", null);
            this.getModel().setValue("entryunquainwaqty", null);
            this.getModel().setValue("entryscrinwaqty", null);
            this.getModel().setValue("entryrepinwaqty", null);
            this.getModel().setValue("entryplansuretime", null);
            this.getModel().setValue("entrytransmittime", null);
            this.getModel().setValue("entrystartworktime", null);
            this.getModel().setValue("entryendworktime", null);
            this.getModel().setValue("entryclosetime", null);
            this.getModel().setValue("entrycloser", null);
            this.getModel().setValue("entrycompletime", null);
            this.getModel().setValue("entrysourcebilltype", null);
            this.getModel().setValue("entrysourcebillnumber", null);
            this.getModel().setValue("entrysourceentryseq", null);
            this.getModel().setValue("entryunit", null);
            this.getModel().setValue("entryseq", (Object)-1);
            this.getModel().setValue("entrybaseunit", null);
            this.getModel().setValue("entrybaseqty", null);
            this.getModel().setValue("entryauxptyunit", null);
            this.getModel().setValue("entryauxptyqty", null);
            this.getModel().setValue("entryacceptqty", null);
            this.getModel().setValue("entrysrcsplitbillnumber", null);
            this.getModel().setValue("entrysrcsplitbillseq", null);
            return;
        }
        DynamicObject material = (DynamicObject)entry.get("material");
        DynamicObject auxproperty = (DynamicObject)entry.get("auxproperty");
        DynamicObject inwardept = (DynamicObject)entry.get("inwardept");
        DynamicObject unit = (DynamicObject)entry.get("unit");
        DynamicObject warehouse = (DynamicObject)entry.get("warehouse");
        DynamicObject location = (DynamicObject)entry.get("location");
        boolean iscontrolqty = entry.getBoolean("iscontrolqty");
        BigDecimal inwarmax = entry.getBigDecimal("inwarmax");
        BigDecimal inwarmin = entry.getBigDecimal("inwarmin");
        DynamicObject outputoperation = (DynamicObject)entry.get("outputoperation");
        BigDecimal rptqty = entry.getBigDecimal("rptqty");
        BigDecimal reportqty = entry.getBigDecimal("reportqty");
        BigDecimal workwasteqty = entry.getBigDecimal("workwasteqty");
        BigDecimal mtlcostqty = entry.getBigDecimal("mtlcostqty");
        BigDecimal qualifiedqty = entry.getBigDecimal("qualifiedqty");
        BigDecimal unqualifiedqty = entry.getBigDecimal("unqualifiedqty");
        BigDecimal scrapqty = entry.getBigDecimal("scrapqty");
        BigDecimal repairqty = entry.getBigDecimal("repairqty");
        BigDecimal reworkqty = entry.getBigDecimal("reworkqty");
        BigDecimal pickingpairs = entry.getBigDecimal("pickingpairs");
        BigDecimal stockqty = entry.getBigDecimal("stockqty");
        BigDecimal quainwaqty = entry.getBigDecimal("quainwaqty");
        BigDecimal unquainwaqty = entry.getBigDecimal("unquainwaqty");
        BigDecimal scrinwaqty = entry.getBigDecimal("scrinwaqty");
        BigDecimal repinwaqty = entry.getBigDecimal("repinwaqty");
        Date plansuretime = entry.getDate("plansuretime");
        Date transmittime = entry.getDate("transmittime");
        Date startworktime = entry.getDate("startworktime");
        Date endworktime = entry.getDate("endworktime");
        Date closetime = entry.getDate("closetime");
        DynamicObject closer = entry.getDynamicObject("closer");
        Date completetime = entry.getDate("completime");
        String sourcebilltype = entry.getString("sourcebilltype");
        String sourcebillnumber = entry.getString("sourcebillnumber");
        String sourceentryseq = entry.getString("sourceentryseq");
        BigDecimal entryrcvinhighlimit = entry.getBigDecimal("rcvinhighlimit");
        BigDecimal entryrcvinlowlimit = entry.getBigDecimal("rcvinlowlimit");
        DynamicObject baseunit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
        BigDecimal baseqty = (BigDecimal)this.getModel().getValue("baseqty", rowIndex);
        DynamicObject auxunit = (DynamicObject)this.getModel().getValue("auxptyunit", rowIndex);
        BigDecimal auxqty = (BigDecimal)this.getModel().getValue("auxptyqty", rowIndex);
        BigDecimal estscrapqty = entry.getBigDecimal("estscrapqty");
        BigDecimal acceptqty = entry.getBigDecimal("acceptqty");
        String srcsplitbillnumber = entry.getString("srcsplitbillnumber");
        DynamicObject srcsplitbillseq = entry.getDynamicObject("srcsplitbillseq");
        DynamicObject omsrcsplitbillseq = null;
        if (entry.containsProperty("omsrcsplitbillseq")) {
            omsrcsplitbillseq = entry.getDynamicObject("omsrcsplitbillseq");
        }
        if (null != srcsplitbillseq) {
            this.getModel().setValue("entrysrcsplitbillseq", (Object)srcsplitbillseq.getString("entryseq"));
        } else if (null != omsrcsplitbillseq) {
            this.getModel().setValue("entrysrcsplitbillseq", (Object)omsrcsplitbillseq.getString("entryseq"));
        }
        this.getModel().setValue("entryyieldrate", entry.get("yieldrate"));
        this.getModel().setValue("entryestscrapqty", entry.get("scrapqty"));
        this.getModel().setValue("entrymaterial", (Object)material);
        this.getModel().setValue("entryunit", (Object)unit);
        this.getModel().setValue("entryauxproperty", (Object)auxproperty);
        this.getModel().setValue("entryinwardept", (Object)inwardept);
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.getModel().setValue("entrywarehouse", (Object)warehouse);
        this.getModel().setValue("entrylocation", (Object)location);
        this.getModel().setValue("entryiscontrolqty", (Object)iscontrolqty);
        this.getModel().setValue("entryinwarmax", (Object)inwarmax);
        this.getModel().setValue("entryinwarmin", (Object)inwarmin);
        this.getModel().setValue("entryoutputoperation", (Object)outputoperation);
        this.getModel().setValue("entryrptqty", (Object)rptqty);
        this.getModel().setValue("entryreportqty", (Object)reportqty);
        this.getModel().setValue("entryworkwasteqty", (Object)workwasteqty);
        this.getModel().setValue("entrymtlcostqty", (Object)mtlcostqty);
        this.getModel().setValue("entryqualifiedqty", (Object)qualifiedqty);
        this.getModel().setValue("entryunqualifiedqty", (Object)unqualifiedqty);
        this.getModel().setValue("entryscrapqty", (Object)scrapqty);
        this.getModel().setValue("entryrepairqty", (Object)repairqty);
        this.getModel().setValue("entryreworkqty", (Object)reworkqty);
        this.getModel().setValue("entrypickingpairs", (Object)pickingpairs);
        this.getModel().setValue("entrystockqty", (Object)stockqty);
        this.getModel().setValue("entryquainwaqty", (Object)quainwaqty);
        this.getModel().setValue("entryunquainwaqty", (Object)unquainwaqty);
        this.getModel().setValue("entryscrinwaqty", (Object)scrinwaqty);
        this.getModel().setValue("entryrepinwaqty", (Object)repinwaqty);
        this.getModel().setValue("entryplansuretime", (Object)plansuretime);
        this.getModel().setValue("entrytransmittime", (Object)transmittime);
        this.getModel().setValue("entrystartworktime", (Object)startworktime);
        this.getModel().setValue("entryendworktime", (Object)endworktime);
        this.getModel().setValue("entryclosetime", (Object)closetime);
        this.getModel().setValue("entrycloser", (Object)closer);
        this.getModel().setValue("entrycompletime", (Object)completetime);
        this.getModel().setValue("entrysourcebilltype", (Object)sourcebilltype);
        this.getModel().setValue("entrysourcebillnumber", (Object)sourcebillnumber);
        this.getModel().setValue("entrysourceentryseq", (Object)sourceentryseq);
        this.getModel().setValue("entryseq", (Object)rowIndex);
        this.getModel().setValue("entryrcvinhighlimit", (Object)entryrcvinhighlimit);
        this.getModel().setValue("entryrcvinlowlimit", (Object)entryrcvinlowlimit);
        this.getModel().setValue("entrybaseunit", (Object)baseunit);
        this.getModel().setValue("entrybaseqty", (Object)baseqty);
        this.getModel().setValue("entryauxptyunit", (Object)auxunit);
        this.getModel().setValue("entryauxptyqty", (Object)auxqty);
        this.getModel().setValue("entryestscrapqty", (Object)estscrapqty);
        this.getModel().setValue("entryacceptqty", (Object)acceptqty);
        this.getModel().setValue("entrysrcsplitbillnumber", (Object)srcsplitbillnumber);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void setSomeControl(DynamicObject entry) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        if (entry == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryauxproperty"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwardept"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entrywarehouse"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryiscontrolqty"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmax"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmin"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"entryoutputoperation"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"advconbaritemap2"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"entryinwardept"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"entrywarehouse"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"entryiscontrolqty"});
            Object warehouseObj = this.getModel().getValue("entrywarehouse");
            if (null != warehouseObj) {
                DynamicObject warehouse = (DynamicObject)warehouseObj;
                long warehouseId = warehouse.getLong("id");
                boolean isopenlocation = (warehouse = BusinessDataServiceHelper.loadSingleFromCache((Object)warehouseId, (String)"bd_warehouse", (String)"isopenlocation")).getBoolean("isopenlocation");
                if (isopenlocation) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"entrylocation"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
                }
            }
            if (entry.getBoolean("iscontrolqty")) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"entryrcvinhighlimit", "entryrcvinlowlimit"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmax", "entryinwarmin", "entryrcvinhighlimit", "entryrcvinlowlimit"});
            }
            DynamicObject material = (DynamicObject)entry.get("material");
            if (material != null) {
                DynamicObject mftmaterial = BusinessDataServiceHelper.loadSingle((Object)material.getPkValue(), (String)"bd_materialmftinfo");
                material = (DynamicObject)mftmaterial.get(MASTERID);
                material = BusinessDataServiceHelper.loadSingle((Object)material.getPkValue(), (String)"bd_material");
                this.setAuxpropLock(material);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"entryauxproperty"});
            }
            String producttype = entry.getString("producttype");
            if ("C".equals(producttype)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"entryoutputoperation"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"advconbaritemap2"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"entryoutputoperation"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"advconbaritemap2"});
            }
        }
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void lockSomeControls() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryauxproperty"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwardept"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrywarehouse"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryiscontrolqty"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmax"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryinwarmin"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryoutputoperation"});
    }

    private void setECNVersionByExpandDate(int rowIndex, DynamicObject pkmaterial, DynamicObject manuversion) {
        IDataModel model = this.getModel();
        DynamicObject transactype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"transactiontype");
        if (null == transactype || "D".equalsIgnoreCase(transactype.getString("stockmaterials")) || !"A".equals(transactype.getString("stockmaterials"))) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            model.setValue("bomid", null, rowIndex);
            IDataEntityProperty programme = model.getProperty("programme");
            if (programme != null) {
                model.setValue("programme", null, rowIndex);
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
            return;
        }
        Date expendbomtime = (Date)model.getValue("expendbomtime", rowIndex);
        if (expendbomtime == null) {
            expendbomtime = new Date();
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        Set<Long> bomTypeIDSet = this.getBomTypeIDSet();
        String selectProperties = "number,enable,id,ecn,type,version,yieldrate";
        String orderByStr = "";
        DynamicObject bom = MsBomQueryHelper.getBomFromCache((DynamicObject)pkmaterial, (Long)org.getLong("id"), (DynamicObject)manuversion, bomTypeIDSet, (Date)expendbomtime, (String)selectProperties, (String)orderByStr);
        if (bom != null) {
            model.setValue("bomid", bom.getPkValue(), rowIndex);
        } else {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            model.setValue("bomid", null, rowIndex);
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    private void setDefaultTrans() {
        String entityId;
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        if (dept == null) {
            return;
        }
        QFilter qFilter = new QFilter("isfault", "=", (Object)"1");
        qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)dept.getLong("id")));
        qFilter.and(new QFilter("isfault", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        switch (entityId = this.getView().getEntityId()) {
            case "pom_mftorder": {
                qFilter.and(new QFilter("transactiontype", "=", (Object)Long.valueOf("738166303168232448")));
                break;
            }
            case "om_mftorder": {
                qFilter.and(new QFilter("transactiontype", "=", (Object)Long.valueOf("1213802446967548928")));
                break;
            }
            case "pom_mroorder": {
                qFilter.and(new QFilter("transactiontype.domain", "=", (Object)"7"));
                break;
            }
            case "prop_mftorder": {
                qFilter.and(new QFilter("transactiontype.domain", "=", (Object)"9"));
                break;
            }
        }
        Map load = BusinessDataServiceHelper.loadFromCache((String)"mpdm_transactproduct", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        if (null != load) {
            DynamicObject trans = null;
            for (Map.Entry entry : load.entrySet()) {
                trans = (DynamicObject)entry.getValue();
                if (null == trans) continue;
                this.getModel().setItemValueByNumber("transactiontype", trans.getString("number"));
                break;
            }
        }
    }

    private void setAuxpropLock(DynamicObject material) {
        if (material != null) {
            boolean isuseauxpty = material.getBoolean("isuseauxpty");
            if (isuseauxpty) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"entryauxproperty"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"entryauxproperty"});
            }
        }
    }

    private void setMaterialF7Filter(BeforeF7SelectEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
        if (transactiontype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u201d\u3002", (String)"MftOrderEditTpl_23", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        int currentrow = evt.getRow();
        String producttype = (String)this.getModel().getValue("producttype", currentrow);
        QFilter qFilter1 = null;
        qFilter1 = ManuBillProductTypeEnum.MAIN.getValue().equals(producttype) ? new QFilter("ismainproduct", "=", (Object)"1") : new QFilter("isjointproduct", "=", (Object)"1");
        QFilter qfilter2 = null;
        if (!"1".equals(transactiontype.get("shutdowncontrol").toString())) {
            if ("2".equals(transactiontype.get("shutdowncontrol").toString())) {
                qfilter2 = new QFilter(SUSPEND, "=", (Object)"1");
            } else if ("3".equals(transactiontype.get("shutdowncontrol").toString())) {
                qfilter2 = new QFilter(SUSPEND, "=", (Object)"0");
            }
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (qfilter2 == null) {
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter1);
        } else {
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter1.and(qfilter2));
        }
    }

    private void setManuversionF7Filter(BeforeF7SelectEvent evt) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        Date expendbomtime = (Date)this.getModel().getValue("expendbomtime", rowIndex);
        QFilter qfilter1 = new QFilter("beginqty", "<=", (Object)qty).and(new QFilter("endqty", ">=", (Object)qty));
        qfilter1.and(new QFilter("begindate", "<=", (Object)expendbomtime).and(new QFilter("enddate", ">=", (Object)expendbomtime)));
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (mftmaterial == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MftOrderEditTpl_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        qfilter1.and(new QFilter("material", "=", mftmaterial.getPkValue()));
        DynamicObject material = (DynamicObject)this.getModel().getValue("materielmasterid", rowIndex);
        boolean isUseAuxpty = material.getBoolean("isuseauxpty");
        DynamicObject config = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex);
        DynamicObject auxPro = (DynamicObject)this.getModel().getValue("auxproperty");
        HashSet<String> bomTypeSet = new HashSet<String>(2);
        bomTypeSet.add("B");
        bomTypeSet.add("C");
        if (config != null && auxPro == null) {
            qfilter1.and(new QFilter("bom.type.purpose", "in", bomTypeSet));
        } else if (config == null && auxPro != null && isUseAuxpty) {
            QFilter qFilter = this.setAuxProFilter(rowIndex, qfilter1, mftmaterial, material, auxPro);
        } else if (config != null && auxPro != null && isUseAuxpty) {
            qfilter1.and(new QFilter("bom.type.purpose", "in", bomTypeSet));
            qfilter1 = this.setAuxProFilter(rowIndex, qfilter1, mftmaterial, material, auxPro);
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setMultiSelect(false);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter1);
    }

    private QFilter setAuxProFilter(int rowIndex, QFilter qfilter1, DynamicObject mftmaterial, DynamicObject material, DynamicObject auxPro) {
        boolean isBompauxattmust;
        HashSet<Object> auxProIds = new HashSet<Object>(16);
        DynamicObjectCollection auxptyEntrys = material.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject auxptyEntry : auxptyEntrys) {
            auxProIds.add(auxptyEntry.getDynamicObject("auxpty").getPkValue());
        }
        HashMap<Object, Object> auxProIdMap = new HashMap<Object, Object>(16);
        QFilter qFilter = new QFilter("id", "in", auxProIds);
        DataSet auxProperty = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_auxproperty", (String)"id,flexfield", (QFilter[])new QFilter[]{qFilter}, null);
        for (Row row : auxProperty) {
            auxProIdMap.put(row.get("id"), row.get("flexfield"));
        }
        Object auxProPkValue = auxPro.getPkValue();
        HashMap<Long, Map> flexValues = new HashMap<Long, Map>(16);
        DynamicObject rsDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)auxProPkValue, (String)"bd_flexauxprop");
        if (rsDyn != null) {
            long id = rsDyn.getLong("id");
            String json = rsDyn.getString("value");
            Map values = (Map)JSON.parseObject((String)json, Map.class);
            flexValues.put(id, values);
        }
        Map bomAuxProvalues = new HashMap(16);
        HashMap<DataSet, Object> auxProFlexAndId = new HashMap<DataSet, Object>(16);
        DynamicObject bomDyn = (DynamicObject)this.getModel().getValue("bomid", rowIndex);
        if (bomDyn != null) {
            DynamicObject auxproDyn;
            Object materialid = bomDyn.getDynamicObject("materialid").getPkValue();
            Iterator bomAuxProperty = bomDyn.getDynamicObject("auxproperty");
            if (bomAuxProperty != null && (auxproDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)bomAuxProperty.getPkValue(), (String)"bd_flexauxprop")) != null) {
                String json = auxproDyn.getString("value");
                bomAuxProvalues = (Map)JSON.parseObject((String)json, Map.class);
                auxProFlexAndId.put(auxProperty, auxproDyn.getPkValue());
            }
        }
        ArrayList<String> auxptyKeys = new ArrayList<String>(16);
        for (Object auxptyEntry : auxptyEntrys) {
            boolean isaffectplan = auxptyEntry.getBoolean("isaffectplan");
            if (!isaffectplan) continue;
            String flexfield = (String)auxProIdMap.get(auxptyEntry.getDynamicObject("auxpty").getPkValue());
            auxptyKeys.add(flexfield);
        }
        boolean isAffectPlan = false;
        for (String auxptyKey : auxptyKeys) {
            if (flexValues == null || flexValues.size() == 0) continue;
            Map flexBizValues = (Map)flexValues.get(auxProPkValue);
            Object bomAuxProvalue = bomAuxProvalues.get(auxptyKey);
            Object flexBizValue = flexBizValues.get(auxptyKey);
            if (bomAuxProvalue == null || !bomAuxProvalue.equals(flexBizValue)) {
                isAffectPlan = false;
                break;
            }
            isAffectPlan = true;
        }
        if ((isBompauxattmust = mftmaterial.getBoolean("isbompauxattmust")) && isAffectPlan) {
            qfilter1.and(new QFilter("bom.auxproperty", "=", auxProFlexAndId.get(auxProperty)));
        }
        return qfilter1;
    }

    private void setBOMF7Filter(BeforeF7SelectEvent evt) {
        DynamicObject configuredcode;
        DynamicObjectCollection bomtypes;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (mftmaterial == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MftOrderEditTpl_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qfilter = new QFilter("materialid", "=", mftmaterial.getDynamicObject(MASTERID).getPkValue());
        DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
        if (transactiontype != null && CollectionUtils.isNotEmpty((Collection)(bomtypes = transactiontype.getDynamicObjectCollection("bomtypes")))) {
            ArrayList<Object> pkValues = new ArrayList<Object>();
            for (DynamicObject dyn : bomtypes) {
                pkValues.add(dyn.get("fbasedataid_id"));
            }
            qfilter.and(new QFilter("type", "in", pkValues));
        }
        if (null != (configuredcode = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex))) {
            QFilter qfilterConfig = new QFilter("configuredcode", "=", configuredcode.getPkValue());
            qfilterConfig.or(new QFilter("type.purpose", "=", (Object)"B"));
            qfilter.and(qfilterConfig);
        }
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        Map boms = BusinessDataServiceHelper.loadFromCache((String)"pdm_mftbom", (String)"id,type,type.isversion,version", (QFilter[])new QFilter[]{qfilter});
        DynamicObject bdmaterial = mftmaterial.getDynamicObject(MASTERID);
        boolean isenablematerialversion = false;
        if (bdmaterial != null) {
            bdmaterial = MaterialQueryHelper.getDataCacheByID((Object)bdmaterial.getPkValue());
            isenablematerialversion = bdmaterial.getBoolean("isenablematerialversion");
        }
        ArrayList<Long> pkValues = new ArrayList<Long>();
        for (Map.Entry entry : boms.entrySet()) {
            DynamicObject bom = (DynamicObject)entry.getValue();
            if (null == bom || null == bom.getDynamicObject("type")) continue;
            if (isenablematerialversion || bom.getDynamicObject("type").getBoolean("isversion")) {
                Object exptendtimeObj = this.getModel().getValue("expendbomtime", rowIndex);
                if (null == exptendtimeObj) continue;
                Date expendbomtime = (Date)exptendtimeObj;
                if (bom.getDynamicObject("version") == null) continue;
                DynamicObject bomVersion = BomVersionQueryHelper.getDataCacheByID((Object)bom.getDynamicObject("version").getPkValue());
                Date effectDate = bomVersion.getDate("effectdate");
                Date invalidDate = bomVersion.getDate("invaliddate");
                if (null == effectDate || null == invalidDate || !expendbomtime.before(invalidDate) || !expendbomtime.after(effectDate)) continue;
                pkValues.add(bom.getLong("id"));
                continue;
            }
            pkValues.add(bom.getLong("id"));
        }
        QFilter qfilter2 = new QFilter("id", "in", pkValues);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter2);
    }

    private void propChangeUnit(ChangeData cd) {
        Object newValue = cd.getNewValue();
        this.getModel().setValue("entryunit", newValue);
        int rowIndex = cd.getRowIndex();
        if (newValue != null) {
            DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
            DynamicObject bdmaterial = (DynamicObject)mftmaterial.get(MASTERID);
            bdmaterial = MaterialQueryHelper.getDataCacheByID((Object)bdmaterial.getPkValue());
            DynamicObject baseunitDO = bdmaterial.getDynamicObject("baseunit");
            DynamicObject auxunitDO = bdmaterial.getDynamicObject("auxptyunit");
            Long desmuid = baseunitDO == null ? 0L : baseunitDO.getLong("id");
            Long auxmuid = auxunitDO == null ? 0L : auxunitDO.getLong("id");
            this.getModel().setItemValueByID("baseunit", (Object)desmuid, rowIndex);
            this.getModel().setItemValueByID("entrybaseunit", (Object)desmuid);
            this.getModel().setItemValueByID("auxptyunit", (Object)auxmuid, rowIndex);
            this.getModel().setItemValueByID("entryauxptyunit", (Object)auxmuid);
        } else {
            this.getModel().setItemValueByID("baseunit", (Object)0, rowIndex);
            this.getModel().setItemValueByID("entrybaseunit", (Object)0);
            this.getModel().setItemValueByID("auxptyunit", (Object)0, rowIndex);
            this.getModel().setItemValueByID("entryauxptyunit", (Object)0);
        }
    }

    private void propChangeQty(ChangeData cd) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        int rowIndex = cd.getRowIndex();
        this.calHighQty(rowIndex);
        this.calLowQty(rowIndex);
        Object baseqty = this.getModel().getValue("baseqty", rowIndex);
        this.getModel().setValue("entrybaseqty", baseqty);
        Object auxqty = this.getModel().getValue("auxptyqty", rowIndex);
        this.getModel().setValue("entryauxptyqty", auxqty);
        this.setYieldrateQty(rowIndex, DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"qty", (int)rowIndex), DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"yieldrate", (int)rowIndex));
        Object materielmaster = this.getModel().getValue("materielmasterid", rowIndex);
        Long materialId = MftOrderEditTpl.getDyObjId(materielmaster);
        if (materialId != null) {
            String leadTimeType;
            QFilter qFilter = new QFilter(MASTERID, "=", (Object)materialId);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            DynamicObject materialPlan = BusinessDataServiceHelper.loadSingle((String)"mpdm_materialplan", (String)"id,leadtimetype", (QFilter[])new QFilter[]{qFilter});
            if (materialPlan != null && "B".equals(leadTimeType = materialPlan.getString("leadtimetype"))) {
                this.calPlanEndTime(rowIndex);
            }
        }
        this.autoChangeCoproduct(rowIndex, "qty");
        this.changeQtyOrUnit("qty", cd.getNewValue(), rowIndex);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void propChangeBaseQty(ChangeData cd) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        int rowIndex = cd.getRowIndex();
        Object baseunit = this.getModel().getValue("baseunit", rowIndex);
        if (baseunit == null) {
            return;
        }
        this.calHighQty(rowIndex);
        this.calLowQty(rowIndex);
        Object baseqty = this.getModel().getValue("baseqty", rowIndex);
        this.getModel().setValue("entrybaseqty", baseqty);
        Object auxqty = this.getModel().getValue("auxptyqty", rowIndex);
        this.getModel().setValue("entryauxptyqty", auxqty);
        this.autoChangeCoproduct(rowIndex, "baseqty");
        this.changeQtyOrUnit("baseqty", cd.getNewValue(), rowIndex);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void propChangeAuxptQty(ChangeData cd) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        int rowIndex = cd.getRowIndex();
        this.changeQtyOrUnit("auxptyqty", cd.getNewValue(), rowIndex);
        Object baseqty = this.getModel().getValue("baseqty", rowIndex);
        this.getModel().setValue("entrybaseqty", baseqty);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void propChangeBOM(ChangeData cd) {
        String typename = this.getModel().getDataEntityType().getName();
        if ("pom_mroorder".equals(typename)) {
            return;
        }
        int rowIndex = cd.getRowIndex();
        Object newValue = cd.getNewValue();
        DynamicObject bom = (DynamicObject)newValue;
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (bom == null) {
            if (mftmaterial == null || !this.checkBOMMustInput(rowIndex)) {
                this.getModel().setValue("auxproperty", null, rowIndex);
                this.getModel().setValue("entryauxproperty", null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"entryauxproperty"});
            }
            this.setBomVersion(rowIndex);
        }
        this.setYieldrateAll(rowIndex);
        this.autoCreateEntryByBOM(rowIndex);
    }

    private void calPlanEndTime(int rowindex) {
        Object org = this.getModel().getValue("org");
        Long orgId = MftOrderEditTpl.getDyObjId(org);
        DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("material", rowindex);
        if (mftmaterial == null) {
            return;
        }
        Date value = (Date)this.getModel().getValue("planbegintime", rowindex);
        Date begindate = value == null ? new Date() : value;
        Date planEndDate = null;
        DynamicObject planInfo = this.getMaterialPlanInfo(rowindex);
        if (planInfo != null) {
            String leadtimetype = planInfo.getString("leadtimetype");
            int fixedleadtime = planInfo.getInt("fixedleadtime");
            int changeleadtime = planInfo.getInt("changeleadtime");
            int changebatch = planInfo.getInt("changebatch");
            if ("A".equals(leadtimetype)) {
                Date endDate;
                planEndDate = endDate = MftOrderEditTpl.getToWorkDateToDate(fixedleadtime, begindate, orgId);
            } else if ("B".equals(leadtimetype)) {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowindex);
                BigDecimal decChangebatch = new BigDecimal(changebatch);
                BigDecimal decChangeleadtime = new BigDecimal(changeleadtime);
                if (changebatch != 0) {
                    Date endDate;
                    BigDecimal preTime = qty.multiply(decChangeleadtime).divide(decChangebatch, 0, 0);
                    int preDays = preTime.setScale(0, 0).intValue();
                    planEndDate = endDate = MftOrderEditTpl.getToWorkDateToDate(preDays, begindate, orgId);
                }
            }
        } else {
            planEndDate = begindate;
        }
        if (planEndDate != null) {
            this.getModel().setValue("planendtime", (Object)planEndDate, rowindex);
        }
    }

    public static Date getToWorkDateToDate(int toDays, Date startDate, Long orgId) {
        return CalendarUtils.getToWorkDateToDate((int)toDays, (Date)startDate, (Long)orgId);
    }

    public static Long getDyObjId(Object dyObj) {
        if (dyObj == null) {
            return null;
        }
        if (dyObj instanceof DynamicObject) {
            return ((DynamicObject)dyObj).getLong("id");
        }
        if (dyObj instanceof Long) {
            return (Long)dyObj;
        }
        return null;
    }

    private void checkPlanDate(BeforeDoOperationEventArgs e) {
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        HashMap<Integer, Date> mapStart = new HashMap<Integer, Date>();
        HashMap<Integer, Date> mapEnd = new HashMap<Integer, Date>();
        ArrayList<Integer> startlist = new ArrayList<Integer>();
        ArrayList<Integer> startDateNulllist = new ArrayList<Integer>();
        ArrayList<Integer> endlist = new ArrayList<Integer>();
        ArrayList<Integer> endDateNulllist = new ArrayList<Integer>();
        boolean isShowMessage = false;
        HashMap calendarInfoMap = new HashMap(16);
        for (int i = 0; i < this.getModel().getEntryRowCount("treeentryentity"); ++i) {
            Date planBeginTime = (Date)this.getModel().getValue("planbegintime", i);
            Date planEndTime = (Date)this.getModel().getValue("planendtime", i);
            if (planBeginTime == null || planEndTime == null) continue;
            Date workDate = CalendarUtils.getRecentleWorkDateNew((DynamicObject)dept, (Date)planBeginTime, calendarInfoMap);
            if (null == workDate) {
                startDateNulllist.add(i + 1);
                mapStart.put(i, workDate);
                isShowMessage = true;
            } else if (!CalendarUtils.compateDateAccurateDay((Date)planBeginTime, (Date)workDate)) {
                startlist.add(i + 1);
                mapStart.put(i, workDate);
                isShowMessage = true;
            }
            workDate = CalendarUtils.getRecentleWorkDateNew((DynamicObject)dept, (Date)planEndTime, calendarInfoMap);
            if (null == workDate) {
                endDateNulllist.add(i + 1);
                mapEnd.put(i, workDate);
                isShowMessage = true;
                continue;
            }
            if (CalendarUtils.compateDateAccurateDay((Date)planEndTime, (Date)workDate)) continue;
            endlist.add(i + 1);
            mapEnd.put(i, workDate);
            isShowMessage = true;
        }
        if (isShowMessage) {
            StringJoiner stringJoiner;
            StringBuilder errMsg = new StringBuilder();
            if (startlist.size() > 0) {
                stringJoiner = new StringJoiner("\u3001");
                startlist.forEach(t -> stringJoiner.add(String.valueOf(t)));
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4\u4e0d\u5728\u5de5\u4f5c\u65e5\u3002", (String)"MftOrderEditTpl_62", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                errMsg.append("\n");
            }
            if (endlist.size() > 0) {
                stringJoiner = new StringJoiner("\u3001");
                endlist.forEach(t -> stringJoiner.add(String.valueOf(t)));
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u8ba1\u5212\u5b8c\u5de5\u65f6\u95f4\u4e0d\u5728\u5de5\u4f5c\u65e5\u3002", (String)"MftOrderEditTpl_63", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                errMsg.append("\n");
            }
            if (startDateNulllist.size() > 0) {
                stringJoiner = new StringJoiner("\u3001");
                startDateNulllist.forEach(t -> stringJoiner.add(String.valueOf(t)));
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u672a\u627e\u5230\u751f\u4ea7\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u751f\u4ea7\u65e5\u5386\u6216\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4\u4e0d\u5728\u65e5\u5386\u8bbe\u7f6e\u4e2d\u65e5\u5386\u7684\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"MftOrderEditTpl_64", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                errMsg.append("\n");
            }
            if (endDateNulllist.size() > 0) {
                stringJoiner = new StringJoiner("\u3001");
                endDateNulllist.forEach(t -> stringJoiner.add(String.valueOf(t)));
                errMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u672a\u627e\u5230\u751f\u4ea7\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u751f\u4ea7\u65e5\u5386\u6216\u8ba1\u5212\u5b8c\u5de5\u65f6\u95f4\u4e0d\u5728\u65e5\u5386\u8bbe\u7f6e\u4e2d\u65e5\u5386\u7684\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"MftOrderEditTpl_65", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                errMsg.append("\n");
            }
            errMsg.append(ResManager.loadKDString((String)"\u662f\u5426\u6309\u5f53\u524d\u65e5\u671f\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"MftOrderEditTpl_17", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getPageCache().put("mapStart", JSON.toJSONString(mapStart));
            this.getPageCache().put("mapEnd", JSON.toJSONString(mapEnd));
            FormOperate source = (FormOperate)e.getSource();
            RefObject afterConfirm = new RefObject();
            if (!source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("checkPlanDate", (IFormPlugin)this);
                this.getView().showConfirm(errMsg.toString(), MessageBoxOptions.YesNo, listener);
                e.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("checkPlanDate".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            Map mapStart = (Map)JSON.parse((String)this.getPageCache().get("mapStart"));
            Map mapEnd = (Map)JSON.parse((String)this.getPageCache().get("mapEnd"));
            ArrayList<Integer> entrySeqList = new ArrayList<Integer>(10);
            for (Map.Entry start : mapStart.entrySet()) {
                int intValue = Integer.parseInt((String)start.getKey());
                entrySeqList.add(intValue);
            }
            if (CollectionUtils.isNotEmpty(entrySeqList)) {
                this.getView().getPageCache().put("planbegintimeentrySeqList", Joiner.on((String)",").join(entrySeqList));
            }
            if (MessageBoxResult.No.equals((Object)result)) {
                int intValue;
                for (Map.Entry start : mapStart.entrySet()) {
                    Date startDate = new Date((Long)start.getValue());
                    intValue = Integer.parseInt((String)start.getKey());
                    this.getModel().setValue("planbegintime", (Object)startDate, intValue);
                }
                for (Map.Entry end : mapEnd.entrySet()) {
                    Date endDate = new Date((Long)end.getValue());
                    intValue = Integer.parseInt((String)end.getKey());
                    this.getModel().setValue("planendtime", (Object)endDate, intValue);
                }
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    private DynamicObject getMaterialPlanInfo(int rowindex) {
        DynamicObject mftorg;
        DynamicObject bdmaterial;
        DynamicObject planInfo;
        DynamicObject mftMaterial = (DynamicObject)this.getModel().getValue("material");
        if (mftMaterial != null && (planInfo = MaterialPlanQueryHelper.getDataCacheByMaterial((DynamicObject)(bdmaterial = mftMaterial.getDynamicObject(MASTERID)), (DynamicObject)(mftorg = (DynamicObject)this.getModel().getValue("org")))) != null) {
            return planInfo;
        }
        return null;
    }

    private boolean checkBOMMustInput(int rowIndex) {
        String productType;
        boolean bomMust = false;
        DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
        if (transactiontype != null && "C".equals(productType = (String)this.getModel().getValue("producttype", rowIndex))) {
            String stockmaterials;
            long transId = (Long)transactiontype.getPkValue();
            if (!transactiontype.containsProperty("stockmaterials")) {
                transactiontype = TransactionTypeQueryHelper.getDataCacheByID((Object)transId);
            }
            if ("A".equals(stockmaterials = transactiontype.getString("stockmaterials"))) {
                bomMust = true;
            }
        }
        return bomMust;
    }

    private void autoCreateEntryByBOM(int rowIndex) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.autoChangeCoproduct(rowIndex, "deleteentry");
        String productType = this.getModel().getValue("producttype", rowIndex).toString();
        if (!StringUtils.equals((CharSequence)"C", (CharSequence)productType)) {
            return;
        }
        DynamicObject bom = (DynamicObject)this.getModel().getValue("bomid", rowIndex);
        this.setBomVersion(rowIndex);
        DynamicObject mftOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject transactionType = (DynamicObject)this.getModel().getValue("transactiontype");
        String stockMaterials = transactionType.getString("stockmaterials");
        if (bom != null && bom.getBoolean("iscoproduct") && "A".equals(stockMaterials)) {
            BigDecimal mainBaseQty = (BigDecimal)this.getModel().getValue("baseqty", rowIndex);
            DynamicObjectCollection bomentry = bom.getDynamicObjectCollection("copentry");
            for (DynamicObject coproduct : bomentry) {
                DynamicObject dymftmaterial = (DynamicObject)coproduct.get("copentrymaterial");
                DynamicObject mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)dymftmaterial.getPkValue());
                if (!mftmaterial.getBoolean("isjointproduct")) continue;
                Date expendbomtime = (Date)this.getModel().getValue("expendbomtime", rowIndex);
                if (null == expendbomtime) {
                    expendbomtime = new Date();
                }
                Date copentryvaliddate = coproduct.getDate("copentryvaliddate");
                Date copentryinvaliddate = coproduct.getDate("copentryinvaliddate");
                if (expendbomtime.before(copentryvaliddate) || expendbomtime.after(copentryinvaliddate)) continue;
                int insertRowIndex = this.getModel().insertEntryRow("treeentryentity", rowIndex);
                this.getModel().setValue("producttype", (Object)("10720".equals(coproduct.getString("copentrytype")) ? "A" : "B"), insertRowIndex);
                this.getModel().setValue("material", coproduct.get("copentrymaterial"), insertRowIndex);
                this.getPageCache().put("isIgnoreChangeListenerPlan", "true");
                this.getModel().setValue("supplyrule", this.getModel().getValue("supplyrule", rowIndex), insertRowIndex);
                this.getPageCache().put("isIgnoreChangeListenerPlan", "false");
                DynamicObject material = (DynamicObject)mftmaterial.get(MASTERID);
                this.getModel().setValue("materielmasterid", (Object)material, insertRowIndex);
                material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
                this.setAuxpropLock(material);
                DynamicObject unitDO = mftmaterial.getDynamicObject("mftunit");
                this.getModel().setValue("unit", (Object)unitDO, insertRowIndex);
                DynamicObject baseunitDO = material.getDynamicObject("baseunit");
                DynamicObject auxunitDO = material.getDynamicObject("auxptyunit");
                int precision = baseunitDO.getInt("precision");
                String precisionAccount = baseunitDO.getString("precisionaccount");
                BigDecimal baseQty = coproduct.getBigDecimal("copentryqty").multiply(mainBaseQty).setScale(precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
                BigDecimal qty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunitDO, (BigDecimal)baseQty, (DynamicObject)unitDO);
                this.getModel().setValue("baseunit", (Object)baseunitDO, insertRowIndex);
                this.getModel().setValue("auxptyunit", (Object)auxunitDO, insertRowIndex);
                this.getModel().setValue("producedept", this.getModel().getValue("producedept", rowIndex), insertRowIndex);
                this.getModel().setValue("tracknumber", this.getModel().getValue("tracknumber", rowIndex), insertRowIndex);
                this.getModel().setValue("qty", (Object)qty, insertRowIndex);
                this.getModel().setValue("planqty", (Object)qty, insertRowIndex);
                this.getModel().setValue("planbegintime", this.getModel().getValue("planbegintime", rowIndex), insertRowIndex);
                this.getModel().setValue("planendtime", this.getModel().getValue("planendtime", rowIndex), insertRowIndex);
                this.getModel().setValue("expendbomtime", this.getModel().getValue("expendbomtime", rowIndex), insertRowIndex);
                this.getModel().setValue("inwardept", this.getModel().getValue("inwardept", rowIndex), insertRowIndex);
                DomainIgnoreValSeUtil.setValue((IDataModel)this.getModel(), (String)"processroute", (Object)this.getModel().getValue("processroute", rowIndex), (int)insertRowIndex, (String[])new String[]{DomainEnum.PROP.getName()});
                this.getModel().setValue("routereplace", this.getModel().getValue("routereplace", rowIndex), insertRowIndex);
                this.getModel().setValue("outputoperation", coproduct.get("copentryoperation"), insertRowIndex);
                this.getModel().setItemValueByNumber("bomid", bom.getString("number"), insertRowIndex);
                this.setBomVersion(insertRowIndex);
                this.setYieldrateAll(insertRowIndex);
                this.setMaterialInvInfo(insertRowIndex);
                this.getView().setEnable(Boolean.FALSE, insertRowIndex, new String[]{"bomid"});
                String entitytype = this.getModel().getDataEntityType().getName();
                if ("pom_xmftorder".equals(entitytype)) {
                    this.getView().setEnable(Boolean.FALSE, insertRowIndex, new String[]{"srcbillno"});
                }
                DynamicObject entryentity = this.getModel().getEntryRowEntity("treeentryentity", insertRowIndex);
                this.fillEntryQualityorg(entryentity, mftOrg, insertRowIndex);
                if (null == entryentity) continue;
                AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)entryentity, (DynamicObject)material, (DynamicObject)auxunitDO, (String)"baseqty", (String)"baseunit", (String)"auxptyqty");
                this.getView().updateView("auxptyqty", insertRowIndex);
            }
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
            treeEntryGrid.expand(rowIndex);
        }
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void setBomVersion(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject bom = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"bomid", (int)rowIndex);
        DataEntityPropertyCollection properties = model.getEntryEntity("treeentryentity").getDynamicObjectType().getProperties();
        boolean hasVersionId = properties.stream().anyMatch(x -> "versionid".equals(x.getName()));
        if (hasVersionId) {
            model.setValue("versionid", null == bom ? null : bom.get("version"), rowIndex);
        }
    }

    private void autoChangeCoproduct(int rowIndex, String changekey) {
        long rowid = (Long)this.getModel().getValue("treeentryentity.id", rowIndex);
        int rowCount = this.getModel().getEntryRowCount("treeentryentity");
        Map<String, Map> mMap = this.initBatchQueryMap(this.getModel().getEntryEntity("treeentryentity"));
        Map mftMap = mMap == null ? null : mMap.get("mftMap");
        Map materialMap = mMap == null ? null : mMap.get("materialMap");
        block34: for (int i = rowCount - 1; i >= 0; --i) {
            long pid;
            String producttype = (String)this.getModel().getValue("producttype", i);
            if ("C".equals(producttype)) continue;
            long l = pid = null == this.getModel().getValue("pid", i) ? 0L : (Long)this.getModel().getValue("pid", i);
            if (rowid != pid) continue;
            switch (changekey) {
                case "deleteentry": {
                    this.getModel().deleteEntryRow("treeentryentity", i);
                    continue block34;
                }
                case "qty": {
                    String entityType;
                    BigDecimal mainBaseQty = (BigDecimal)this.getModel().getValue("baseqty", rowIndex);
                    DynamicObject bom = (DynamicObject)this.getModel().getValue("bomid", rowIndex);
                    DynamicObject copmaterial = (DynamicObject)this.getModel().getValue("material", i);
                    if (copmaterial == null || bom == null) continue block34;
                    QFilter qFilter = new QFilter("id", "=", (Object)bom.getLong("id"));
                    qFilter.and(new QFilter("copentry.copentrymaterial", "=", copmaterial.getPkValue()));
                    DynamicObjectCollection coproduct = QueryServiceHelper.query((String)"pdm_mftbom", (String)"copentry.copentryqty", (QFilter[])new QFilter[]{qFilter});
                    if (coproduct == null || coproduct.isEmpty()) continue block34;
                    DynamicObject entryentity = this.getModel().getEntryRowEntity("treeentryentity", i);
                    DynamicObject mftmaterial = entryentity.getDynamicObject("material");
                    DynamicObject material = mftmaterial.getDynamicObject(MASTERID);
                    DynamicObject baseunitDO = entryentity.getDynamicObject("baseunit");
                    DynamicObject unitDO = entryentity.getDynamicObject("unit");
                    int precision = baseunitDO.getInt("precision");
                    String precisionAccount = baseunitDO.getString("precisionaccount");
                    mainBaseQty = ((DynamicObject)coproduct.get(0)).getBigDecimal("copentry.copentryqty").multiply(mainBaseQty).setScale(precision, PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(precisionAccount)));
                    this.getModel().setValue("baseqty", (Object)mainBaseQty, i);
                    BigDecimal mainQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunitDO, (BigDecimal)mainBaseQty, (DynamicObject)unitDO);
                    this.getModel().setValue("qty", (Object)mainQty, i);
                    if (null != entryentity) {
                        AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)entryentity, (DynamicObject)(null == entryentity.getDynamicObject("material") ? null : entryentity.getDynamicObject("material").getDynamicObject(MASTERID)), (DynamicObject)entryentity.getDynamicObject("auxptyunit"), (String)"baseqty", (String)"baseunit", (String)"auxptyqty");
                        this.getView().updateView("auxptyqty", i);
                    }
                    if (!StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)(entityType = this.getModel().getDataEntityType().getName())) && !StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)entityType) && (!StringUtils.equals((CharSequence)"pom_xmftorder", (CharSequence)entityType) || !StringUtils.equals((CharSequence)"A", (CharSequence)this.getModel().getValue("changetype", rowIndex).toString())) && (!StringUtils.equals((CharSequence)"om_xmftorder", (CharSequence)entityType) || !StringUtils.equals((CharSequence)"A", (CharSequence)this.getModel().getValue("changetype", rowIndex).toString()))) continue block34;
                    this.getModel().setValue("planqty", (Object)mainQty, i);
                    continue block34;
                }
                case "planbegintime": {
                    Object begintime = this.getModel().getValue("planbegintime", rowIndex);
                    this.getModel().setValue("planbegintime", begintime, i);
                    continue block34;
                }
                case "planendtime": {
                    Object endtime = this.getModel().getValue("planbegintime", rowIndex);
                    this.getModel().setValue("planbegintime", endtime, i);
                    continue block34;
                }
                case "expendbomtime": {
                    Object expandbomtime = this.getModel().getValue("expendbomtime", rowIndex);
                    this.getModel().setValue("expendbomtime", expandbomtime, i);
                    continue block34;
                }
                case "processroute": {
                    Object process = this.getModel().getValue("processroute", rowIndex);
                    DomainIgnoreValSeUtil.setValue((IDataModel)this.getModel(), (String)"processroute", (Object)process, (int)i, (String[])new String[]{DomainEnum.PROP.getName()});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"processroute"});
                    continue block34;
                }
                case "routereplace": {
                    Object routereplace = this.getModel().getValue("routereplace", rowIndex);
                    this.getModel().setValue("routereplace", routereplace, i);
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"routereplace"});
                    continue block34;
                }
                case "producedept": {
                    Object producedetp = this.getModel().getValue("producedept", rowIndex);
                    this.getModel().setValue("producedept", producedetp, i);
                    continue block34;
                }
                case "inwardept": {
                    Object inwardept = this.getModel().getValue("inwardept", rowIndex);
                    this.getModel().setValue("inwardept", inwardept, i);
                    continue block34;
                }
                case "srcbillno": {
                    String entitytype = this.getModel().getDataEntityType().getName();
                    if (!"pom_xmftorder".equals(entitytype) && !StringUtils.equals((CharSequence)"om_xmftorder", (CharSequence)entitytype)) continue block34;
                    Object srcbillno = this.getModel().getValue("srcbillno", rowIndex);
                    this.getModel().setValue("srcbillno", srcbillno, i);
                    Object srcbillid = this.getModel().getValue("srcbillid", rowIndex);
                    this.getModel().setValue("srcbillid", srcbillid, i);
                    Object planstatus = this.getModel().getValue("planstatus", rowIndex);
                    Object plantime = this.getModel().getValue("plansuretime", rowIndex);
                    this.getModel().setValue("planstatus", planstatus, i);
                    this.getModel().setValue("plansuretime", plantime, i);
                    Object taskstatus = this.getModel().getValue("taskstatus", rowIndex);
                    this.getModel().setValue("taskstatus", taskstatus, i);
                    Object transmittime = this.getModel().getValue("transmittime", rowIndex);
                    this.getModel().setValue("transmittime", transmittime, i);
                    Object startworktime = this.getModel().getValue("startworktime", rowIndex);
                    this.getModel().setValue("startworktime", startworktime, i);
                    continue block34;
                }
                case "workcenter": {
                    Object workcenter = this.getModel().getValue("workcenter", rowIndex);
                    this.getModel().setValue("workcenter", workcenter, i);
                    continue block34;
                }
                case "tracknumber": {
                    Object tracknumber = this.getModel().getValue("tracknumber", rowIndex);
                    this.getModel().setValue("tracknumber", tracknumber, i);
                    continue block34;
                }
                case "bdproject": {
                    Object bdProject = this.getModel().getValue("bdproject", rowIndex);
                    this.getModel().setValue("bdproject", bdProject, i);
                    continue block34;
                }
                case "planscope": {
                    Object planscope = this.getModel().getValue("planscope", rowIndex);
                    this.getModel().setValue("planscope", planscope, i);
                    continue block34;
                }
                case "supplyrule": {
                    Object supplyrule = this.getModel().getValue("supplyrule", rowIndex);
                    this.getModel().setValue("supplyrule", supplyrule, i);
                    continue block34;
                }
            }
        }
    }

    private void lockMaterialAfterSave() {
        int entryRowCount = this.getModel().getEntryRowCount("treeentryentity");
        if (entryRowCount > 0) {
            HashSet<Long> entryidSet = new HashSet<Long>(16);
            for (int i = 0; i < entryRowCount; ++i) {
                String producttype = (String)this.getModel().getValue("producttype");
                if (!ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) continue;
                Object entryPK = this.getModel().getValue("treeentryentity.id", i);
                entryidSet.add((Long)entryPK);
            }
            HashMap<Long, Long> stockMap = new HashMap<Long, Long>(16);
            if (!entryidSet.isEmpty()) {
                QFilter qFilter = new QFilter("orderentryid", "in", entryidSet);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryStockData", (String)"pom_mftstock", (String)"id,orderentryid", (QFilter[])new QFilter[]{qFilter}, (String)"");){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Long id = row.getLong("id");
                        Long orderentryid = row.getLong("orderentryid");
                        stockMap.put(orderentryid, id);
                    }
                }
            }
            for (int i = 0; i < entryRowCount; ++i) {
                String producttype = (String)this.getModel().getValue("producttype");
                if (!ManuBillProductTypeEnum.MAIN.getValue().equals(producttype)) continue;
                Long entryPK = (Long)this.getModel().getValue("treeentryentity.id", i);
                if (stockMap.containsKey(entryPK)) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"material", "producttype"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"material", "producttype"});
            }
        }
    }

    private void clearEntryBOM(DynamicObjectCollection newbomtype) {
        List pkValues = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)newbomtype);
        int entryRowCount = this.getModel().getEntryRowCount("treeentryentity");
        if (entryRowCount > 0) {
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject bom = (DynamicObject)this.getModel().getValue("bomid", i);
                if (null == bom || pkValues.contains(bom.getDynamicObject("type").getPkValue())) continue;
                this.clearEntryField("bomid", i);
            }
        }
    }

    private void clearEntryField(String colName, int rowIndex) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.getModel().setValue(colName, null, rowIndex);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private int getParentRowIndex(int childIndex) {
        long pid = null == this.getModel().getValue("pid", childIndex) ? 0L : (Long)this.getModel().getValue("pid", childIndex);
        int rowCount = this.getModel().getEntryRowCount("treeentryentity");
        for (int i = rowCount - 1; i >= 0; --i) {
            long rowid;
            String producttype = (String)this.getModel().getValue("producttype", i);
            if (!"C".equals(producttype) || (rowid = ((Long)this.getModel().getValue("treeentryentity.id", i)).longValue()) != pid) continue;
            return i;
        }
        return -1;
    }

    private List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        if (this.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    private boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
        return dyOrg.getBoolean("fisaccounting");
    }

    private QFilter getProcessRouteFilter(DynamicObject mftmaterial, DynamicObject org) {
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_route", (Long)((Long)org.getPkValue()));
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)mftmaterial.getPkValue());
        DynamicObject bdmaterial = mftmaterial.getDynamicObject(MASTERID);
        QFilter materialFilter = new QFilter("material.id", "=", bdmaterial.getPkValue());
        DynamicObjectCollection materialgroup = mftmaterial.getDynamicObjectCollection("mftcontrolentry");
        ArrayList<Long> grouplist = new ArrayList<Long>();
        for (DynamicObject group : materialgroup) {
            grouplist.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
        }
        QFilter result = orgqFilter.and(new QFilter("status", "=", (Object)"C"));
        QFilter statusFilter = typeA.and(materialFilter);
        if (grouplist.size() > 0) {
            statusFilter.or(typeB.and(new QFilter("materialgroup", "in", grouplist)));
        }
        statusFilter.or(typeC);
        result.and(statusFilter);
        return result;
    }

    private DynamicObject getProcessRoute(DynamicObject mftmaterial, DynamicObject org) {
        String selectProperties = "id,routeversion.effectdate";
        Map invokeBizService = MsProcessRouteQueryHelper.queryRouteMapFromCache((DynamicObject)mftmaterial, (DynamicObject)org, (String)selectProperties);
        if (invokeBizService != null) {
            Map processrouteMap = invokeBizService;
            OrderCommonService orderCommonService = new OrderCommonService();
            return orderCommonService.filterByorderBy(processrouteMap);
        }
        return null;
    }

    private boolean isHeadField(String fieldname) {
        List<String> headfields = Arrays.asList(HEADFIELDS);
        return headfields.contains(fieldname);
    }

    private void changeQtyOrUnit(String propName, Object newValue, int rowIndex) {
        IDataModel bill;
        Object material;
        if (StringUtils.equals((CharSequence)"unit", (CharSequence)propName)) {
            this.getView().setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty"});
        }
        if (StringUtils.isBlank((Object)(material = (bill = this.getModel()).getValue("material", rowIndex)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7269\u6599\u4fe1\u606f\u201d\u3002", (String)"MftOrderEditTpl_37", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        AuxQtyAndUnitHelper.setAucBizQtyAndUnit((IDataModel)bill, (int)rowIndex, (String)propName, (Object)newValue);
        this.assignPlanQty(this.getView().getModel().getValue("qty", rowIndex), rowIndex);
        this.getView().updateView("qty", rowIndex);
        this.getView().updateView("baseqty", rowIndex);
        this.getView().updateView("auxptyqty", rowIndex);
    }

    private boolean validateOrgPermission(ListShowParameter listShowParameter, List<QFilter> filters, String keyEntity) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object orgPkValue = org.getPkValue();
        Long userId = RequestContext.get().getCurrUserId();
        String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
        String permItemId = "47150e89000000ac";
        long produceOrgId = Long.parseLong(orgPkValue.toString());
        int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)produceOrgId, (String)appId, (String)keyEntity, (String)permItemId);
        return checkPermission == 1;
    }

    private void assignPlanQty(Object newValue, int rowIndex) {
        String entityType = this.getModel().getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)entityType) || StringUtils.equals((CharSequence)"om_mftorder", (CharSequence)entityType) || StringUtils.equals((CharSequence)"pom_xmftorder", (CharSequence)entityType) && StringUtils.equals((CharSequence)"A", (CharSequence)this.getModel().getValue("changetype", rowIndex).toString()) || StringUtils.equals((CharSequence)"om_xmftorder", (CharSequence)entityType) && StringUtils.equals((CharSequence)"A", (CharSequence)this.getModel().getValue("changetype", rowIndex).toString())) {
            this.getModel().setValue("planqty", newValue, rowIndex);
        }
    }

    private void propChangeManuVersion(ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        Object newValue = cd.getNewValue();
        if (newValue != null) {
            DynamicObject processroute;
            String type = (String)this.getModel().getValue("producttype", rowIndex);
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)type)) {
                return;
            }
            DynamicObject manuversion = (DynamicObject)newValue;
            DynamicObject loadSingle = MsManuVersionQueryHelper.getDataCacheByID((Object)manuversion.getPkValue());
            DynamicObject versionBom = (DynamicObject)loadSingle.get("bom");
            DynamicObject versionProcessroute = (DynamicObject)loadSingle.get("processroute");
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (!this.checkManuVersionBOMType(versionBom)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7248\u672c\u4e2dBOM\u7684\u7c7b\u578b\u4e0e\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u4e2dBOM\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MftOrderEditTpl_12", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("manuversion", null);
                if (!this.getView().getEntityId().equals("prop_mftorder")) {
                    this.getModel().setValue("workcenter", null);
                }
                return;
            }
            QFilter routeQfilter = this.getProcessRouteFilter(material, org);
            if (!this.checkManuVersionRoute(versionProcessroute, routeQfilter)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7248\u672c\u4e2d\u7684\u5de5\u827a\u8def\u7ebf\u4e0d\u7b26\u5408\u7269\u6599\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MftOrderEditTpl_13", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("manuversion", null);
                return;
            }
            DynamicObject bom = MsBomQueryHelper.getDataCacheByID((Object)versionBom.getLong("id"));
            if (null != bom) {
                String bomEnable = bom.getString("enable");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)bomEnable)) {
                    this.getModel().setValue("bomid", bom.getPkValue(), rowIndex);
                } else {
                    this.getModel().setValue("bomid", null, rowIndex);
                }
            }
            if (versionProcessroute != null && null != (processroute = MsProcessRouteQueryHelper.getDataCacheByID((Object)versionProcessroute.get("id")))) {
                String processrouteEnable = processroute.getString("enable");
                if (versionProcessroute != null && StringUtils.equals((CharSequence)"1", (CharSequence)processrouteEnable)) {
                    this.getModel().setItemValueByID("processroute", versionProcessroute.getPkValue(), rowIndex);
                } else {
                    DomainIgnoreValSeUtil.setValue((IDataModel)this.getModel(), (String)"processroute", null, (int)rowIndex, (String[])new String[]{DomainEnum.PROP.getName()});
                }
            }
            DynamicObject mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
            this.setECNVersionByExpandDate(rowIndex, mftmaterial.getDynamicObject(MASTERID), loadSingle);
            if (null != bom) {
                this.autoCreateEntryByBOM(rowIndex);
            }
        }
    }

    private void setMaterialInvInfo(int rowIndex) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("inwardept", rowIndex);
        DynamicObject master = (DynamicObject)this.getModel().getValue("materielmasterid", rowIndex);
        DynamicObject materialInvInfo = MaterialInvInfoHelper.getMaterialInvInfo((DynamicObject)org, (DynamicObject)master);
        this.getModel().setValue("materielinv", (Object)materialInvInfo, rowIndex);
    }

    private void fillEntryQualityorg(DynamicObject entryentity, DynamicObject mftOrg, int i) {
        if (null != entryentity && null != mftOrg) {
            DynamicObject qualityorg = entryentity.getDynamicObject("qualityorg");
            long initOrgId = 0L;
            if (null == qualityorg) {
                long mftOrgId = mftOrg.getLong("id");
                initOrgId = OrderQualityOrgService.queryFisqcInitOrgId((long)mftOrgId, (String)"fisqc", (String)"06");
            } else {
                initOrgId = qualityorg.getLong("id");
            }
            this.getModel().setValue("qualityorg", (Object)initOrgId, i);
            boolean isinspection = OrderQualityOrgService.getMaterialQCInfo((DynamicObject)entryentity.getDynamicObject("material"), (long)initOrgId);
            this.getModel().setValue("isinspection", (Object)isinspection, i);
        }
    }

    private void filterQualityOrg(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        DynamicObject mftOrderReportBill = this.getModel().getDataEntity();
        DynamicObject mftOrg = (DynamicObject)mftOrderReportBill.get("org");
        if (null == mftOrg) {
            return;
        }
        Long mftOrgId = mftOrg.getLong(MASTERID);
        List rangeList = OrderQualityOrgService.queryFisqcRangeList((Long)mftOrgId, (String)"fisqc", (String)"06");
        if (null != rangeList && rangeList.size() > 0) {
            QFilter qfilter = new QFilter("id", "in", (Object)rangeList);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void modclosetime() {
        TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = orderEntry.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"MftOrderEditTpl_39", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject mftOrderBill = this.getModel().getDataEntity();
        List rowInfos = MftOrderModTimeUtils.makeFormRowInfos((DynamicObject)mftOrderBill, (int[])selectRows);
        if (rowInfos.size() > 0) {
            String formId = "mpdm_ordermodetime";
            String jsonString = SerializationUtils.toJsonString((Object)rowInfos);
            this.getPageCache().put("billAndSelectRowMapList", jsonString);
            FormShowParameter showParameter = MftOrderModTimeUtils.modTimeShowForm((String)ResManager.loadKDString((String)"\u4fee\u6539\u5173\u95ed\u65f6\u95f4", (String)"MftOrderEditTpl_49", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (IFormPlugin)this, (String)"modCloseTime", (String)formId);
            this.getView().showForm(showParameter);
        }
    }

    private void modtransmittime() {
        TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = orderEntry.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"MftOrderEditTpl_39", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject mftOrderBill = this.getModel().getDataEntity();
        List rowInfos = MftOrderModTimeUtils.makeFormRowInfos((DynamicObject)mftOrderBill, (int[])selectRows);
        if (rowInfos.size() > 0) {
            String formId = "mpdm_ordermodetime";
            String jsonString = SerializationUtils.toJsonString((Object)rowInfos);
            this.getPageCache().put("billAndSelectRowMapList", jsonString);
            FormShowParameter showParameter = MftOrderModTimeUtils.modTimeShowForm((String)ResManager.loadKDString((String)"\u4fee\u6539\u4e0b\u8fbe\u65f6\u95f4", (String)"MftOrderEditTpl_50", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (IFormPlugin)this, (String)"modTransmitTime", (String)formId);
            this.getView().showForm(showParameter);
        }
    }

    private void modBookDate() {
        TreeEntryGrid orderEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = orderEntry.getSelectRows();
        if (selectRows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"MftOrderEditTpl_39", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject mftOrderBill = this.getModel().getDataEntity();
        List rowInfos = MftOrderModTimeUtils.makeFormRowInfos((DynamicObject)mftOrderBill, (int[])selectRows);
        if (rowInfos.size() > 0) {
            String formId = "mpdm_ordermodedate";
            String jsonString = SerializationUtils.toJsonString((Object)rowInfos);
            this.getPageCache().put("billAndSelectRowMapList", jsonString);
            FormShowParameter showParameter = MftOrderModTimeUtils.modTimeShowForm((String)ResManager.loadKDString((String)"\u4fee\u6539\u8bb0\u8d26\u65e5\u671f", (String)"MftOrderEditTpl_56", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (IFormPlugin)this, (String)"modBookDate", (String)formId);
            this.getView().showForm(showParameter);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entityName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"treeentryentity", (CharSequence)entityName)) {
            RowDataEntity[] rowDataEntities;
            DynamicObject producedept;
            DynamicObject transactiontype = (DynamicObject)this.getModel().getValue("transactiontype");
            if (transactiontype != null && (producedept = transactiontype.getDynamicObject("producedept")) != null && this.queryProducedeptBoolean((Long)producedept.getPkValue())) {
                this.getModel().setValue("producedept", (Object)producedept, e.getRowDataEntities()[0].getRowIndex());
            }
            this.getModel().setValue("tracknumber", this.getModel().getValue("tracknumber", e.getParentRow()), e.getRowDataEntities()[0].getRowIndex());
            this.getModel().setValue("bdproject", this.getModel().getValue("bdproject", e.getParentRow()), e.getRowDataEntities()[0].getRowIndex());
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                DynamicObject entryDyObj = rowDataEntity.getDataEntity();
                long pid = entryDyObj.getLong("pid");
                if (pid == 0L) {
                    this.getModel().setValue("producttype", (Object)"C", rowIndex);
                } else {
                    this.getModel().setValue("producttype", (Object)"A", rowIndex);
                }
                this.getView().updateView("producttype", rowIndex);
            }
        }
    }

    private void queryBomAndSet(int rowIndex) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
        DynamicObject mftmaterial = MaterialMftQueryHelper.getDataCacheByID((Object)material.getPkValue());
        DynamicObject pkmaterial = mftmaterial.getDynamicObject(MASTERID);
        DynamicObject manuversion = (DynamicObject)this.getModel().getValue("manuversion", rowIndex);
        Date expendbomtime = (Date)this.getModel().getValue("expendbomtime", rowIndex);
        if (expendbomtime == null) {
            expendbomtime = new Date();
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Set<Long> bomTypeIDSet = this.getBomTypeIDSet();
        DynamicObject auxproprtty = (DynamicObject)this.getModel().getValue("auxproperty", rowIndex);
        String selectProperties = "auxproperty,number,enable,id,ecn,type,version,yieldrate";
        String orderByStr = "";
        DynamicObject bom = MsBomQueryHelper.getBomFromCache((DynamicObject)pkmaterial, (Long)org.getLong("id"), (DynamicObject)manuversion, bomTypeIDSet, (Date)expendbomtime, (String)selectProperties, (String)orderByStr, (DynamicObject)auxproprtty);
        if (bom != null) {
            this.getModel().setValue("bomid", bom.getPkValue(), rowIndex);
        } else {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            DynamicObject manuVersion = (DynamicObject)this.getModel().getValue("manuversion");
            if (manuVersion != null) {
                this.getModel().setValue("bomid", manuVersion.get("bom"), rowIndex);
            } else {
                this.getModel().setValue("bomid", null, rowIndex);
            }
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    private Map<String, Map> initBatchQueryMap(DynamicObjectCollection orderEntryEntitys) {
        HashMap<String, Map> returnMap = new HashMap<String, Map>(16);
        HashSet<Object> mftIDSet = new HashSet<Object>(16);
        HashSet<Object> mIDSet = new HashSet<Object>(16);
        for (Object orderEntry : orderEntryEntitys) {
            DynamicObject bom;
            String string = orderEntry.getString("producttype");
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)string) || (bom = orderEntry.getDynamicObject("bomid")) == null || !bom.getBoolean("iscoproduct")) continue;
            DynamicObjectCollection bomentry = bom.getDynamicObjectCollection("copentry");
            for (DynamicObject coproduct : bomentry) {
                DynamicObject dymftmaterial = (DynamicObject)coproduct.get("copentrymaterial");
                mftIDSet.add(dymftmaterial.getPkValue());
            }
        }
        Map mftMap = MaterialMftQueryHelper.getDataCacheBySet(mftIDSet);
        if (null != mftMap) {
            for (Map.Entry entry : mftMap.entrySet()) {
                DynamicObject mftMaterialInfo = (DynamicObject)entry.getValue();
                DynamicObject material = (DynamicObject)mftMaterialInfo.get(MASTERID);
                mIDSet.add(material.getPkValue());
            }
        }
        Map materialMap = MaterialQueryHelper.getDataCacheBySet(mIDSet);
        returnMap.put("materialMap", materialMap);
        returnMap.put("mftMap", mftMap);
        return returnMap;
    }

    private Set<Long> queryProducedeptList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = 0L;
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(16);
        qfs.add(new QFilter("status", "=", (Object)"C"));
        qfs.add(new QFilter("enable", "=", (Object)"1"));
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId);
        if (qFilter != null) {
            qfs.add(qFilter);
        }
        HashSet idSet = new HashSet(16);
        try (DataSet col = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryProducedeptBoolean"), (String)"mpdm_workshopsetup", (String)"workshoporg", (QFilter[])qfs.toArray(new QFilter[0]), null);){
            if (!col.isEmpty()) {
                for (Row obj : col) {
                    idSet.add(obj.getLong("workshoporg"));
                }
            } else {
                idSet = Sets.newHashSet((Iterable)OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId));
            }
        }
        return idSet;
    }

    private boolean queryProducedeptBoolean(Long producedeptId) {
        Set<Long> idSets = this.queryProducedeptList();
        return idSets.isEmpty() || idSets.contains(producedeptId);
    }

    private void setYieldrateAll(int rowIndex) {
        DynamicObject bom = (DynamicObject)this.getModel().getValue("bomid", rowIndex);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        BigDecimal yieldrate = BigDecimal.ONE;
        if (bom == null) {
            DynamicObject planinfo = this.getMaterialPlanInfo(rowIndex);
            if (planinfo != null) {
                yieldrate = (BigDecimal)planinfo.get("yield");
            } else {
                qty = BigDecimal.ZERO;
            }
        } else {
            yieldrate = (BigDecimal)bom.get("yieldrate");
        }
        this.setYieldrate(rowIndex, yieldrate);
        this.setYieldrateQty(rowIndex, qty, yieldrate);
    }

    private void setYieldrate(int rowIndex, BigDecimal yieldrate) {
        if (null == yieldrate) {
            yieldrate = BigDecimal.ZERO;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("entryyieldrate", (Object)yieldrate);
        model.setValue("yieldrate", (Object)yieldrate, rowIndex);
        model.endInit();
        IFormView view = this.getView();
        view.updateView("entryyieldrate");
    }

    private void setYieldrateQty(int rowIndex, BigDecimal qty, BigDecimal yieldrate) {
        if (null == yieldrate) {
            yieldrate = BigDecimal.ZERO;
        }
        if (null == qty) {
            qty = BigDecimal.ZERO;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        BigDecimal estscrapqty = BigDecimal.ZERO.compareTo(qty) == 0 ? BigDecimal.ZERO : qty.multiply(BigDecimal.valueOf(1L).subtract(new BigDecimal(yieldrate.toString())));
        model.setValue("estscrapqty", (Object)estscrapqty, rowIndex);
        model.setValue("entryestscrapqty", (Object)estscrapqty);
        model.endInit();
        IFormView view = this.getView();
        view.updateView("entryestscrapqty");
    }

    private void auxPtyUnitChange(ChangeData changeData) {
        Object auxptyUnit = changeData.getNewValue();
        if (null == auxptyUnit || ((DynamicObject)auxptyUnit).getLong("id") <= 0L) {
            this.getModel().setValue("auxptyqty", (Object)0, changeData.getRowIndex());
        }
    }
}

