/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderImportService;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.mvc.bill.BillModel;

public class MftOrderImportTpl
extends AbstractBillPlugIn {
    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        Map option = e.getOption();
        BillModel billModel = (BillModel)e.getSource();
        OrderImportService.initImportDataMethod((List)sourceDataList, (BillModel)billModel, (Map)option);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        String billEntityId = this.getModel().getDataEntityType().getName();
        String errMessage = OrderImportService.validateBeforeImport((Map)sourceData, (String)billEntityId);
        if (errMessage.length() > 0) {
            e.setCancel(true);
            e.setCancelMessage(errMessage);
            e.setFireAfterImportData(false);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        DynamicObjectCollection orderEntrys = this.getModel().getEntryEntity("treeentryentity");
        for (DynamicObject orderEntry : orderEntrys) {
            DynamicObject BOMDyn;
            DynamicObject orderDataEntity;
            Boolean isinitbill;
            DynamicObject mftMaterial = orderEntry.getDynamicObject("material");
            if (null != mftMaterial) {
                boolean isstoragelimit = mftMaterial.getBoolean("isstoragelimit");
                Object highlimit = mftMaterial.get("rcvinhighlimit");
                Object lowlimit = mftMaterial.get("rcvinlowlimit");
                orderEntry.set("iscontrolqty", (Object)isstoragelimit);
                orderEntry.set("rcvinhighlimit", highlimit);
                orderEntry.set("rcvinlowlimit", lowlimit);
                boolean isreportlimit = mftMaterial.getBoolean("isreportlimit");
                Object rpthighlimit = mftMaterial.get("rcvinhighlimit");
                Object rptlowlimit = mftMaterial.get("rcvinlowlimit");
                orderEntry.set("isconreportqty", (Object)isreportlimit);
                orderEntry.set("repmaxrate", rpthighlimit);
                orderEntry.set("repminrate", rptlowlimit);
            }
            if (!(isinitbill = Boolean.valueOf((orderDataEntity = this.getModel().getDataEntity()).getBoolean("isinitbill"))).booleanValue()) continue;
            BigDecimal quainwaqty = orderEntry.getBigDecimal("quainwaqty");
            BigDecimal unquainwaqty = orderEntry.getBigDecimal("unquainwaqty");
            BigDecimal scrinwaqty = orderEntry.getBigDecimal("scrinwaqty");
            orderEntry.set("stockqty", (Object)quainwaqty.add(unquainwaqty).add(scrinwaqty));
            BigDecimal qualifiedqty = orderEntry.getBigDecimal("qualifiedqty");
            BigDecimal acceptqty = orderEntry.getBigDecimal("acceptqty");
            BigDecimal workwasteqty = orderEntry.getBigDecimal("workwasteqty");
            BigDecimal mtlcostqty = orderEntry.getBigDecimal("mtlcostqty");
            BigDecimal reworkqty = orderEntry.getBigDecimal("reworkqty");
            BigDecimal repairqty = orderEntry.getBigDecimal("repairqty");
            BigDecimal sumQty = qualifiedqty.add(acceptqty).add(workwasteqty).add(mtlcostqty).add(reworkqty).add(repairqty);
            orderEntry.set("rptqty", (Object)sumQty);
            orderEntry.set("reportqty", (Object)sumQty);
            orderEntry.set("scrapqty", (Object)workwasteqty.add(mtlcostqty));
            if (!orderEntry.containsProperty("ecnversion") || (BOMDyn = orderEntry.getDynamicObject("bomid")) == null) continue;
            DynamicObject ecn = BOMDyn.getDynamicObject("ecn");
            orderEntry.set("ecnversion", (Object)ecn);
        }
    }
}

