/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.PlanScopeHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.WarehouseQueryHelper;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MftOrderPlanScopeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit planscopebasedataEdit = (BasedataEdit)this.getView().getControl("planscope");
        planscopebasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        if (org != null && treeentryentity != null && !treeentryentity.isEmpty()) {
            this.setPlanScopeInfo(org, 0);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if ("planscope".equals(fieldKey)) {
            int row = e.getRow();
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", row);
            if (material == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"MftOrderPlanScopeEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                Long orgId = PlanScopeHelper.innerTypeOrgId((int)row, (IDataModel)this.getModel());
                List planScopes = PlanScopeHelper.getPlanScopes((Long)orgId);
                List planScopeIds = PlanScopeHelper.getPlanScopes((Long)orgId, (Long)((Long)material.getDynamicObject("masterid").getPkValue()));
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                QFilter qfilter = new QFilter("id", "in", (Object)planScopes);
                qfilter.or(new QFilter("id", "in", (Object)planScopeIds));
                listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String keyName = e.getProperty().getName();
        if (this.getPageCache().get("isIgnoreChangeListenerPlan") == "true") {
            return;
        }
        DynamicObject changeSet = e.getChangeSet();
        boolean usePlanscope = PlanScopeHelper.isUsePlanscope();
        DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject entrustdept = (DynamicObject)this.getModel().getValue("entrustdept");
        if ("entrustdept".equals(keyName)) {
            DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String newtran = "0";
            String oldtran = "0";
            if (newObj != null) {
                newtran = newObj.getPkValue().toString();
            }
            if (oldObj != null) {
                oldtran = oldObj.getPkValue().toString();
            }
            this.getPageCache().put("newXStockObj", newtran);
            this.getPageCache().put("oldXStockObj", oldtran);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
            if (entryEntity != null && !entryEntity.isEmpty() && !newtran.equals(this.getPageCache().get("oldXStockObj"))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgChange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u59d4\u6258\u7ec4\u7ec7\u5207\u6362\uff0c\u5c06\u6e05\u9664\u4ea7\u54c1\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MftOrderPlanScopeEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        }
        if ("supplyrule".equals(keyName)) {
            for (DynamicObject change : changeSet) {
                this.getModel().setValue("material", null, change.getRowIndex());
            }
        }
        if ("material".equals(keyName)) {
            DynamicObject masterIdSet = new HashSet(16);
            HashSet<Long> entrustSet = new HashSet<Long>(16);
            for (DynamicObject change : changeSet) {
                DynamicObject material = (DynamicObject)change.getNewValue();
                String supplyrule = (String)this.getModel().getValue("supplyrule", change.getRowIndex());
                if ("C".equals(supplyrule) && entrustdept != null && material != null) {
                    entrustSet.add((Long)material.getDynamicObject("masterid").getPkValue());
                }
                if ("C".equals(supplyrule) || material == null) continue;
                masterIdSet.add((Long)material.getDynamicObject("masterid").getPkValue());
            }
            HashMap<Long, Map> orgplanMaterialMap = new HashMap<Long, Map>(16);
            HashMap supplynetworkMap = new HashMap(16);
            if (!entrustSet.isEmpty()) {
                Map planMaterialMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet(entrustSet, (Long)entrustdept.getLong("id"));
                orgplanMaterialMap.put(entrustdept.getLong("id"), planMaterialMap);
                supplynetworkMap.putAll(PlanScopeHelper.getSupplynetworkMap(planMaterialMap.values()));
            }
            if (!masterIdSet.isEmpty()) {
                Map planMaterialMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet((Set)masterIdSet, (Long)mtfOrg.getLong("id"));
                orgplanMaterialMap.put(mtfOrg.getLong("id"), planMaterialMap);
                supplynetworkMap.putAll(PlanScopeHelper.getSupplynetworkMap(planMaterialMap.values()));
            }
            for (DynamicObject change : changeSet) {
                DynamicObject material = (DynamicObject)change.getNewValue();
                this.getModel().setValue("planscope", null, change.getRowIndex());
                if (material == null) continue;
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treeentryentity", change.getRowIndex());
                String errorInfo = PlanScopeHelper.validateAfterMaterialChanged((DynamicObject)entryRowEntity, (DynamicObject)material, orgplanMaterialMap, supplynetworkMap, (DynamicObject)mtfOrg, (DynamicObject)entrustdept);
                if ("".equals(errorInfo)) {
                    String supplyrule;
                    if (usePlanscope) {
                        supplyrule = (String)this.getModel().getValue("supplyrule", change.getRowIndex());
                        if ("C".equals(supplyrule) && entrustdept != null) {
                            this.setPlanScopeInfo(entrustdept, change.getRowIndex());
                            continue;
                        }
                        this.setPlanScopeInfo(mtfOrg, change.getRowIndex());
                        continue;
                    }
                    supplyrule = (String)this.getModel().getValue("supplyrule", change.getRowIndex());
                    if ("C".equals(supplyrule) && entrustdept != null) {
                        PlanScopeHelper.setInWarInfo((IDataModel)this.getModel(), (Long)entrustdept.getLong("id"), (Long)material.getDynamicObject("masterid").getLong("id"), (int)change.getRowIndex());
                        continue;
                    }
                    PlanScopeHelper.setInWarInfo((IDataModel)this.getModel(), (Long)mtfOrg.getLong("id"), (Long)material.getDynamicObject("masterid").getLong("id"), (int)change.getRowIndex());
                    continue;
                }
                this.getView().showTipNotification(errorInfo);
                this.getModel().setValue("material", null, change.getRowIndex());
            }
        } else if ("planscope".equals(keyName)) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            this.getPageCache().put("isIgnoreChangeListenerPlan", "true");
            for (DynamicObject change : changeSet) {
                DynamicObject planscope = (DynamicObject)change.getNewValue();
                if (planscope != null) {
                    if (entrustdept != null) {
                        this.setValueByPlanscope(change.getRowIndex(), planscope, entrustdept);
                    } else {
                        this.setValueByPlanscope(change.getRowIndex(), planscope, mtfOrg);
                    }
                }
                this.getPageCache().put("isIgnoreChangeListener", "false");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "false");
            }
        } else if ("entrywarehouse".equals(keyName) && usePlanscope) {
            DynamicObject warehouse = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int changeIndex = this.getSelectEntryRowIndex();
            if (changeIndex == -1) {
                return;
            }
            Long orgId = PlanScopeHelper.innerTypeOrgId((int)changeIndex, (IDataModel)this.getModel());
            if (warehouse == null) {
                this.getModel().setValue("warehouse", null, changeIndex);
                this.getModel().setValue("location", null, changeIndex);
                this.getModel().setValue("entrywarehouse", null);
                this.getModel().setValue("entrylocation", null);
                return;
            }
            Map inwareInfo = PlanScopeHelper.getInwareInfoByInwarehouse((Long)warehouse.getLong("id"), (Long)orgId, (Boolean)true);
            if (inwareInfo == null) {
                Long planScope = PlanScopeHelper.getPlanScope((Long)orgId);
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "true");
                this.getModel().setValue("warehouse", (Object)warehouse, changeIndex);
                this.getModel().setValue("planscope", (Object)planScope, changeIndex);
                this.getPageCache().put("isIgnoreChangeListener", "false");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "false");
                this.getModel().setValue("entrylocation", null);
                if (warehouse != null) {
                    DynamicObject warehouseDym = WarehouseQueryHelper.getDataCacheByID((Object)warehouse.getLong("id"));
                    boolean isopenlocation = warehouseDym.getBoolean("isopenlocation");
                    if (isopenlocation) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"entrylocation"});
                    } else {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
                    }
                }
                return;
            }
            Long inwarOrg = (Long)inwareInfo.get("inwarorg");
            Long planScopeid = (Long)inwareInfo.get("planscope");
            DynamicObject oldplanScope = (DynamicObject)this.getModel().getValue("planscope", changeIndex);
            if (oldplanScope == null || oldplanScope.getPkValue().toString().equals(planScopeid.toString())) {
                this.getModel().setValue("warehouse", (Object)warehouse, changeIndex);
                this.getModel().setValue("entrylocation", null);
                if (warehouse != null) {
                    DynamicObject warehouseDym = WarehouseQueryHelper.getDataCacheByID((Object)warehouse.getLong("id"));
                    boolean isopenlocation = warehouseDym.getBoolean("isopenlocation");
                    if (isopenlocation) {
                        this.getView().setEnable(Boolean.TRUE, new String[]{"entrylocation"});
                    } else {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
                    }
                }
            } else {
                DynamicObject planScope = BusinessDataServiceHelper.loadSingleFromCache((Object)planScopeid, (String)"msplan_planscope");
                this.getPageCache().put("inwarOrg", inwarOrg.toString());
                this.getPageCache().put("planScope", planScopeid.toString());
                this.getPageCache().put("inwareHouse", warehouse.get("id").toString());
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5165\u5e93\u4ed3\u5e93\uff08%1$s\uff09\u5c5e\u4e8e\u8ba1\u5212\u8303\u56f4\uff08%2$s\uff09\uff0c\u5982\u4fee\u6539\u5165\u5e93\u4ed3\u5e93\uff0c\u8ba1\u5212\u8303\u56f4\u4e5f\u4f1a\u4fee\u6539\uff0c\u662f\u5426\u4fee\u6539\u5165\u5e93\u4ed3\u5e93\uff1f", (String)"MftOrderPlanScopeEdit_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), warehouse.getLocaleString("name").getLocaleValue(), planScope.getLocaleString("name").getLocaleValue()), MessageBoxOptions.YesNo, new ConfirmCallBackListener("warehosecollback", (IFormPlugin)this));
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "true");
                MftOrderPlanScopeEdit.setOldValue(this.getView(), this.getModel(), "entrywarehouse", e.getChangeSet()[0].getOldValue());
                this.getPageCache().put("isIgnoreChangeListener", "false");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "false");
            }
        }
    }

    private static void setOldValue(IFormView fv, IDataModel dm, String propertyName, Object oldObject) {
        dm.beginInit();
        dm.setValue(propertyName, oldObject);
        dm.endInit();
        fv.updateView(propertyName);
    }

    private void setPlanScopeInfo(DynamicObject mtfOrg, int changeIndex) {
        Long planScope = PlanScopeHelper.getPlanScope((Long)((Long)mtfOrg.getPkValue()));
        this.getPageCache().put("isIgnoreChangeListenerPlan", "true");
        this.getModel().setValue("planscope", (Object)planScope, changeIndex);
        DynamicObject planScopeDym = BusinessDataServiceHelper.loadSingleFromCache((Object)planScope, (String)"msplan_planscope", (String)"type");
        if (planScopeDym != null) {
            this.setValueByPlanscope(changeIndex, planScopeDym, mtfOrg);
        }
        this.getPageCache().put("isIgnoreChangeListenerPlan", "false");
    }

    private void setValueByPlanscope(int changeIndex, DynamicObject planscope, DynamicObject org) {
        DynamicObject masterid;
        Map inwareInfo;
        int currentIndex = this.getSelectEntryRowIndex();
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", changeIndex);
        if (material != null && (inwareInfo = PlanScopeHelper.getDefInwareInfo((DynamicObject)planscope, (DynamicObject)(masterid = material.getDynamicObject("masterid")), (DynamicObject)org)) != null) {
            Long inwarorg = ((Long)inwareInfo.get("inwarorg")).equals(0L) ? null : (Long)inwareInfo.get("inwarorg");
            Long inwarehouse = ((Long)inwareInfo.get("inwarehouse")).equals(0L) ? null : (Long)inwareInfo.get("inwarehouse");
            Long inwarelocation = ((Long)inwareInfo.get("inwarelocation")).equals(0L) ? null : (Long)inwareInfo.get("inwarelocation");
            this.getModel().setValue("inwardept", (Object)inwarorg, changeIndex);
            this.getModel().setValue("warehouse", (Object)inwarehouse, changeIndex);
            this.getModel().setValue("location", (Object)inwarelocation, changeIndex);
            if (currentIndex == changeIndex) {
                this.getModel().setValue("entryinwardept", (Object)inwarorg);
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "true");
                this.getModel().setValue("entrywarehouse", (Object)inwarehouse);
                this.getModel().setValue("entrylocation", (Object)inwarelocation);
            }
        }
    }

    private int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPlanscopeMustInput();
        this.setSupplyRuleEanble();
    }

    private void setPlanscopeMustInput() {
        if (PlanScopeHelper.isUsePlanscope()) {
            FieldEdit planscopeEdit = (FieldEdit)this.getView().getControl("planscope");
            if (planscopeEdit != null) {
                planscopeEdit.setMustInput(true);
                planscopeEdit.setVisible("", true);
            }
        } else {
            FieldEdit planscopeEdit = (FieldEdit)this.getView().getControl("planscope");
            if (planscopeEdit != null) {
                planscopeEdit.setMustInput(false);
                planscopeEdit.setVisible("", false);
            }
        }
    }

    private void setSupplyRuleEanble() {
        FieldEdit planscopeEdit;
        FieldEdit supplyruleEdit;
        String ordername = this.getModel().getDataEntityType().getName();
        DynamicObject entrustdept = (DynamicObject)this.getModel().getValue("entrustdept");
        Boolean isEnable = Boolean.TRUE;
        if (entrustdept == null) {
            isEnable = Boolean.FALSE;
        }
        if ((supplyruleEdit = (FieldEdit)this.getView().getControl("supplyrule")) != null) {
            int entryRowCount = this.getModel().getEntryRowCount("treeentryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                String changetype;
                String producttype = (String)this.getModel().getValue("producttype", i);
                boolean fromDatabase = this.getModel().getEntryRowEntity("treeentryentity", i).getDataEntityState().getFromDatabase();
                isEnable = !fromDatabase && isEnable != false;
                if (!"C".equals(producttype)) {
                    supplyruleEdit.setEnable("", false, i);
                } else {
                    supplyruleEdit.setEnable("", isEnable.booleanValue(), i);
                }
                if (!"pom_xmftorder".equals(ordername) && !"om_xmftorder".equals(ordername) || "A".equals(changetype = (String)this.getModel().getValue("changetype", i))) continue;
                supplyruleEdit.setEnable("", false, i);
            }
        }
        if ((planscopeEdit = (FieldEdit)this.getView().getControl("planscope")) != null) {
            int entryRowCount = this.getModel().getEntryRowCount("treeentryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                String changetype;
                String producttype = (String)this.getModel().getValue("producttype", i);
                String sourcebilltype = (String)this.getModel().getValue("sourcebilltype", i);
                boolean fromDatabase = this.getModel().getEntryRowEntity("treeentryentity", i).getDataEntityState().getFromDatabase();
                if (fromDatabase || !"C".equals(producttype) || "mrp_planorder".equals(sourcebilltype) || "mps_scheduleplan".equals(sourcebilltype)) {
                    planscopeEdit.setEnable("", false, i);
                } else {
                    planscopeEdit.setEnable("", true, i);
                }
                if (!"pom_xmftorder".equals(ordername) && !"om_xmftorder".equals(ordername) || "A".equals(changetype = (String)this.getModel().getValue("changetype", i))) continue;
                planscopeEdit.setEnable("", false, i);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("warehosecollback".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            int changeIndex = this.getSelectEntryRowIndex();
            String inwarOrgStr = this.getPageCache().get("inwarOrg");
            String planScopeStr = this.getPageCache().get("planScope");
            String inwareHouseStr = this.getPageCache().get("inwareHouse");
            this.getModel().beginInit();
            this.getModel().setValue("warehouse", (Object)Long.valueOf(inwareHouseStr), changeIndex);
            this.getModel().setValue("inwardept", (Object)Long.valueOf(inwarOrgStr), changeIndex);
            this.getModel().setValue("planscope", (Object)Long.valueOf(planScopeStr), changeIndex);
            this.getModel().setValue("location", null, changeIndex);
            this.getModel().setValue("entrywarehouse", (Object)Long.valueOf(inwareHouseStr));
            this.getModel().setValue("entryinwardept", (Object)Long.valueOf(inwarOrgStr));
            this.getModel().setValue("entrylocation", null);
            this.getModel().endInit();
            this.getView().updateView("planscope", changeIndex);
            this.getView().updateView("entryinwardept");
            this.getView().updateView("entrywarehouse");
            this.getView().updateView("entrylocation");
            DynamicObject warehouseDym = WarehouseQueryHelper.getDataCacheByID((Object)Long.valueOf(inwareHouseStr));
            boolean isopenlocation = warehouseDym.getBoolean("isopenlocation");
            if (isopenlocation) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"entrylocation"});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"entrylocation"});
            }
        }
        if (StringUtils.equals((CharSequence)"orgChange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("treeentryentity");
                this.showEntryDetial();
                this.getModel().setValue("entrustdept", (Object)this.getPageCache().get("newXStockObj"));
                PlanScopeHelper.setDefSupplyRule((IDataModel)this.getModel());
                this.setPlanscopeMustInput();
                this.setSupplyRuleEanble();
            } else {
                this.getPageCache().put("isIgnoreChangeListener", "true");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "true");
                this.getModel().setValue("entrustdept", (Object)this.getPageCache().get("oldXStockObj"));
                this.getPageCache().put("isIgnoreChangeListener", "false");
                this.getPageCache().put("isIgnoreChangeListenerPlan", "false");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("newentry".equals(operateKey) || "save".equals(operateKey) || "insertentry".equals(operateKey)) {
            this.setPlanscopeMustInput();
            this.setSupplyRuleEanble();
        }
        if ("newentry".equals(operateKey)) {
            int index = this.getModel().getEntryCurrentRowIndex("treeentryentity");
            DynamicObject entrustdept = (DynamicObject)this.getModel().getValue("entrustdept");
            if (entrustdept != null) {
                this.getModel().setValue("supplyrule", (Object)"C", index);
            }
        }
    }

    private void showEntryDetial() {
        this.getModel().setValue("entrymaterial", null);
        this.getModel().setValue("entryauxproperty", null);
        this.getModel().setValue("entryyieldrate", null);
        this.getModel().setValue("entryestscrapqty", null);
        this.getModel().setValue("entryinwardept", null);
        this.getModel().setValue("entrywarehouse", null);
        this.getModel().setValue("entrylocation", null);
        this.getModel().setValue("entryiscontrolqty", null);
        this.getModel().setValue("entryinwarmax", null);
        this.getModel().setValue("entryinwarmin", null);
        this.getModel().setValue("entryrcvinhighlimit", null);
        this.getModel().setValue("entryrcvinlowlimit", null);
        this.getModel().setValue("entryoutputoperation", null);
        this.getModel().setValue("entryrptqty", null);
        this.getModel().setValue("entryreportqty", null);
        this.getModel().setValue("entryworkwasteqty", null);
        this.getModel().setValue("entrymtlcostqty", null);
        this.getModel().setValue("entryqualifiedqty", null);
        this.getModel().setValue("entryunqualifiedqty", null);
        this.getModel().setValue("entryscrapqty", null);
        this.getModel().setValue("entryrepairqty", null);
        this.getModel().setValue("entryreworkqty", null);
        this.getModel().setValue("entrypickingpairs", null);
        this.getModel().setValue("entrystockqty", null);
        this.getModel().setValue("entryquainwaqty", null);
        this.getModel().setValue("entryunquainwaqty", null);
        this.getModel().setValue("entryscrinwaqty", null);
        this.getModel().setValue("entryrepinwaqty", null);
        this.getModel().setValue("entryplansuretime", null);
        this.getModel().setValue("entrytransmittime", null);
        this.getModel().setValue("entrystartworktime", null);
        this.getModel().setValue("entryendworktime", null);
        this.getModel().setValue("entryclosetime", null);
        this.getModel().setValue("entrycompletime", null);
        this.getModel().setValue("entrysourcebilltype", null);
        this.getModel().setValue("entrysourcebillnumber", null);
        this.getModel().setValue("entrysourceentryseq", null);
        this.getModel().setValue("entryunit", null);
        this.getModel().setValue("entryseq", (Object)-1);
        this.getModel().setValue("entrybaseunit", null);
        this.getModel().setValue("entrybaseqty", null);
        this.getModel().setValue("entryauxptyunit", null);
        this.getModel().setValue("entryauxptyqty", null);
        this.getModel().setValue("entryacceptqty", null);
        this.getModel().setValue("entrysrcsplitbillnumber", null);
        this.getModel().setValue("entrysrcsplitbillseq", null);
    }
}

