/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class MftOrderSplitLogList
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent hlc = args.getHyperLinkClickEvent();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRow lsr = billList.getCurrentSelectedRowInfo();
        Object entryPk = lsr.getEntryPrimaryKeyValue();
        if (entryPk == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5355\u636e\u5206\u5f55\u7684\u4e3b\u952e\uff0c\u8bf7\u68c0\u67e5\u5217\u8868\u6570\u636e\u663e\u793a\u7684\u51c6\u786e\u6027\u3002", (String)"MftOrderSplitLogList_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        Object customParam = this.getView().getFormShowParameter().getCustomParam("billFormId");
        if (customParam instanceof String && StringUtils.isNotEmpty((CharSequence)customParam.toString())) {
            String fieldName = hlc.getFieldName();
            if ("orderno".equals(fieldName)) {
                DynamicObject splitLogEntity = BusinessDataServiceHelper.loadSingleFromCache((String)customParam.toString(), (String)"orderid, orderentryid", (QFilter[])new QFilter[]{new QFilter("billentry.id", "=", entryPk)});
                Long orderid = splitLogEntity.getLong("orderid");
                this.openOrderBillForm(args, orderid, this.getOrderTypeByOrderF7(splitLogEntity.getDynamicObject("orderentryid")));
            } else if ("torderno".equals(fieldName)) {
                DynamicObject splitLogEntity = BusinessDataServiceHelper.loadSingleFromCache((String)customParam.toString(), (String)"torderid, torderentryid, tomorderentryid, billentry", (QFilter[])new QFilter[]{new QFilter("billentry.id", "=", entryPk)});
                DynamicObject entryRow = splitLogEntity.getDynamicObjectCollection("billentry").stream().filter(x -> entryPk.equals(x.getLong("id"))).findFirst().get();
                Long orderid = entryRow.getLong("torderid");
                DynamicObject torderentryid = entryRow.getDynamicObject("torderentryid");
                DynamicObject tomorderentryid = entryRow.getDynamicObject("tomorderentryid");
                if (null != torderentryid) {
                    this.openOrderBillForm(args, orderid, this.getOrderTypeByOrderF7(torderentryid));
                } else if (null != tomorderentryid) {
                    this.openOrderBillForm(args, orderid, this.getOrderTypeByOrderF7(tomorderentryid));
                } else {
                    this.openOrderBillForm(args, orderid, "");
                }
            }
        }
    }

    private String getOrderTypeByOrderF7(DynamicObject orderF7Obj) {
        DynamicObjectType orderF7Type = orderF7Obj.getDynamicObjectType();
        String orderF7TypeName = orderF7Type.getName();
        String orderType = null;
        switch (orderF7TypeName) {
            case "pom_mftorder_f7": {
                orderType = "pom_mftorder";
                break;
            }
            case "om_mftorder_f7": {
                orderType = "om_mftorder";
                break;
            }
        }
        return orderType;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("billFormId");
        if (customParam instanceof String && StringUtils.isNotEmpty((CharSequence)customParam.toString())) {
            List produceOrgIdFilter = (List)formShowParameter.getCustomParam("useorgIdFilter");
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                List defaultValues;
                String fieldName = filterColumn.getFieldName();
                if (!StringUtils.equals((CharSequence)"org.name", (CharSequence)fieldName) || (defaultValues = filterColumn.getDefaultValues()).isEmpty() || null == produceOrgIdFilter) continue;
                defaultValues.clear();
                if (produceOrgIdFilter.size() != 1) continue;
                String produceOrgId = produceOrgIdFilter.get(0).toString();
                filterColumn.setDefaultValue(produceOrgId);
            }
        }
    }

    private void openOrderBillForm(HyperLinkClickArgs args, Long orderid, String orderType) {
        args.setCancel(true);
        DynamicObjectCollection order = null;
        if (StringUtils.isNotEmpty((CharSequence)orderType)) {
            order = QueryServiceHelper.query((String)orderType, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orderid)});
        }
        if (CollectionUtils.isEmpty(order)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"MftOrderSplitLogList_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        } else {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)orderid);
            billShowParameter.setFormId(orderType);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

