/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bd.mpdm.common.ext.IMftStockCallBackInterveneMapper;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.StockCulUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ReplaceStockEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    private void showEntryDetial(DynamicObject entryentity) {
        this.getPageCache().put("isIgnoreChangeListenerReplace", "true");
        IDataModel model = this.getModel();
        if (entryentity != null && this.getSelectEntryRowIndex() != -1) {
            if (StringUtils.equals((CharSequence)this.getModel().getValue("billstatus").toString(), (CharSequence)"A")) {
                this.setControlState(true);
            } else {
                this.setControlState(false);
            }
            model.setValue("replaceplanfield", entryentity.get("replaceplan"));
            model.setValue("priorityfield", entryentity.get("priority"));
            model.setValue("ismainreplacefield", entryentity.get("ismainreplace"));
        } else {
            model.setValue("replaceplanfield", null);
            model.setValue("priorityfield", null);
            model.setValue("ismainreplacefield", null);
        }
        this.getPageCache().put("isIgnoreChangeListenerReplace", "false");
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    private void setControlState(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"replaceplanfield", "priorityfield", "ismainreplacefield"});
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"stockentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("stockentry", this.getSelectEntryRowIndex());
            this.showEntryDetial(entryentity);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        ArrayList<Integer> errReplaceList;
        int[] selectRows;
        EntryGrid entryGrid;
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)op.getOperateKey()) && (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"om_componentlist") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"pom_mftstock") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"om_mftstock") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"prop_mftstock"))) {
            entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            selectRows = entryGrid.getSelectRows();
            errReplaceList = new ArrayList(selectRows.length);
            for (int j = 0; j < selectRows.length; ++j) {
                int i = selectRows[j];
                if (this.getModel().getValue("replaceplan", i) == null) continue;
                errReplaceList.add(i + 1);
            }
            if (!errReplaceList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u3002", (String)"ReplaceStockEdit_18", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), ((Object)errReplaceList).toString()));
                e.cancel = true;
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"replacedelbtn", (CharSequence)op.getOperateKey())) {
            entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            selectRows = entryGrid.getSelectRows();
            errReplaceList = new ArrayList<Integer>(selectRows.length);
            ArrayList<Integer> errMuchList = new ArrayList<Integer>(selectRows.length);
            List<Object> errExistList = new ArrayList(selectRows.length);
            HashSet<Long> needDelReplaceGroupIds = new HashSet<Long>(selectRows.length);
            for (int j = 0; j < selectRows.length; ++j) {
                DynamicObject firstDym;
                int i = selectRows[j];
                needDelReplaceGroupIds.add((Long)this.getModel().getValue("replacegroupid", i));
                if (this.getModel().getValue("replaceplan", i) == null) {
                    errReplaceList.add(i + 1);
                    continue;
                }
                if (selectRows.length <= 1 || (firstDym = (DynamicObject)this.getModel().getValue("replaceplan", selectRows[0])) == null) continue;
                DynamicObject currentDym = (DynamicObject)this.getModel().getValue("replaceplan", i);
                if (firstDym.getPkValue().equals(currentDym.getPkValue())) continue;
                errMuchList.clear();
                errMuchList.add(selectRows[0]);
                errMuchList.add(i);
            }
            if (!errReplaceList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errReplaceList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4e0d\u5b58\u5728\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u3002", (String)"ReplaceStockEdit_19", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                e.cancel = true;
                return;
            }
            if (!errMuchList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errMuchList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u4e0d\u4e00\u81f4\u3002", (String)"ReplaceStockEdit_20", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                e.cancel = true;
                return;
            }
            if (selectRows.length > 0) {
                DynamicObject firstDym = (DynamicObject)this.getModel().getValue("replaceplan", selectRows[0]);
                errExistList = this.getExistList(firstDym);
                if (!errExistList.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u7ecf\u53d1\u751f\u9886\u6599\u6216\u8c03\u62e8\u4e1a\u52a1\u3002", (String)"ReplaceStockEdit_21", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), errExistList.toString()));
                    e.cancel = true;
                    return;
                }
                int[] replaceRows = this.getSameReplaceRows(firstDym, needDelReplaceGroupIds);
                this.clearReplaceInfo(firstDym, needDelReplaceGroupIds);
                this.getModel().deleteEntryRows("stockentry", replaceRows);
                e.cancel = true;
                MPDMMftGenStocksUtils.setUseratioEnable((IDataModel)this.getModel(), (IFormView)this.getView());
                MPDMMftGenStocksUtils.setMaterialEnable((IDataModel)this.getModel(), (IFormView)this.getView());
                return;
            }
        }
    }

    private void clearReplaceInfo(DynamicObject firstDym, Set<Long> needDelReplaceGroupIds) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || !"0".equals(entry.getString("pid")) || !needDelReplaceGroupIds.contains(entry.getLong("replacegroupid"))) continue;
            this.getModel().setValue("priority", (Object)0, i);
            this.getModel().setValue("ismainreplace", (Object)false, i);
            this.getModel().setValue("replaceplan", null, i);
            this.getModel().setValue("useratio", (Object)100, i);
            this.getModel().setValue("replacegroupid", (Object)0, i);
            this.getPageCache().put("isIgnoreChangeMftstock", "true");
            if (this.getModel().getValue("seqfield").equals(i + 1)) {
                this.getModel().setValue("priorityfield", (Object)0);
                this.getModel().setValue("ismainreplacefield", (Object)false);
                this.getModel().setValue("replaceplanfield", null);
                MPDMMftGenStocksUtils.change4qtyRes((String)"useratio", (BigDecimal)BigDecimal.ONE, (IDataModel)this.getModel(), (int)i, (int)i, (IFormView)this.getView());
            } else {
                MPDMMftGenStocksUtils.change4qtyRes((String)"useratio", (BigDecimal)BigDecimal.ONE, (IDataModel)this.getModel(), (int)i, (int)(i + 1), (IFormView)this.getView());
            }
            this.getPageCache().put("isIgnoreChangeMftstock", "false");
        }
    }

    private int[] getSameReplaceRows(DynamicObject firstDym, Set<Long> needDelReplaceGroupIds) {
        ArrayList<String> delListSeq = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || "0".equals(entry.getString("pid")) || !needDelReplaceGroupIds.contains(entry.getLong("replacegroupid"))) continue;
            delListSeq.add(i + "");
        }
        int[] replaceRows = new int[delListSeq.size()];
        for (int i = 0; i < delListSeq.size(); ++i) {
            replaceRows[i] = Integer.parseInt((String)delListSeq.get(i));
        }
        return replaceRows;
    }

    private List<Integer> getExistList(DynamicObject firstDym) {
        ArrayList<Integer> errExistList = new ArrayList<Integer>();
        DynamicObject stockDym = this.getModel().getDataEntity();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)stockDym.getDataEntityType().getName(), (String)"replaceplan,pid,actissueqty,rejectedqty,feedingqty,allotqty,outqty", (QFilter[])new QFilter[]{new QFilter("id", "=", stockDym.getPkValue())});
        if (load == null || load.length == 0) {
            return errExistList;
        }
        DynamicObjectCollection entryEntity = load[0].getDynamicObjectCollection("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || "0".equals(entry.getString("pid"))) continue;
            BigDecimal actissueQty = entry.getBigDecimal("actissueqty");
            BigDecimal rejectedQty = entry.getBigDecimal("rejectedqty");
            BigDecimal feedingQty = entry.getBigDecimal("feedingqty");
            BigDecimal allotQty = entry.getBigDecimal("allotqty");
            BigDecimal outqty = entry.getBigDecimal("outqty");
            if (actissueQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (rejectedQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (feedingQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (allotQty.compareTo(BigDecimal.ZERO) != 0) {
                errExistList.add(i + 1);
                continue;
            }
            if (outqty.compareTo(BigDecimal.ZERO) == 0) continue;
            errExistList.add(i + 1);
        }
        return errExistList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if (StringUtils.equals((CharSequence)"replacesetbtn", (CharSequence)e.getOperateKey())) {
            if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"om_componentlist")) {
                DynamicObject orderEntryId = (DynamicObject)this.getModel().getValue("orderentryid");
                String orderId = (String)this.getModel().getValue("orderid");
                QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(orderId));
                DynamicObject orderDym = BusinessDataServiceHelper.loadSingle((String)"pm_om_purorderbill", (String)"closestatus,billentry.rowclosestatus,billentry.rowterminatestatus", (QFilter[])new QFilter[]{idFilter});
                if (orderDym == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u59d4\u5916\u8ba2\u5355\u3002", (String)"ReplaceStockEdit_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                } else if (orderEntryId == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355\u884c\u53f7\u4e3a\u7a7a\u3002", (String)"ReplaceStockEdit_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                } else {
                    DynamicObject OmEntry = this.getOmEntry(orderEntryId.getPkValue(), orderDym);
                    if (OmEntry == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355\u884c\u53f7\u5bf9\u5e94\u7684\u884c\u4e0d\u5b58\u5728\u3002", (String)"ReplaceStockEdit_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    } else if (!"A".equals(OmEntry.getString("rowclosestatus"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355\u884c\u5173\u95ed\u72b6\u6001\u4e0d\u7b49\u4e8e\u6b63\u5e38\u3002", (String)"ReplaceStockEdit_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    } else if (!"A".equals(OmEntry.getString("rowterminatestatus"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355\u884c\u7ec8\u6b62\u72b6\u6001\u4e0d\u7b49\u4e8e\u6b63\u5e38\u3002", (String)"ReplaceStockEdit_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    } else if ("B".equals(orderDym.getString("closestatus"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u59d4\u5916\u8ba2\u5355\u5df2\u5173\u95ed\u3002", (String)"ReplaceStockEdit_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.showReplaceList();
                    }
                }
            } else if (null != this.getModel().getValue("orderentryid") && !"A".equals(((DynamicObject)this.getModel().getValue("orderentryid")).getString("bizstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e1a\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u6b63\u5e38\u3002", (String)"ReplaceStockEdit_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                this.showReplaceList();
            }
        }
        if (StringUtils.equals((CharSequence)"replacedelbtn", (CharSequence)e.getOperateKey())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u5220\u9664\u6210\u529f\uff0c\u8bf7\u624b\u5de5\u6267\u884c\u751f\u4ea7\u5de5\u5355\u7684\u3010\u8ba1\u7b97\u5df2\u9886\u5957\u6570\u3011", (String)"ReplaceStockEdit_26", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        switch (operateKey) {
            case "audit": {
                this.getView().updateView();
                break;
            }
        }
    }

    private DynamicObject getOmEntry(Object pkValue, DynamicObject orderDym) {
        DynamicObjectCollection orderDymCol = orderDym.getDynamicObjectCollection("billentry");
        for (DynamicObject omEntry : orderDymCol) {
            if (!omEntry.getPkValue().equals(pkValue)) continue;
            return omEntry;
        }
        return null;
    }

    private void showReplaceList() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        if (entryGrid.getSelectRows().length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u5206\u5f55\u3002", (String)"ReplaceStockEdit_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        } else {
            Map repConfigSet = StockCulUtils.getRepConfigSet();
            int selectSize = entryGrid.getSelectRows().length;
            ArrayList<String> infoList = new ArrayList<String>(selectSize);
            HashMap<String, BigDecimal> infoListMap = new HashMap<String, BigDecimal>(16);
            ArrayList<Integer> errMaterialList = new ArrayList<Integer>(selectSize);
            ArrayList<Integer> errOutList = new ArrayList<Integer>(selectSize);
            ArrayList<Integer> errReplaceList = new ArrayList<Integer>(selectSize);
            ArrayList<Integer> mainList = new ArrayList<Integer>(selectSize);
            Long materialIdFind = 0L;
            DynamicObject pro = (DynamicObject)this.getModel().getValue("productid");
            for (int i = 0; i < selectSize; ++i) {
                DynamicObject entry = this.getModel().getEntryRowEntity("stockentry", entryGrid.getSelectRows()[i]);
                DynamicObject material = entry.getDynamicObject("materialid");
                if (material == null) {
                    errMaterialList.add(entryGrid.getSelectRows()[i] + 1);
                    continue;
                }
                if (pro != null && material.getPkValue().equals(pro.getPkValue())) {
                    mainList.add(entryGrid.getSelectRows()[i] + 1);
                }
                if (entry.getBoolean("iscannegative")) {
                    errOutList.add(entryGrid.getSelectRows()[i] + 1);
                }
                if (entry.getDynamicObject("replaceplan") != null) {
                    errReplaceList.add(entryGrid.getSelectRows()[i] + 1);
                }
                materialIdFind = (Long)material.getDynamicObject("masterid").getPkValue();
                String stockCompareString = StockCulUtils.getStockCompareString((DynamicObject)entry, (Map)repConfigSet);
                infoList.add(stockCompareString);
                infoListMap.put(stockCompareString + "0", entry.getBigDecimal("qtynumerator"));
                infoListMap.put(stockCompareString + "1", entry.getBigDecimal("qtydenominator"));
            }
            if (!errMaterialList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errMaterialList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7ec4\u4ef6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReplaceStockEdit_22", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                return;
            }
            if (!mainList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                mainList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7269\u6599\u4e0e\u4e3b\u4ea7\u54c1\u76f8\u540c\uff0c\u4e0d\u5141\u8bb8\u88ab\u66ff\u4ee3\u3002", (String)"ReplaceStockEdit_23", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                return;
            }
            if (!errOutList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errOutList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u9000\u6599\u4e3a\u662f\u3002", (String)"ReplaceStockEdit_24", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                return;
            }
            if (!errReplaceList.isEmpty()) {
                StringJoiner stringJoiner = new StringJoiner("\u3001");
                errReplaceList.forEach(t -> stringJoiner.add(String.valueOf(t)));
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u7ecf\u505a\u8fc7\u7ec4\u4ef6\u66ff\u4ee3\u3002", (String)"ReplaceStockEdit_25", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), stringJoiner));
                return;
            }
            DynamicObject[] loadSingles = null;
            DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
            if (mtfOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u3002", (String)"ReplaceStockEdit_15", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_replaceplan", (Long)((Long)mtfOrg.getPkValue()));
                orgFilter.and(new QFilter("status", "=", (Object)"C"));
                orgFilter.and(new QFilter("enable", "=", (Object)"1"));
                orgFilter.and(new QFilter("mainmaterentry.material.masterid", "=", (Object)materialIdFind));
                loadSingles = BusinessDataServiceHelper.load((String)"mpdm_replaceplan", (String)"mainmaterentry,mainmaterentry.material,mainmaterentry.bomversion,mainmaterentry.mole,mainmaterentry.deno,mainmaterentry.auxpty,mainmaterentry.unit", (QFilter[])new QFilter[]{orgFilter});
            }
            if (loadSingles != null) {
                List<Long> ids = this.getReplaceId(infoList, loadSingles, infoListMap, repConfigSet);
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mpdm_replaceplan", (boolean)false);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("id", "in", ids));
                showParameter.getListFilterParameter().setQFilters(filters);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "replacesetbtn");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private List<Long> getReplaceId(List<String> infoList, DynamicObject[] loadSingles, Map<String, BigDecimal> infoListMap, Map<String, Boolean> repConfigSet) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject loadSingle : loadSingles) {
            DynamicObjectCollection dymCol = loadSingle.getDynamicObjectCollection("mainmaterentry");
            ArrayList<String> replaceInfoList = new ArrayList<String>();
            HashMap<String, BigDecimal> replaceInfoListMap = new HashMap<String, BigDecimal>(16);
            for (DynamicObject dym : dymCol) {
                String replaceCompareString = StockCulUtils.getReplaceCompareString((DynamicObject)dym, repConfigSet);
                replaceInfoList.add(replaceCompareString);
                replaceInfoListMap.put(replaceCompareString + "0", dym.getBigDecimal("mole"));
                replaceInfoListMap.put(replaceCompareString + "1", dym.getBigDecimal("deno"));
            }
            if (!ReplaceStockEdit.isListEqual(infoList, replaceInfoList) || !StockCulUtils.isAlike(infoList, infoListMap, replaceInfoListMap, repConfigSet)) continue;
            ids.add((Long)loadSingle.getPkValue());
        }
        return ids;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        if (e.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)"replacesetbtn", (CharSequence)actionKey)) {
                DynamicObject replacePlan = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"mpdm_replaceplan");
                this.setReplaceInfo(replacePlan);
                MPDMMftGenStocksUtils.setUseratioEnable((IDataModel)this.getModel(), (IFormView)this.getView());
                MPDMMftGenStocksUtils.setMaterialEnable((IDataModel)this.getModel(), (IFormView)this.getView());
                PluginProxy extPlugin = PluginProxy.create(null, IMftStockCallBackInterveneMapper.class, (String)"POM_MFTSTOCK_RUNRULEAFTERCALLBACK_EXT", null);
                extPlugin.callReplace(p -> {
                    p.runRuleAfterCallBackStock(this.getView(), this.getModel());
                    return null;
                });
            }
        }
    }

    private void setReplaceInfo(DynamicObject replacePlan) {
        Map repConfigSet = StockCulUtils.getRepConfigSet();
        if (!this.validReplace(replacePlan, repConfigSet)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u4ef6\u66ff\u4ee3\u5173\u7cfb\u4e0d\u5b58\u5728\u6709\u6548\u7684\u66ff\u4ee3\u7269\u6599\u3002", (String)"ReplaceStockEdit_16", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), new Object[0]));
        } else {
            DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("mainmaterentry");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            if (entryGrid.getSelectRows().length > 0) {
                long replaceGroupId = ID.genLongId();
                for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    for (DynamicObject dym : dymCol) {
                        this.setReplaceInfoByID(entryGrid.getSelectRows()[i], dym, replacePlan, repConfigSet, replaceGroupId);
                    }
                }
            }
        }
    }

    private boolean validReplace(DynamicObject replacePlan, Map<String, Boolean> repConfigSet) {
        DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("mainmaterentry");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
            for (DynamicObject dym : dymCol) {
                DynamicObject entry = this.getModel().getEntryRowEntity("stockentry", entryGrid.getSelectRows()[i]);
                if (!StockCulUtils.getStockCompareString((DynamicObject)entry, repConfigSet).equals(StockCulUtils.getReplaceCompareString((DynamicObject)dym, repConfigSet)) || !dym.getBoolean("isreplace")) continue;
                return this.validReplaceEntry(entryGrid.getSelectRows()[i], replacePlan);
            }
        }
        return false;
    }

    private boolean validReplaceEntry(int curreuntIndex, DynamicObject replacePlan) {
        DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("repmaterentry");
        DynamicObject[] dymList = this.sortByReppriority(dymCol);
        for (int i = 0; i < dymList.length; ++i) {
            Date demandDate = (Date)this.getModel().getValue("demanddate", curreuntIndex);
            Date validDate = dymList[i].getDate("repeffectdate");
            Date invalidDate = dymList[i].getDate("repinvaliddate");
            if (demandDate.compareTo(validDate) < 0 || demandDate.compareTo(invalidDate) > 0) continue;
            return true;
        }
        return false;
    }

    private void setReplaceInfoByID(int i, DynamicObject dym, DynamicObject replacePlan, Map<String, Boolean> repConfigSet, long replaceGroupId) {
        DynamicObject entry = this.getModel().getEntryRowEntity("stockentry", i);
        if (StockCulUtils.getStockCompareString((DynamicObject)entry, repConfigSet).equals(StockCulUtils.getReplaceCompareString((DynamicObject)dym, repConfigSet))) {
            this.getModel().setValue("priority", dym.get("priority"), i);
            this.getModel().setValue("ismainreplace", dym.get("isreplace"), i);
            this.getModel().setValue("replaceplan", replacePlan.getPkValue(), i);
            this.getModel().setValue("replacegroupid", (Object)replaceGroupId, i);
            if (this.getModel().getValue("seqfield").equals(i + 1)) {
                this.getModel().setValue("priorityfield", dym.get("priority"));
                this.getModel().setValue("ismainreplacefield", dym.get("isreplace"));
                this.getModel().setValue("replaceplanfield", replacePlan.getPkValue());
            }
            if (dym.getBoolean("isreplace")) {
                this.insertReplaceEntry(i, replacePlan, dym, repConfigSet, replaceGroupId);
            }
        }
    }

    private void insertReplaceEntry(int curreuntIndex, DynamicObject replacePlan, DynamicObject dym, Map<String, Boolean> repConfigSet, long replaceGroupId) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection dymCol = replacePlan.getDynamicObjectCollection("repmaterentry");
        DynamicObject[] dymList = this.sortByReppriority(dymCol);
        for (int i = 0; i < dymList.length; ++i) {
            Date demandDate = (Date)this.getModel().getValue("demanddate", curreuntIndex);
            Date validDate = dymList[i].getDate("repeffectdate");
            Date invalidDate = dymList[i].getDate("repinvaliddate");
            if (demandDate.compareTo(validDate) < 0 || demandDate.compareTo(invalidDate) > 0) continue;
            int insertEntryRow = this.getModel().insertEntryRow("stockentry", curreuntIndex);
            for (int j = 0; j < selectRows.length; ++j) {
                if (selectRows[j] < insertEntryRow) continue;
                selectRows[j] = selectRows[j] + 1;
            }
            this.setReplaceValue(insertEntryRow, dymList[i], curreuntIndex, replacePlan, dym, repConfigSet, replaceGroupId);
        }
        entryGrid.selectRows(selectRows, curreuntIndex);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("stockentry");
        grid.expand(curreuntIndex);
    }

    private void setReplaceValue(int insertEntryRow, DynamicObject dymList, int curreuntIndex, DynamicObject replacePlan, DynamicObject dym, Map<String, Boolean> repConfigSet, long replaceGroupId) {
        String isquotacontrol;
        DynamicObject stockEntry = this.getModel().getEntryRowEntity("stockentry", curreuntIndex);
        Map res = StockCulUtils.calRepRes((DynamicObject)dymList, (DynamicObject)dym, (DynamicObject)stockEntry, repConfigSet);
        this.getPageCache().put("isIgnoreChangeMftstock", "true");
        this.getModel().setValue("replaceplan", replacePlan.getPkValue(), insertEntryRow);
        this.getModel().setValue("priority", dymList.get("reppriority"), insertEntryRow);
        this.getModel().setValue("replacegroupid", (Object)replaceGroupId, insertEntryRow);
        DynamicObject pro = (DynamicObject)this.getModel().getValue("productid");
        DynamicObject materialold = dymList.getDynamicObject("repmaterial");
        if (materialold == null) {
            return;
        }
        DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
        if (mtfOrg == null) {
            return;
        }
        DynamicObject masterid = materialold.getDynamicObject("masterid");
        QFilter filter = new QFilter("masterid", "=", masterid.getPkValue());
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)((Long)mtfOrg.getPkValue()));
        DynamicObject materialinfoold = BusinessDataServiceHelper.loadSingle((Object)materialold.getPkValue(), (String)"bd_materialmftinfo");
        DynamicObject[] materialinfos = BusinessDataServiceHelper.load((String)"bd_materialmftinfo", (String)"supplyorgunitid,warehouse,location,outstorageunit,outwarehouse,outwarelocation,issuemode,isbackflush,iskeypart,isquotacontrol,issinhighlimit,issinlowlimit,isstockallot,isbulkmaterial", (QFilter[])new QFilter[]{filter, orgFilter});
        DynamicObject materialinfo = materialinfoold;
        if (materialinfos != null && materialinfos.length > 0) {
            materialinfo = materialinfos[0];
        }
        if (pro != null && pro.getPkValue().equals(materialinfo.getPkValue())) {
            this.getModel().setValue("rework", (Object)Boolean.TRUE, insertEntryRow);
        }
        this.getModel().setValue("materialid", (Object)materialinfo, insertEntryRow);
        this.getModel().setValue("materielmasterid", materialinfo.get("masterid"), insertEntryRow);
        this.getModel().setValue("childauxpropertyid", dymList.get("repauxpty"), insertEntryRow);
        this.getModel().setValue("bomreversion", dymList.get("repbomversion"), insertEntryRow);
        this.getModel().setValue("ismainreplace", dymList.get("isrep"), insertEntryRow);
        this.getModel().setValue("materialunitid", dymList.get("repunit"), insertEntryRow);
        this.getModel().setValue("qtynumerator", res.get("mole"), insertEntryRow);
        this.getModel().setValue("qtydenominator", res.get("deno"), insertEntryRow);
        this.getModel().setValue("qtytype", stockEntry.get("qtytype"), insertEntryRow);
        this.getModel().setValue("useratio", (Object)0, insertEntryRow);
        this.getModel().setValue("fixscrap", stockEntry.get("fixscrap"), insertEntryRow);
        this.getModel().setValue("scraprate", stockEntry.get("scraprate"), insertEntryRow);
        this.getModel().setValue("wastagerateformula", stockEntry.get("wastagerateformula"), insertEntryRow);
        this.getModel().setValue("isbomextend", (Object)Boolean.FALSE, insertEntryRow);
        this.getModel().setValue("iscannegative", stockEntry.get("iscannegative"), insertEntryRow);
        this.getModel().setValue("supplymode", stockEntry.get("supplymode"), insertEntryRow);
        this.getModel().setValue("supplierid", stockEntry.get("supplierid"), insertEntryRow);
        this.getModel().setValue("parentid", stockEntry.getPkValue(), insertEntryRow);
        if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"pom_mftstock")) {
            this.getModel().setValue("workprocedureid", stockEntry.get("workprocedureid"), insertEntryRow);
            this.getModel().setValue("oprno", stockEntry.get("oprno"), insertEntryRow);
            this.getModel().setValue("processseq", stockEntry.get("processseq"), insertEntryRow);
            this.getModel().setValue("oprworkcenter", stockEntry.get("oprworkcenter"), insertEntryRow);
            this.getModel().setValue("machiningtype", stockEntry.get("machiningtype"), insertEntryRow);
            this.getModel().setValue("outsupplier", stockEntry.get("outsupplier"), insertEntryRow);
            this.getModel().setValue("workstation", stockEntry.get("workstation"), insertEntryRow);
        }
        this.getModel().setValue("demanddate", stockEntry.get("demanddate"), insertEntryRow);
        this.getModel().setValue("leadtime", stockEntry.get("leadtime"), insertEntryRow);
        if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"pom_mftstock") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"om_mftstock") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"prop_mftstock")) {
            this.getModel().setValue("parentmaterial", stockEntry.get("parentmaterial"), insertEntryRow);
            this.getModel().setValue("pstockentryid", stockEntry.get("pstockentryid"), insertEntryRow);
        }
        this.getModel().setValue("supplyorgid", materialinfo.get("supplyorgunitid"), insertEntryRow);
        String entityName = this.getModel().getDataEntityType().getName();
        this.getModel().setValue("warehouseid", materialinfo.get("warehouse"), insertEntryRow);
        this.getModel().setValue("location", materialinfo.get("location"), insertEntryRow);
        this.getModel().setValue("outorgunitid", materialinfo.get("outstorageunit"), insertEntryRow);
        this.getModel().setValue("outwarehouseid", materialinfo.get("outwarehouse"), insertEntryRow);
        this.getModel().setValue("outlocation", materialinfo.get("outwarelocation"), insertEntryRow);
        String modestring = MPDMMftGenStocksUtils.getIssuemode((Object)materialinfo.get("issuemode"));
        this.getModel().setValue("issuemode", (Object)modestring, insertEntryRow);
        this.getModel().setValue("isbackflush", materialinfo.get("isbackflush"), insertEntryRow);
        MPDMMftGenStocksUtils.setbackflush((Object)materialinfo.get("isbackflush"), (int)insertEntryRow, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_mftstock")) {
            MPDMMftGenStocksUtils.setStockEntryWarehouse((DynamicObject)mtfOrg, (String)entityName, (IDataModel)this.getModel(), (int)insertEntryRow);
        }
        this.getModel().setValue("iskeypart", materialinfo.get("iskeypart"), insertEntryRow);
        String string = isquotacontrol = materialinfo.get("isquotacontrol") == null ? "" : materialinfo.getString("isquotacontrol");
        if (StringUtils.equals((CharSequence)isquotacontrol, (CharSequence)"true")) {
            this.getModel().setValue("overissuecontrl", (Object)"B", insertEntryRow);
        } else {
            this.getModel().setValue("overissuecontrl", (Object)"A", insertEntryRow);
        }
        BigDecimal issinhighlimit = materialinfo.get("issinhighlimit") == null ? BigDecimal.ZERO : materialinfo.getBigDecimal("issinhighlimit");
        this.getModel().setValue("issinhighlimit", (Object)issinhighlimit, insertEntryRow);
        BigDecimal issinlowlimit = materialinfo.get("issinlowlimit") == null ? BigDecimal.ZERO : materialinfo.getBigDecimal("issinlowlimit");
        this.getModel().setValue("issinlowlimit", (Object)issinlowlimit, insertEntryRow);
        this.getModel().setValue("isstockallot", materialinfo.get("isstockallot"), insertEntryRow);
        this.getModel().setValue("isbulkmaterial", materialinfo.get("isbulkmaterial"), insertEntryRow);
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
    }

    private DynamicObject[] sortByReppriority(DynamicObjectCollection dymCol) {
        int i;
        DynamicObject[] dymList = new DynamicObject[dymCol.size()];
        for (i = 0; i < dymCol.size(); ++i) {
            dymList[i] = (DynamicObject)dymCol.get(i);
        }
        for (i = 0; i < dymList.length - 1; ++i) {
            for (int j = 0; j < dymList.length - 1 - i; ++j) {
                if (dymList[j].getInt("reppriority") <= dymList[j + 1].getInt("reppriority")) continue;
                DynamicObject temp = dymList[j];
                dymList[j] = dymList[j + 1];
                dymList[j + 1] = temp;
            }
        }
        return dymList;
    }

    public static boolean isListEqual(List<String> list1, List<String> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.containsAll(list2);
    }
}

