/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.StockCulUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ReplaceUpdateEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("repnew".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
            if (entryGrid.getSelectRows().length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5206\u5f55\u3002", (String)"ReplaceUpdateEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else if (entryGrid.getSelectRows().length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u6761\u5206\u5f55\u3002", (String)"ReplaceUpdateEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObject entry = this.getModel().getEntryRowEntity("stockentry", entryGrid.getSelectRows()[0]);
                DynamicObject replaceplan = entry.getDynamicObject("replaceplan");
                if (replaceplan == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u672a\u8fdb\u884c\u66ff\u4ee3\u3002", (String)"ReplaceUpdateEdit_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                } else {
                    Map repConfigSet = StockCulUtils.getRepConfigSet();
                    int[] replaceRows = this.getSameReplaceRows(replaceplan);
                    int pidIndex = this.getSameReplacePidIndex(replaceplan);
                    HashSet<String> keySet = new HashSet<String>(16);
                    for (int i = 0; i < replaceRows.length; ++i) {
                        DynamicObject childEntry = this.getModel().getEntryRowEntity("stockentry", replaceRows[i]);
                        keySet.add(StockCulUtils.getStockCompareString((DynamicObject)childEntry, (Map)repConfigSet) + childEntry.get("priority"));
                    }
                    DynamicObject replacePlanLoad = BusinessDataServiceHelper.loadSingle((Object)replaceplan.getPkValue(), (String)"mpdm_replaceplan");
                    DynamicObjectCollection dymCol = replacePlanLoad.getDynamicObjectCollection("mainmaterentry");
                    for (DynamicObject pdym : dymCol) {
                        if (!pdym.getBoolean("isreplace")) continue;
                        this.insert(replacePlanLoad, keySet, pidIndex, pdym, repConfigSet);
                    }
                }
            }
        }
    }

    private void insert(DynamicObject replacePlanLoad, Set<String> keySet, int pidIndex, DynamicObject pdym, Map<String, Boolean> repConfigSet) {
        DynamicObject[] dymList;
        DynamicObjectCollection dymCol = replacePlanLoad.getDynamicObjectCollection("repmaterentry");
        for (DynamicObject dym : dymList = this.sortByReppriority(dymCol)) {
            String replaceCompareString = StockCulUtils.getReplaceCompareString((DynamicObject)dym, repConfigSet);
            Date demandDate = (Date)this.getModel().getValue("demanddate", pidIndex);
            Date validDate = dym.getDate("repeffectdate");
            Date invalidDate = dym.getDate("repinvaliddate");
            if (demandDate.compareTo(validDate) < 0 || demandDate.compareTo(invalidDate) > 0 || keySet.contains(replaceCompareString)) continue;
            int insertEntryRow = this.getModel().insertEntryRow("stockentry", pidIndex);
            this.setReplaceValue(insertEntryRow, dym, pidIndex, replacePlanLoad, pdym, repConfigSet);
        }
    }

    private int getSameReplacePidIndex(DynamicObject firstDym) {
        int pidIndex = -1;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || !"0".equals(entry.getString("pid")) || !entry.getBoolean("ismainreplace")) continue;
            pidIndex = i;
        }
        if (pidIndex == -1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u66ff\u4ee3\u4e3b\u6599\u3002", (String)"ReplaceUpdateEdit_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        return pidIndex;
    }

    private int[] getSameReplaceRows(DynamicObject firstDym) {
        ArrayList<String> errExistList = new ArrayList<String>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject("replaceplan");
            if (replacePlan == null || !replacePlan.getPkValue().equals(firstDym.getPkValue()) || "0".equals(entry.getString("pid"))) continue;
            errExistList.add(Integer.toString(i));
        }
        int[] replaceRows = new int[errExistList.size()];
        for (int i = 0; i < errExistList.size(); ++i) {
            replaceRows[i] = Integer.parseInt((String)errExistList.get(i));
        }
        return replaceRows;
    }

    private DynamicObject[] sortByReppriority(DynamicObjectCollection dymCol) {
        int i;
        DynamicObject[] dymList = new DynamicObject[dymCol.size()];
        for (i = 0; i < dymCol.size(); ++i) {
            dymList[i] = (DynamicObject)dymCol.get(i);
        }
        for (i = 0; i < dymList.length - 1; ++i) {
            for (int j = 0; j < dymList.length - 1 - i; ++j) {
                if (dymList[j].getInt("reppriority") <= dymList[j + 1].getInt("reppriority")) continue;
                DynamicObject temp = dymList[j];
                dymList[j] = dymList[j + 1];
                dymList[j + 1] = temp;
            }
        }
        return dymList;
    }

    private void setReplaceValue(int insertEntryRow, DynamicObject dymList, int curreuntIndex, DynamicObject replacePlan, DynamicObject dym, Map<String, Boolean> repConfigSet) {
        String isquotacontrol;
        DynamicObject stockEntry = this.getModel().getEntryRowEntity("stockentry", curreuntIndex);
        Map res = StockCulUtils.calRepRes((DynamicObject)dymList, (DynamicObject)dym, (DynamicObject)stockEntry, repConfigSet);
        this.getPageCache().put("isIgnoreChangeMftstock", "true");
        this.getModel().setValue("replaceplan", replacePlan.getPkValue(), insertEntryRow);
        this.getModel().setValue("priority", dymList.get("reppriority"), insertEntryRow);
        DynamicObject pro = (DynamicObject)this.getModel().getValue("productid");
        DynamicObject materialold = dymList.getDynamicObject("repmaterial");
        if (materialold == null) {
            return;
        }
        DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("org");
        if (mtfOrg == null) {
            return;
        }
        DynamicObject masterid = materialold.getDynamicObject("masterid");
        QFilter filter = new QFilter("masterid", "=", masterid.getPkValue());
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)((Long)mtfOrg.getPkValue()));
        DynamicObject materialinfoold = BusinessDataServiceHelper.loadSingle((Object)materialold.getPkValue(), (String)"bd_materialmftinfo");
        DynamicObject[] materialinfos = BusinessDataServiceHelper.load((String)"bd_materialmftinfo", (String)"supplyorgunitid,warehouse,location,outstorageunit,outwarehouse,outwarelocation,issuemode,isbackflush,iskeypart,isquotacontrol,issinhighlimit,issinlowlimit,isstockallot,isbulkmaterial", (QFilter[])new QFilter[]{filter, orgFilter});
        DynamicObject materialinfo = materialinfoold;
        if (materialinfos != null && materialinfos.length > 0) {
            materialinfo = materialinfos[0];
        }
        if (pro != null && pro.getPkValue().equals(materialinfo.getPkValue())) {
            this.getModel().setValue("rework", (Object)Boolean.TRUE, insertEntryRow);
        }
        this.getModel().setValue("materialid", (Object)materialinfo, insertEntryRow);
        this.getModel().setValue("materielmasterid", materialinfo.get("masterid"), insertEntryRow);
        this.getModel().setValue("childauxpropertyid", dymList.get("repauxpty"), insertEntryRow);
        this.getModel().setValue("bomreversion", dymList.get("repbomversion"), insertEntryRow);
        this.getModel().setValue("ismainreplace", dymList.get("isrep"), insertEntryRow);
        this.getModel().setValue("materialunitid", dymList.get("repunit"), insertEntryRow);
        this.getModel().setValue("qtynumerator", res.get("mole"), insertEntryRow);
        this.getModel().setValue("qtydenominator", res.get("deno"), insertEntryRow);
        this.getModel().setValue("qtytype", stockEntry.get("qtytype"), insertEntryRow);
        this.getModel().setValue("useratio", (Object)0, insertEntryRow);
        this.getModel().setValue("fixscrap", stockEntry.get("fixscrap"), insertEntryRow);
        this.getModel().setValue("scraprate", stockEntry.get("scraprate"), insertEntryRow);
        this.getModel().setValue("wastagerateformula", stockEntry.get("wastagerateformula"), insertEntryRow);
        this.getModel().setValue("isbomextend", (Object)Boolean.FALSE, insertEntryRow);
        this.getModel().setValue("iscannegative", stockEntry.get("iscannegative"), insertEntryRow);
        this.getModel().setValue("supplymode", stockEntry.get("supplymode"), insertEntryRow);
        this.getModel().setValue("supplierid", stockEntry.get("supplierid"), insertEntryRow);
        this.getModel().setValue("parentid", stockEntry.getPkValue(), insertEntryRow);
        if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"pom_mftstock")) {
            this.getModel().setValue("workprocedureid", stockEntry.get("workprocedureid"), insertEntryRow);
            this.getModel().setValue("oprno", stockEntry.get("oprno"), insertEntryRow);
            this.getModel().setValue("processseq", stockEntry.get("processseq"), insertEntryRow);
            this.getModel().setValue("oprworkcenter", stockEntry.get("oprworkcenter"), insertEntryRow);
            this.getModel().setValue("machiningtype", stockEntry.get("machiningtype"), insertEntryRow);
            this.getModel().setValue("outsupplier", stockEntry.get("outsupplier"), insertEntryRow);
            this.getModel().setValue("workstation", stockEntry.get("workstation"), insertEntryRow);
        }
        this.getModel().setValue("demanddate", stockEntry.get("demanddate"), insertEntryRow);
        this.getModel().setValue("leadtime", stockEntry.get("leadtime"), insertEntryRow);
        if (StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"pom_mftstock") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"om_mftstock") || StringUtils.equals((CharSequence)this.getModel().getDataEntityType().getName(), (CharSequence)"prop_mftstock")) {
            this.getModel().setValue("parentmaterial", stockEntry.get("parentmaterial"), insertEntryRow);
            this.getModel().setValue("pstockentryid", stockEntry.get("pstockentryid"), insertEntryRow);
        }
        this.getModel().setValue("supplyorgid", materialinfo.get("supplyorgunitid"), insertEntryRow);
        String entityName = this.getModel().getDataEntityType().getName();
        this.getModel().setValue("warehouseid", materialinfo.get("warehouse"), insertEntryRow);
        this.getModel().setValue("location", materialinfo.get("location"), insertEntryRow);
        this.getModel().setValue("outorgunitid", materialinfo.get("outstorageunit"), insertEntryRow);
        this.getModel().setValue("outwarehouseid", materialinfo.get("outwarehouse"), insertEntryRow);
        this.getModel().setValue("outlocation", materialinfo.get("outwarelocation"), insertEntryRow);
        String modestring = MPDMMftGenStocksUtils.getIssuemode((Object)materialinfo.get("issuemode"));
        this.getModel().setValue("issuemode", (Object)modestring, insertEntryRow);
        this.getModel().setValue("isbackflush", materialinfo.get("isbackflush"), insertEntryRow);
        MPDMMftGenStocksUtils.setbackflush((Object)materialinfo.get("isbackflush"), (int)insertEntryRow, (IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"pom_mftstock")) {
            MPDMMftGenStocksUtils.setStockEntryWarehouse((DynamicObject)mtfOrg, (String)entityName, (IDataModel)this.getModel(), (int)insertEntryRow);
        }
        this.getModel().setValue("iskeypart", materialinfo.get("iskeypart"), insertEntryRow);
        String string = isquotacontrol = materialinfo.get("isquotacontrol") == null ? "" : materialinfo.getString("isquotacontrol");
        if (StringUtils.equals((CharSequence)isquotacontrol, (CharSequence)"true")) {
            this.getModel().setValue("overissuecontrl", (Object)"B", insertEntryRow);
        } else {
            this.getModel().setValue("overissuecontrl", (Object)"A", insertEntryRow);
        }
        BigDecimal issinhighlimit = materialinfo.get("issinhighlimit") == null ? BigDecimal.ZERO : materialinfo.getBigDecimal("issinhighlimit");
        this.getModel().setValue("issinhighlimit", (Object)issinhighlimit, insertEntryRow);
        BigDecimal issinlowlimit = materialinfo.get("issinlowlimit") == null ? BigDecimal.ZERO : materialinfo.getBigDecimal("issinlowlimit");
        this.getModel().setValue("issinlowlimit", (Object)issinlowlimit, insertEntryRow);
        this.getModel().setValue("isstockallot", materialinfo.get("isstockallot"), insertEntryRow);
        this.getModel().setValue("isbulkmaterial", materialinfo.get("isbulkmaterial"), insertEntryRow);
        this.getPageCache().put("isIgnoreChangeMftstock", "false");
    }
}

