/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.mmcserv;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MmcServiceConfigFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ATMOP = "atmop";
    private static final String KEY_OPSEL = "opsel";
    private static final String KEY_OPNUM = "opnum";
    private static final String KEY_SELECTEDROWIDX = "selectedRowidx";
    private static final String KEY_DATAENTITYID = "dataentityid";
    private static final String KEY_ISSHUTPC = "isShutPc";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection doc = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        for (DynamicObject doo : doc) {
            DynamicObject atmop = doo.getDynamicObject(KEY_ATMOP);
            if (atmop == null) continue;
            this.dealValEnable(atmop, doo.getInt("seq") - 1);
        }
        this.initOpsel();
    }

    private void initOpsel() {
        DynamicObjectCollection oplist = this.oplist();
        ComboEdit opsel = (ComboEdit)this.getView().getControl(KEY_OPSEL);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (oplist != null) {
            String number = (String)this.getModel().getValue("number");
            for (DynamicObject op : oplist) {
                if (op.getBoolean("isset") && !op.getString(KEY_OPNUM).equals(number)) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(op.getString("opname")));
                item.setValue(op.getString(KEY_OPNUM));
                items.add(item);
            }
            opsel.setComboItems(items);
            if (items.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u652f\u6301\u7684\u64cd\u4f5c\u5df2\u5168\u90e8\u8bbe\u7f6e\u5236\u9020\u4e91\u670d\u52a1\u3002", (String)"MmcServiceConfigFormPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            if (number != null && StringUtils.isNotBlank((CharSequence)number)) {
                this.getModel().setValue(KEY_OPSEL, (Object)number);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_OPSEL});
                this.getModel().setDataChanged(false);
            }
        } else {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"MmcServiceConfigFormPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0])));
            item.setValue("");
            items.add(item);
            opsel.setComboItems(items);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    private DynamicObjectCollection oplist() {
        if (this.getModel().getValue("group") != null) {
            long group = (Long)((DynamicObject)this.getModel().getValue("group")).getPkValue();
            DynamicObject gp = BusinessDataServiceHelper.loadSingle((String)"mpdm_atmocfggp", (String)"entryentity,entryentity.opnum,entryentity.opname,entryentity.isset", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)group)});
            if (gp != null) {
                return gp.getDynamicObjectCollection(KEY_ENTRYENTITY);
            }
        } else {
            this.getView().close();
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"donothing", (CharSequence)formOperate.getOperateKey())) {
            String idx = this.getPageCache().get(KEY_SELECTEDROWIDX);
            this.openInparam(idx);
            EntryGrid e = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            e.selectRows(Integer.parseInt(idx));
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_ENTRYENTITY, (CharSequence)entryGrid.getKey())) {
            this.getPageCache().put(KEY_SELECTEDROWIDX, String.valueOf(evt.getRow()));
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_ENTRYENTITY, (CharSequence)entryGrid.getKey())) {
            this.getPageCache().put(KEY_SELECTEDROWIDX, String.valueOf(evt.getRow()));
        }
    }

    private void openInparam(String idx) {
        DynamicObject atmop;
        if (idx != null && !kd.bos.util.StringUtils.isBlank((String)idx) && (atmop = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, Integer.parseInt(idx)).getDynamicObject(KEY_ATMOP)) != null) {
            String billnum = atmop.getString("dataentitynum");
            if (StringUtils.isBlank((CharSequence)billnum)) {
                this.showInparamForm(null, idx, this.getModel().getValue("inparam", Integer.parseInt(idx)).toString());
            } else {
                this.showInparamForm(billnum, idx, this.getModel().getValue(KEY_DATAENTITYID, Integer.parseInt(idx)).toString());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("1".equals(this.getPageCache().get(KEY_ISSHUTPC))) {
            return;
        }
        this.getPageCache().put(KEY_ISSHUTPC, "1");
        String fieldKey = e.getProperty().getName();
        int rowindex = e.getChangeSet()[0].getRowIndex();
        Object val = e.getChangeSet()[0].getNewValue();
        if (KEY_ATMOP.equals(fieldKey)) {
            if (val != null && !(val instanceof DynamicObject)) {
                this.getModel().setValue(fieldKey, null, rowindex);
                return;
            }
            this.dealValEnable(val, rowindex);
        }
        if (KEY_OPSEL.equals(fieldKey) && val != null && !StringUtils.isBlank((Object)val)) {
            this.getModel().setValue("number", val);
            String name = this.loadOpname(val);
            this.getModel().setValue("name", (Object)name);
        }
        this.getPageCache().put(KEY_ISSHUTPC, "0");
    }

    private String loadOpname(Object val) {
        DynamicObjectCollection doc = this.oplist();
        for (DynamicObject dd : doc) {
            if (!dd.getString(KEY_OPNUM).equals(val.toString())) continue;
            return dd.getString("opname");
        }
        return null;
    }

    private void dealValEnable(Object val, int rowindex) {
        if (val != null) {
            DynamicObject value = (DynamicObject)val;
            this.getModel().setValue("opdescrip", value.get("opdescrip"), rowindex);
        }
    }

    private void showInparamForm(String billnum, String ridx, String val) {
        String status = (String)this.getModel().getValue("status");
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", billnum == null ? "mpdm_atmosv" : billnum);
        if (billnum != null) {
            if (!StringUtils.isBlank((CharSequence)val)) {
                para.put("pkId", val);
            } else if ("C".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u67e5\u770b\u7684\u53c2\u6570\u6570\u636e\u3002", (String)"MmcServiceConfigFormPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setCustomParam("key", (Object)(billnum == null ? "inparam" : KEY_DATAENTITYID));
        showParameter.setCustomParam("rowidx", (Object)ridx);
        showParameter.setCustomParam("val", (Object)val);
        showParameter.setCustomParam("status", (Object)status);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "inparamform");
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        super.closedCallBack(args);
        if (StringUtils.equals((CharSequence)args.getActionId(), (CharSequence)"inparamform")) {
            if (args.getReturnData() == null) {
                return;
            }
            Object data = args.getReturnData();
            this.getModel().setValue(KEY_DATAENTITYID, data);
            this.getModel().setValue("issetinparam", (Object)true);
        }
    }
}

