/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.ordermerge;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.OrderMergeHelper;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrderMergeFromPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit locationmg = (BasedataEdit)this.getView().getControl("locationmg");
        locationmg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehousemg = (BasedataEdit)this.getView().getControl("warehousemerge");
        warehousemg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inwardeptmerge = (BasedataEdit)this.getView().getControl("inwardeptmerge");
        inwardeptmerge.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit proddeptmerge = (BasedataEdit)this.getView().getControl("proddeptmerge");
        proddeptmerge.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter;
        DynamicObject org;
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("locationmg".equals(source)) {
            ArrayList<Long> locationList = new ArrayList<Long>();
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehousemerge");
            if (warehouse != null) {
                QFilter idFilter = new QFilter("id", "=", warehouse.getPkValue());
                DataSet wareHosedataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,entryentity,entryentity.location", (QFilter[])idFilter.toArray(), null);
                for (Row row : wareHosedataSet) {
                    Long aLong = row.getLong("entryentity.location");
                    locationList.add(aLong);
                }
            }
            ListShowParameter listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            Long[] qfilter = new QFilter("id", "in", locationList);
            listShowParameter2.getListFilterParameter().getQFilters().add(qfilter);
        }
        if ("warehousemerge".equals(source)) {
            QFilter qfilter;
            org = (DynamicObject)this.getModel().getValue("inwardeptmerge");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5165\u5e93\u7ec4\u7ec7\u201d\u3002", (String)"OrderMergeFromPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long[] warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)Long.parseLong(org.getPkValue().toString()));
            ArrayList<Long> ids = new ArrayList<Long>();
            for (Long warehouseid : warehouseids) {
                if (warehouseid == null) continue;
                ids.add(warehouseid);
            }
            if (!ids.isEmpty()) {
                listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                qfilter = new QFilter("id", "in", ids);
                listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
            } else {
                listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                qfilter = new QFilter("id", "=", (Object)Long.valueOf("0"));
                listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
            }
        }
        if ("inwardeptmerge".equals(source)) {
            DynamicObject mftmaterial = (DynamicObject)this.getModel().getValue("productmerge");
            if (mftmaterial == null || "0".equals(mftmaterial.getPkValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"OrderMergeFromPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter3 = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter3.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter3.setMultiSelect(false);
            DynamicObject org2 = (DynamicObject)this.getModel().getValue("org");
            DynamicObject entrustdept = (DynamicObject)this.getModel().getValue("entrustdept");
            ArrayList<Long> inwareOrgFilter = new ArrayList<Long>(16);
            if (entrustdept != null) {
                inwareOrgFilter.addAll(this.getInwareOrgFilter((Long)entrustdept.getPkValue()));
            }
            if (org2 != null) {
                inwareOrgFilter.addAll(this.getInwareOrgFilter((Long)org2.getPkValue()));
            }
            listShowParameter3.getListFilterParameter().getQFilters().add(new QFilter("id", "in", inwareOrgFilter));
        }
        if ("proddeptmerge".equals(source)) {
            org = (DynamicObject)this.getModel().getValue("org");
            Long orgId = 0L;
            if (org != null) {
                orgId = (Long)org.getPkValue();
            }
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshopsetup", (Long)orgId);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"mpdm_workshopsetup", (String)"workshoporg", (QFilter[])new QFilter[]{qFilter});
            if (!col.isEmpty()) {
                HashSet<Long> idSet = new HashSet<Long>(col.size());
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject obj = (DynamicObject)col.get(i);
                    idSet.add(Long.valueOf(obj.getString("workshoporg")));
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            } else {
                List toOrg = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId);
                if (!toOrg.isEmpty()) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)toOrg));
                }
            }
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("warehousemerge".equals(propertyName)) {
            this.getModel().setValue("locationmg", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotBlank((CharSequence)parentView.getPageCache().get("ConvertOperationResult"))) {
            String isSaved;
            Object billstatusObj = this.getModel().getValue("billstatus");
            String billStatus = billstatusObj == null ? "" : billstatusObj.toString();
            String string = isSaved = this.getPageCache().get("isSaved") == null ? "false" : this.getPageCache().get("isSaved");
            if (parentView != null && StringUtils.equals((CharSequence)"A", (CharSequence)billStatus) && StringUtils.equals((CharSequence)"false", (CharSequence)isSaved)) {
                HashSet<Object> idSet = new HashSet<Object>();
                idSet.add(this.getModel().getValue("id"));
                boolean isExists = QueryServiceHelper.exists((String)"pom_ordermerge", (Object)this.getModel().getValue("id"));
                if (isExists) {
                    OrderMergeHelper.callBillOperation((String)"pom_ordermerge", idSet, (String)"delete");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        boolean success = e.getOperationResult().isSuccess();
        if (!success) {
            return;
        }
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            this.getPageCache().put("isSaved", "true");
        }
    }

    private List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        if (this.checkOrgIsAccount(mftOrg)) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)mftOrg);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
            if (fromOrgs.isEmpty()) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                Long longFromOrg = (Long)((Object)fromOrg);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            } else {
                Long fromOrg = (Long)fromOrgs.get(0);
                List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg);
                if (!allToOrg.isEmpty()) {
                    filterList.addAll(allToOrg);
                }
            }
        }
        return filterList;
    }

    private boolean checkOrgIsAccount(Long orgid) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org");
        return dyOrg.getBoolean("fisaccounting");
    }
}

