/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.productConfig;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bd.mpdm.common.page.Element;
import kd.bd.mpdm.common.page.EntryElement;
import kd.bd.mpdm.common.page.TextElement;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ConfigmatrixEditPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
BeforeF7SelectListener,
RowClickEventListener,
CellClickListener {
    private static final String FEATURE_ENTRY = "featureentry";
    private static final String SHOW_MATRIX_ENTRY = "entryentity";
    private static final String MATRIX_ENTRY = "matrixentry";
    private static final String ENTRY_FEATUREID = "featureid";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{SHOW_MATRIX_ENTRY});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.featureIdPropertyChanged(true);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        model.beginInit();
        this.storeTransfShowData();
        model.endInit();
        this.getView().updateView(SHOW_MATRIX_ENTRY);
        this.setBizChange();
    }

    private void storeTransfShowData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid entryGrid = this.getEntryElement().getControl(this.getView());
        DynamicObjectCollection matrixEntryDOC = model.getEntryEntity(MATRIX_ENTRY);
        if (matrixEntryDOC == null || matrixEntryDOC.isEmpty()) {
            return;
        }
        model.beginInit();
        for (int i = 0; i < matrixEntryDOC.size(); ++i) {
            DynamicObject matrixEntryDO = (DynamicObject)matrixEntryDOC.get(i);
            if (matrixEntryDO == null) continue;
            this.storeToShowMatrixEntry(matrixEntryDO);
        }
        model.endInit();
    }

    private void storeToShowMatrixEntry(DynamicObject matrixEntryDO) {
        if (matrixEntryDO == null) {
            return;
        }
        int rowindex = matrixEntryDO.getInt("rowindex");
        DynamicObject featureColumnIdDO = matrixEntryDO.getDynamicObject("featurecolumnid");
        Long featureValueID = matrixEntryDO.getLong("featurevalueid");
        String featureValue = matrixEntryDO.getString("featurevalue");
        String featureValueName = matrixEntryDO.getString("featurevaluename");
        String group = matrixEntryDO.getString("group");
        IDataModel model = this.getModel();
        EntryGrid entryGrid = this.getEntryElement().getControl(this.getView());
        DynamicObjectCollection showMatrixEntryDOC = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        int rowIndex = -1;
        if (showMatrixEntryDOC.isEmpty()) {
            if (rowindex > 0) {
                rowIndex = model.createNewEntryRow(SHOW_MATRIX_ENTRY);
            }
        } else {
            int size = showMatrixEntryDOC.size();
            if (size < rowindex) {
                for (int i = 0; i < rowindex - size; ++i) {
                    rowIndex = model.createNewEntryRow(SHOW_MATRIX_ENTRY);
                }
            }
        }
        if (!showMatrixEntryDOC.isEmpty() && rowindex > 0) {
            DynamicObject showMatrixEntryDO;
            DataEntityPropertyCollection properties = showMatrixEntryDOC.getDynamicObjectType().getProperties();
            String columnKey = "";
            if (featureColumnIdDO != null && StringUtils.isNotEmpty((CharSequence)featureColumnIdDO.getString("number"))) {
                columnKey = featureColumnIdDO.getString("number").toLowerCase();
            }
            if ((showMatrixEntryDO = model.getEntryRowEntity(SHOW_MATRIX_ENTRY, rowindex - 1)) != null && properties.containsKey((Object)columnKey)) {
                showMatrixEntryDO.set(columnKey, (Object)featureValue);
                showMatrixEntryDO.set(columnKey + "_id", featureValueID == 0L ? "" : featureValueID);
                showMatrixEntryDO.set(columnKey + "_name", (Object)featureValueName);
                showMatrixEntryDO.set("group_show", (Object)group);
            }
            if (rowIndex > -1 && showMatrixEntryDO != null) {
                BindingContext bindCtx = new BindingContext(showMatrixEntryDO.getDataEntityType(), showMatrixEntryDO, rowindex - 1);
                List rowValues = entryGrid.getRowBindValue(bindCtx);
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.appendRow(SHOW_MATRIX_ENTRY, rowValues);
            }
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid control;
        EntryGrid matrixEntry;
        super.registerListener(e);
        BasedataEdit featureID = (BasedataEdit)this.getControl(ENTRY_FEATUREID);
        if (featureID != null) {
            featureID.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((matrixEntry = (EntryGrid)this.getControl(MATRIX_ENTRY)) != null) {
            matrixEntry.addCellClickListener((CellClickListener)this);
        }
        if ((control = (EntryGrid)this.getView().getControl(SHOW_MATRIX_ENTRY)) != null) {
            control.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        int row = event.getRow();
        ListShowParameter parameter = (ListShowParameter)event.getFormShowParameter();
        switch (propertyName) {
            case "featureid": {
                QFilter qFilter = this.beforeF7FeatrueId(row);
                if (qFilter == null) break;
                parameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    private QFilter beforeF7FeatrueId(int row) {
        QFilter qFilter = null;
        IDataModel model = this.getModel();
        DynamicObjectCollection featureEntryDOC = model.getEntryEntity(FEATURE_ENTRY);
        HashSet<Long> featurePkSet = new HashSet<Long>(4);
        for (int i = 0; i < featureEntryDOC.size(); ++i) {
            if (row == i) continue;
            DynamicObject featureEntryDO = (DynamicObject)featureEntryDOC.get(i);
            DynamicObject entryFeatureDO = null;
            if (featureEntryDO != null) {
                entryFeatureDO = featureEntryDO.getDynamicObject(ENTRY_FEATUREID);
            }
            if (entryFeatureDO == null) continue;
            featurePkSet.add(entryFeatureDO.getLong("id"));
        }
        if (!featurePkSet.isEmpty()) {
            qFilter = new QFilter("id", "not in", featurePkSet);
        }
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String propertyName = e.getProperty().getName();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            this.propertyChanged(propertyName, changeData);
        }
    }

    private void propertyChanged(String propertyName, ChangeData changeData) {
        switch (propertyName) {
            case "featureid": {
                this.clearEntryData();
                this.featureIdPropertyChanged(false);
                this.callBackWriteShowMatrixEntry();
                break;
            }
            case "featurecolumnid": {
                int rowIndex = changeData.getRowIndex();
                Object newValue = changeData.getNewValue();
                if (newValue instanceof DynamicObject) {
                    String number = ((DynamicObject)newValue).getString("number");
                    String name = ((DynamicObject)newValue).getString("name");
                    this.getModel().setValue("columnname", (Object)(name + "(" + number + ")"), rowIndex);
                }
                this.getView().updateView(MATRIX_ENTRY);
            }
        }
    }

    private void callBackWriteShowMatrixEntry() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection matrixEntryDOC = model.getEntryEntity(MATRIX_ENTRY);
        if (matrixEntryDOC == null || matrixEntryDOC.isEmpty()) {
            return;
        }
        model.beginInit();
        for (int i = 0; i < matrixEntryDOC.size(); ++i) {
            DynamicObject matrixEntryDO = (DynamicObject)matrixEntryDOC.get(i);
            if (matrixEntryDO == null) continue;
            this.writeShoMatrixEntry(matrixEntryDO);
        }
        model.endInit();
        view.updateView(SHOW_MATRIX_ENTRY);
    }

    private void writeShoMatrixEntry(DynamicObject matrixEntryDO) {
        if (matrixEntryDO == null) {
            return;
        }
        int rowindex = matrixEntryDO.getInt("rowindex");
        DynamicObject featureColumnIdDO = matrixEntryDO.getDynamicObject("featurecolumnid");
        Long featureValueID = matrixEntryDO.getLong("featurevalueid");
        String featureValue = matrixEntryDO.getString("featurevalue");
        String featureValueName = matrixEntryDO.getString("featurevaluename");
        String group = matrixEntryDO.getString("group");
        IDataModel model = this.getModel();
        DynamicObjectCollection showMatrixEntryDOC = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        if (showMatrixEntryDOC.isEmpty()) {
            if (rowindex > 0) {
                model.createNewEntryRow(SHOW_MATRIX_ENTRY);
            }
        } else {
            int size = showMatrixEntryDOC.size();
            if (size < rowindex) {
                for (int i = 0; i < rowindex - size; ++i) {
                    model.createNewEntryRow(SHOW_MATRIX_ENTRY);
                }
            }
        }
        if (!showMatrixEntryDOC.isEmpty() && rowindex > 0) {
            DataEntityPropertyCollection properties = showMatrixEntryDOC.getDynamicObjectType().getProperties();
            String columnKey = "";
            if (featureColumnIdDO != null && StringUtils.isNotEmpty((CharSequence)featureColumnIdDO.getString("number"))) {
                columnKey = featureColumnIdDO.getString("number").toLowerCase();
            }
            if (properties.containsKey((Object)columnKey) && model.getProperty(columnKey) != null) {
                model.setValue(columnKey, (Object)featureValue, rowindex - 1);
                model.setValue(columnKey + "_id", featureValueID == 0L ? "" : featureValueID, rowindex - 1);
                model.setValue(columnKey + "_name", (Object)featureValueName, rowindex - 1);
                model.setValue("group_show", (Object)group, rowindex - 1);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        boolean success = false;
        if (operationResult != null) {
            success = operationResult.isSuccess();
        }
        switch (operateKey) {
            case "deleterow": {
                this.getModel().beginInit();
                this.clearEntryData();
                this.featureIdPropertyChanged(false);
                this.callBackWriteShowMatrixEntry();
                this.getModel().endInit();
                break;
            }
            case "submit": 
            case "save": {
                this.getModel().beginInit();
                this.callBackWriteShowMatrixEntry();
                this.getModel().endInit();
                this.getView().updateView(SHOW_MATRIX_ENTRY);
                if (!success) break;
                this.setBizChange();
            }
        }
    }

    private void setBizChange() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(SHOW_MATRIX_ENTRY);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryEntity.get(i);
            for (int j = 0; j < properties.size(); ++j) {
                entryDO.getDataEntityState().setBizChanged(((IDataEntityProperty)properties.get(j)).getOrdinal(), false);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": 
            case "submit": {
                this.deleteAllEmptyRowToShowEntry();
                this.transfMatrixEntryData();
            }
        }
    }

    private void transfMatrixEntryData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        int rowCount = entryEntity.getRowCount();
        DynamicObjectCollection matrixEntryDOC = model.getEntryEntity(MATRIX_ENTRY);
        if (matrixEntryDOC != null) {
            model.deleteEntryData(MATRIX_ENTRY);
        }
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject matrixDO = (DynamicObject)entryEntity.get(i);
            this.writeMatrixData(model, matrixDO);
        }
        this.getView().updateView(MATRIX_ENTRY);
    }

    private void clearEntryData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        int rowCount = entryEntity.getRowCount();
        int[] rows = new int[rowCount];
        DynamicObjectCollection matrixEntryDOC = model.getEntryEntity(MATRIX_ENTRY);
        if (matrixEntryDOC != null) {
            model.deleteEntryData(MATRIX_ENTRY);
        }
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = i;
            DynamicObject matrixDO = (DynamicObject)entryEntity.get(i);
            this.writeMatrixData(model, matrixDO);
        }
        this.getView().updateView(MATRIX_ENTRY);
        model.deleteEntryRows(SHOW_MATRIX_ENTRY, rows);
        this.deleteShowMatrixProp(model);
    }

    private void deleteShowMatrixProp(IDataModel model) {
        Map<String, DynamicObject> pageCacheFeatue = this.getPageCacheFeatue();
        if (pageCacheFeatue == null) {
            return;
        }
        for (Map.Entry<String, DynamicObject> entry : pageCacheFeatue.entrySet()) {
            String propKey = entry.getKey();
            DataEntityPropertyCollection properties = model.getEntryEntity(SHOW_MATRIX_ENTRY).getDynamicObjectType().getProperties();
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            IDataEntityProperty propertyID = (IDataEntityProperty)properties.get((Object)(propKey + "_id"));
            IDataEntityProperty propertyName = (IDataEntityProperty)properties.get((Object)(propKey + "_name"));
            if (property != null) {
                properties.remove((Object)property);
            }
            if (propertyID != null) {
                properties.remove((Object)propertyID);
            }
            if (propertyName == null) continue;
            properties.remove((Object)propertyName);
        }
    }

    private void writeMatrixData(IDataModel model, DynamicObject matrixDO) {
        if (model == null || matrixDO == null) {
            return;
        }
        Set<String> featureColumns = this.getFeatureDefNumber();
        DataEntityPropertyCollection properties = matrixDO.getDynamicObjectType().getProperties();
        Map<String, DynamicObject> pageCacheFeatue = this.getPageCacheFeatue();
        if (pageCacheFeatue == null) {
            return;
        }
        for (Map.Entry<String, DynamicObject> entry : pageCacheFeatue.entrySet()) {
            String featureIDStr;
            String fieldName = entry.getKey();
            if (featureColumns == null || !featureColumns.contains(fieldName)) continue;
            DynamicObject featureDefDO = entry.getValue();
            int newEntryRow = model.createNewEntryRow(MATRIX_ENTRY);
            int seq = matrixDO.getInt("seq");
            String groupShow = matrixDO.getString("group_show");
            model.setValue("rowindex", (Object)seq, newEntryRow);
            model.setValue("group", (Object)groupShow, newEntryRow);
            Long featureDefPK = 0L;
            if (featureDefDO != null) {
                featureDefPK = featureDefDO.getLong("id");
                String name = featureDefDO.getString("name");
                String number = featureDefDO.getString("number");
                model.setValue("featurecolumnid", (Object)featureDefPK, newEntryRow);
                model.setValue("columnname", (Object)(name + "(" + number + ")"), newEntryRow);
            }
            if (properties.containsKey((Object)fieldName)) {
                String featureValue = matrixDO.getString(fieldName);
                model.setValue("featurevalue", (Object)featureValue, newEntryRow);
            }
            if (properties.containsKey((Object)(fieldName + "_id")) && StringUtils.isNotEmpty((CharSequence)(featureIDStr = matrixDO.getString(fieldName + "_id"))) && Pattern.matches("^[0-9]*$", featureIDStr)) {
                model.setValue("featurevalueid", (Object)Long.parseLong(featureIDStr), newEntryRow);
            }
            if (!properties.containsKey((Object)(fieldName + "_name"))) continue;
            String featureValueName = matrixDO.getString(fieldName + "_name");
            model.setValue("featurevaluename", (Object)featureValueName, newEntryRow);
        }
    }

    private Set<String> getFeatureDefNumber() {
        IDataModel model = this.getModel();
        HashSet<String> featureColSet = new HashSet<String>(4);
        DynamicObjectCollection featureEntryDOC = model.getEntryEntity(FEATURE_ENTRY);
        for (int i = 0; i < featureEntryDOC.size(); ++i) {
            String number;
            DynamicObject featurEntruDO = (DynamicObject)featureEntryDOC.get(i);
            DynamicObject featureDO = featurEntruDO.getDynamicObject(ENTRY_FEATUREID);
            if (featureDO == null || !StringUtils.isNotEmpty((CharSequence)(number = featureDO.getString("number")))) continue;
            featureColSet.add(number.toLowerCase());
        }
        return featureColSet;
    }

    private void featureIdPropertyChanged(boolean isBeforeBindData) {
        List<DynamicObject> featureDefList;
        IDataModel model = this.getModel();
        if (isBeforeBindData) {
            Object pkId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
            featureDefList = this.getSQLFeatureDefinition(pkId);
        } else {
            featureDefList = this.getFeatureDefinition(model);
        }
        List<Element> elementList = this.getElementList(featureDefList);
        this.cacheEntryElement(elementList);
        this.build();
        this.clearDataChanged();
        if (isBeforeBindData) {
            MainEntityType dataEntityType = this.getModel().getDataEntityType();
            for (int i = 0; i < elementList.size(); ++i) {
                Element element = elementList.get(i);
                String name = element.getName();
                dataEntityType.findProperty(name);
                DynamicProperty property = element.getProperty();
                dataEntityType.addProperty(property);
            }
        }
    }

    private List<DynamicObject> getSQLFeatureDefinition(Object pkId) {
        ArrayList<DynamicObject> featureDefList = new ArrayList<DynamicObject>(2);
        if (pkId == null) {
            return featureDefList;
        }
        QFilter qFilter = new QFilter("id", "=", pkId);
        DynamicObject configMatrixDO = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"mpdm_configmatrix");
        if (configMatrixDO == null) {
            return featureDefList;
        }
        DynamicObjectCollection featureEntryDOC = configMatrixDO.getDynamicObjectCollection(FEATURE_ENTRY);
        if (featureEntryDOC == null || featureEntryDOC.size() == 0) {
            return featureDefList;
        }
        for (int i = 0; i < featureEntryDOC.size(); ++i) {
            DynamicObject featureDO;
            DynamicObject featureEntryDO = (DynamicObject)featureEntryDOC.get(i);
            if (featureEntryDO == null || (featureDO = featureEntryDO.getDynamicObject(ENTRY_FEATUREID)) == null) continue;
            featureDefList.add(featureDO);
        }
        return featureDefList;
    }

    private void clearDataChanged() {
        this.getModel().setDataChanged(false);
    }

    private EntryElement cacheEntryElement(List<Element> elementList) {
        EntryElement entryElement = new EntryElement(SHOW_MATRIX_ENTRY);
        entryElement.setItems(elementList);
        String s = SerializationUtils.serializeToBase64((Object)entryElement);
        this.putCache("entry_element", s);
        return entryElement;
    }

    public void build() {
        this.getEntryElement().build(this.getView());
    }

    private EntryElement getEntryElement() {
        String elements = this.getCache("entry_element");
        if (elements == null) {
            ArrayList<Element> elementList = new ArrayList<Element>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private void putCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(SHOW_MATRIX_ENTRY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entityName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)SHOW_MATRIX_ENTRY, (CharSequence)entityName)) {
            DynamicObjectCollection showMatrixEntryDOC = model.getEntryEntity(SHOW_MATRIX_ENTRY);
            DataEntityPropertyCollection properties = showMatrixEntryDOC.getDynamicObjectType().getProperties();
            if (showMatrixEntryDOC != null && !showMatrixEntryDOC.isEmpty()) {
                int maxGroup = this.getMaxGroup(showMatrixEntryDOC);
                if (properties.containsKey((Object)"group_show")) {
                    model.setValue("group_show", (Object)(maxGroup + 1), showMatrixEntryDOC.size() - 1);
                }
            }
        }
    }

    private int getMaxGroup(DynamicObjectCollection showMatrixEntryDOC) {
        int maxGroup = 0;
        if (showMatrixEntryDOC == null) {
            return maxGroup;
        }
        for (int i = 0; i < showMatrixEntryDOC.size(); ++i) {
            DynamicObject showMatrixDO = (DynamicObject)showMatrixEntryDOC.get(i);
            String groupStr = showMatrixDO.getString("group_show");
            if (!StringUtils.isNotEmpty((CharSequence)groupStr) || !Pattern.matches("^[0-9]*$", groupStr) || maxGroup >= Integer.parseInt(groupStr)) continue;
            maxGroup = Integer.parseInt(groupStr);
        }
        return maxGroup;
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        if (first.isPresent()) {
            Element element = first.get();
            Control control = element.getControl(this.getView());
            if (control instanceof TextEdit) {
                ((TextEdit)control).addButtonClickListener((ClickListener)this);
            }
            if (control instanceof EntryGrid) {
                ((EntryGrid)control).addCellClickListener((CellClickListener)this);
                ((EntryGrid)control).addDataBindListener((EntryGridBindDataListener)this);
                List fieldEdits = ((EntryGrid)control).getFieldEdits();
                if (fieldEdits != null) {
                    for (int i = 0; i < fieldEdits.size(); ++i) {
                        FieldEdit fieldEdit = (FieldEdit)fieldEdits.get(i);
                        String fieldKey = fieldEdit.getFieldKey();
                        if (!fieldKey.contains("_id") && !fieldKey.contains("_name")) continue;
                        IDataEntityProperty property = fieldEdit.getProperty();
                        if (property != null) {
                            ((EntryGrid)control).getView().setVisible(Boolean.valueOf(false), new String[]{fieldKey});
                            continue;
                        }
                        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                        fieldMap = new HashMap();
                        fieldMap.put("policy", "");
                        fieldMap.put("visible", false);
                        String[] keys = new String[]{fieldKey};
                        fieldMap.put("keys", keys);
                        clientViewProxy.addAction("setVisible", fieldMap);
                    }
                }
            }
            e.setControl(control);
        }
    }

    private List<Element> getElementList(List<DynamicObject> featureDefList) {
        ArrayList<Element> result = new ArrayList<Element>();
        if (featureDefList == null) {
            return result;
        }
        HashMap<String, DynamicObject> cacheFeatureMap = new HashMap<String, DynamicObject>(4);
        for (int i = 0; i < featureDefList.size(); ++i) {
            DynamicObject featureDO = featureDefList.get(i);
            if (featureDO == null) continue;
            String number = featureDO.getString("number");
            String fieldKey = "";
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                fieldKey = number.toLowerCase();
            }
            String name = featureDO.getString("name");
            result.add((Element)new TextElement(fieldKey, String.format(ResManager.loadKDString((String)"%1$s(%2$s)", (String)"ConfigmatrixEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), name, number), SHOW_MATRIX_ENTRY));
            result.add((Element)new TextElement(fieldKey + "_id", String.format(ResManager.loadKDString((String)"%1$s(ID)", (String)"ConfigmatrixEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), name), SHOW_MATRIX_ENTRY));
            result.add((Element)new TextElement(fieldKey + "_name", String.format(ResManager.loadKDString((String)"%1$s(NAME)", (String)"ConfigmatrixEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), name), SHOW_MATRIX_ENTRY));
            cacheFeatureMap.put(fieldKey, featureDO);
        }
        if (cacheFeatureMap != null && cacheFeatureMap.size() > 0) {
            this.getPageCache().put("feature", SerializationUtils.serializeToBase64(cacheFeatureMap));
        }
        return result;
    }

    private List<DynamicObject> getFeatureDefinition(IDataModel model) {
        ArrayList<DynamicObject> featureSet = new ArrayList<DynamicObject>(4);
        if (model == null) {
            return featureSet;
        }
        DynamicObjectCollection featureEntryDOC = model.getEntryEntity(FEATURE_ENTRY);
        if (featureEntryDOC == null || featureEntryDOC.size() == 0) {
            return featureSet;
        }
        for (int i = 0; i < featureEntryDOC.size(); ++i) {
            DynamicObject featureDO;
            DynamicObject featureEntryDO = (DynamicObject)featureEntryDOC.get(i);
            if (featureEntryDO == null || (featureDO = featureEntryDO.getDynamicObject(ENTRY_FEATUREID)) == null) continue;
            featureSet.add(featureDO);
        }
        return featureSet;
    }

    public void click(EventObject evt) {
        super.click(evt);
        TextEdit control = (TextEdit)evt.getSource();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SHOW_MATRIX_ENTRY);
        int[] selectRows = entryGrid.getSelectRows();
        int row = -1;
        if (selectRows != null && selectRows.length > 0) {
            row = selectRows[0];
        }
        String fieldKey = control.getKey();
        Map<String, DynamicObject> featureMap = this.getPageCacheFeatue();
        DynamicObject featureDO = null;
        if (featureMap != null) {
            featureDO = featureMap.get(fieldKey);
        }
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"featurevalue", (CharSequence)fieldKey) && row > -1) {
            Object featureColumn = model.getValue("featurecolumnid", row);
            if (featureColumn instanceof DynamicObject) {
                featureDO = (DynamicObject)featureColumn;
                this.showFeatureValForm(featureDO, row, true);
            }
        } else if (featureDO != null && row > -1) {
            this.showFeatureValForm(featureDO, row, false);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private Map<String, DynamicObject> getPageCacheFeatue() {
        String feature = this.getPageCache().get("feature");
        if (StringUtils.isEmpty((CharSequence)feature)) {
            return null;
        }
        Map featureMap = (Map)SerializationUtils.deSerializeFromBase64((String)feature);
        return featureMap;
    }

    private void showFeatureValForm(DynamicObject oldFeatureDO, int row, boolean isStore) {
        if (oldFeatureDO == null) {
            return;
        }
        Long featurePKValue = oldFeatureDO.getLong("id");
        DynamicObject featureDO = BusinessDataServiceHelper.loadSingle((Object)featurePKValue, (String)"pdm_featuredefinition");
        String featureType = featureDO.getString("featuretype");
        boolean isAllowMulValue = featureDO.getBoolean("isallowmulvalue");
        boolean isAllowNegative = featureDO.getBoolean("isallownegative");
        int len = 0;
        if (StringUtils.equals((CharSequence)featureType, (CharSequence)"A")) {
            len = featureDO.getInt("length");
        } else if (StringUtils.equals((CharSequence)featureType, (CharSequence)"B")) {
            len = featureDO.getInt("precision");
        }
        List<Map<String, Object>> selectParamData = this.getFeatureDOList(featureDO, row);
        ArrayList<Map<String, Object>> valueData = new ArrayList(4);
        boolean isEdit = false;
        DynamicObjectCollection treeEntryEntity = featureDO.getDynamicObjectCollection("treeentryentity");
        if (treeEntryEntity != null && !treeEntryEntity.isEmpty()) {
            for (DynamicObject entryDO : treeEntryEntity) {
                if (entryDO == null) continue;
                HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
                String entryValue = entryDO.getString("entryvalue");
                String entryvalueName = entryDO.getString("entryvaluename");
                long entryPK = entryDO.getLong("id");
                long featureValueId = 0L;
                String featurevalueidStr = entryDO.getString("featurevalueid");
                if (StringUtils.isNotEmpty((CharSequence)featurevalueidStr) && Pattern.matches("^[0-9]*$", featurevalueidStr)) {
                    featureValueId = Long.parseLong(featurevalueidStr);
                }
                entryMap.put("entryvalue", entryValue);
                entryMap.put("entryvaluename", entryvalueName);
                entryMap.put("entryid", entryPK);
                entryMap.put("entryauxvalueid", featureValueId);
                valueData.add(entryMap);
            }
        } else {
            isEdit = true;
            String group_show = this.getRowGroupShow(row);
            List<Map<String, Object>> cacheManualDataList = this.queryFeatureValueCacheManualData(featureDO, group_show);
            valueData = cacheManualDataList;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("isallownegative", isAllowNegative);
        param.put("len", len);
        param.put("featuretype", featureType);
        param.put("featurepkvalue", featurePKValue);
        this.showFeaturF7Form(param, valueData, selectParamData, isAllowMulValue, isEdit, isStore);
    }

    private String getRowGroupShow(int row) {
        Object group_showObj;
        String group_show = "";
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        if (row > -1 && entryEntity != null && row < entryEntity.size() && (group_showObj = this.getModel().getValue("group_show", row)) != null) {
            group_show = String.valueOf(group_showObj);
        }
        return group_show;
    }

    private void showFeaturF7Form(Map<String, Object> paramData, List<Map<String, Object>> valueData, List<Map<String, Object>> selectParamData, boolean isAllowMulValue, boolean isEdit, boolean isStore) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", valueData);
        params.put("selectData", selectParamData);
        params.put("isedit", isEdit);
        params.put("isallowmulvalue", isAllowMulValue);
        params.put("formId", "mpdm_featurevalselector");
        if (paramData != null) {
            params.putAll(paramData);
        }
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (isStore) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "featurevalue"));
        } else {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "itemselector"));
        }
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Map callBackDataMap = (Map)evt.getReturnData();
        if (callBackDataMap == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"itemselector")) {
            this.callBackItemSelector(view, model, callBackDataMap, false);
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"featurevalue")) {
            this.callBackItemSelector(view, model, callBackDataMap, true);
        }
    }

    private void callBackItemSelector(IFormView view, IDataModel model, Map<String, Object> callBackDataMap, boolean isStore) {
        if (view == null || model == null || callBackDataMap == null) {
            return;
        }
        Object datas = callBackDataMap.get("datas");
        Object featurePkValueObj = callBackDataMap.get("featurepkvalue");
        Long featurePkValue = 0L;
        if (featurePkValueObj instanceof Long) {
            featurePkValue = (Long)featurePkValueObj;
        }
        Map<String, DynamicObject> featureMap = this.getPageCacheFeatue();
        DynamicObject featureDO = null;
        List<Map<String, Object>> dataList = new ArrayList(8);
        EntryGrid subentryGrid = isStore ? (EntryGrid)this.getControl(MATRIX_ENTRY) : (EntryGrid)this.getControl(SHOW_MATRIX_ENTRY);
        int[] subEntrySelects = subentryGrid.getSelectRows();
        int row = subEntrySelects[0];
        Long featureID = 0L;
        model.beginInit();
        if (isStore) {
            Object featureIDObj = model.getValue("featurecolumnid", row);
            if (featureIDObj instanceof DynamicObject) {
                featureDO = (DynamicObject)featureIDObj;
                featureID = featureDO.getLong("id");
            }
        } else {
            featureDO = this.getFeatureToMap(featureMap, featurePkValue);
            Object cacheManualData = callBackDataMap.get("cachemanualdata");
            this.recordCacheManualData(view, model, cacheManualData, featurePkValue, row);
            this.clearShowEntryData(featurePkValue, model, row);
        }
        if (datas instanceof List) {
            dataList = (List)datas;
        }
        if (dataList != null && !dataList.isEmpty()) {
            this.callBackWriteFeatureValue(view, model, featureDO, dataList, row, isStore);
        }
        model.endInit();
        view.updateView(SHOW_MATRIX_ENTRY);
        view.updateView(MATRIX_ENTRY);
    }

    private void clearShowEntryData(Long featurePkValue, IDataModel model, int row) {
        if (model == null) {
            return;
        }
        DynamicObject columnFeatureDO = this.getColumnFeatureDO(featurePkValue);
        String groupShow = this.getGroupShowRowData(model, row);
        String columnKey = "";
        if (columnFeatureDO != null && StringUtils.isNotEmpty((CharSequence)columnFeatureDO.getString("number"))) {
            columnKey = columnFeatureDO.getString("number").toLowerCase();
        }
        DynamicObjectCollection showMatrixEntryDOC = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        DataEntityPropertyCollection properties = showMatrixEntryDOC.getDynamicObjectType().getProperties();
        for (int i = 0; i < showMatrixEntryDOC.size(); ++i) {
            String group_show;
            DynamicObject showMatrixEntryDO = (DynamicObject)showMatrixEntryDOC.get(i);
            if (showMatrixEntryDO == null || !StringUtils.equals((CharSequence)(group_show = showMatrixEntryDO.getString("group_show")), (CharSequence)groupShow) || !properties.containsKey((Object)columnKey)) continue;
            model.setValue(columnKey, (Object)"", i);
            model.setValue(columnKey + "_id", (Object)"", i);
            model.setValue(columnKey + "_name", (Object)"", i);
        }
    }

    private void callBackWriteFeatureValue(IFormView view, IDataModel model, DynamicObject featureDO, List<Map<String, Object>> dataList, int row, boolean isStore) {
        if (view == null || model == null || dataList == null || featureDO == null) {
            return;
        }
        String number = featureDO.getString("number");
        String fieldKey = "";
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            fieldKey = number.toLowerCase();
        }
        String groupShow = this.getGroupShowRowData(model, row);
        List<Integer> rowList = this.getGroupRowList(model, groupShow, row);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            Object entryValue = dataMap.get("entryvalue");
            Object entryValueName = dataMap.get("entryvaluename");
            Object entryid = dataMap.get("entryid");
            if (isStore) {
                if (i == 0) {
                    this.setMatrixEntryVal(fieldKey, entryid, entryValue, entryValueName, row);
                    continue;
                }
                model.insertEntryRow(MATRIX_ENTRY, row + i);
                this.setMatrixEntryVal(fieldKey, entryid, entryValue, entryValueName, row + i);
                continue;
            }
            if (rowList.size() > 0 && i < rowList.size()) {
                this.setMatrixEntryValue(number, entryid, entryValue, entryValueName, rowList.get(i));
                continue;
            }
            int rowIndex = row;
            if (rowList.size() > 0) {
                rowIndex = rowList.get(rowList.size() - 1) + (i - (rowList.size() - 1));
            }
            model.insertEntryRow(SHOW_MATRIX_ENTRY, rowIndex);
            this.setMatrixEntryValue(fieldKey, entryid, entryValue, entryValueName, rowIndex);
            model.setValue("group_show", (Object)groupShow, rowIndex);
        }
        this.deleteShowMatrixEmptyRow(model, rowList, dataList.size());
    }

    private void deleteShowMatrixEmptyRow(IDataModel model, List<Integer> rowList, int size) {
        if (rowList == null || rowList.isEmpty()) {
            return;
        }
        if (rowList.size() > size) {
            int start = 1;
            if (size > 0) {
                start = size;
            }
            DynamicObjectCollection showMatrixEntryDO = model.getEntryEntity(SHOW_MATRIX_ENTRY);
            DataEntityPropertyCollection properties = showMatrixEntryDO.getDynamicObjectType().getProperties();
            ArrayList<Integer> deleteRows = new ArrayList<Integer>(4);
            for (int i = start; i < rowList.size(); ++i) {
                boolean flag = false;
                for (int j = 0; j < properties.size(); ++j) {
                    Object value;
                    IDataEntityProperty property = (IDataEntityProperty)properties.get(j);
                    String name = property.getName();
                    if (StringUtils.equals((CharSequence)"group_show", (CharSequence)name) || StringUtils.equals((CharSequence)"seq", (CharSequence)name) || StringUtils.equals((CharSequence)"id", (CharSequence)name) || (value = model.getValue(name, rowList.get(i).intValue())) == null || !StringUtils.isNotEmpty((CharSequence)value.toString())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                deleteRows.add(rowList.get(i));
            }
            this.deleteRowData(model, deleteRows);
        }
    }

    private void deleteAllEmptyRowToShowEntry() {
        IDataModel model = this.getModel();
        DynamicObjectCollection showEntryDOC = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        if (showEntryDOC == null || showEntryDOC.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection properties = showEntryDOC.getDynamicObjectType().getProperties();
        ArrayList<Integer> deleteRows = new ArrayList<Integer>(4);
        for (int i = 0; i < showEntryDOC.size(); ++i) {
            DynamicObject showMatrixDO = (DynamicObject)showEntryDOC.get(i);
            if (!this.isEmptyRow(showMatrixDO, properties)) continue;
            deleteRows.add(i);
        }
        this.deleteRowData(model, deleteRows);
    }

    private boolean isEmptyRow(DynamicObject showMatrixDO, DataEntityPropertyCollection properties) {
        if (showMatrixDO == null || properties == null || properties.isEmpty()) {
            return false;
        }
        boolean emptyRow = true;
        for (int j = 0; j < properties.size(); ++j) {
            Object value;
            String propName = ((IDataEntityProperty)properties.get(j)).getName();
            if (StringUtils.equals((CharSequence)"group_show", (CharSequence)propName) || StringUtils.equals((CharSequence)"seq", (CharSequence)propName) || StringUtils.equals((CharSequence)"id", (CharSequence)propName) || (value = showMatrixDO.get(propName)) == null || !StringUtils.isNotEmpty((CharSequence)String.valueOf(value))) continue;
            emptyRow = false;
            break;
        }
        return emptyRow;
    }

    private void deleteRowData(IDataModel model, List<Integer> deleteRows) {
        if (deleteRows == null || deleteRows.isEmpty()) {
            return;
        }
        Integer[] deleteRowInteger = deleteRows.toArray(new Integer[deleteRows.size()]);
        int[] deleteRowIndexs = new int[deleteRowInteger.length];
        for (int i = 0; i < deleteRowInteger.length; ++i) {
            deleteRowIndexs[i] = deleteRowInteger[i];
        }
        model.deleteEntryRows(SHOW_MATRIX_ENTRY, deleteRowIndexs);
    }

    private List<Integer> getGroupRowList(IDataModel model, String groupShow, int row) {
        ArrayList<Integer> rowList = new ArrayList<Integer>(4);
        DynamicObjectCollection showMatrixEntryDOC = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        for (int i = 0; i < showMatrixEntryDOC.size(); ++i) {
            String group_show;
            DynamicObject showMatrixEntryDO = (DynamicObject)showMatrixEntryDOC.get(i);
            if (showMatrixEntryDO == null || !StringUtils.equals((CharSequence)(group_show = showMatrixEntryDO.getString("group_show")), (CharSequence)groupShow)) continue;
            rowList.add(i);
        }
        return rowList;
    }

    private void setMatrixEntryValue(String number, Object entryid, Object entryValue, Object entryValueName, int row) {
        IDataModel model = this.getModel();
        Long entryPK = 0L;
        if (entryid != null && StringUtils.isNotEmpty((CharSequence)entryid.toString()) && Pattern.matches("^[0-9]*$", entryid.toString())) {
            entryPK = Long.parseLong(entryid.toString());
        }
        model.setValue(number, entryValue, row);
        model.setValue(number + "_id", (Object)entryPK, row);
        model.setValue(number + "_name", entryValueName, row);
    }

    private void setMatrixEntryVal(String number, Object entryid, Object entryValue, Object entryValueName, int row) {
        IDataModel model = this.getModel();
        Long entryPK = 0L;
        if (entryid != null && StringUtils.isNotEmpty((CharSequence)entryid.toString()) && Pattern.matches("^[0-9]*$", entryid.toString())) {
            entryPK = Long.parseLong(entryid.toString());
        }
        model.setValue("featurevalue", entryValue, row);
        model.setValue("featurevalueid", (Object)entryPK, row);
        model.setValue("featurevaluename", entryValueName, row);
    }

    private DynamicObject getFeatureToMap(Map<String, DynamicObject> featureMap, Long featurePkValue) {
        DynamicObject featureDO = null;
        if (featureMap != null) {
            for (Map.Entry<String, DynamicObject> entry : featureMap.entrySet()) {
                DynamicObject entryValue = entry.getValue();
                if (entryValue == null) continue;
                long pkValue = entryValue.getLong("id");
                if (featurePkValue != pkValue) continue;
                featureDO = entryValue;
                break;
            }
        }
        return featureDO;
    }

    private void recordCacheManualData(IFormView view, IDataModel model, Object cacheManualData, Long featurePkValue, int row) {
        if (view == null || model == null || cacheManualData == null) {
            return;
        }
        List cacheManualDataList = new ArrayList(8);
        DynamicObject colFeatureDO = this.getColumnFeatureDO(featurePkValue);
        if (colFeatureDO == null) {
            return;
        }
        String featurePkStr = "";
        if (colFeatureDO.getPkValue() != null) {
            featurePkStr = String.valueOf(colFeatureDO.getPkValue());
        }
        String groupShow = this.getGroupShowRowData(model, row);
        if (cacheManualData instanceof List) {
            cacheManualDataList = (List)cacheManualData;
            String cacheManualDataJson = JSONObject.toJSONString(cacheManualDataList);
            view.getPageCache().put(featurePkStr + "_" + groupShow, cacheManualDataJson);
        }
    }

    private String getGroupShowRowData(IDataModel model, int row) {
        String groupShow = "";
        if (model == null || row < 0) {
            return groupShow;
        }
        Object groupShowObj = model.getValue("group_show", row);
        if (groupShowObj instanceof String) {
            groupShow = String.valueOf(groupShowObj);
        }
        return groupShow;
    }

    private DynamicObject getColumnFeatureDO(Long featurePkValue) {
        Map<String, DynamicObject> pageCacheFeatue = this.getPageCacheFeatue();
        if (pageCacheFeatue != null) {
            for (Map.Entry<String, DynamicObject> entry : pageCacheFeatue.entrySet()) {
                DynamicObject value = entry.getValue();
                if (value == null || value.getLong("id") != featurePkValue.longValue()) continue;
                return value;
            }
        }
        return null;
    }

    private List<Map<String, Object>> queryFeatureValueCacheManualData(DynamicObject featureDO, String group_show) {
        String cacheManualDataJSON;
        List<Map<String, Object>> cacheManualDataList = new ArrayList<Map<String, Object>>(2);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String featurePkStr = "";
        if (featureDO != null && featureDO.getPkValue() != null) {
            featurePkStr = String.valueOf(featureDO.getPkValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(cacheManualDataJSON = view.getPageCache().get(featurePkStr + "_" + group_show)))) {
            cacheManualDataList = (List)JSONObject.parseObject((String)cacheManualDataJSON, List.class);
        }
        return cacheManualDataList;
    }

    private List<Map<String, Object>> getFeatureDOList(DynamicObject featureDO, int row) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(4);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(SHOW_MATRIX_ENTRY);
        if (featureDO == null || entryEntity == null || entryEntity.isEmpty()) {
            return paramList;
        }
        String groupShow = this.getGroupShowRowData(model, row);
        DataEntityPropertyCollection properties = ((DynamicObject)entryEntity.get(0)).getDynamicObjectType().getProperties();
        String number = featureDO.getString("number");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryEntityDO = (DynamicObject)entryEntity.get(i);
            String group_show = entryEntityDO.getString("group_show");
            if (!StringUtils.equals((CharSequence)groupShow, (CharSequence)group_show) || !properties.containsKey((Object)number)) continue;
            String featureValue = entryEntityDO.getString(number);
            String featureValueID = entryEntityDO.getString(number + "_id");
            String featureValueName = entryEntityDO.getString(number + "_name");
            if (!StringUtils.isNotEmpty((CharSequence)featureValueID) && !StringUtils.isNotEmpty((CharSequence)featureValue)) continue;
            HashMap<String, String> param = new HashMap<String, String>(4);
            param.put("entryid", featureValueID);
            param.put("entryvalue", featureValue);
            param.put("entryvaluename", featureValueName);
            paramList.add(param);
        }
        return paramList;
    }
}

