/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.rule.expression.property.ExpressionProperty;
import kd.bos.workflow.engine.rule.expression.property.IExpressionProperty;
import kd.bos.workflow.engine.rule.expression.property.ProcessMarcoExpressionProp;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.exception.WFErrorCode;

public class MpdmValExpressionPlugin
extends AbstractFormPlugin {
    public static final String CURRENTPROPLIST = "currentPropList";
    public static final String CURRENTPROP = "currentProp";
    public static final String SUBJECT = "subject";
    public static final String COMBOFIELD = "combofield";
    public static final String COMBOFIELD_0 = "combofield0";
    public static final String ICONAP = "iconap";
    public static final String CONFIRM = "confirm";
    public static final String CANCEL = "cancel";
    public static final String TIP = "tip";
    public static final String CONFIRMTYPE = "confirmType";
    public static final String CONFIRMTYPE_TIPS = "confirmType_tips";
    public static final String CONFIRMTYPE_ORG = "bos_org";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM});
        this.addClickListeners(new String[]{CANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        try {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entityNumber", parameter.getCustomParam("entityNumber"));
            this.getPageCache().put("fromSubjectModelAndApp", (String)parameter.getCustomParam("fromSubjectModelAndApp"));
            if (WfUtils.isNotEmptyString((Object)parameter.getCustomParam("leftEntryPath"))) {
                this.getPageCache().put("leftEntryPath", (String)parameter.getCustomParam("leftEntryPath"));
            }
            String expressionStr = (String)parameter.getCustomParam("expression");
            ComboEdit combofield0 = (ComboEdit)this.getControl(COMBOFIELD_0);
            List defaultProps = ExpressionPropUtils.getDefaultProps(params, (AbstractFormPlugin)this);
            this.getPageCache().put(COMBOFIELD_0, SerializationUtils.toJsonString((Object)defaultProps, (boolean)true));
            List<ComboItem> items = this.getItems(defaultProps);
            combofield0.setComboItems(items);
            if (WfUtils.isNotEmptyString((Object)parameter.getCustomParam(TIP))) {
                this.getView().showTipNotification((String)parameter.getCustomParam(TIP), Integer.valueOf(3000));
            }
            if (WfUtils.isNotEmpty((String)expressionStr)) {
                if (expressionStr.endsWith(".id")) {
                    expressionStr = expressionStr.substring(0, expressionStr.length() - 3);
                }
                int si = 0;
                if (expressionStr.startsWith("model")) {
                    String s = expressionStr;
                    while (s.length() > 0) {
                        String currentpropListJson = this.getPageCache().get(COMBOFIELD + si);
                        if (WfUtils.isEmpty((String)currentpropListJson)) {
                            s = "";
                            throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ea7props\u89e3\u6790\u4e3a\u7a7a\uff01\uff01\uff01", (String)"MpdmValExpressionPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), si)});
                        }
                        List props = SerializationUtils.fromJsonStringToList((String)currentpropListJson, ExpressionProperty.class);
                        Collections.sort(props, new Comparator<ExpressionProperty>(){

                            @Override
                            public int compare(ExpressionProperty p1, ExpressionProperty p2) {
                                if (p1.getNumber().length() == p2.getNumber().length()) {
                                    return 0;
                                }
                                if (p1.getNumber().length() < p2.getNumber().length()) {
                                    return 1;
                                }
                                return -1;
                            }
                        });
                        if (props == null || props.size() < 1) {
                            s = "";
                        }
                        boolean propsHasNotCurrentExpress = true;
                        for (ExpressionProperty p : props) {
                            String path = p.getPath();
                            StringBuilder sbder = new StringBuilder();
                            if (WfUtils.isEmpty((String)path)) {
                                throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ea7\u8868\u8fbe\u5f0f\u5c5e\u6027\u83b7\u53d6\u9519\u8bef\uff01\u67d0\u4e2aprop\u7684path\u4e3a\u7a7a\u3002", (String)"MpdmValExpressionPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), si)});
                            }
                            if (!s.startsWith(path)) continue;
                            this.getModel().setValue(COMBOFIELD + si, (Object)path);
                            this.getModel().setValue(SUBJECT, (Object)(WfUtils.isEmpty((String)p.getFullName()) ? p.getName() : p.getFullName()), 0);
                            this.getPageCache().put(CURRENTPROP, SerializationUtils.toJsonString((Object)p, (boolean)true));
                            List nextProps = ExpressionPropUtils.getNextProps((ExpressionProperty)p, (AbstractFormPlugin)this, null);
                            if (nextProps.size() > 0 && ++si < 8) {
                                this.showNextCombo(COMBOFIELD + si, nextProps);
                                int iconShow = si - 1;
                                this.getView().setVisible(Boolean.valueOf(true), new String[]{ICONAP + iconShow});
                            }
                            if ((s = s.substring(path.length())).length() > 0 && nextProps.size() > 0 && s.startsWith(".")) {
                                s = s.substring(1);
                            }
                            propsHasNotCurrentExpress = false;
                            break;
                        }
                        if (!propsHasNotCurrentExpress) continue;
                        throw new KDException(WFErrorCode.conditionParseError(), new Object[]{String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ea7\u8868\u8fbe\u5f0f\u5c5e\u6027\u83b7\u53d6\u9519\u8bef\uff01\u6ca1\u6709\u627e\u5230\u4e0e\u5f53\u524d\u8868\u8fbe\u5f0f\u5bf9\u5e94\u7684path", (String)"MpdmValExpressionPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), si)});
                    }
                } else {
                    ProcessMarcoExpressionProp prop = ExpressionPropUtils.getPropByExpression((String)expressionStr, (AbstractFormPlugin)this);
                    String structurenumber = prop.getStructurenumber();
                    if (WfUtils.isNotEmpty((String)structurenumber)) {
                        this.recoverExpression(structurenumber);
                    }
                }
            } else if (defaultProps.size() > 0) {
                List secondLevelProps;
                ExpressionProperty ep = (ExpressionProperty)defaultProps.get(0);
                if (WfUtils.isNotEmpty((String)ep.getNumber())) {
                    this.getModel().setValue(COMBOFIELD_0, (Object)ep.getNumber());
                }
                if ((secondLevelProps = ExpressionPropUtils.getNextProps((ExpressionProperty)ep, (AbstractFormPlugin)this, null)).size() > 0) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"iconap0"});
                    this.showNextCombo("combofield1", secondLevelProps);
                    ep = (ExpressionProperty)secondLevelProps.get(0);
                    this.getModel().setValue("combofield1", (Object)ep.getNumber());
                    this.getModel().setValue(SUBJECT, (Object)(WfUtils.isEmpty((String)ep.getFullName()) ? ep.getName() : ep.getFullName()), 0);
                    this.getPageCache().put(CURRENTPROP, SerializationUtils.toJsonString((Object)ep, (boolean)true));
                    List threeLevelProps = ExpressionPropUtils.getNextProps((ExpressionProperty)ep, (AbstractFormPlugin)this, null);
                    if (threeLevelProps.size() > 0) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"iconap1"});
                        this.showNextCombo("combofield2", threeLevelProps);
                    }
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u53c2\uff08\uff09\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"MpdmValExpressionPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            this.log.error("\u8868\u8fbe\u5f0f\u521d\u59cb\u5316\u9519\u8bef\uff01\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace((Throwable)ex));
        }
    }

    private void recoverExpression(String structurenumber) {
        String[] expArr = structurenumber.split("\\.");
        int i = 0;
        while (i < expArr.length) {
            String expression = expArr[i];
            this.getModel().setValue(COMBOFIELD + i, (Object)expression);
            ExpressionProperty currentProp = this.getCurrentPropFromCacheByNumber(expression, COMBOFIELD + i);
            if (currentProp == null) break;
            this.getModel().setValue(SUBJECT, (Object)(WfUtils.isEmpty((String)currentProp.getFullName()) ? currentProp.getName() : currentProp.getFullName()), 0);
            this.getPageCache().put(CURRENTPROP, SerializationUtils.toJsonString((Object)currentProp, (boolean)true));
            List props = ExpressionPropUtils.getNextProps((ExpressionProperty)currentProp, (AbstractFormPlugin)this, null);
            if (props != null && !props.isEmpty()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ICONAP + i});
                if (++i >= 8) continue;
                this.showNextCombo(COMBOFIELD + i, props);
                continue;
            }
            ++i;
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (CONFIRM.equals(key)) {
            String propStr = this.getPageCache().get(CURRENTPROP);
            if (WfUtils.isNotEmpty((String)propStr)) {
                ExpressionProperty prop = (ExpressionProperty)SerializationUtils.fromJsonString((String)propStr, ExpressionProperty.class);
                String expression = prop.getExpression();
                if (WfUtils.isEmpty((String)expression) || "model".equals(expression) || "proc".equals(expression)) {
                    List props = ExpressionPropUtils.getNextProps((ExpressionProperty)prop, (AbstractFormPlugin)this, null);
                    if (props != null && props.size() > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9700\u8981\u9009\u5230\u53f6\u5b50\u8282\u70b9\uff0c\u8bf7\u5f80\u4e0b\u9009\u62e9\u3002", (String)"MpdmValExpressionPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u8fbe\u5f0f\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u8868\u8fbe\u5f0f\u3002", (String)"MpdmValExpressionPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Object confirmType = parameter.getCustomParam(CONFIRMTYPE);
                if (WfUtils.isNotEmptyString((Object)confirmType) && null != prop && !confirmType.equals(prop.getEntityNumber())) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u7c7b\u578b\u662f%s\u7684\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"MpdmValExpressionPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (Object[])parameter.getCustomParam(CONFIRMTYPE_TIPS)));
                    return;
                }
                if (!prop.getPrefix().equalsIgnoreCase("proc") && WfUtils.isNotEmpty((String)prop.getEntityNumber()) && !prop.getPath().startsWith("mc_")) {
                    expression = expression + ".id";
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("expression", expression);
                data.put("prop", propStr);
                this.getView().returnDataToParent(data);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6ca1\u6709\u6570\u636e\u54e6\uff01\u8bf7\u9009\u62e9\u6570\u636e.", (String)"MpdmValExpressionPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        } else if (CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.contains(COMBOFIELD)) {
            String value = this.getModel().getValue(propertyName).toString();
            if (WfUtils.isEmpty((String)value)) {
                int level = Integer.parseInt(propertyName.split(COMBOFIELD)[1]);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ICONAP + level});
                this.removePropsInCacheAndHideCtl(++level);
                if ((level -= 2) > -1) {
                    value = this.getModel().getValue(COMBOFIELD + level).toString();
                    ExpressionProperty currentProp = this.getCurrentPropFromCacheByNumber(value, COMBOFIELD + level);
                    if (currentProp != null) {
                        this.getModel().setValue(SUBJECT, (Object)(WfUtils.isEmpty((String)currentProp.getFullName()) ? currentProp.getName() : currentProp.getFullName()), 0);
                        this.getPageCache().put(CURRENTPROP, SerializationUtils.toJsonString((Object)currentProp, (boolean)true));
                    }
                } else {
                    this.getPageCache().remove(CURRENTPROP);
                    this.getModel().setValue(SUBJECT, (Object)"", 0);
                }
            } else {
                String nodeId = (String)this.getView().getFormShowParameter().getCustomParam("nodeId");
                ExpressionProperty currentProp = this.getCurrentPropFromCacheByNumber(value, propertyName);
                if (currentProp != null) {
                    this.getModel().setValue(SUBJECT, (Object)(WfUtils.isEmpty((String)currentProp.getFullName()) ? currentProp.getName() : currentProp.getFullName()), 0);
                    this.getPageCache().put(CURRENTPROP, SerializationUtils.toJsonString((Object)currentProp, (boolean)true));
                }
                List props = ExpressionPropUtils.getNextProps((ExpressionProperty)currentProp, (AbstractFormPlugin)this, (String)nodeId);
                int level = Integer.parseInt(propertyName.split(COMBOFIELD)[1]);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ICONAP + level});
                this.removePropsInCacheAndHideCtl(++level);
                if (props != null && !props.isEmpty() && level < 8) {
                    int i = level - 1;
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{ICONAP + i});
                    this.showNextCombo(COMBOFIELD + level, props);
                }
            }
        }
    }

    private void removePropsInCacheAndHideCtl(int level) {
        IPageCache pageCache = this.getPageCache();
        for (int i = level; i < 9; ++i) {
            if (!WfUtils.isNotEmpty((String)pageCache.get(COMBOFIELD + i))) continue;
            this.getModel().setValue(COMBOFIELD + i, (Object)"");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{COMBOFIELD + i});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ICONAP + i});
            pageCache.remove(COMBOFIELD + i);
        }
    }

    private ExpressionProperty getCurrentPropFromCacheByNumber(String number, String controlName) {
        String currentpropListJson = this.getPageCache().get(controlName);
        if (WfUtils.isNotEmpty((String)currentpropListJson)) {
            List props = SerializationUtils.fromJsonStringToList((String)currentpropListJson, ExpressionProperty.class);
            for (ExpressionProperty p : props) {
                if (!number.equalsIgnoreCase(p.getNumber())) continue;
                return p;
            }
        }
        return null;
    }

    private void showNextCombo(String comnoName, List<ExpressionProperty> props) {
        ComboEdit nextComboEdit = (ComboEdit)this.getControl(comnoName);
        nextComboEdit.setComboItems(this.getItems(props));
        this.getPageCache().put(comnoName, SerializationUtils.toJsonString(props, (boolean)false));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{comnoName});
    }

    private List<ComboItem> getItems(List<ExpressionProperty> props) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(8);
        for (IExpressionProperty iExpressionProperty : props) {
            ComboItem i = new ComboItem();
            i.setValue(iExpressionProperty.getNumber());
            i.setCaption(new LocaleString(iExpressionProperty.getName()));
            items.add(i);
        }
        return items;
    }
}

