/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.business.helper.DateChangeProHelper;
import kd.bd.mpdm.business.helper.SystemCallParamHelper;
import kd.bd.mpdm.common.manuftech.ChargeAgainstUtil;
import kd.bd.mpdm.common.manuftech.utils.MftOrderReportTplUtils;
import kd.bd.mpdm.common.utils.AcctOrgCloseDateUtil;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MPDMProcessReportEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    protected Boolean isIgnoreChangeListener = Boolean.FALSE;
    public static Map<String, String> entityMap = new HashMap<String, String>();

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isIgnoreChangeListener.booleanValue()) {
            this.isIgnoreChangeListener = Boolean.FALSE;
            return;
        }
        String key = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        int currentIndex = this.getSelectEntryRowIndex();
        boolean allowed = true;
        switch (key) {
            case "qtyfield": {
                DynamicObject dataEntity;
                BigDecimal allowedNums;
                if (currentIndex < 0 || (allowed = this.checkPropAllow(key, allowedNums = (dataEntity = this.getModel().getEntryRowEntity("sumentry", currentIndex)).getBigDecimal("completqty"), currentIndex))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u4eba\u5458\u5217\u8868\u7684\u6570\u91cf\u5408\u8ba1\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6c47\u62a5\u6570\u91cf\u3002", (String)"MPDMProcessReportEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                this.setPropNotChange(key, e);
                break;
            }
            case "proportion": {
                BigDecimal allowedNums1;
                if (currentIndex < 0 || (allowed = this.checkPropAllow(key, allowedNums1 = new BigDecimal(100), currentIndex))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u4eba\u5458\u5217\u8868\u7684\u201c\u6bd4\u4f8b\uff08%\uff09\u201d\u4e4b\u548c\u987b\u5c0f\u4e8e\u7b49\u4e8e100\u3002", (String)"MPDMProcessReportEditPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                this.setPropNotChange(key, e);
                break;
            }
            case "staffreport": {
                if ("qty".equals(newObj)) {
                    this.setChildReptMust("qtyfield", Boolean.TRUE);
                    this.setChildReptMust("proportion", Boolean.FALSE);
                }
                if (!"cooportion".equals(newObj)) break;
                this.setChildReptMust("proportion", Boolean.TRUE);
                this.setChildReptMust("qtyfield", Boolean.FALSE);
                break;
            }
            case "adjustdate": 
            case "reportdate": {
                DynamicObject org;
                Date bookDate;
                if (!(newObj instanceof Date) || (bookDate = DateChangeProHelper.getBookDate((Date)((Date)newObj), (Long)(org = (DynamicObject)this.getModel().getValue("org")).getLong("id"))) == null) break;
                this.getModel().setValue("bookdate", (Object)bookDate);
                break;
            }
        }
    }

    private void setChildReptMust(String keyChildreportKey, Boolean isMust) {
        EntryGrid childreptGrid = (EntryGrid)this.getView().getControl("childreportentity");
        childreptGrid.setMustInput(keyChildreportKey, isMust.booleanValue());
    }

    private void setPropNotChange(String key, PropertyChangedArgs e) {
        this.getModel().setValue(key, e.getChangeSet()[0].getOldValue(), e.getChangeSet()[0].getRowIndex());
        this.isIgnoreChangeListener = Boolean.TRUE;
    }

    private boolean checkPropAllow(String key, BigDecimal allowedNums, int currentIndex) {
        DynamicObjectCollection cEntitis = this.getChildDynmicObjColls("sumentry", "childreportentity", currentIndex);
        if (CollectionUtils.isEmpty((Collection)cEntitis)) {
            return true;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (DynamicObject userObj : cEntitis) {
            sum = sum.add(userObj.getBigDecimal(key));
        }
        return allowedNums.compareTo(sum) >= 0;
    }

    private DynamicObjectCollection getChildDynmicObjColls(String keyFatherEnti, String keyChildEnti, int currentIndex) {
        DynamicObject fdataEntity = this.getModel().getEntryRowEntity(keyFatherEnti, currentIndex);
        if (null != fdataEntity) {
            return fdataEntity.getDynamicObjectCollection(keyChildEnti);
        }
        return null;
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"sumentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", evt.getRow());
            this.showEntryDetial(entryentity);
            this.showChildreportentity();
            this.showRepsubentryentity();
        }
    }

    protected void showEntryDetial(DynamicObject entryentity) {
        this.isIgnoreChangeListener = Boolean.TRUE;
        IDataModel model = this.getModel();
        if (entryentity != null) {
            model.setValue("entrymanufacturenun", entryentity.get("manufacturenun"));
            model.setValue("entrymanufacturenun1", entryentity.get("manufacturenun"));
            model.setValue("entrymanufacturerow", entryentity.get("manufacturerow"));
            model.setValue("entrymanufacturerow1", entryentity.get("manufacturerow"));
            model.setValue("entryreporttype", entryentity.get("reporttype"));
            model.setValue("entryremark", entryentity.get("remarks"));
            model.setValue("entryresource", entryentity.get("resource"));
            model.setValue("productid", entryentity.get("material"));
            DynamicObject masterObj = entryentity.getDynamicObject("material");
            model.setValue("entryauxproperty", entryentity.get("auxproperty"));
            model.setValue("entrybatchno", entryentity.get("batchno"));
            this.setAuxpropLock(masterObj);
        } else {
            model.setValue("entrymanufacturenun", null);
            model.setValue("entrymanufacturenun1", null);
            model.setValue("entrymanufacturerow", null);
            model.setValue("entrymanufacturerow1", null);
            model.setValue("entrybatchno", null);
            model.setValue("entryauxproperty", null);
            model.setValue("entryreporttype", null);
            model.setValue("entryremark", null);
        }
        this.isIgnoreChangeListener = Boolean.FALSE;
    }

    private void setAuxpropLock(DynamicObject masterObj) {
        DynamicObject bd_material;
        if (null != masterObj && null != (bd_material = BusinessDataServiceHelper.loadSingle((Object)masterObj.getDynamicObject("masterid").getPkValue(), (String)"bd_material"))) {
            boolean isuseauxpty = bd_material.getBoolean("isuseauxpty");
            this.getView().setEnable(Boolean.valueOf(isuseauxpty), new String[]{"entryauxproperty"});
            this.getView().updateView("entryauxproperty");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        FormOperate formOperate = (FormOperate)evt.getSource();
        if ("submit".equals(formOperate.getOperateKey())) {
            boolean isAllow = this.validRepotEntity();
            if (!isAllow) {
                evt.setCancel(true);
            }
            this.autoSetBookDate(this.getModel().getDataEntity(true));
        } else if ("chargeagainst".equals(formOperate.getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
            int[] selectRows = entryGrid.getSelectRows();
            if (null == selectRows || selectRows.length == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u51b2\u9500\u7684\u6570\u636e\u3002", (String)"MPDMProcessReportEditPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (selectRows.length > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5e94\u7528\u53ea\u652f\u6301\u5355\u6761\u5206\u5f55\u3002", (String)"MPDMProcessReportEditPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            FormOperate operate = (FormOperate)evt.getSource();
            String pkValue = String.valueOf(((DynamicObject)this.getModel().getEntryEntity("sumentry").get(selectRows[0])).getPkValue());
            operate.getOption().setVariableValue("entryid", pkValue);
        }
        String operateKey = formOperate.getOperateKey();
        String entityName = this.getModel().getDataEntityType().getName();
        if (entityMap.containsKey(entityName)) {
            if ("backflushout".equals(operateKey)) {
                BillShowParameter showParameter;
                ArrayList<String> billnos = new ArrayList<String>(1);
                billnos.add(this.getModel().getValue("billno").toString());
                if ("prop_processreportbill".equals(entityName) || "prop_mftorderreport".equals(entityName)) {
                    showParameter = MftOrderReportTplUtils.createAddNewPropBillShowParam(billnos, (Object)((DynamicObject)this.getModel().getValue("org")).getPkValue());
                    this.getView().showForm((FormShowParameter)showParameter);
                } else {
                    showParameter = MftOrderReportTplUtils.createAddNewBillShowParam(billnos, (Object)((DynamicObject)this.getModel().getValue("org")).getPkValue());
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            } else if ("unbackflush".equals(operateKey)) {
                IFormView view = this.getView();
                EntryGrid grid = (EntryGrid)view.getControl("sumentry");
                int[] selectRows = grid.getSelectRows();
                if (selectRows.length <= 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MPDMProcessReportEditPlugin_13", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                ArrayList<Long> entryPks = new ArrayList<Long>(16);
                for (int row : selectRows) {
                    entryPks.add((Long)this.getModel().getValue("sumentry.id", row));
                }
                String entryPksJsonString = SerializationUtils.toJsonString(entryPks);
                formOperate.getOption().setVariableValue("unBackFlushEntryPks", entryPksJsonString);
            }
        }
    }

    private void autoSetBookDate(DynamicObject bill) {
        String entityTypeName = bill.getDataEntityType().getName();
        Date bookDate = bill.getDate("bookdate");
        Date closeDate = AcctOrgCloseDateUtil.getAcctOrgCloseDate((Long)bill.getDynamicObject("org").getLong("id"));
        boolean bizDateEqualsBookDate = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004");
        boolean autoCalBookDateByCloseDate = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0008");
        if (closeDate != null) {
            closeDate = DateUtils.getAddDate((Date)closeDate, (int)1);
            if (autoCalBookDateByCloseDate && bookDate.before(closeDate)) {
                this.getModel().setValue("bookdate", (Object)DateUtils.getShortDate((Date)closeDate));
                if (bizDateEqualsBookDate) {
                    String bizDate = "sfc_reportresource_adjust".equals(entityTypeName) ? "adjustdate" : "reportdate";
                    this.getModel().setValue(bizDate, (Object)closeDate);
                }
            }
        }
    }

    private boolean validRepotEntity() {
        boolean isAllow = true;
        IDataModel model = this.getModel();
        DynamicObjectCollection sumEntry = model.getEntryEntity("sumentry");
        String staffType = (String)model.getValue("staffreport");
        if (!CollectionUtils.isEmpty((Collection)sumEntry)) {
            for (DynamicObject reportEnti : sumEntry) {
                DynamicObjectCollection childRptColls = reportEnti.getDynamicObjectCollection("childreportentity");
                if (CollectionUtils.isEmpty((Collection)childRptColls)) continue;
                for (DynamicObject dyn : childRptColls) {
                    isAllow = this.validReportField(dyn, staffType);
                    if (isAllow) continue;
                    return isAllow;
                }
            }
        }
        return isAllow;
    }

    private boolean validReportField(DynamicObject dyn, String staffType) {
        BigDecimal qty = dyn.getBigDecimal("qtyfield");
        if ("qty".equals(staffType) && qty.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u4eba\u5458\u5217\u8868\u7684\u201c\u6570\u91cf\u201d\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MPDMProcessReportEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        qty = dyn.getBigDecimal("proportion");
        if ("cooportion".equals(staffType) && qty.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u62a5\u4eba\u5458\u5217\u8868\u7684\u201c\u6bd4\u4f8b\uff08%\uff09\u201d\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MPDMProcessReportEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"previousentry") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"nextentry")) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", this.getSelectEntryRowIndex());
            this.showEntryDetial(entryentity);
        } else if ("chargeagainst".equals(key)) {
            if (e.getOperationResult().isSuccess()) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
                int[] selectRows = entryGrid.getSelectRows();
                this.opCaPage(selectRows[0] + 1, "mpdm_changeagainst");
            }
        } else if ("audit".equals(key) || "unaudit".equals(key) || "updatebackflush".equals(key) || "unbackflush".equals(key) || "submit".equals(key) && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void opCaPage(int seq, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("entrySeq", (Object)seq);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "chargeagainstCallback"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "chargeagainstCallback".equals(actionId)) {
            JSONObject returnData = (JSONObject)object;
            String entrySeq = returnData.getString("entrySeq");
            String reason = returnData.getString("careason");
            Date caDate = returnData.getDate("cadate");
            Date cabookdate = returnData.getDate("cabookdate");
            if (caDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u51b2\u9500\u65e5\u671f\u201d\u3002", (String)"MPDMProcessReportEditPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            if (cabookdate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8bb0\u8d26\u65e5\u671f\u201d\u3002", (String)"MPDMProcessReportEditPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            Date reportdate = (Date)this.getModel().getValue("reportdate");
            Date bookdate = (Date)this.getModel().getValue("bookdate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (null != reportdate && cabookdate.before(DateUtils.getShortDate((Date)reportdate))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u5728\u6e90\u5355\u65e5\u671f\u4e4b\u524d\u3002", (String)"MPDMProcessReportEditPlugin_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            if (null != bookdate && cabookdate.before(bookdate)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5c0f\u4e8e\u6e90\u5355\u8bb0\u8d26\u65e5\u671f\uff08%2$s\uff09\uff0c\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MPDMProcessReportEditPlugin_16", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), sdf.format(cabookdate), sdf.format(bookdate)));
            }
            if (cabookdate.before(caDate)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5c0f\u4e8e\u51b2\u9500\u65e5\u671f\uff08%2$s\uff09\uff0c\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MPDMProcessReportEditPlugin_17", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), sdf.format(cabookdate), sdf.format(caDate)));
            }
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (DynamicObjectType)this.getModel().getDataEntityType());
            ChargeAgainstUtil.startCaService((DynamicObject)srcBill, (String)entrySeq, (String)reason, (Date)caDate, (Date)cabookdate);
            this.rewrite(srcBill, entrySeq);
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5b8c\u6210\u3002", (String)"MPDMProcessReportEditPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
    }

    private void rewrite(DynamicObject bill, String entrySeq) {
        DynamicObjectCollection sumentitys = bill.getDynamicObjectCollection("sumentry");
        for (DynamicObject obj : sumentitys) {
            String seq = obj.getString("seq");
            if (!StringUtils.equals((CharSequence)seq, (CharSequence)entrySeq)) continue;
            this.rewriteRep(obj, false);
            obj.getDynamicObjectCollection("subentryentity1").clear();
        }
    }

    private void rewriteRep(DynamicObject reportbill, boolean isaudit) {
        String name = this.getModel().getDataEntityType().getName();
        String manFetchEntityName = this.getManFetchEntityName(name);
        if (StringUtils.isEmpty((CharSequence)manFetchEntityName)) {
            return;
        }
        DynamicObjectCollection repsubentryentitys = reportbill.getDynamicObjectCollection("repsubentryentity");
        Long oprentryid = Long.valueOf(reportbill.getString("oprentryid"));
        DynamicObject manftech = BusinessDataServiceHelper.loadSingle((String)manFetchEntityName, (String)this.selectProperties(), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "=", (Object)oprentryid)});
        if (manftech == null) {
            return;
        }
        DynamicObjectCollection manftechentrys = manftech.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject manftechentry : manftechentrys) {
            if (!manftechentry.getPkValue().toString().equals(oprentryid.toString())) continue;
            DynamicObjectCollection repentitys = manftechentry.getDynamicObjectCollection("repsubentryentity");
            for (int k = 0; k < repsubentryentitys.size(); ++k) {
                DynamicObject repentry = (DynamicObject)repsubentryentitys.get(k);
                if (isaudit) {
                    DynamicObject rep = repentitys.addNew();
                    rep.set("repactivity", repentry.get("repactivity"));
                    rep.set("repbaseqty", repentry.get("repbaseqty"));
                    rep.set("repactualqty", repentry.get("repactualqty"));
                    rep.set("repactualbegintime", repentry.get("repactualbegintime"));
                    rep.set("repactualfinishtime", repentry.get("repactualfinishtime"));
                    rep.set("represources", repentry.get("represources"));
                    rep.set("srcentryid", (Object)repentry.getPkValue().toString());
                    rep.set("seq", repentry.get("seq"));
                    continue;
                }
                for (int i = 0; i < repentitys.size(); ++i) {
                    if (!repentry.getPkValue().toString().equals(((DynamicObject)repentitys.get(i)).getString("srcentryid"))) continue;
                    repentitys.remove(i);
                    --i;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{manftech});
    }

    private String getManFetchEntityName(String name) {
        String manFetch = "";
        switch (name) {
            case "om_processreport": {
                manFetch = "om_mfttechnics";
                break;
            }
            case "sfc_processreportbill": {
                manFetch = "sfc_manftech";
                break;
            }
        }
        return manFetch;
    }

    private String selectProperties() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("qty").append(',');
        strBuilder.append("processroute").append(',');
        strBuilder.append("planstarttime").append(',');
        strBuilder.append("planfinishtime").append(',');
        strBuilder.append("baseqty").append(',');
        strBuilder.append("mftentryseq").append(',');
        strBuilder.append("billno").append(',');
        strBuilder.append("billstatus").append(',');
        strBuilder.append("modifytime").append(',');
        strBuilder.append("modifier").append(',');
        strBuilder.append("manufactureorderseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqqty").append(',');
        strBuilder.append("proentryentity").append('.').append("processseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanbegintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanendtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("headqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstandardqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprproductionqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstatus").append(',');
        strBuilder.append("oprentryentity").append('.').append("oproperation").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalqualifiedqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprparent").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactivity").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repbaseqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualbegintime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualfinishtime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("srcentryid").append(',');
        strBuilder.append("repsubentryentity").append('.').append("represources").append(',');
        strBuilder.append("repsubentryentity").append('.').append("seq").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprinvalid");
        return strBuilder.toString();
    }

    public void afterBindData(EventObject e) {
        String staff;
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int rowcount = this.getModel().getEntryRowCount("sumentry");
        if (entryGrid != null && rowcount > 0) {
            entryGrid.selectRows(0, true);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", 0);
            this.showEntryDetial(entryentity);
        }
        if (StringUtils.isNotEmpty((CharSequence)(staff = (String)this.getModel().getValue("staffreport"))) && "qty".equals(staff)) {
            this.setChildReptMust("qtyfield", Boolean.TRUE);
        }
        boolean bookDateEnable = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004");
        this.getView().setEnable(Boolean.valueOf(!bookDateEnable), new String[]{"bookdate"});
        if (!bookDateEnable) {
            DateEdit bookDateDateEdit = (DateEdit)this.getView().getControl("bookdate");
            bookDateDateEdit.hideTips();
        }
        this.showChildreportentity();
        this.showRepsubentryentity();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Date reportDate = dataEntity.getDate("reportdate");
        if ("sfc_reportresource_adjust".equals(dataEntity.getDataEntityType().getName())) {
            reportDate = dataEntity.getDate("adjustdate");
        }
        if (dataEntity.getDynamicObject("org") != null) {
            Date bookDate = DateChangeProHelper.getBookDate((Date)reportDate, (Long)dataEntity.getDynamicObject("org").getLong("id"));
            dataEntity.set("bookdate", (Object)bookDate);
        }
    }

    private void showChildreportentity() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int[] selectRows = entryGrid.getSelectRows();
        boolean isShowAdvconap2 = selectRows.length > 0;
        this.getView().setVisible(Boolean.valueOf(isShowAdvconap2), new String[]{"advconap2"});
    }

    private void showRepsubentryentity() {
        boolean haveRepsubentryentity;
        Control advconap3 = this.getView().getControl("advconap3");
        Control subentryentity = this.getView().getControl("subentryentity");
        Control repsubentryentity = this.getView().getControl("repsubentryentity");
        boolean bl = haveRepsubentryentity = null != advconap3 && (null != repsubentryentity || null != subentryentity);
        if (haveRepsubentryentity) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
            boolean isShowAdvconap3 = true;
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length > 0) {
                for (int selectRow : selectRows) {
                    String matertype = (String)this.getModel().getValue("matertype", selectRow);
                    if (null == matertype || "C".equals(matertype)) continue;
                    isShowAdvconap3 = false;
                    break;
                }
            } else {
                isShowAdvconap3 = false;
            }
            this.getView().setVisible(Boolean.valueOf(isShowAdvconap3), new String[]{"advconap3"});
        }
    }

    static {
        entityMap.put("sfc_processreportbill", "sfc_processreportbill");
        entityMap.put("pom_mftorderreport", "pom_mftorderreport");
        entityMap.put("prop_processreportbill", "prop_processreportbill");
        entityMap.put("prop_mftorderreport", "prop_mftorderreport");
    }
}

