/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.common.manuftech.ChargeAgainstUtil;
import kd.bd.mpdm.common.manuftech.utils.MftOrderReportTplUtils;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MPDMProcessReportListPlugin
extends AbstractListPlugin {
    private static final String BILLLISTAP = "billlistap";
    public static Map<String, String> entityMap = new HashMap<String, String>();

    private void opCaPage(String seq, String formid) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formid);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("entrySeq", (Object)seq);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "chargeagainstCallback"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object object = e.getReturnData();
        if (object != null && "chargeagainstCallback".equals(actionId)) {
            JSONObject returnData = (JSONObject)object;
            String entrySeq = returnData.getString("entrySeq");
            String reason = returnData.getString("careason");
            Date caDate = returnData.getDate("cadate");
            Date cabookdate = returnData.getDate("cabookdate");
            if (caDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u51b2\u9500\u65e5\u671f\u201d\u3002", (String)"MPDMProcessReportListPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            if (cabookdate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8bb0\u8d26\u65e5\u671f\u201d\u3002", (String)"MPDMProcessReportListPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            ListSelectedRowCollection selects = billList.getSelectedRows();
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)selects.getPrimaryKeyValues()[0], (String)billList.getBillFormId());
            Date reportdate = srcBill.getDate("reportdate");
            Date bookdate = srcBill.getDate("bookdate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (null != reportdate && cabookdate.before(DateUtils.getShortDate((Date)reportdate))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u5728\u6e90\u5355\u65e5\u671f\u4e4b\u524d\u3002", (String)"MPDMProcessReportListPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
            if (null != bookdate && cabookdate.before(bookdate)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5c0f\u4e8e\u6e90\u5355\u8bb0\u8d26\u65e5\u671f\uff08%2$s\uff09\uff0c\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MPDMProcessReportListPlugin_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), sdf.format(cabookdate), sdf.format(bookdate)));
            }
            if (cabookdate.before(caDate)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5c0f\u4e8e\u51b2\u9500\u65e5\u671f\uff08%2$s\uff09\uff0c\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"MPDMProcessReportListPlugin_12", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), sdf.format(cabookdate), sdf.format(caDate)));
            }
            DynamicObjectCollection objCols = srcBill.getDynamicObjectCollection("sumentry");
            for (DynamicObject sumentry : objCols) {
                if (!sumentry.getPkValue().toString().equals(entrySeq)) continue;
                entrySeq = sumentry.getString("seq");
                break;
            }
            ChargeAgainstUtil.startCaService((DynamicObject)srcBill, (String)entrySeq, (String)reason, (Date)caDate, (Date)cabookdate);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5b8c\u6210\u3002", (String)"MPDMProcessReportListPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            billList.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        ListSelectedRowCollection selects = beforeDoOperationEventArgs.getListSelectedData();
        FormOperate formOperate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String key = formOperate.getOperateKey();
        String entityName = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        switch (key) {
            case "chargeagainst": {
                if (selects == null) {
                    return;
                }
                if (selects != null && selects.size() > 1) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5e94\u7528\u53ea\u652f\u6301\u5355\u6761\u5206\u5f55\u3002", (String)"MPDMProcessReportListPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    beforeDoOperationEventArgs.setCancel(true);
                    return;
                }
                FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
                operate.getOption().setVariableValue("entryid", selects.get(0).getEntryPrimaryKeyValue().toString());
                break;
            }
            case "backflushout": {
                if (!entityMap.containsKey(entityName)) break;
                Object[] entryPrimaryKeyValues = selects.getPrimaryKeyValues();
                QFilter qFilter = new QFilter("id", "in", (Object)entryPrimaryKeyValues);
                DataSet dataSet = null;
                DataSet dataSetTemp = null;
                try {
                    BillShowParameter showParameter;
                    dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"billno,billstatus,org", (QFilter[])new QFilter[]{qFilter}, null);
                    if (null == dataSet) break;
                    dataSetTemp = dataSet.copy();
                    ArrayList<String> billnos = new ArrayList<String>(10);
                    HashSet<Long> proOrgSet = new HashSet<Long>(1);
                    while (dataSetTemp.hasNext()) {
                        Row row = dataSetTemp.next();
                        String billNo = row.getString("billno");
                        billnos.add(billNo);
                        long orgPkValue = row.getLong("org");
                        proOrgSet.add(orgPkValue);
                        if (proOrgSet.size() <= 1) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u540c\u65f6\uff0c\u6267\u884c\u3010\u5012\u51b2\u9886\u6599\u3011\u3002", (String)"MPDMProcessReportListPlugin_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                        beforeDoOperationEventArgs.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    if (billnos.size() <= 0 || proOrgSet.size() != 1) break;
                    if ("prop_processreportbill".equals(entityName) || "prop_mftorderreport".equals(entityName)) {
                        showParameter = MftOrderReportTplUtils.createAddNewPropBillShowParam(billnos, (Object)proOrgSet.toArray()[0]);
                        this.getView().showForm((FormShowParameter)showParameter);
                        break;
                    }
                    showParameter = MftOrderReportTplUtils.createAddNewBillShowParam(billnos, (Object)proOrgSet.toArray()[0]);
                    this.getView().showForm((FormShowParameter)showParameter);
                    break;
                }
                finally {
                    if (null != dataSet) {
                        dataSet.close();
                    }
                    if (null != dataSetTemp) {
                        dataSetTemp.close();
                    }
                }
            }
            case "unbackflush": {
                if (!entityMap.containsKey(entityName)) break;
                ArrayList<Long> entryPks = new ArrayList<Long>(16);
                for (ListSelectedRow listSelectedRow : selects) {
                    entryPks.add(Long.parseLong(listSelectedRow.getEntryPrimaryKeyValue().toString()));
                }
                String entryPksJsonString = SerializationUtils.toJsonString(entryPks);
                formOperate.getOption().setVariableValue("unBackFlushEntryPks", entryPksJsonString);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("chargeagainst".equals(key)) {
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.opCaPage(selects.get(0).getEntryPrimaryKeyValue().toString(), "mpdm_changeagainst");
            }
        } else if ("audit".equals(key) || "unaudit".equals(key) || "updatebackflush".equals(key) || "unbackflush".equals(key)) {
            billList.refresh();
        }
    }

    static {
        entityMap.put("sfc_processreportbill", "sfc_processreportbill");
        entityMap.put("pom_mftorderreport", "pom_mftorderreport");
        entityMap.put("prop_processreportbill", "prop_processreportbill");
        entityMap.put("prop_mftorderreport", "prop_mftorderreport");
    }
}

