/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.resourcecheck;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class BizResouceCheckCommonListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(BizResouceCheckCommonListPlugin.class);
    private static final String KEY_CACHE_RESOURCECHECK_OPKEY = "pagecacheResoueceCheckOpKey";
    private static final String KEY_CACHE_RESOURCECHECK_RESULTCOLUMNA = "pagecacheResourceCheckResultColumnA";
    private static final String KEY_CACHE_RESOURCECHECK_RESULTCOLUMNB = "pagecacheResourceCheckResultColumnB";
    private static final String KEY_CACHE_RESOURCECHECKID = "pagecacheResourceCheckId";
    private static final String KEY_CACHE_RESOURCECHECK_IDSETTAG = "pagecacheResourceIdSetTag";
    private static final String KEY_CACHE_ISADDBUTTONANDCOLUMN = "pagecacheIsAddButtonAndColumn";
    private static final String KEY_CACHE_ISEXISTRESULTCOLUMN = "pagecacheIsExistsResourceResultColumn";
    private static final String KEY_CACHE_RESOURCECHECKFILTER_QCP = "pagecacheResourceColumnFilterQCP";
    private static final String KEY_CACHE_RESOURCECHECKFILTER_VALUE = "pagecacheResourceColumnFilterValue";
    private static final String KEY_ISTRUE_STR = "true";
    private String toolBarAp = "toolbarap";
    private String tblCloseAp = "tblclose";
    private String gridViewAp = "gridview";
    private String billListAp = "billlistap";
    public static final String APPPARAM = "bd-mpdm-formplugin";

    public String getBillListAp() {
        return this.billListAp;
    }

    public void setBillListAp(String billlistAp) {
        this.billListAp = billlistAp;
    }

    public Object[] getSelectIdValues() {
        BillList billList = (BillList)this.getView().getControl(this.getBillListAp());
        ListSelectedRowCollection selects = billList.getSelectedRows();
        return selects.getPrimaryKeyValues();
    }

    public void createJob(Long tagId, Set<Long> allResourceCheckIdSet, String operateKey, Map<Long, Set<Long>> srcMap) {
        try {
            String formNum = ((ListView)this.getView()).getBillFormId();
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String appId = kd.bos.util.StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId()) ? appIdByFormNum : this.getView().getFormShowParameter().getAppId();
            appId = kd.bos.util.StringUtils.isEmpty((String)appId) ? "msplan" : appId;
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("msplan");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setName("msplan-resourcecheck-task-job");
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            jobInfo.setTaskClassname("kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecResourceCheckTask");
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("appId", appId);
            params.put("formNum", formNum);
            params.put("pageId", this.getPageCache().getPageId());
            params.put("tagid", tagId);
            params.put("srcmap", srcMap);
            params.put("resourcecheckids", allResourceCheckIdSet.toString());
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, operateKey);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5\u5f02\u6b65\u4efb\u52a1\u7684\u6267\u884c", (String)"BizResouceCheckCommonListPlugin_06", (String)APPPARAM, (Object[])new Object[0]));
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setClickClassName("kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecResourceCheckClickTask");
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
        catch (Exception e1) {
            logger.warn("ResourceCheckListFormPlugin.execcheck error", (Throwable)e1);
            throw new KDBizException(new ErrorCode("0", e1.getMessage()), new Object[0]);
        }
    }

    public void handleTaskCallBack(Object returnData) {
        try {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && !kd.bos.util.StringUtils.isBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String msgType;
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                switch (msgType = String.valueOf(dataMap.get("msgType"))) {
                    case "errorNotice": {
                        view.showErrorNotification(msg);
                        break;
                    }
                    case "showMess": {
                        view.showMessage(msg);
                        break;
                    }
                    case "successNotice": {
                        Integer showTime = (Integer)dataMap.get("showTime");
                        view.showSuccessNotification(msg, showTime);
                        BillList billList = (BillList)this.getView().getControl(this.getBillListAp());
                        billList.refresh();
                        break;
                    }
                }
            }
        }
        catch (Exception e1) {
            logger.warn("ResourceCheckExecBaseFormPlugin.handleTaskCallBack error", (Throwable)e1);
        }
    }

    public String getToolBarAp() {
        return this.toolBarAp;
    }

    public void setToolBarAp(String toolBarap) {
        this.toolBarAp = toolBarap;
    }

    public String getTblCloseTag() {
        return this.tblCloseAp;
    }

    public void setTblCloseTag(String tblclose) {
        this.tblCloseAp = tblclose;
    }

    public String getGridViewAp() {
        return this.gridViewAp;
    }

    public void setGridViewAp(String gridvp) {
        this.gridViewAp = gridvp;
    }

    public String getBizEntityId() {
        return ((ListView)this.getView()).getBillFormId();
    }

    public String getSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("opnumber");
        sb.append(",").append("opname");
        sb.append(",").append("idsetfieldtag");
        sb.append(",").append("bizresultfieldname");
        sb.append(",").append("bizresultfieldnumber");
        return sb.toString();
    }

    public DynamicObject getResourceCheckObj() {
        String entityId = this.getBizEntityId();
        QFilter qfilter = new QFilter("mainentity", "=", (Object)entityId);
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("isdefault", "=", (Object)"1"));
        return QueryServiceHelper.queryOne((String)"msplan_resourcecheck", (String)this.getSelectProperties(), (QFilter[])qfilter.toArray());
    }

    public void setCacheResourceCheckOpKey(String opKey) {
        this.getPageCache().put(KEY_CACHE_RESOURCECHECK_OPKEY, opKey);
    }

    public String getCacheResourceCheckOpKey() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_RESOURCECHECK_OPKEY);
        return kd.bos.util.StringUtils.isEmpty((String)cacheValue) ? "resourcecheckop" : cacheValue;
    }

    public void setCacheResourceCheckResultColumnA(String columnname) {
        this.getPageCache().put(KEY_CACHE_RESOURCECHECK_RESULTCOLUMNA, columnname);
    }

    public String getCacheResourceCheckResultColumnA() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_RESOURCECHECK_RESULTCOLUMNA);
        return kd.bos.util.StringUtils.isEmpty((String)cacheValue) ? "" : cacheValue;
    }

    public void setCacheResourceCheckResultColumnB(String columnname) {
        this.getPageCache().put(KEY_CACHE_RESOURCECHECK_RESULTCOLUMNB, columnname);
    }

    public String getCacheResourceCheckResultColumnB() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_RESOURCECHECK_RESULTCOLUMNB);
        return kd.bos.util.StringUtils.isEmpty((String)cacheValue) ? "" : cacheValue;
    }

    public void setCacheResourceCheckId(String resourceCheckId) {
        this.getPageCache().put(KEY_CACHE_RESOURCECHECKID, resourceCheckId);
    }

    public Long getCacheResourceCheckId() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_RESOURCECHECKID);
        return kd.bos.util.StringUtils.isEmpty((String)cacheValue) ? 0L : Long.parseLong(cacheValue);
    }

    public void setCacheResourceIdSetTag(String idSetTag) {
        this.getPageCache().put(KEY_CACHE_RESOURCECHECK_IDSETTAG, idSetTag);
    }

    public String getCacheResourceIdSetTag() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_RESOURCECHECK_IDSETTAG);
        return kd.bos.util.StringUtils.isEmpty((String)cacheValue) ? "id" : cacheValue;
    }

    public void setCacheIsAddControl(String istrue) {
        this.getPageCache().put(KEY_CACHE_ISADDBUTTONANDCOLUMN, istrue);
    }

    public boolean getCacheIsAddControl() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_ISADDBUTTONANDCOLUMN);
        return KEY_ISTRUE_STR.equalsIgnoreCase(cacheValue);
    }

    public void setCacheIsExistResultColumn(String istrue) {
        this.getPageCache().put(KEY_CACHE_ISEXISTRESULTCOLUMN, istrue);
    }

    public boolean getCacheIsExistResultColumn() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_ISEXISTRESULTCOLUMN);
        return KEY_ISTRUE_STR.equalsIgnoreCase(cacheValue);
    }

    public void setCacheResourceFilterQCP(String qcp) {
        this.getPageCache().put(KEY_CACHE_RESOURCECHECKFILTER_QCP, qcp);
    }

    public String getCacheResourceFilterQCP() {
        return this.getPageCache().get(KEY_CACHE_RESOURCECHECKFILTER_QCP);
    }

    public void setCacheResourceFilterValue(String value) {
        this.getPageCache().put(KEY_CACHE_RESOURCECHECKFILTER_VALUE, value);
    }

    public String getCacheResourceFilterValue() {
        String cacheValue = this.getPageCache().get(KEY_CACHE_RESOURCECHECKFILTER_VALUE);
        return kd.bos.util.StringUtils.isEmpty((String)cacheValue) ? "" : cacheValue;
    }

    public boolean isF7OpenMode() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            return formShowParameter.getFormId().contains("listf7");
        }
        return false;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs e) {
        super.beforeCreateListColumns(e);
        if (this.isF7OpenMode()) {
            return;
        }
        boolean isAddControl = this.getCacheIsAddControl();
        boolean isExistsResultColumn = this.getCacheIsExistResultColumn();
        long startTime = System.currentTimeMillis();
        if (!isAddControl) {
            DynamicObject resourceCheck = this.getResourceCheckObj();
            if (resourceCheck == null) {
                this.setCacheIsAddControl(KEY_ISTRUE_STR);
                return;
            }
            String opNumber = resourceCheck.getString("opnumber");
            String opName = resourceCheck.getString("opname");
            if (kd.bos.util.StringUtils.isEmpty((String)opNumber) || kd.bos.util.StringUtils.isEmpty((String)opName)) {
                this.setCacheIsAddControl(KEY_ISTRUE_STR);
                return;
            }
            String resultFieldNumber = resourceCheck.getString("bizresultfieldnumber");
            String resultFieldNumberB = this.getLastStr(resultFieldNumber, ".");
            Map<String, Object> existObjMap = this.getExistsDataMap(opNumber, resultFieldNumberB);
            if (!existObjMap.containsKey(opNumber)) {
                Object tblCloseObj = existObjMap.get(this.getTblCloseTag());
                int addIndex = tblCloseObj == null ? 0 : ((BarItemAp)tblCloseObj).getIndex();
                this.addResourceCheckButton(addIndex, opNumber, opName);
            }
            this.setCacheIsExistResultColumn((isExistsResultColumn = existObjMap.containsKey(resultFieldNumberB)) ? KEY_ISTRUE_STR : "false");
            this.setCacheResourceCheckOpKey(opNumber);
            this.setCacheResourceIdSetTag(resourceCheck.getString("idsetfieldtag"));
            this.setCacheResourceCheckResultColumnA(resultFieldNumber);
            this.setCacheResourceCheckResultColumnB(resultFieldNumberB);
            this.setCacheResourceCheckId(resourceCheck.getString("id"));
            this.setCacheIsAddControl(KEY_ISTRUE_STR);
        }
        if (!isExistsResultColumn) {
            String resultFieldNumber = this.getCacheResourceCheckResultColumnB();
            this.createResourceCheckResultColumn(e, resultFieldNumber, ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5\u7ed3\u679c", (String)"BizResouceCheckCommonListPlugin_01", (String)APPPARAM, (Object[])new Object[0]));
        }
        long endTime = System.currentTimeMillis() - startTime;
        logger.info("BizResouceCheckCommonListPlugin,addcolumn and addbutton cost:" + endTime + "ms,entityNumber = " + this.getBizEntityId());
    }

    public void createResourceCheckResultColumn(BeforeCreateListColumnsArgs e, String columnFieldNumber, String columnFieldName) {
        ListColumn addColumn = new ListColumn();
        addColumn.setCaption(new LocaleString(columnFieldName));
        addColumn.setKey(columnFieldNumber + "listap");
        addColumn.setListFieldKey(columnFieldNumber);
        addColumn.setAutoTextWrap(true);
        addColumn.setColumnOrder(true);
        addColumn.setWidth(new LocaleString("8%"));
        addColumn.setVisible(63);
        addColumn.setDesignHidden(false);
        addColumn.setInvisible(true);
        addColumn.setParentViewKey(this.getGridViewAp());
        addColumn.setHyperlink(true);
        addColumn.setSeqColumnType("NotSeq");
        e.getListColumns().add(addColumn);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs e) {
        super.beforeCreateListDataProvider(e);
        if (!this.isF7OpenMode()) {
            e.setListDataProvider((IListDataProvider)new ResourceCheckResultDataProvider());
        }
    }

    private boolean isMatchFilter(String qcp, String value, String newValue, boolean isLeftLike, boolean isRightLike) {
        if (qcp.equals("is not null")) {
            return !kd.bos.util.StringUtils.isEmpty((String)newValue);
        }
        if (qcp.equals("is null")) {
            return kd.bos.util.StringUtils.isEmpty((String)newValue);
        }
        if (qcp.equals("=")) {
            return StringUtils.equals((CharSequence)newValue, (CharSequence)value);
        }
        if (qcp.equals("!=")) {
            return !StringUtils.equals((CharSequence)newValue, (CharSequence)value);
        }
        if (qcp.equals("like")) {
            return isLeftLike && isRightLike ? newValue.contains(value) : (isLeftLike ? newValue.endsWith(value) : (isRightLike ? newValue.startsWith(value) : false));
        }
        if (qcp.equals("not like")) {
            return !newValue.contains(value);
        }
        return true;
    }

    private Map<Long, String> queryLastCheckResult(Set<Long> bizIdSet, String idSetTag, Long srcResourceCheckId) {
        QFilter qfilter = new QFilter("bizbillid", "in", bizIdSet);
        qfilter.and(new QFilter("bizentity", "=", (Object)this.getBizEntityId()));
        qfilter.and(new QFilter("bizidtag", "=", (Object)idSetTag));
        qfilter.and(new QFilter("srcresourcecheck", "=", (Object)srcResourceCheckId));
        DynamicObjectCollection bizResults = QueryServiceHelper.query((String)"msplan_bizbillcheckresult", (String)this.getBizResultProperties(), (QFilter[])new QFilter[]{qfilter});
        HashMap<Long, String> resultMap = new HashMap<Long, String>(bizResults.size());
        for (DynamicObject bizResult : bizResults) {
            resultMap.put(bizResult.getLong("bizbillid"), bizResult.getString("checkremark"));
        }
        return resultMap;
    }

    private Long queryLastCheckResultId(Long bizId, String idSetTag, Long srcResourceCheckId) {
        QFilter qfilter = new QFilter("bizbillid", "=", (Object)bizId);
        qfilter.and(new QFilter("bizentity", "=", (Object)this.getBizEntityId()));
        qfilter.and(new QFilter("bizidtag", "=", (Object)idSetTag));
        qfilter.and(new QFilter("srcresourcecheck", "=", (Object)srcResourceCheckId));
        DynamicObject bizResult = QueryServiceHelper.queryOne((String)"msplan_bizbillcheckresult", (String)"id", (QFilter[])new QFilter[]{qfilter});
        return bizResult == null ? 0L : bizResult.getLong("id");
    }

    private String getBizResultProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("bizbillid");
        sb.append(",").append("checkremark");
        return sb.toString();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String resourceCheckOp = this.getCacheResourceCheckOpKey();
        if (resourceCheckOp.equals(evt.getItemKey())) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(resourceCheckOp, (IFormPlugin)this);
            String msg = ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u5bf9\u9009\u62e9\u7684\u6570\u636e\u6267\u884c\u68c0\u67e5\u5417\uff1f", (String)"BizResouceCheckCommonListPlugin_03", (String)APPPARAM, (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String resourceCheckOp = this.getCacheResourceCheckOpKey();
        if (resourceCheckOp.equals(evt.getItemKey())) {
            Object[] pks = this.getSelectIdValues();
            if (pks == null || pks.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fdb\u884c\u8d44\u6e90\u68c0\u67e5\u7684\u6570\u636e\u884c\u3002", (String)"BizResouceCheckCommonListPlugin_02", (String)APPPARAM, (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long resourceCheckId = this.getCacheResourceCheckId();
            if (resourceCheckId == null || resourceCheckId.equals(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u52a0\u8f7d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u8d44\u6e90\u68c0\u67e5\u9879\u76ee\u3002", (String)"BizResouceCheckCommonListPlugin_04", (String)APPPARAM, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String resourceCheckOp = this.getCacheResourceCheckOpKey();
        if (resourceCheckOp.equals(callBackId) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            this.createExecCheckJob(resourceCheckOp);
        }
    }

    public void createExecCheckJob(String operateKey) {
        Object[] entryPrimaryKeyValues = this.getSelectIdValues();
        HashSet<Long> allResourceCheckIds = new HashSet<Long>(16);
        Set<Long> bizIdSet = Arrays.stream(entryPrimaryKeyValues).mapToLong(obj -> (Long)obj).boxed().collect(Collectors.toSet());
        Long resourceCheckId = this.getCacheResourceCheckId();
        HashSet<Long> resourceCheckIdSet = new HashSet<Long>(16);
        resourceCheckIdSet.add(resourceCheckId);
        HashMap<Long, Set<Long>> srcMap = new HashMap<Long, Set<Long>>(16);
        this.genSrcMap(resourceCheckIdSet, allResourceCheckIds, srcMap);
        Long tagId = this.buildResultData(bizIdSet, resourceCheckIdSet);
        this.createJob(tagId, allResourceCheckIds, operateKey, srcMap);
    }

    private Long buildResultData(Set<Long> bizIds, Set<Long> resourceCheckIds) {
        return (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IResourceCheckBuildResult", (String)"buildResultData", (Object[])new Object[]{bizIds, resourceCheckIds});
    }

    private void genSrcMap(Set<Long> resourceCheckIds, Set<Long> allResourceCheckIds, Map<Long, Set<Long>> srcMap) {
        QFilter qfilter = new QFilter("id", "in", resourceCheckIds);
        DynamicObjectCollection coll = this.queryResourceCheckByFilter(qfilter);
        for (DynamicObject entry : coll) {
            Long itemId = entry.getLong("id");
            this.addToLongMap(itemId, itemId, srcMap);
            allResourceCheckIds.add(itemId);
            if (!"B".equals(entry.getString("checkrange"))) continue;
            Long subItemId = entry.getLong("subid");
            allResourceCheckIds.add(subItemId);
            this.addToLongMap(subItemId, itemId, srcMap);
        }
    }

    private void addToLongMap(Long keyString, Long value, Map<Long, Set<Long>> map) {
        Set<Long> idSet = map.get(keyString);
        if (idSet == null) {
            idSet = new HashSet<Long>(16);
        }
        idSet.add(value);
        map.put(keyString, idSet);
    }

    private DynamicObjectCollection queryResourceCheckByFilter(QFilter qfilter) {
        String selectFields = "id,checkrange,groupcheckentry.resourcecheckitem subid, resultentitynumber,mainentity";
        return QueryServiceHelper.query((String)"msplan_resourcecheck", (String)selectFields, (QFilter[])new QFilter[]{qfilter});
    }

    private Map<Long, String> queryResourceCheckResultEntityNumber(Set<Long> subIdset) {
        QFilter qfilter = new QFilter("id", "in", subIdset);
        DynamicObjectCollection coll = this.queryResourceCheckByFilter(qfilter);
        HashMap<Long, String> dataMap = new HashMap<Long, String>(16);
        for (DynamicObject entry : coll) {
            Long itemId = entry.getLong("id");
            String resultentitynumber = this.getResultEntityNumber(entry.getString("resultentitynumber"));
            dataMap.put(itemId, resultentitynumber);
        }
        return dataMap;
    }

    private String getResultEntityNumber(String oldEntityNumber) {
        return kd.bos.util.StringUtils.isEmpty((String)oldEntityNumber) ? "msplan_checkresult" : oldEntityNumber;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String resourceCheckOp = this.getCacheResourceCheckOpKey();
        if (resourceCheckOp.equals(actionId)) {
            this.handleTaskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    public void addResourceCheckButton(int addIndex, String keyNumber, String keyName) {
        Toolbar toolbarap = (Toolbar)this.getView().getControl(this.getToolBarAp());
        ArrayList<Map> items = new ArrayList<Map>(16);
        BarItemAp barItemAp = new BarItemAp();
        barItemAp.setKey(keyNumber);
        barItemAp.setId(keyNumber);
        barItemAp.setName(new LocaleString(keyName));
        items.add(barItemAp.createControl());
        toolbarap.deleteControls(new String[]{keyNumber});
        toolbarap.insertControls(addIndex - 1, items);
    }

    public Map<String, Object> getExistsDataMap(String resourceCheckOpNumber, String resultFieldNumber) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        String formId = MetadataDao.getIdByNumber((String)this.getBizEntityId(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        List controlAps = formMetadata.getItems();
        String tblCloseTag = this.getTblCloseTag();
        for (ControlAp control : controlAps) {
            if (!(control instanceof BasedataFormAp)) continue;
            BasedataFormAp baseDataFromAp = (BasedataFormAp)control;
            FormMetadata listMeta = baseDataFromAp.getListMeta();
            List listControlAps = listMeta.getItems();
            for (ControlAp listcontrol : listControlAps) {
                ListColumnAp columnAp;
                if (listcontrol instanceof BarItemAp) {
                    BarItemAp toolbarAp = (BarItemAp)listcontrol;
                    if (tblCloseTag.equals(toolbarAp.getKey())) {
                        dataMap.put(tblCloseTag, toolbarAp);
                    }
                    if (resourceCheckOpNumber.equals(toolbarAp.getKey())) {
                        dataMap.put(resourceCheckOpNumber, toolbarAp);
                    }
                }
                if (!(listcontrol instanceof ListColumnAp) || !resultFieldNumber.equals((columnAp = (ListColumnAp)listcontrol).getListFieldId())) continue;
                dataMap.put(resultFieldNumber, columnAp);
            }
        }
        return dataMap;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        if (e == null || e.getFieldName() == null) {
            return;
        }
        String fieldName = e.getFieldName();
        String resultColumn = this.getCacheResourceCheckResultColumnB();
        if (resultColumn != null && resultColumn.equalsIgnoreCase(fieldName)) {
            Long bizId;
            e.setCancel(true);
            BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)e.getHyperLinkClickEvent();
            ListSelectedRow currentRow = event.getCurrentRow();
            String idSetTag = this.getCacheResourceIdSetTag();
            boolean isIdTag = "id".equalsIgnoreCase(idSetTag);
            Long l = bizId = isIdTag ? (Long)currentRow.getPrimaryKeyValue() : (Long)currentRow.getEntryPrimaryKeyValue();
            if (bizId == null || bizId.equals(0L)) {
                return;
            }
            Long bizResultId = this.queryLastCheckResultId(bizId, idSetTag, this.getCacheResourceCheckId());
            if (bizResultId == null || bizResultId.equals(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u68c0\u67e5\u7ed3\u679c\u8868\u7684\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"BizResouceCheckCommonListPlugin_05", (String)APPPARAM, (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("msplan_bizbillcheckresult");
            showParameter.setPkId((Object)bizResultId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        String resultColumn = this.getCacheResourceCheckResultColumnA();
        if (kd.bos.util.StringUtils.isEmpty((String)resultColumn)) {
            return;
        }
        QFilter resultColumnFilter = null;
        for (QFilter filter : filters) {
            String selectField = filter.getProperty();
            List allFilters = filter.getNests(true);
            for (QFilter.QFilterNest sub : allFilters) {
                QFilter qfSub = sub.getFilter();
                String subfieldNumber = qfSub.getProperty();
                if (!subfieldNumber.contains(resultColumn)) continue;
                resultColumnFilter = qfSub;
                filter.clearNests();
                break;
            }
            if (!selectField.contains(resultColumn)) continue;
            resultColumnFilter = filter;
            break;
        }
        if (resultColumnFilter != null) {
            this.setCacheResourceFilterQCP(resultColumnFilter.getCP());
            Object value = resultColumnFilter.getValue();
            this.setCacheResourceFilterValue(value == null || value instanceof QEmptyValue ? "" : (String)value);
            filters.remove(resultColumnFilter);
        } else {
            this.setCacheResourceFilterQCP("");
            this.setCacheResourceFilterValue("");
        }
    }

    private String getLastStr(String str, String chars) {
        int firstDotIndex = str.indexOf(chars);
        if (firstDotIndex != -1) {
            str = str.substring(firstDotIndex + 1);
        }
        return str;
    }

    class ResourceCheckResultDataProvider
    extends ListDataProvider {
        ResourceCheckResultDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection colls = super.getData(start, limit);
            if (null != colls && !colls.isEmpty()) {
                long startTime = System.currentTimeMillis();
                String idSetTag = BizResouceCheckCommonListPlugin.this.getCacheResourceIdSetTag();
                boolean isIdTag = "id".equalsIgnoreCase(idSetTag);
                String resultColumn = BizResouceCheckCommonListPlugin.this.getCacheResourceCheckResultColumnA();
                HashSet<Long> bizIdSet = new HashSet<Long>(colls.size());
                DynamicObject dyn0 = (DynamicObject)colls.get(0);
                boolean isExistsIdtagColumn = isIdTag ? true : dyn0.containsProperty(idSetTag);
                boolean isExistsResultColumn = dyn0.containsProperty(resultColumn);
                if (isExistsIdtagColumn && isExistsResultColumn) {
                    for (DynamicObject dyn : colls) {
                        bizIdSet.add(isIdTag ? ((Long)dyn.getPkValue()).longValue() : dyn.getLong(idSetTag));
                    }
                    if (bizIdSet.isEmpty()) {
                        return colls;
                    }
                    String qcp = BizResouceCheckCommonListPlugin.this.getCacheResourceFilterQCP();
                    String value = BizResouceCheckCommonListPlugin.this.getCacheResourceFilterValue();
                    boolean needFilter = !kd.bos.util.StringUtils.isEmpty((String)qcp);
                    boolean isLeftLike = value.startsWith("%");
                    boolean isRightLike = value.endsWith("%");
                    if (isLeftLike || isRightLike) {
                        value = value.replace("%", "");
                    }
                    Map resultMap = BizResouceCheckCommonListPlugin.this.queryLastCheckResult(bizIdSet, idSetTag, BizResouceCheckCommonListPlugin.this.getCacheResourceCheckId());
                    DynamicObjectCollection newColls = new DynamicObjectCollection(colls.getDynamicObjectType(), colls.getParent());
                    for (DynamicObject dyn : colls) {
                        Long bizId = isIdTag ? ((Long)dyn.getPkValue()).longValue() : dyn.getLong(idSetTag);
                        String objectValue = (String)resultMap.get(bizId);
                        dyn.set(resultColumn, resultMap.get(bizId));
                        if (!needFilter || !BizResouceCheckCommonListPlugin.this.isMatchFilter(qcp, value, objectValue, isLeftLike, isRightLike)) continue;
                        newColls.add((Object)dyn);
                    }
                    if (needFilter) {
                        return newColls;
                    }
                }
                long endTime = System.currentTimeMillis() - startTime;
                logger.info("BizResouceCheckCommonListPlugin,set resourcecheckresult column value cost:" + endTime + "ms,entityNumber = " + BizResouceCheckCommonListPlugin.this.getBizEntityId() + ",colls.size=" + colls.size());
            }
            return colls;
        }
    }
}

