/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.resourcemanagerment;

import java.util.EventObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ConstraintDimensionFormPlugin
extends AbstractFormPlugin {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getControl(BTNOK);
        button.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        MainEntityType dataEntityType;
        String result;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String targetObject = (String)formShowParameter.getCustomParam("targetObject");
        if (StringUtils.isBlank((CharSequence)targetObject)) {
            return;
        }
        String filterConfig = (String)formShowParameter.getCustomParam("filterConfig");
        if (StringUtils.isBlank((CharSequence)filterConfig) && StringUtils.isNotEmpty((CharSequence)(result = this.verifyMasterId((dataEntityType = EntityMetadataCache.getDataEntityType((String)targetObject)).getProperties())))) {
            this.getView().showErrorNotification(result);
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        filterGrid.setEntityNumber(targetObject);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String filterConfig = (String)this.getView().getFormShowParameter().getCustomParam("filterConfig");
        if (StringUtils.isBlank((CharSequence)filterConfig)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConfig, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        filterGrid.SetValue(filterCondition);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (BTNOK.equals(control.getKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            if (filterCondition != null) {
                this.getView().returnDataToParent((Object)filterCondition);
            }
            this.getView().close();
        }
    }

    private String verifyMasterId(DataEntityPropertyCollection properties) {
        for (IDataEntityProperty property : properties) {
            EntryProp entryProp;
            DynamicObjectType itemPropertyType;
            if (property.getClass().isAssignableFrom(BasedataProp.class)) {
                BasedataProp basedataProp = (BasedataProp)property;
                IDataEntityType complexType = basedataProp.getComplexType();
                if (complexType == null) continue;
                for (IDataEntityProperty iDataEntityProperty : complexType.getProperties()) {
                    BasedataProp masterIdProp;
                    if (!"masterid".equals(iDataEntityProperty.getName()) || !(iDataEntityProperty instanceof BasedataProp) || (masterIdProp = (BasedataProp)iDataEntityProperty).getComplexType() != null) continue;
                    return String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u914d\u7f6emasterid\u5f15\u7528\u5c5e\u6027\u3002", (String)"ConstraintDimensionFormPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), basedataProp.getDisplayName().getLocaleValue());
                }
                continue;
            }
            if (!(property instanceof EntryProp) || (itemPropertyType = (entryProp = (EntryProp)property).getDynamicCollectionItemPropertyType()) == null) continue;
            return this.verifyMasterId(itemPropertyType.getProperties());
        }
        return "";
    }
}

