/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.resourcemanagerment;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;

public class LabelColorEdit
extends AbstractBillPlugIn {
    private static final String BTN_SELECT_COLOR = "btn_select_color";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SELECT_COLOR});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillColor((String)this.getModel().getValue("color"));
    }

    public void click(EventObject evt) {
        String status;
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (BTN_SELECT_COLOR.equals(control.getKey()) && StringUtils.equals((CharSequence)"A", (CharSequence)(status = (String)this.getModel().getValue("status")))) {
            this.showColorSelectorForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (BTN_SELECT_COLOR.equals(actionId) && returnData instanceof String) {
            String color = (String)returnData;
            this.getModel().setValue("color", (Object)color);
            this.fillColor(color);
        }
    }

    private void fillColor(String color) {
        if (StringUtils.isBlank((CharSequence)color)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("bc", color);
        this.getView().updateControlMetadata(BTN_SELECT_COLOR, params);
    }

    private void showColorSelectorForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mpdm_color_selector");
        formShowParameter.setShowClose(false);
        formShowParameter.setShowTitle(false);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SELECT_COLOR));
        String color = (String)this.getModel().getValue("color");
        if (StringUtils.isNotBlank((CharSequence)color)) {
            formShowParameter.setCustomParam("color", (Object)color);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }
}

