/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.resourcemanagerment;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;

public class ResourceConstraintConfigEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String CACHE_SELECTEDROW = "selectedRow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit dimension = (TextEdit)this.getControl("dimension");
        dimension.addButtonClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        int selectedRowFromCache;
        int row = evt.getRow();
        if (row != (selectedRowFromCache = this.getSelectedRowFromCache())) {
            this.getPageCache().put(CACHE_SELECTEDROW, Integer.toString(row));
            this.reloadFilterGrid();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.getPageCache().remove(CACHE_SELECTEDROW);
        this.reloadFilterGrid(null);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getPageCache().remove(CACHE_SELECTEDROW);
        if (entryCurrentRowIndex == -1) {
            this.reloadFilterGrid(null);
        } else {
            this.reloadFilterGrid();
        }
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        this.getPageCache().remove(CACHE_SELECTEDROW);
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        this.getPageCache().remove(CACHE_SELECTEDROW);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("dimension".equals(control.getKey())) {
            DynamicObject targetObject = (DynamicObject)this.getModel().getValue("targetobject");
            if (targetObject == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ea6\u675f\u5bf9\u8c61\u201d\u3002", (String)"ResourceConstraintConfigEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            String filterConfig = (String)this.getModel().getValue("filterconfig_tag");
            this.showDimensionConfigForm(targetObject, filterConfig);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("dimension".equals(closedCallBackEvent.getActionId())) {
            FilterCondition filterCondition = (FilterCondition)returnData;
            DynamicObject targetObject = (DynamicObject)this.getModel().getValue("targetobject");
            String entityNumber = targetObject.getString("number");
            this.getModel().setValue("dimension", (Object)this.convertFilterCondition(filterCondition, entityNumber));
            this.getModel().setValue("filterconfig_tag", (Object)SerializationUtils.toJsonString((Object)filterCondition));
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            filterGrid.setEntityNumber(entityNumber);
            filterGrid.SetValue(filterCondition);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("targetobject".equals(name)) {
            this.targetObjectChanged(changeData);
        } else if ("dimension".equals(name)) {
            this.dimensionChanged(changeData);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        if (collection.isEmpty()) {
            return;
        }
        int ordinal = collection.getDynamicObjectType().getProperty("filterconfig_tag").getOrdinal();
        for (DynamicObject dynamicObject : collection) {
            dynamicObject.getDataEntityState().setBizChanged(ordinal, false);
        }
    }

    private void reloadFilterGrid() {
        this.reloadFilterGrid((String)this.getModel().getValue("filterconfig_tag"));
    }

    private void reloadFilterGrid(String filterConfig) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        if (StringUtils.isBlank((CharSequence)filterConfig)) {
            filterGrid.SetValue(new FilterCondition());
            return;
        }
        DynamicObject targetObject = (DynamicObject)this.getModel().getValue("targetobject");
        if (targetObject == null) {
            filterGrid.SetValue(new FilterCondition());
            return;
        }
        filterGrid.setEntityNumber(targetObject.getString("number"));
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConfig, FilterCondition.class);
        filterGrid.SetValue(filterCondition);
        this.getView().updateView(FILTERGRIDAP);
    }

    private int getSelectedRowFromCache() {
        String str = this.getPageCache().get(CACHE_SELECTEDROW);
        return str == null ? -1 : Integer.parseInt(str);
    }

    private void showDimensionConfigForm(DynamicObject targetObject, String filterConfig) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mpdm_constraint_dimension");
        formShowParameter.setCustomParam("targetObject", (Object)targetObject.getString("number"));
        formShowParameter.setCustomParam("filterConfig", (Object)filterConfig);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimension"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void dimensionChanged(ChangeData changeData) {
        if (StringUtils.isBlank((Object)changeData.getNewValue())) {
            int rowIndex = changeData.getRowIndex();
            this.getModel().beginInit();
            this.getModel().setValue("filterconfig_tag", null, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("filterconfig_tag", rowIndex);
            this.reloadFilterGrid();
        }
    }

    private void targetObjectChanged(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        this.getModel().beginInit();
        this.getModel().setValue("dimension", null, rowIndex);
        this.getModel().setValue("filterconfig_tag", null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("dimension", rowIndex);
        this.getView().updateView("filterconfig_tag", rowIndex);
        if (changeData.getOldValue() != null) {
            this.reloadFilterGrid();
        }
    }

    private String convertFilterCondition(FilterCondition filterCondition, String targetObjectNumber) {
        List filterRow = filterCondition.getFilterRow();
        if (filterRow.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)targetObjectNumber);
        HashMap<String, FilterField> filterFieldCache = new HashMap<String, FilterField>();
        int maxFilterRowIndex = filterRow.size() - 1;
        for (int i = 0; i <= maxFilterRowIndex; ++i) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterRow.get(i);
            String fieldName = simpleFilterRow.getFieldName();
            FilterField filterField = filterFieldCache.computeIfAbsent(fieldName, k -> FilterField.create((MainEntityType)dt, (String)fieldName));
            sb.append(simpleFilterRow.getLeftBracket()).append(filterField.getCaption().getLocaleValue()).append(' ').append(filterField.getCompareType(simpleFilterRow.getCompareType()).getOperate()).append(" [");
            List value = simpleFilterRow.getValue();
            int maxValueIndex = value.size() - 1;
            for (int j = 0; j <= maxValueIndex; ++j) {
                sb.append(((FilterValue)value.get(j)).getValue());
                if (j == maxValueIndex) break;
                sb.append(',');
            }
            sb.append(']').append(simpleFilterRow.getRightBracket());
            if (i == maxFilterRowIndex) break;
            sb.append(simpleFilterRow.getLogic().equals("0") ? " AND " : " OR ");
            if (sb.length() > 255) break;
        }
        if (sb.length() > 255) {
            sb.replace(252, sb.length(), "...");
        }
        return sb.toString();
    }
}

