/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.resourcemanagerment;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class WorkCenterInfoEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String PRIORITY = "priority";
    private static final String ABILITYMULTIPLE = "abilitymultiple";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SUPPLYWAY = "supplyway";
    private static final String ABILITY = "ability";
    private static final String WAREHOUSENO = "warehouseno";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ability = (BasedataEdit)this.getControl(ABILITY);
        ability.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{WAREHOUSENO});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)ABILITYMULTIPLE, (CharSequence)key)) {
            this.afterAbilitymultipleChanged(e);
        } else if (StringUtils.equals((CharSequence)WAREHOUSENO, (CharSequence)key)) {
            this.afterWarehousenoChanged(e);
        }
    }

    private void afterWarehousenoChanged(PropertyChangedArgs e) {
        String obj = (String)e.getChangeSet()[0].getNewValue();
        if (StringUtils.isEmpty((CharSequence)obj)) {
            this.setWarehouse(null, null, null);
        }
    }

    private void afterAbilitymultipleChanged(PropertyChangedArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        String supplyway = (String)this.getModel().getValue(SUPPLYWAY, focusRow);
        if (!StringUtils.equals((CharSequence)"B", (CharSequence)supplyway)) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        Integer abilitymultiple = (Integer)changeData.getNewValue();
        if (abilitymultiple == null) {
            return;
        }
        if (abilitymultiple <= 0) {
            this.getModel().setValue(ABILITYMULTIPLE, null, focusRow);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    public void afterLoadData(EventObject e) {
        DynamicObject workcenter = (DynamicObject)this.getModel().getValue("masterid");
        this.getModel().setValue("workcenter", (Object)workcenter);
        this.getModel().setValue("group", workcenter.get("groupid"));
        this.getModel().setValue("parentworkcenter", workcenter.get("parentcenter"));
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String key = basedataEdit.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)ABILITY)) {
            this.beforeAbilityF7Select(event);
        }
    }

    private void beforeAbilityF7Select(BeforeF7SelectEvent event) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Object> selectedIds = new ArrayList<Object>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject ability = dynamicObject.getDynamicObject(ABILITY);
            if (ability == null) continue;
            selectedIds.add(ability.getPkValue());
        }
        QFilter qfilter = new QFilter("id", "not in", selectedIds);
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)WAREHOUSENO)) {
            this.showWarehouseF7();
        }
    }

    private void showWarehouseF7() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_warehouse", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, WAREHOUSENO));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)WAREHOUSENO)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
            if (returnData == null) {
                return;
            }
            ListSelectedRow selectedRow = returnData.get(0);
            this.setWarehouse(selectedRow.getPrimaryKeyValue(), selectedRow.getNumber(), selectedRow.getName());
        }
    }

    protected void setWarehouse(Object id, Object number, Object name) {
        this.getModel().setValue("warehouse", id);
        if (number != null) {
            this.getModel().setValue(WAREHOUSENO, number);
        }
        this.getModel().setValue("warehousename", name);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void initWarehouse() {
    }
}

