/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ClassSystemEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String KEY_DELETELIST = "deleteList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit workshift = (BasedataEdit)this.getControl("workshift");
        if (workshift != null) {
            workshift.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            workshift.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        if ("workshift".equals(propertyName)) {
            Object oldValue = cd.getOldValue();
            Object newValue = cd.getNewValue();
            if (oldValue != null && newValue == null) {
                long workShiftId = (Long)((DynamicObject)oldValue).getPkValue();
                List<Integer> deleteList = this.getRowIndexList(workShiftId);
                int[] deleteRowIndex = new int[deleteList.size()];
                for (int i = 0; i < deleteList.size(); ++i) {
                    deleteRowIndex[i] = Integer.parseInt(deleteList.get(i).toString());
                }
                this.getModel().deleteEntryRows("entryentity", deleteRowIndex);
                int rowIndex = cd.getRowIndex();
                if (rowIndex >= 0) {
                    this.getModel().setValue("workstarttime", (Object)-1, rowIndex);
                    this.getModel().setValue("workendtime", (Object)-1, rowIndex);
                    this.getModel().setValue("worktime", (Object)0, rowIndex);
                    this.getModel().setValue("iscrossday", (Object)Boolean.FALSE, rowIndex);
                    this.getModel().setValue("wsentryid", (Object)0, rowIndex);
                    this.getModel().setValue("workshiftid", (Object)0, rowIndex);
                }
            }
            if (newValue != null) {
                this.updateView(newValue, oldValue);
            }
            this.calculateClassSystemTime();
        }
    }

    private void updateView(Object newValue, Object oldValue) {
        long workShiftId;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List<Object> deleteList = new ArrayList();
        if (oldValue != null) {
            workShiftId = (Long)((DynamicObject)oldValue).getPkValue();
            deleteList = this.getRowIndexList(workShiftId);
        }
        workShiftId = (Long)((DynamicObject)newValue).getPkValue();
        List<Integer> deleteListNew = this.getRowIndexList(workShiftId);
        deleteList.addAll(deleteListNew);
        if (!deleteList.isEmpty()) {
            String delStr = SerializationUtils.toJsonString(deleteList);
            this.getPageCache().put(KEY_DELETELIST, delStr);
        } else {
            this.getPageCache().put(KEY_DELETELIST, null);
        }
        DynamicObject workShift = BusinessDataServiceHelper.loadSingle((Object)workShiftId, (String)"mpdm_workshifts");
        DynamicObjectCollection shiftEntries = workShift.getDynamicObjectCollection("entryentity");
        if (shiftEntries == null || shiftEntries.isEmpty()) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("workshift", new Object[0]);
        vs.addField("workstarttime", new Object[0]);
        vs.addField("workendtime", new Object[0]);
        vs.addField("worktime", new Object[0]);
        vs.addField("iscrossday", new Object[0]);
        vs.addField("wsentryid", new Object[0]);
        vs.addField("workshiftid", new Object[0]);
        for (int i = 0; i < shiftEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)shiftEntries.get(i);
            BigDecimal workStartTime = entry.get("workstarttime") == null ? new BigDecimal(-1) : new BigDecimal(entry.get("workstarttime").toString());
            BigDecimal workEndTIme = entry.get("workendtime") == null ? new BigDecimal(-1) : new BigDecimal(entry.get("workendtime").toString());
            BigDecimal workTIme = (BigDecimal)entry.get("worktime");
            boolean isCrossDay = entry.getBoolean("iscrossday");
            long wsentryid = (Long)entry.getPkValue();
            vs.addRow(new Object[]{i, workShiftId, workStartTime, workEndTIme, workTIme, isCrossDay, wsentryid, workShiftId});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List<Integer> list;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        IDataModel model = this.getModel();
        if ("save".equals(operateKey) && e.getOperationResult().isSuccess()) {
            DynamicObject workshift = model.getDataEntity();
            if (workshift == null) {
                return;
            }
            workshift.set("status", (Object)"A");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workshift});
            this.getView().updateView();
        }
        if ("deleteline".equals(operateKey)) {
            this.deleteLine();
        }
        if ("newentry".equals(operateKey) && (list = this.getRowIndexList(0L)).size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7a7a\u767d\u5206\u5f55\u3002", (String)"ClassSystemEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getModel().deleteEntryRow("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
        }
    }

    private void deleteLine() {
        EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectIndex = entry.getSelectRows();
        ArrayList<Integer> deleteList = new ArrayList<Integer>();
        for (int i = 0; i < selectIndex.length; ++i) {
            long workShiftId = (Long)this.getModel().getValue("workshiftid", selectIndex[i]);
            if (workShiftId == 0L) {
                deleteList.add(selectIndex[i]);
                continue;
            }
            List<Integer> rowList = this.getRowIndexList(workShiftId);
            for (int j = 0; j < rowList.size(); ++j) {
                deleteList.add(rowList.get(j));
            }
        }
        HashSet set = new HashSet(deleteList);
        deleteList = new ArrayList(set);
        int[] deleteIndex = new int[deleteList.size()];
        for (int i = 0; i < deleteList.size(); ++i) {
            deleteIndex[i] = Integer.parseInt(((Integer)deleteList.get(i)).toString());
        }
        this.getModel().deleteEntryRows("entryentity", deleteIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)e.getEntryProp().getName())) {
            this.calculateClassSystemTime();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private void calculateClassSystemTime() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int rowCounts = model.getEntryRowCount("entryentity");
        BigDecimal classSystemTime = BigDecimal.ZERO;
        for (int i = 0; i < rowCounts; ++i) {
            String workTimeStr = this.getModel().getValue("worktime", i).toString();
            BigDecimal workTime = new BigDecimal(workTimeStr);
            classSystemTime = classSystemTime.add(workTime);
        }
        model.setValue("classsystemtime", (Object)classSystemTime);
    }

    private List<Integer> getRowIndexList(long workShiftId) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        if (entrys == null || entrys.isEmpty()) {
            return list;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject workShift = entry.getDynamicObject("workshift");
            long wsId = 0L;
            if (workShift != null) {
                wsId = (Long)workShift.getPkValue();
            }
            if (workShiftId != wsId) continue;
            list.add(i);
        }
        return list;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (event == null) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        IDataModel dm = fv.getModel();
        if (dm == null) {
            return;
        }
        FormShowParameter fsp = event.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        this.setFilter(fsp, event, dm);
    }

    private void setFilter(FormShowParameter fsp, BeforeF7SelectEvent event, IDataModel dm) {
        String srcDEPName;
        ListFilterParameter lfp;
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lfp == null) {
            return;
        }
        IDataEntityProperty srcDEP = event.getProperty();
        String string = srcDEPName = srcDEP == null ? null : srcDEP.getName();
        if (StringUtils.isBlank((CharSequence)srcDEPName)) {
            return;
        }
        this.setF7Filter(srcDEPName, dm, lsp, lfp, event);
    }

    private void setF7Filter(String srcDEPName, IDataModel dm, ListShowParameter lsp, ListFilterParameter lfp, BeforeF7SelectEvent event) {
        DynamicObjectCollection entrys;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (StringUtils.equalsIgnoreCase((CharSequence)"workshift", (CharSequence)srcDEPName) && (entrys = dm.getEntryEntity("entryentity")) != null && !entrys.isEmpty()) {
            this.addFilter(qFilterList, entrys);
        }
        if (!qFilterList.isEmpty()) {
            List qFilters = lfp.getQFilters();
            qFilterList.addAll(qFilters);
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            event.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    private void addFilter(List<QFilter> qFilterList, DynamicObjectCollection entrys) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (DynamicObject entry : entrys) {
            DynamicObject workShift = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"workshift");
            if (workShift == null || list.contains(workShift.getPkValue())) continue;
            list.add(workShift.getPkValue());
        }
        if (!list.isEmpty()) {
            QFilter qFilter = new QFilter("id", "not in", list);
            qFilterList.add(qFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        Object source = event.getSource();
        if (source instanceof BasedataEdit && StringUtils.equalsIgnoreCase((CharSequence)((BasedataEdit)source).getKey(), (CharSequence)"workshift")) {
            String delStr = this.getPageCache().get(KEY_DELETELIST);
            if (StringUtils.isNotBlank((CharSequence)delStr)) {
                this.deleteEntry(delStr);
            }
            this.getPageCache().put(KEY_DELETELIST, null);
        }
    }

    private void deleteEntry(String delStr) {
        List deleteList = SerializationUtils.fromJsonStringToList((String)delStr, Long.TYPE);
        if (deleteList != null && !deleteList.isEmpty()) {
            int[] deleteRowIndex = new int[deleteList.size()];
            for (int i = 0; i < deleteList.size(); ++i) {
                deleteRowIndex[i] = Integer.parseInt(deleteList.get(i).toString());
            }
            this.getModel().deleteEntryRows("entryentity", deleteRowIndex);
        }
    }
}

