/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class MPDMBomTypeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((String)number)) {
            this.getModel().setValue("issyspre", (Object)Boolean.FALSE);
        }
        this.setVerifyDimensionMust();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit versionrule = (BasedataEdit)this.getControl("versionrule");
        if (versionrule != null) {
            versionrule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String source = con.getKey();
        if ("versionrule".equals(source)) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(this.getVersionRuleQfilter());
        }
    }

    private void setVerifyDimensionMust() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object checkrepeatObj = model.getValue("checkrepeat");
        MulComboEdit verifyDimensionControl = (MulComboEdit)view.getControl("verifydimension");
        if (checkrepeatObj != null && "A".equals(String.valueOf(checkrepeatObj))) {
            verifyDimensionControl.setMustInput(false);
        } else {
            verifyDimensionControl.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDatas;
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        for (ChangeData changeData : changeDatas = e.getChangeSet()) {
            this.fieldChanged(fieldName, changeData);
        }
    }

    public void fieldChanged(String fieldName, ChangeData changeData) {
        if ("isversion".equals(fieldName)) {
            boolean isVersion = (Boolean)changeData.getNewValue();
            this.setDefaultVerRule(isVersion);
        } else if ("purpose".equals(fieldName)) {
            String purpose = String.valueOf(changeData.getNewValue());
            this.isConfigTypeMustInput(purpose);
            this.setSuperBomOrSaleBom(purpose);
        } else if ("issurereplace".equals(fieldName)) {
            boolean isReplace = (Boolean)changeData.getNewValue();
            this.isReplaceObjMustInput(isReplace);
        } else if ("checkrepeat".equals(fieldName)) {
            this.setVerifyDimensionMust();
        }
    }

    private void setSuperBomOrSaleBom(String purpose) {
        if ("B".equals(purpose)) {
            this.getModel().setValue("issuperbom", (Object)true);
            this.getModel().setValue("issalebom", (Object)false);
        } else if ("C".equals(purpose)) {
            this.getModel().setValue("issuperbom", (Object)false);
            this.getModel().setValue("issalebom", (Object)true);
        } else {
            this.getModel().setValue("issuperbom", (Object)false);
            this.getModel().setValue("issalebom", (Object)false);
        }
        this.getView().updateView("issuperbom");
        this.getView().updateView("issalebom");
    }

    public void setDefaultVerRule(boolean isVersion) {
        this.getModel().beginInit();
        if (isVersion) {
            DynamicObject versionRule = this.getDefaultVersionRule("A");
            this.getModel().setValue("versionrule", (Object)versionRule);
        } else {
            this.getModel().setValue("versionrule", null);
        }
        this.getModel().endInit();
        this.getView().updateView("versionrule");
    }

    public QFilter getVersionRuleQfilter() {
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterType = new QFilter("multype", "like", (Object)"%A%");
        return qFilterStatus.and(qFilterEnable).and(qFilterType);
    }

    public DynamicObject getDefaultVersionRule(String type) {
        String defField = "B".equals(type) ? "isdefaultroute" : ("C".equals(type) ? "isdefaultprograme" : "isdefault");
        QFilter qFilter2 = new QFilter(defField, "=", (Object)Boolean.TRUE);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bomversionrule_new", (String)"id,number,entryentity.version", (QFilter[])new QFilter[]{qFilter2, this.getVersionRuleQfilter()});
    }

    public void isConfigTypeMustInput(String purpose) {
        FieldEdit configTypeEdit = (FieldEdit)this.getView().getControl("configtype");
        if ("B".equals(purpose)) {
            configTypeEdit.setMustInput(true);
        } else {
            configTypeEdit.setMustInput(false);
            this.getModel().setValue("configtype", null);
        }
    }

    public void isReplaceObjMustInput(boolean isReplace) {
        FieldEdit replaceobjEdit = (FieldEdit)this.getView().getControl("replaceobj");
        if (isReplace) {
            replaceobjEdit.setMustInput(true);
        } else {
            replaceobjEdit.setMustInput(false);
        }
    }
}

