/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MPDMManuPersonEditPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    public static final String USER = "user";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject user = (DynamicObject)this.getModel().getValue(USER);
        this.showWorkAge(user);
        this.showCoreTeam();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"coreteamtab")) {
            this.showCoreTeam();
        }
    }

    public void showCoreTeam() {
        Object currentPkValue = this.getModel().getDataEntity().getPkValue();
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("personnelentry.personnel", "in", currentPkValue));
        DynamicObjectCollection coreteams = QueryServiceHelper.query((String)"fmm_coreteam", (String)"id", (QFilter[])qFilter.toArray());
        if (null != coreteams) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("teamnumber", new Object[0]);
            vs.addField("ctname", new Object[0]);
            vs.addField("ctcust", new Object[0]);
            vs.addField("ctstatus", new Object[0]);
            vs.addField("crole", new Object[0]);
            for (DynamicObject coreteam : coreteams) {
                DynamicObject coreteamInfo = BusinessDataServiceHelper.loadSingle((Object)coreteam.getLong("id"), (String)"fmm_coreteam");
                if (null == coreteamInfo) continue;
                DynamicObject customer = coreteamInfo.getDynamicObject("customer");
                model.deleteEntryData("coreteamentity");
                this.getView().updateView("coreteamentity");
                String roleMsg = "";
                DynamicObjectCollection personnelentry = coreteamInfo.getDynamicObjectCollection("personnelentry");
                for (DynamicObject person : personnelentry) {
                    DynamicObject personnel = person.getDynamicObject("personnel");
                    if (!currentPkValue.equals(personnel.getPkValue())) continue;
                    roleMsg = person.getString("role.name");
                    break;
                }
                vs.addRow(new Object[]{coreteamInfo.getString("number"), coreteamInfo.getLocaleString("name").getLocaleValue(), customer.getLocaleString("name").getLocaleValue(), coreteamInfo.getInt("enable"), roleMsg});
            }
            model.batchCreateNewEntryRow("coreteamentity", vs);
            this.getView().updateView("coreteamentity");
            model.endInit();
        }
    }

    public void showWorkAge(DynamicObject user) {
        if (null != user) {
            String enable = user.getString("enable");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)enable)) {
                this.getModel().setValue("personstatus", (Object)true);
            }
            this.getWorkAge();
        }
    }

    public void getWorkAge() {
        Date hiredate = (Date)this.getModel().getValue("hiredate");
        if (null != hiredate) {
            Calendar cal = Calendar.getInstance();
            int yearNow = cal.get(1);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            int hireYear = Integer.parseInt(sdf.format(hiredate));
            this.getModel().setValue("workage", (Object)(yearNow - hireYear));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject user = (DynamicObject)this.getModel().getValue(USER);
        this.showWorkAge(user);
        this.showCoreTeam();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (USER.equals(propName)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            this.showWorkAge(newValue);
        }
        if ("hiredate".equals(propName)) {
            this.getWorkAge();
        }
    }
}

