/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class MPDMWorkcentreEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
IDataModelListener {
    private Boolean isIgnoreFieldChange = Boolean.FALSE;
    private static String MPDM_RESOURCES = "mpdm_resources";
    private static String RESOURCES_QUERY = "id,number,sharingtype";
    private static String MPDM_WORKCENTRE = "mpdm_workcentre";
    private static String USER_QUERY = "id,number";
    private static String WORKCENTRE_QUERY = "id,name,parentorg.name,parentorg.number,entryresouce.resource";
    private static String ENTRY_ENTITY = "entryentity";
    private static String ABILITY_TYPE = "abilitytype";
    private static String ID = "id";
    private static String MPDM_WORKCENT_GROUP = "mpdm_workcentgroup";
    private static String MANUAL = "manual";
    private static String MACHINE = "machine";
    private static String NUMBER = "number";
    private static String MPDM_SHARINGRESOUCE = "mpdm_sharingresouce";
    private static String SHARINGTYPE = "sharingtype";
    private static String ENTRYRESOUCE_RESOURCE = "entryresouce.resource";
    private static String WORKCENT_GROUP_QUERY = "id,name,abilitygroup";
    private static String ABILITYGROUP = "abilitygroup";
    private static String PARENT_WORKCENT_QUERY = "id,name,groupid,abilitytype,parentcenter";
    private static String ENABLE_TRUE = "1";
    private static String BACKFLUSHFLAG = "backflushflag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryresouce");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit resource = (BasedataEdit)this.getView().getControl("resource");
        resource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehouse = (BasedataEdit)this.getView().getControl("warehouse");
        warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit location = (BasedataEdit)this.getView().getControl("location");
        location.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit processactive = (BasedataEdit)this.getView().getControl("processactive");
        processactive.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit activeformula = (BasedataEdit)this.getView().getControl("activeformula");
        activeformula.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit reportformula = (BasedataEdit)this.getView().getControl("reportformula");
        reportformula.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        String parentname = paramBeforeF7SelectEvent.getProperty().getName();
        if ("resource".equals(parentname)) {
            List<Object> ids = new ArrayList<Object>();
            ids = this.getIds(ids);
            QFilter listFilter = new QFilter(ID, "not in", ids);
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(listFilter);
        } else if ("warehouse".equals(parentname)) {
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            QFilter qFilter = null;
            if (createOrg == null) {
                return;
            }
            if (((Boolean)createOrg.get("fisinventory")).booleanValue()) {
                qFilter = new QFilter("org.id", "=", createOrg.getPkValue());
            } else {
                List<Long> list = this.getFromOrgs("05", (Long)createOrg.getPkValue(), "04", false);
                qFilter = new QFilter("org.id", "in", list);
            }
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            QFilter enableFilter = new QFilter("enable", "=", (Object)ENABLE_TRUE);
            QFilter initstatusFilter = new QFilter("initstatus", "=", (Object)"B");
            QFilter startstatusFilter = new QFilter("startstatus", "=", (Object)"B");
            DynamicObjectCollection col = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{qFilter, initstatusFilter, startstatusFilter, enableFilter});
            ArrayList<Object> obj = new ArrayList<Object>(col.size());
            for (int i = 0; i < col.size(); ++i) {
                obj.add(((DynamicObject)col.get(i)).get("warehouse.id"));
            }
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", obj));
        } else if (StringUtils.equals((CharSequence)"location", (CharSequence)parentname)) {
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
            if (warehouse == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93\u3002", (String)"MPDMWorkcentreEdit_19", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                paramBeforeF7SelectEvent.setCancel(true);
                return;
            }
            this.setLocationFilter(warehouse.getLong("id"), paramBeforeF7SelectEvent);
        } else if (StringUtils.equals((CharSequence)"processactive", (CharSequence)parentname)) {
            this.showResourceProcess(paramBeforeF7SelectEvent);
        } else if (StringUtils.equals((CharSequence)"activeformula", (CharSequence)parentname) || StringUtils.equals((CharSequence)"reportformula", (CharSequence)parentname)) {
            int seq = paramBeforeF7SelectEvent.getRow();
            Object obj = this.getModel().getValue("processnumber", seq);
            if (ObjectUtils.isEmpty((Object)obj)) {
                int flag = seq + 1;
                String info = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%1$s\u884c\u5de5\u5e8f\u7f16\u7801\u3002", (String)"MPDMWorkcentreEdit_20", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), flag);
                this.getView().showTipNotification(info);
                paramBeforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject process = (DynamicObject)obj;
            String processstage = process.getString("processstage");
            QFilter listFilter = new QFilter("processstage", "=", (Object)processstage);
            ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(listFilter);
        }
    }

    public void showResourceProcess(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("processactivetable");
        ArrayList<Object> processList = new ArrayList<Object>();
        if (entryEntity != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject processNumber = (DynamicObject)((DynamicObject)entryEntity.get(i)).get("processnumber");
                if (processNumber == null) continue;
                processList.add(processNumber.getPkValue());
            }
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", processList));
    }

    private void setLocationFilter(Long warehouseId, BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>();
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)warehouseId, (String)"bd_warehouse");
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : col) {
            DynamicObject location = dynamicObject.getDynamicObject("location");
            if (location == null) continue;
            locationList.add(location.getPkValue());
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationList);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private List<Object> getIds(List<Object> ids) {
        DynamicObject[] resourcesInfo;
        int index = this.getModel().getEntryCurrentRowIndex("entryresouce");
        DynamicObject dyobejct = (DynamicObject)this.getModel().getValue("resource", index);
        if (dyobejct != null && "2".equals(dyobejct.get(SHARINGTYPE))) {
            ids.add(dyobejct.getPkValue());
        }
        QFilter resourcesFilter = new QFilter(SHARINGTYPE, "=", (Object)"2");
        for (DynamicObject dynamicObject : resourcesInfo = BusinessDataServiceHelper.load((String)MPDM_RESOURCES, (String)RESOURCES_QUERY, (QFilter[])new QFilter[]{resourcesFilter})) {
            QFilter qfilter = new QFilter(ENTRYRESOUCE_RESOURCE, "=", dynamicObject.getPkValue());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)MPDM_WORKCENTRE, (String)WORKCENTRE_QUERY, (QFilter[])new QFilter[]{qfilter});
            if (dynamicObjects.length <= 0) continue;
            ids.add(dynamicObject.getPkValue());
        }
        return ids;
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache pageCache;
        Map map;
        String treeNode;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject workcentInfo = model.getDataEntity();
        if (workcentInfo == null) {
            return;
        }
        DynamicObjectCollection entryA = (DynamicObjectCollection)workcentInfo.get("entryproduct");
        for (int i = 0; i < entryA.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entryA.get(i);
            entryInfo.set("workcentf7", (Object)workcentInfo);
        }
        IFormView pView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (pView instanceof IListView && (treeNode = (String)(map = (pageCache = (IPageCache)pView.getService(IPageCache.class)).getAll()).get("workcentid")) != null && !"root".equals(treeNode)) {
            this.updateCell(treeNode);
        }
    }

    private void updateCell(String treeNode) {
        if (treeNode.contains("workcent")) {
            String workcentid = treeNode.replaceAll("workcent", "");
            QFilter[] filter = new QFilter[]{new QFilter(ID, "=", (Object)Long.valueOf(workcentid))};
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)MPDM_WORKCENTRE, (String)PARENT_WORKCENT_QUERY, (QFilter[])filter);
            if (dynamicObjects.length > 0) {
                this.getModel().setValue("groupid", dynamicObjects[0].get("groupid"));
                this.getModel().setValue("parentcenter", (Object)dynamicObjects[0]);
            }
        } else {
            QFilter[] filter = new QFilter[1];
            boolean isNum = treeNode.matches("[0-9]+");
            if (isNum) {
                filter[0] = new QFilter(ID, "=", (Object)Long.valueOf(treeNode));
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)MPDM_WORKCENT_GROUP, (String)WORKCENT_GROUP_QUERY, (QFilter[])filter);
                if (dynamicObjects.length > 0) {
                    this.getModel().setValue("groupid", (Object)dynamicObjects[0]);
                    this.getModel().setValue(ABILITY_TYPE, dynamicObjects[0].get(ABILITYGROUP));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        IDataModel model = this.getModel();
        if ("save".equals(operateKey) && e.getOperationResult().isSuccess()) {
            DynamicObject workcentInfo = model.getDataEntity();
            if (workcentInfo == null) {
                return;
            }
            DynamicObjectCollection entryA = (DynamicObjectCollection)workcentInfo.get("entryproduct");
            for (int i = 0; i < entryA.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entryA.get(i);
                if (entryInfo.get("workcentf7") != null) continue;
                entryInfo.set("workcentf7", (Object)workcentInfo);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workcentInfo});
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            this.setBackFlushFlag(model);
            this.checkNumOnly(args);
        } else if (StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            this.setBackFlushFlag(model);
            this.checkNumOnly(args);
        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey)) {
            this.setBackFlushFlag(model);
        }
    }

    private void checkNumOnly(BeforeDoOperationEventArgs e) {
        DynamicObject[] load;
        String newNum = (String)this.getModel().getValue("number");
        String productType = (String)this.getModel().getValue("product_type");
        if ("".equals(newNum)) {
            return;
        }
        ArrayList<String> stutas = new ArrayList<String>(2);
        stutas.add("B");
        stutas.add("C");
        QFilter statusFilter = new QFilter("status", "in", stutas);
        QFilter controlFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workcentre", (Long)RequestContext.get().getOrgId());
        QFilter typeFilter = new QFilter("product_type", "=", (Object)productType);
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"mpdm_workcentre", (String)"number", (QFilter[])new QFilter[]{controlFilter.and(statusFilter).and(typeFilter)})) {
            String number = dynamicObject.getString("number");
            if (!number.equals(newNum)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u4e0b\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MPDMWorkcentreEdit_21", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number));
            e.setCancel(true);
            break;
        }
    }

    public void setBackFlushFlag(IDataModel model) {
        Object backflushflag = model.getValue(BACKFLUSHFLAG);
        if (Objects.isNull(backflushflag) || StringUtils.equals((CharSequence)backflushflag.toString(), (CharSequence)"")) {
            model.setValue(BACKFLUSHFLAG, (Object)"0");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkASMustInput();
    }

    private void checkASMustInput() {
        String productType = (String)this.getModel().getValue("product_type");
        if ("B".equals(productType)) {
            return;
        }
        DynamicObject groupId = (DynamicObject)this.getModel().getValue("groupid");
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("activestandard");
        if (Objects.isNull(basedataEdit)) {
            return;
        }
        if (!Objects.isNull(groupId) && !groupId.getBoolean("activitystamust")) {
            basedataEdit.setMustInput(false);
        } else {
            basedataEdit.setMustInput(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isIgnoreFieldChange.booleanValue()) {
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        switch (key) {
            case "groupid": {
                DynamicObject group = (DynamicObject)changeData.getNewValue();
                if (group != null) {
                    Long pk = (Long)group.getPkValue();
                    QFilter[] qfilter = new QFilter[]{new QFilter(ID, "=", (Object)pk)};
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)MPDM_WORKCENT_GROUP, (String)WORKCENT_GROUP_QUERY, (QFilter[])qfilter);
                    group = dynamicObjects[0];
                    DynamicObject abilityInfo = (DynamicObject)group.get(ABILITYGROUP);
                    this.getModel().setValue(ABILITY_TYPE, (Object)abilityInfo);
                }
                this.checkASMustInput();
                break;
            }
            case "capagroupnum": {
                DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                String repeatMsg = this.checkIsRepeat(rowIndex);
                if (StringUtils.isNotBlank((CharSequence)repeatMsg)) {
                    this.getView().showTipNotification(repeatMsg);
                    this.isIgnoreFieldChange = Boolean.TRUE;
                    this.getModel().setValue("capagroupnum", (Object)oldValue, rowIndex);
                    this.isIgnoreFieldChange = Boolean.FALSE;
                    return;
                }
                this.isIgnoreFieldChange = Boolean.TRUE;
                this.addProduct(rowIndex);
                this.getView().updateView("subentryentityfix");
                this.getView().updateView("subentryentitycal");
                this.isIgnoreFieldChange = Boolean.FALSE;
                break;
            }
            case "capacityqty": {
                DynamicObjectCollection entrycal = this.getModel().getEntryEntity("subentryentitycal");
                DynamicObjectCollection entryfix = this.getModel().getEntryEntity("subentryentityfix");
                for (int i = 0; i < entrycal.size(); ++i) {
                    DynamicObject calDynamicObject = (DynamicObject)entrycal.get(i);
                    this.setResult(entryfix, i, calDynamicObject);
                }
                break;
            }
            case "precision": {
                String completeresult = (String)this.getModel().getValue("completeresult", rowIndex);
                DynamicObjectCollection entryfix = this.getModel().getEntryEntity("subentryentityfix");
                if (StringUtils.isEmpty((CharSequence)completeresult)) break;
                DynamicObject calDynamicObject = (DynamicObject)this.getModel().getEntryEntity("subentryentitycal").get(rowIndex);
                this.setResult(entryfix, rowIndex, calDynamicObject);
                break;
            }
            case "materielf7": 
            case "materialgroup": {
                for (ChangeData change : changeSet) {
                    Object oldValue = change.getOldValue();
                    int row = change.getRowIndex();
                    String repeatMsg = this.checkIsRepeat(row);
                    if (!StringUtils.isNotBlank((CharSequence)repeatMsg)) continue;
                    this.getView().showTipNotification(repeatMsg);
                    this.isIgnoreFieldChange = Boolean.TRUE;
                    this.getModel().setValue(key, oldValue, rowIndex);
                    this.isIgnoreFieldChange = Boolean.FALSE;
                }
                break;
            }
            case "activestandard": {
                this.getModel().deleteEntryData("processactivetable");
                this.setProcessEntry();
                break;
            }
            case "warehouse": {
                this.getModel().setValue("location", null);
                break;
            }
        }
    }

    public void setProcessEntry() {
        DynamicObject activeStandard = (DynamicObject)this.getModel().getValue("activestandard");
        if (activeStandard == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", activeStandard.getPkValue());
        DynamicObject activestandard = BusinessDataServiceHelper.loadSingle((String)"mpdm_activestandard", (String)"entry.activenumber,entry.activityformula,entry.reportformula", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection entryRows = (DynamicObjectCollection)activestandard.get("entry");
        this.createNewEntryRows(this.getModel(), entryRows);
    }

    public void createNewEntryRows(IDataModel model, DynamicObjectCollection entryRows) {
        if (entryRows == null || entryRows.isEmpty()) {
            return;
        }
        AbstractFormDataModel dm = (AbstractFormDataModel)model;
        dm.deleteEntryData("processactivetable");
        dm.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("processnumber", new Object[0]);
        vs.addField("processqty", new Object[0]);
        vs.addField("processunit", new Object[0]);
        vs.addField("activeformula", new Object[0]);
        vs.addField("reportformula", new Object[0]);
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryRows.get(i);
            DynamicObject activenumberDO = (DynamicObject)dynamicObject.get("activenumber");
            DynamicObject activityformulaDO = (DynamicObject)dynamicObject.get("activityformula");
            DynamicObject reportformulaDO = (DynamicObject)dynamicObject.get("reportformula");
            BigDecimal baseqty = (BigDecimal)dynamicObject.get("activenumber.baseqty");
            DynamicObject unitDo = (DynamicObject)dynamicObject.get("activenumber.unit");
            Long activenumberPK = 0L;
            Long activityformulaPK = 0L;
            Long reportformulaPK = 0L;
            Long unitPK = 0L;
            if (!Objects.isNull(activenumberDO)) {
                activenumberPK = (Long)activenumberDO.getPkValue();
            }
            if (!Objects.isNull(unitDo)) {
                unitPK = (Long)unitDo.getPkValue();
            }
            if (!Objects.isNull(activityformulaDO)) {
                activityformulaPK = (Long)activityformulaDO.getPkValue();
            }
            if (!Objects.isNull(reportformulaDO)) {
                reportformulaPK = (Long)reportformulaDO.getPkValue();
            }
            vs.addRow(new Object[]{activenumberPK, baseqty, unitPK, activityformulaPK, reportformulaPK});
        }
        dm.batchCreateNewEntryRow("processactivetable", vs);
        dm.endInit();
        this.getView().updateView("processactivetable");
    }

    private void setResult(DynamicObjectCollection entryfix, int i, DynamicObject calDynamicObject) {
        String expression = calDynamicObject.getString("capacitycalen");
        String[] fixCapacitys = FormulaEngine.extractVariables((String)expression);
        HashMap<String, Object> valueMap = new HashMap<String, Object>(fixCapacitys.length);
        for (String fixCapacity : fixCapacitys) {
            Object fixCapacityQty = entryfix.stream().filter(x -> fixCapacity.equals(x.get("capacitynumber"))).map(x -> x.get("capacityqty")).findFirst().get();
            if (!Objects.nonNull(fixCapacityQty) || BigDecimal.ZERO.compareTo(new BigDecimal(fixCapacityQty.toString())) == 0) continue;
            valueMap.put(fixCapacity, fixCapacityQty);
        }
        this.getModel().setValue("completeresult", null, i);
        if (valueMap.size() == fixCapacitys.length) {
            String result = FormulaEngine.execExcelFormula((String)expression, valueMap).toString();
            this.getModel().setValue("completeresult", (Object)new BigDecimal(result).setScale(2, 1), i);
            int precision = calDynamicObject.getInt("precision");
            if (precision != 0) {
                this.getModel().setValue("completeresult", (Object)new BigDecimal(result).setScale(precision, 1).toString(), i);
            }
        }
    }

    private void addProduct(int rowIndex) {
        DynamicObject entryproduct = this.getModel().getEntryRowEntity("entryproduct", rowIndex);
        DynamicObjectCollection subentryentityfix = entryproduct.getDynamicObjectCollection("subentryentityfix");
        DynamicObjectCollection subentryentitycal = entryproduct.getDynamicObjectCollection("subentryentitycal");
        subentryentityfix.clear();
        subentryentitycal.clear();
        DynamicObject capagroupnum = entryproduct.getDynamicObject("capagroupnum");
        if (Objects.isNull(capagroupnum)) {
            return;
        }
        DynamicObjectCollection entryentity = capagroupnum.getDynamicObjectCollection(ENTRY_ENTITY);
        List fixCapacity = entryentity.stream().filter(x -> "A".equals(x.get("capacitytype"))).collect(Collectors.toList());
        List calCapacity = entryentity.stream().filter(x -> "B".equals(x.get("capacitytype"))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fixCapacity)) {
            DynamicObject user = UserServiceHelper.getUserInfoByID((Long)Long.valueOf(RequestContext.get().getUserId()), (String)USER_QUERY);
            for (DynamicObject dynamicObject : fixCapacity) {
                DynamicObject dynamicObject1 = subentryentityfix.addNew();
                dynamicObject1.set("capacitytype", dynamicObject.get("capacitytype"));
                dynamicObject1.set("capacityname", dynamicObject.get("capacityname"));
                dynamicObject1.set("capacitynumber", dynamicObject.get("capacitynumber"));
                dynamicObject1.set("efficiencyqty", (Object)1);
                dynamicObject1.set("createrfield1", (Object)user);
                dynamicObject1.set("createdatefield1", (Object)new Date());
            }
        }
        if (!CollectionUtils.isEmpty(calCapacity)) {
            DynamicObject groupid = (DynamicObject)this.getModel().getValue("groupid");
            String workstype = null;
            if (Objects.nonNull(groupid)) {
                if (MANUAL.equals(groupid.get(NUMBER))) {
                    workstype = "B";
                }
                if (MACHINE.equals(groupid.get(NUMBER))) {
                    workstype = "A";
                }
            }
            for (DynamicObject dynamicObject : calCapacity) {
                DynamicObject dynamicObject1 = subentryentitycal.addNew();
                dynamicObject1.set("capacitytype1", dynamicObject.get("capacitytype"));
                dynamicObject1.set("capacityname1", dynamicObject.get("capacityname"));
                dynamicObject1.set("capacitynumber1", dynamicObject.get("capacitynumber"));
                dynamicObject1.set("capacitycalen", dynamicObject.get("capacitycalen"));
                dynamicObject1.set("capacitycal", dynamicObject.get("capacitycal"));
                dynamicObject1.set("workunits", dynamicObject.get("workunits"));
                dynamicObject1.set("workstype", (Object)workstype);
                dynamicObject1.set("precision", (Object)2);
            }
        }
    }

    private String checkIsRepeat(int rowIndex) {
        String alertMsg = "";
        DynamicObjectCollection entryproductList = this.getModel().getEntryEntity("entryproduct");
        DynamicObject entryproduct = (DynamicObject)entryproductList.get(rowIndex);
        DynamicObject capagroupnum = entryproduct.getDynamicObject("capagroupnum");
        String producttype = entryproduct.getString("producttype");
        DynamicObject materielf7 = entryproduct.getDynamicObject("materielf7");
        DynamicObject materialgroup = entryproduct.getDynamicObject("materialgroup");
        if ("A".equals(producttype)) {
            if (Objects.isNull(materielf7)) {
                return alertMsg;
            }
            if (this.isRepeat(rowIndex, entryproductList, entryproduct, "materielf7")) {
                if (Objects.isNull(capagroupnum)) {
                    return alertMsg.concat(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ef4\u5ea6+\u7269\u6599\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MPDMWorkcentreEdit_15", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                }
                return alertMsg.concat(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ef4\u5ea6+\u7269\u6599+\u80fd\u529b\u9879\u7ec4\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MPDMWorkcentreEdit_16", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        } else if ("C".equals(producttype)) {
            if (Objects.isNull(materialgroup)) {
                return alertMsg;
            }
            if (this.isRepeat(rowIndex, entryproductList, entryproduct, "materialgroup")) {
                if (Objects.isNull(capagroupnum)) {
                    return alertMsg.concat(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ef4\u5ea6+\u7269\u6599\u63a7\u5236\u7ec4\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MPDMWorkcentreEdit_17", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                }
                return alertMsg.concat(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ef4\u5ea6+\u7269\u6599\u63a7\u5236\u7ec4+\u80fd\u529b\u9879\u7ec4\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MPDMWorkcentreEdit_18", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        }
        return alertMsg;
    }

    private boolean isRepeat(int rowIndex, DynamicObjectCollection entryproductList, DynamicObject entryproduct, String type) {
        String connect = (Objects.isNull(entryproduct.getDynamicObject("capagroupnum")) ? "" : entryproduct.getDynamicObject("capagroupnum").getPkValue().toString()) + entryproduct.getDynamicObject(type).getPkValue();
        Boolean isRepeat = Boolean.FALSE;
        for (int i = 0; i < entryproductList.size(); ++i) {
            String otherConnect;
            DynamicObject dynamicObject;
            if (i == rowIndex || !Objects.nonNull((dynamicObject = (DynamicObject)entryproductList.get(i)).getDynamicObject(type)) || !connect.equals(otherConnect = (Objects.isNull(dynamicObject.getDynamicObject("capagroupnum")) ? "" : dynamicObject.getDynamicObject("capagroupnum").getPkValue().toString()) + dynamicObject.getDynamicObject(type).getPkValue())) continue;
            isRepeat = Boolean.TRUE;
            break;
        }
        return isRepeat;
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        String fielName = paramHyperLinkClickEvent.getFieldName();
        if ("resource".equals(fielName)) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryresouce", paramHyperLinkClickEvent.getRowIndex());
            DynamicObject entryResource = (DynamicObject)entry.get("resource");
            DynamicObject workcentInfo = this.getModel().getDataEntity();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("formId", MPDM_SHARINGRESOUCE);
            para.put("workcentid", workcentInfo.getPkValue());
            para.put("resouce", entryResource.getPkValue());
            para.put("entryIndex", paramHyperLinkClickEvent.getRowIndex());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "reload");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private List<Long> getFromOrgs(String toOrgType, Long toOrgId, String fromOrgType, boolean isIncludeToOrgSelf) {
        if (StringUtils.isEmpty((CharSequence)toOrgType) || toOrgId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u534f\u4f5c\u7ec4\u7ec7\u7c7b\u578b\u6216\u53d7\u6258\u7ec4\u7ec7\uff0c\u53c2\u6570\u5f02\u5e38\u3002", (String)"MPDMWorkcentreEdit_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        long relationOrgId = MPDMWorkcentreEdit.getOrgRelationId(fromOrgType, toOrgType);
        if (relationOrgId == 0L) {
            return new ArrayList<Long>(0);
        }
        List<Long> fromOrgs = MPDMWorkcentreEdit.getFromOrgs(relationOrgId, toOrgId);
        if (!isIncludeToOrgSelf || !fromOrgs.contains(toOrgId)) {
            // empty if block
        }
        return fromOrgs;
    }

    private static long getOrgRelationId(String fromOrgType, String toOrgType) {
        QFilter fromTypeFilter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter toTypeFilter = new QFilter("totype", "=", (Object)toOrgType);
        filterList.add(toTypeFilter);
        if (StringUtils.isEmpty((CharSequence)fromOrgType)) {
            fromTypeFilter = new QFilter("fromtype", "=", (Object)" ");
            filterList.add(fromTypeFilter);
        } else {
            fromTypeFilter = new QFilter("fromtype", "=", (Object)fromOrgType);
            filterList.add(fromTypeFilter);
        }
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        String selectProperties = "id";
        DynamicObject[] relationTypeList = BusinessDataServiceHelper.load((String)"bos_org_typerelation", (String)selectProperties, (QFilter[])filters);
        if (relationTypeList == null || relationTypeList.length == 0) {
            return 0L;
        }
        return relationTypeList[0].getLong("id");
    }

    private static List<Long> getFromOrgs(long relationOrgId, Long toOrgId) {
        QFilter toOrgIdFilter;
        ArrayList<Long> fromOrgs = new ArrayList<Long>();
        String selectProperties = "id,toorg";
        QFilter relationTypeFilter = new QFilter("typerelation", "=", (Object)relationOrgId);
        QFilter[] filters = new QFilter[]{relationTypeFilter, toOrgIdFilter = new QFilter("fromorg", "=", (Object)toOrgId)};
        DynamicObject[] orgRelationList = BusinessDataServiceHelper.load((String)"bos_org_orgrelation", (String)selectProperties, (QFilter[])filters, (String)"isdefaultfromorg desc");
        if (orgRelationList == null || orgRelationList.length == 0) {
            return fromOrgs;
        }
        for (DynamicObject relationObj : orgRelationList) {
            DynamicObject fromOrgObj = relationObj.getDynamicObject("toorg");
            if (fromOrgObj == null) continue;
            fromOrgs.add((Long)fromOrgObj.getPkValue());
        }
        return fromOrgs;
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryresouce");
        if (entryEntitys != null && !entryEntitys.isEmpty()) {
            entryEntitys.clear();
        }
    }
}

