/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class MPDMWorkshopsetupEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit warehouse = (BasedataEdit)this.getView().getControl("warehouse");
        warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit workprincipal = (BasedataEdit)this.getView().getControl("workprincipal");
        workprincipal.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit workshoporg = (BasedataEdit)this.getView().getControl("workshoporg");
        workshoporg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("unsubmit".equals(operateKey) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            this.getModel().setValue("submiter", null);
            this.getModel().setValue("submitdate", (Object)"");
            DynamicObject[] dys = new DynamicObject[]{this.getModel().getDataEntity()};
            SaveServiceHelper.save((DynamicObject[])dys);
        } else if ("unaudit".equals(operateKey) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            this.getModel().setValue("submiter", null);
            this.getModel().setValue("submitdate", (Object)"");
            this.getModel().setValue("auditer", null);
            this.getModel().setValue("aduitdate", (Object)"");
            DynamicObject[] dys = new DynamicObject[]{this.getModel().getDataEntity()};
            SaveServiceHelper.save((DynamicObject[])dys);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey()) || "submit".equals(formOperate.getOperateKey())) {
            DynamicObject workshoporgInfo = (DynamicObject)this.getModel().getValue("workshoporg");
            this.getModel().setValue("name", workshoporgInfo.get("name"));
            this.getModel().setValue("number", workshoporgInfo.get("number"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyname = e.getProperty().getName();
        if ("workshoporg".equals(propertyname)) {
            DynamicObject workprincipal = (DynamicObject)this.getModel().getValue("workprincipal");
            DynamicObject workshoporg = (DynamicObject)this.getModel().getValue("workshoporg");
            if (workprincipal != null) {
                DynamicObjectCollection entryentity = workprincipal.getDynamicObjectCollection("entryentity");
                ArrayList<String> workprincipalorgs = new ArrayList<String>();
                for (DynamicObject entity : entryentity) {
                    if (entity.getDynamicObject("dpt") == null) continue;
                    workprincipalorgs.add(entity.getDynamicObject("dpt").getPkValue().toString());
                }
                if (workshoporg == null || !workprincipalorgs.contains(workshoporg.getPkValue().toString())) {
                    this.getModel().setValue("workprincipal", null);
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject orgInfo;
        String name = e.getProperty().getName();
        if ("workprincipal".equals(name)) {
            DynamicObject workshoporg = (DynamicObject)this.getModel().getValue("workshoporg");
            if (workshoporg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8f66\u95f4\u3002", (String)"MPDMWorkshopsetupEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            List<Long> ids = Collections.singletonList(workshoporg.getLong("id"));
            Set allUsersOfOrg = UserServiceHelper.getAllUsersOfOrg((int)0, ids, (boolean)true, (boolean)false);
            QFilter filter = new QFilter("id", "in", (Object)allUsersOfOrg);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
            showParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
        if ("warehouse".equals(name)) {
            orgInfo = (DynamicObject)this.getModel().getValue("createorg");
            if (orgInfo == null) {
                return;
            }
            List<Long> list = this.getFromOrgs("05", (Long)orgInfo.getPkValue(), "04", true);
            if (list == null || list.isEmpty()) {
                return;
            }
            QFilter filter = new QFilter("createorg", "in", list);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
        if ("workshoporg".equals(name)) {
            orgInfo = (DynamicObject)this.getModel().getValue("createorg");
            if (orgInfo == null) {
                return;
            }
            QFilter qf = new QFilter("fromorg", "=", orgInfo.getPkValue());
            qf.and(new QFilter("typerelation", "=", (Object)585511977942548480L));
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_orgrelation_dept", (String)"toorg", (QFilter[])new QFilter[]{qf});
            Set toOrgSet = coll.stream().map(p -> p.getLong("toorg")).collect(Collectors.toSet());
            QFilter filter = toOrgSet == null || toOrgSet.isEmpty() ? new QFilter("fisadministrative", "=", (Object)true) : new QFilter("id", "in", toOrgSet);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    private List<Long> getFromOrgs(String toOrgType, Long toOrgId, String fromOrgType, boolean isIncludeToOrgSelf) {
        if (StringUtils.isEmpty((CharSequence)toOrgType) || toOrgId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u534f\u4f5c\u7ec4\u7ec7\u7c7b\u578b\u6216\u53d7\u6258\u7ec4\u7ec7\uff0c\u53c2\u6570\u5f02\u5e38\u3002", (String)"MPDMWorkshopsetupEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        long relationOrgId = MPDMWorkshopsetupEdit.getOrgRelationId(fromOrgType, toOrgType);
        if (relationOrgId == 0L) {
            return new ArrayList<Long>(0);
        }
        List<Long> fromOrgs = MPDMWorkshopsetupEdit.getFromOrgs(relationOrgId, toOrgId);
        if (isIncludeToOrgSelf && !fromOrgs.contains(toOrgId) && (StringUtils.isBlank((CharSequence)fromOrgType) || this.checkOrgFunction(toOrgId, fromOrgType))) {
            fromOrgs.add(toOrgId);
        }
        return fromOrgs;
    }

    private static long getOrgRelationId(String fromOrgType, String toOrgType) {
        QFilter fromTypeFilter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter toTypeFilter = new QFilter("totype", "=", (Object)toOrgType);
        filterList.add(toTypeFilter);
        if (StringUtils.isEmpty((CharSequence)fromOrgType)) {
            fromTypeFilter = new QFilter("fromtype", "=", (Object)" ");
            filterList.add(fromTypeFilter);
        } else {
            fromTypeFilter = new QFilter("fromtype", "=", (Object)fromOrgType);
            filterList.add(fromTypeFilter);
        }
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        String selectProperties = "id";
        DynamicObject[] relationTypeList = BusinessDataServiceHelper.load((String)"bos_org_typerelation", (String)selectProperties, (QFilter[])filters);
        if (relationTypeList == null || relationTypeList.length == 0) {
            return 0L;
        }
        return relationTypeList[0].getLong("id");
    }

    private static List<Long> getFromOrgs(long relationOrgId, Long toOrgId) {
        QFilter toOrgIdFilter;
        ArrayList<Long> fromOrgs = new ArrayList<Long>();
        String selectProperties = "id,toorg";
        QFilter relationTypeFilter = new QFilter("typerelation", "=", (Object)relationOrgId);
        QFilter[] filters = new QFilter[]{relationTypeFilter, toOrgIdFilter = new QFilter("fromorg", "=", (Object)toOrgId)};
        DynamicObject[] orgRelationList = BusinessDataServiceHelper.load((String)"bos_org_orgrelation", (String)selectProperties, (QFilter[])filters, (String)"isdefaultfromorg desc");
        if (orgRelationList == null || orgRelationList.length == 0) {
            return fromOrgs;
        }
        for (DynamicObject relationObj : orgRelationList) {
            DynamicObject fromOrgObj = relationObj.getDynamicObject("toorg");
            if (fromOrgObj == null) continue;
            fromOrgs.add((Long)fromOrgObj.getPkValue());
        }
        return fromOrgs;
    }

    public boolean checkOrgFunction(Long orgID, String orgFunction) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgID);
        return this.filterOrgDuty(orgIds, orgFunction).contains(orgID);
    }

    public List<Long> filterOrgDuty(List<Long> orgIds, String orgViewNumber) {
        if (orgIds == null || orgIds.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        if (StringUtils.isBlank((CharSequence)orgViewNumber)) {
            return new ArrayList<Long>(orgIds);
        }
        ArrayList<Long> filterOrgIds = new ArrayList<Long>(orgIds.size());
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.service.OrgService.filterOrgDuty", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                filterOrgIds.add(row.getLong("org"));
            }
        }
        return filterOrgIds;
    }
}

