/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.TimeUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ProductCalendarEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ProductCalendarEdit.class);
    private static final int DEFAULT_YEAR_COUNT = 50;
    public final SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");

    public void initialize() {
        this.initProperty();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject orgInfo = (DynamicObject)this.getModel().getValue("createorg");
        if (orgInfo == null) {
            this.getModel().setValue("createorg", (Object)RequestContext.get().getOrgId());
            this.getModel().setValue("useorg", (Object)RequestContext.get().getOrgId());
        } else {
            this.getModel().setValue("useorg", (Object)orgInfo);
        }
        Calendar cal = Calendar.getInstance();
        this.getModel().setValue("expiringyearfrom", (Object)cal.get(1));
        this.getModel().setValue("expiringmonthfrom", (Object)(cal.get(2) + 1));
        this.getModel().setValue("expiringyearto", (Object)cal.get(1));
    }

    private void initProperty() {
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        this.genYearComboItems("expiringyearfrom", currentYear - 3);
        this.genYearComboItems("expiringyearto", currentYear);
    }

    private void genYearComboItems(String propertyName, int currentYear) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(50);
        for (int i = 0; i < 50; ++i) {
            String year = String.valueOf(currentYear + i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(year));
            comboItem.setValue(year);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (!(source instanceof AbstractOperate)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)source;
        if ("save".equalsIgnoreCase(op.getOperateKey())) {
            if (this.validate()) {
                log.debug("\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
                this.generateDate();
            } else {
                args.cancel = true;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        boolean success;
        super.afterDoOperation(event);
        if ("save".equals(event.getOperateKey()) && (success = event.getOperationResult().isSuccess())) {
            this.getView().close();
        }
    }

    private boolean isGenerateDate() {
        DynamicObject calendar = this.getModel().getDataEntity();
        long id = (Long)calendar.getPkValue();
        if (id != 0L) {
            DynamicObject calendarInfo = BusinessDataServiceHelper.loadHead((Object)id, (DynamicObjectType)this.getModel().getDataEntity().getDynamicObjectType());
            String expiringyearfrom = calendarInfo.get("expiringyearfrom").toString();
            String expiringmonthfrom = calendarInfo.get("expiringmonthfrom").toString();
            String expiringyearto = calendarInfo.get("expiringyearto").toString();
            String expiringmonthto = calendarInfo.get("expiringmonthto").toString();
            String modeexpiringyearfrom = this.getModel().getValue("expiringyearfrom").toString();
            String modeexpiringmonthfrom = this.getModel().getValue("expiringmonthfrom").toString();
            String modeexpiringyearto = this.getModel().getValue("expiringyearto").toString();
            String modeexpiringmonthto = this.getModel().getValue("expiringmonthto").toString();
            return expiringyearfrom.equals(modeexpiringyearfrom) && expiringmonthfrom.equals(modeexpiringmonthfrom) && expiringyearto.equals(modeexpiringyearto) && expiringmonthto.equals(modeexpiringmonthto);
        }
        return false;
    }

    private void setStartAndEndDate() {
        IDataModel model = this.getModel();
        model.getDataEntity();
        DynamicObject obj = model.getDataEntity();
        model.setValue("startdate", (Object)DateUtils.getMinMaxDate((Date)DateUtils.getFirstDayOfMonth((int)obj.getInt("expiringyearfrom"), (int)obj.getInt("expiringmonthfrom")), (boolean)true));
        model.setValue("enddate", (Object)DateUtils.getMinMaxDate((Date)DateUtils.getLastDayOfMonth((int)obj.getInt("expiringyearto"), (int)obj.getInt("expiringmonthto")), (boolean)false));
    }

    private void generateDate() {
        IDataModel model = this.getModel();
        model.getDataEntity();
        DynamicObject obj = model.getDataEntity();
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        this.setStartAndEndDate();
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        boolean[] isRestDay = this.getRestDays(model);
        boolean[] isHalfWorkDay = this.getHalfWorkDays(model);
        this.removeAllRecord();
        int days = TimeUtil.daysBetween((Calendar)fromDate, (Calendar)toDate);
        for (int i = 0; i < days; ++i) {
            int index = i;
            model.createNewEntryRow("dateEntry");
            model.setValue("workdate", (Object)this.SDF.format(fromDate.getTime()), index);
            if (isRestDay[fromDate.get(7) - 1]) {
                model.setValue("datetype", (Object)"4", index);
            } else if (isHalfWorkDay[fromDate.get(7) - 1]) {
                model.setValue("datetype", (Object)"2", index);
            } else {
                model.setValue("datetype", (Object)"1", index);
            }
            fromDate.add(5, 1);
        }
    }

    private int removeDuplicateRecord(Calendar fromDate) {
        int i;
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("dateEntry");
        Calendar oldCal = Calendar.getInstance();
        ArrayList<DynamicObject> oldCalendarList = new ArrayList<DynamicObject>();
        for (i = rowCount - 1; i >= 0; --i) {
            DynamicObject oldObj = model.getEntryRowEntity("dateEntry", i);
            if (oldObj.getDate("workdate") == null) continue;
            oldCal.setTime(oldObj.getDate("workdate"));
            if (fromDate.before(oldCal) || TimeUtil.isSameDate((Calendar)fromDate, (Calendar)oldCal)) {
                model.deleteEntryRow("dateEntry", i);
                continue;
            }
            oldCalendarList.add(oldObj);
        }
        rowCount = model.getEntryRowCount("dateEntry");
        for (i = rowCount - 1; i >= 0; --i) {
            model.deleteEntryRow("dateEntry", i);
        }
        int oldRecordCount = oldCalendarList.size();
        int entryIndex = 0;
        for (int i2 = oldRecordCount - 1; i2 >= 0; --i2) {
            DynamicObject oldObj = (DynamicObject)oldCalendarList.get(i2);
            model.createNewEntryRow("dateEntry");
            model.setValue("workdate", (Object)oldObj.getDate("workdate"), entryIndex);
            model.setValue("datetype", oldObj.get("datetype"), entryIndex);
            ++entryIndex;
        }
        return oldRecordCount;
    }

    private void removeAllRecord() {
        IDataModel model = this.getModel();
        model.deleteEntryData("dateEntry");
    }

    private boolean validate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        return this.expiringDateValidate();
    }

    private boolean expiringDateValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (obj.get("expiringyearfrom") == null || obj.get("expiringmonthfrom") == null || obj.get("expiringyearto") == null || obj.get("expiringmonthto") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProductCalendarEdit_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Calendar curDate = Calendar.getInstance();
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int curYear = curDate.get(1) - 3;
        if (yearFrom < curYear || yearFrom == curYear && monthFrom - 1 < curDate.get(2)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u4e09\u5e74\u524d\u7684\u5f53\u6708\u65e5\u671f\uff01", (String)"ProductCalendarEdit_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        if (yearTo < yearFrom || yearTo == yearFrom && monthTo < monthFrom) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\uff01", (String)"ProductCalendarEdit_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        int tenyear = curDate.get(1) + 10;
        if (yearTo > tenyear || yearTo == tenyear && monthTo - 1 > curDate.get(2)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5341\u5e74\u540e\u7684\u5f53\u6708\u65e5\u671f\uff01", (String)"ProductCalendarEdit_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject getDynamicObject() {
        IDataModel model = this.getModel();
        return model.getDataEntity();
    }

    private boolean dateExclusionValidate() {
        boolean[] isHalfWorkDay;
        boolean result = true;
        boolean[] isRestDay = this.getRestDays(this.getModel());
        if (isRestDay.length != (isHalfWorkDay = this.getHalfWorkDays(this.getModel())).length) {
            return result;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (!isRestDay[i] || !isHalfWorkDay[i]) continue;
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"ProductCalendarEdit_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            break;
        }
        return result;
    }

    private boolean[] getRestDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isRestDay = new boolean[]{obj.getBoolean("issunrest"), obj.getBoolean("ismonrest"), obj.getBoolean("istuerest"), obj.getBoolean("iswedrest"), obj.getBoolean("isthurest"), obj.getBoolean("isfrirest"), obj.getBoolean("issatrest")};
        return isRestDay;
    }

    private boolean[] getHalfWorkDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrest"), obj.getBoolean("ishalfmonrest"), obj.getBoolean("ishalftuerest"), obj.getBoolean("ishalfwedrest"), obj.getBoolean("ishalfthurest"), obj.getBoolean("ishalffrirest"), obj.getBoolean("ishalfsatrest")};
        return isHalfWorkDay;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fileName = arg0.getProperty().getName();
    }
}

