/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bd.mpdm.common.calendar.CalendarWeekEnum;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ProductCalendarerImportList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ProductCalendarerImportList.class);
    private static final List<String> attrList = new ArrayList<String>();
    private static final List<String> attrNameList = new ArrayList<String>();
    private static final ThreadLocal<List<DynamicObject>> threadLocalData = new ThreadLocal();

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        String selectfield = "expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto,number,name,issunrest,ismonrest,istuerest,iswedrest,isthurest,isfrirest,issatrest,createorg,dateentry.workdate,dateentry.datetype";
        e.setSelectFields(selectfield);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas = e.getQueryValues();
        List<DynamicObject> list = threadLocalData.get();
        if (list == null) {
            list = new LinkedList<DynamicObject>();
            threadLocalData.set(list);
        }
        for (DynamicObject data : datas) {
            list.add(data);
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        File file = e.getFile();
        List<DynamicObject> datas = threadLocalData.get();
        if (file != null && datas != null && !datas.isEmpty()) {
            try (SXSSFWorkbook newExcel = this.createExcelTemp();
                 FileOutputStream out = new FileOutputStream(file);){
                this.writeSheet(newExcel, datas);
                threadLocalData.remove();
                newExcel.write((OutputStream)out);
            }
            catch (Exception ex) {
                throw new KDBizException((Throwable)ex, new ErrorCode("ProductCalendarerImportList", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)), new Object[0]);
            }
        }
    }

    public void writeSheet(SXSSFWorkbook newExcel, List<DynamicObject> datas) {
        ArrayList overrideList = new ArrayList(datas.size());
        SXSSFSheet newSheet = newExcel.getSheetAt(0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject data : datas) {
            ArrayList<String> overridedata = new ArrayList<String>(7);
            String number = data.getString("number");
            overridedata.add(number);
            String name = data.getLocaleString("name").getLocaleValue_zh_CN();
            overridedata.add(name);
            DynamicObject createorg = data.getDynamicObject("createorg");
            String orgnumber = createorg.getString("number");
            overridedata.add(orgnumber);
            HashMap weekFreeday = Maps.newHashMapWithExpectedSize((int)7);
            String orgname = createorg.getLocaleString("name").getLocaleValue_zh_CN();
            overridedata.add(orgname);
            StringBuilder datetype = new StringBuilder(ResManager.loadKDString((String)"\u4f11\u606f\u65e5=", (String)"ProductCalendarerImportList_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            boolean issun = data.getBoolean("issunrest");
            datetype = this.getDattype(issun, datetype, CalendarWeekEnum.ISSUNREST.getValue());
            weekFreeday.put(Integer.valueOf(CalendarWeekEnum.ISSUNREST.getName()), issun);
            boolean ismon = data.getBoolean("ismonrest");
            datetype = this.getDattype(ismon, datetype, CalendarWeekEnum.ISMONREST.getValue());
            weekFreeday.put(Integer.valueOf(CalendarWeekEnum.ISMONREST.getName()), ismon);
            boolean istue = data.getBoolean("istuerest");
            datetype = this.getDattype(istue, datetype, CalendarWeekEnum.ISTUEREST.getValue());
            weekFreeday.put(Integer.valueOf(CalendarWeekEnum.ISTUEREST.getName()), istue);
            boolean iswed = data.getBoolean("iswedrest");
            datetype = this.getDattype(iswed, datetype, CalendarWeekEnum.ISWEDREST.getValue());
            weekFreeday.put(Integer.valueOf(CalendarWeekEnum.ISWEDREST.getName()), iswed);
            boolean isthu = data.getBoolean("isthurest");
            datetype = this.getDattype(isthu, datetype, CalendarWeekEnum.ISTHUREST.getValue());
            weekFreeday.put(Integer.valueOf(CalendarWeekEnum.ISTHUREST.getName()), isthu);
            boolean isfri = data.getBoolean("isfrirest");
            datetype = this.getDattype(isfri, datetype, CalendarWeekEnum.ISFRIREST.getValue());
            weekFreeday.put(Integer.valueOf(CalendarWeekEnum.ISFRIREST.getName()), isfri);
            boolean issat = data.getBoolean("issatrest");
            datetype = this.getDattype(issat, datetype, CalendarWeekEnum.ISSATREST.getValue());
            weekFreeday.put(Integer.valueOf(CalendarWeekEnum.ISSATREST.getName()), issat);
            StringBuilder holiday = new StringBuilder(ResManager.loadKDString((String)"\u8282\u5047\u65e5=", (String)"ProductCalendarerImportList_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            StringBuilder freeday = new StringBuilder(ResManager.loadKDString((String)"\u4f11\u606f\u65e5=", (String)"ProductCalendarerImportList_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection dateentrys = data.getDynamicObjectCollection("dateentry");
            String startdate = "";
            String enddate = "";
            for (DynamicObject dateentry : dateentrys) {
                Date date = dateentry.getDate("workdate");
                String entrydatetype = dateentry.getString("datetype");
                String dateStr = sdf.format(date);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int i = calendar.get(7);
                if ("3".equals(entrydatetype)) {
                    if (!holiday.toString().endsWith("=")) {
                        holiday.append(',');
                    }
                    holiday.append(dateStr);
                }
                if ("4".equals(entrydatetype) && weekFreeday.get(i) != null && !((Boolean)weekFreeday.get(i)).booleanValue()) {
                    if (!freeday.toString().endsWith("=")) {
                        freeday.append(',');
                    }
                    freeday.append(dateStr);
                }
                if (StringUtils.isBlank((CharSequence)startdate) || startdate.compareTo(dateStr) > 0) {
                    startdate = dateStr;
                }
                if (!StringUtils.isBlank((CharSequence)enddate) && enddate.compareTo(dateStr) >= 0) continue;
                enddate = dateStr;
            }
            StringBuilder datetypeStr = this.getDatetype(datetype, holiday);
            datetypeStr = this.getDatetype(datetypeStr, freeday);
            overridedata.add(datetypeStr.toString());
            overridedata.add(startdate);
            overridedata.add(enddate);
            overrideList.add(overridedata);
        }
        for (int i = 0; i < overrideList.size(); ++i) {
            int num = newSheet.getLastRowNum() + 1;
            Row newRow = newSheet.createRow(num);
            List sub_list = (List)overrideList.get(i);
            for (int j = 0; j < sub_list.size(); ++j) {
                String data = (String)sub_list.get(j);
                newRow.createCell(j).setCellValue(data);
                if (!data.contains("\r\n")) continue;
                CellStyle wrapTextstyle = newExcel.createCellStyle();
                wrapTextstyle.setWrapText(true);
                newRow.getCell(j).setCellStyle(wrapTextstyle);
            }
        }
    }

    public StringBuilder getDatetype(StringBuilder datetype, StringBuilder holiday) {
        StringBuilder result = new StringBuilder();
        if (!datetype.toString().endsWith("=")) {
            result.append((CharSequence)datetype);
        }
        if (StringUtils.isNotBlank((CharSequence)result.toString()) && !holiday.toString().endsWith("=")) {
            result.append("\r\n");
        }
        if (!holiday.toString().endsWith("=")) {
            result.append((CharSequence)holiday);
        }
        return result;
    }

    public StringBuilder getDattype(boolean isRestDay, StringBuilder datetype, String week) {
        if (isRestDay) {
            if (!datetype.toString().endsWith("=")) {
                datetype.append(',');
            }
            datetype.append(week);
        }
        return datetype;
    }

    public SXSSFWorkbook createExcelTemp() {
        SXSSFWorkbook newExcel = new SXSSFWorkbook();
        SXSSFSheet newExcelSheet = newExcel.createSheet();
        newExcelSheet.setColumnWidth(0, 10240);
        for (int i = 1; i < 7; ++i) {
            newExcelSheet.setColumnWidth(i, 5120);
        }
        SXSSFRow row1 = newExcelSheet.createRow(0);
        SXSSFRow row2 = newExcelSheet.createRow(1);
        SXSSFRow row3 = newExcelSheet.createRow(2);
        SXSSFRow row4 = newExcelSheet.createRow(3);
        row1.createCell(0).setCellValue(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386 # mpdm_calendar", (String)"ProductCalendarerImportList_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        row2.createCell(0).setCellValue(String.format(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42%1$s2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5%2$s3\u3001\u7b2c\u4e8c\u884c\u7b2c\u4e00\u4e2a\u5355\u5143\u683c\u8f93\u5165#SetNULL\uff0c\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5%3$s#OverrideEntry", (String)"ProductCalendarerImportList_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\r\n", "\r\n", "\r\n"));
        CellStyle wrapTextstyle = newExcel.createCellStyle();
        wrapTextstyle.setWrapText(true);
        row2.getCell(0).setCellStyle(wrapTextstyle);
        CellStyle redstyle = this.getFontStyle(newExcel, IndexedColors.RED.getIndex());
        CellStyle blackstyle = this.getFontStyle(newExcel, IndexedColors.BLACK.getIndex());
        DataFormat format = newExcel.createDataFormat();
        CellStyle columnStyle = newExcel.createCellStyle();
        SXSSFDrawing p = newExcelSheet.createDrawingPatriarch();
        columnStyle.setDataFormat(format.getFormat("@"));
        this.addLineCell((Row)row3, attrList, null, null);
        this.addLineCell((Row)row4, attrNameList, redstyle, blackstyle);
        Comment temp = this.getCellComment(p, new XSSFRichTextString(String.format(ResManager.loadKDString((String)"\u793a\u4f8b\uff1a%1$s\u4f11\u606f\u65e5=\u5468\u516d\uff0c\u5468\u65e5%2$s\u8282\u5047\u65e5=2020-10-10\uff0c2020-10-16%3$s\u540c\u4e00\u6761\u751f\u4ea7\u65e5\u5386\u53ef\u4ee5\u6dfb\u52a0\u591a\u884c\u4f11\u606f\u65e5\u7c7b\u578b", (String)"ProductCalendarerImportList_12", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\r\n", "\r\n", "\r\n")), (short)4, 3, (short)7, 9);
        row4.getCell(4).setCellComment(temp);
        CellStyle cellStyle = row4.getCell(4).getCellStyle();
        cellStyle.setWrapText(true);
        row4.getCell(4).setCellStyle(cellStyle);
        Comment temp2 = this.getCellComment(p, new XSSFRichTextString(ResManager.loadKDString((String)"\u793a\u4f8b\uff1a2020-10-1\uff08\u5fc5\u987b\u662f\u5f53\u6708\u7b2c\u4e00\u5929\uff09", (String)"ProductCalendarerImportList_13", (String)"bd-mpdm-formplugin", (Object[])new Object[0])), (short)5, 3, (short)6, 6);
        row4.getCell(5).setCellComment(temp2);
        Comment temp3 = this.getCellComment(p, new XSSFRichTextString(ResManager.loadKDString((String)"\u793a\u4f8b\uff1a2020-10-31\uff08\u5fc5\u987b\u662f\u5f53\u6708\u6700\u540e\u4e00\u5929\uff09", (String)"ProductCalendarerImportList_15", (String)"bd-mpdm-formplugin", (Object[])new Object[0])), (short)6, 3, (short)7, 6);
        row4.getCell(6).setCellComment(temp3);
        return newExcel;
    }

    private CellStyle getFontStyle(SXSSFWorkbook newExcel, short index) {
        CellStyle style = newExcel.createCellStyle();
        Font font = newExcel.createFont();
        font.setColor(index);
        style.setFont(font);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    private Comment getCellComment(SXSSFDrawing p, XSSFRichTextString xssfRichTextString, short line, int column, short width, int height) {
        Comment temp = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)line, column, (int)width, height));
        temp.setString((RichTextString)xssfRichTextString);
        return temp;
    }

    private void addLineCell(Row row, List<String> attrlist, CellStyle redstyle, CellStyle blackstyle) {
        for (int i = 0; i < attrlist.size(); ++i) {
            String attr = attrlist.get(i);
            row.createCell(i).setCellValue(attr);
            if (redstyle == null || blackstyle == null) continue;
            if (attr.contains("*")) {
                row.getCell(i).setCellStyle(redstyle);
                continue;
            }
            row.getCell(i).setCellStyle(blackstyle);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("importdownload".equals(operateKey)) {
            ByteArrayOutputStream outStream = null;
            ByteArrayInputStream inStream = null;
            SXSSFWorkbook newExcel = null;
            try {
                newExcel = this.createExcelTemp();
                outStream = new ByteArrayOutputStream();
                newExcel.write((OutputStream)outStream);
                inStream = new ByteArrayInputStream(outStream.toByteArray());
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                int timeout = 7200;
                String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u5f15\u5165\u6a21\u677f.xlsx", (String)"ProductCalendarerImportList_14", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), (InputStream)inStream, timeout);
                this.getView().download(tempUrl);
            }
            catch (IOException ex) {
                throw new KDBizException(ex.getMessage());
            }
            finally {
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                    if (newExcel != null) {
                        newExcel.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException ioe) {
                    logger.error((Throwable)ioe);
                }
            }
        }
    }

    static {
        attrList.add("number");
        attrList.add("name.zh_CN");
        attrList.add("createorg.number");
        attrList.add("createorg.name");
        attrList.add("datetype");
        attrList.add("startdate");
        attrList.add("enddate");
        attrNameList.add(ResManager.loadKDString((String)"*\u65e5\u5386\u7f16\u7801", (String)"ProductCalendarerImportList_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u65e5\u5386\u540d\u79f0.\u7b80\u4f53\u4e2d\u6587", (String)"ProductCalendarerImportList_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u521b\u5efa\u7ec4\u7ec7.\u7f16\u7801", (String)"ProductCalendarerImportList_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7.\u540d\u79f0", (String)"ProductCalendarerImportList_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u4f11\u606f\u65e5\u7c7b\u578b", (String)"ProductCalendarerImportList_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u5f00\u59cb\u65e5\u671f", (String)"ProductCalendarerImportList_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u7ed3\u675f\u65e5\u671f", (String)"ProductCalendarerImportList_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
    }
}

