/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ProductCalendarerList
extends AbstractFormPlugin
implements TreeNodeClickListener,
ListRowClickListener,
SelectRowsEventListener {
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
    private static final Log logger = LogFactory.getLog(ProductCalendarerList.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public void initialize() {
        super.initialize();
        FormShowParameter form = this.getView().getFormShowParameter();
        String f = form.getFormId();
        if ("bos_listf7".equals(f)) {
            return;
        }
        this.addClickListeners(new String[]{"setdefoultworkcalendar", "setworkcalendar", "preyear", "nextyear"});
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        if (workCalendar != null) {
            workCalendar.addClickListener((ClickListener)this);
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.addListRowDoubleClickListener((ListRowClickListener)this);
        list.addSelectRowsListener((SelectRowsEventListener)this);
        list.addClickListener((ClickListener)this);
        FilterContainer container = (FilterContainer)this.getControl("filtercontainerap");
        container.setBillFormId("mpdm_calendar");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter form = this.getView().getFormShowParameter();
        String f = form.getFormId();
        if ("bos_listf7".equals(f)) {
            return;
        }
        if (this.getModel().getValue("year") == null || String.valueOf(this.getModel().getDataEntity().get("year")).trim().length() == 0) {
            this.setCurYear(Calendar.getInstance().get(1));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!QueryServiceHelper.exists((String)"bos_org", null)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u670d\u52a1\u521b\u5efa\u884c\u653f\u7ec4\u7ec7", (String)"ProductCalendarerList_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void setCurYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    private boolean isSetCalendarAtYear(int year) {
        String idr = this.getFocusId();
        if (idr == null) {
            return false;
        }
        if (idr.contains("calendar")) {
            String calendarId = idr.replaceAll("calendar", "").trim();
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(calendarId));
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mpdm_calendar", (String)"id,name,expiringyearfrom,expiringyearto", (QFilter[])filters);
            if (null == dynamicObjects || dynamicObjects.length == 0) {
                return false;
            }
            DynamicObject calendarInfo = dynamicObjects[0];
            if (calendarInfo != null) {
                String start = (String)calendarInfo.get("expiringyearfrom");
                String end = (String)calendarInfo.get("expiringyearto");
                int startYear = Integer.parseInt(start);
                int endYear = Integer.parseInt(end);
                if (year >= startYear && year <= endYear) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void click(EventObject evt) {
        Control c;
        block10: {
            int year;
            block11: {
                c = (Control)evt.getSource();
                Object yearValue = this.getModel().getValue("year");
                String yearValueStr = "";
                String pattern = "^[0-9]*$";
                boolean patternFlag = true;
                if (yearValue instanceof String) {
                    yearValueStr = yearValue.toString();
                    patternFlag = Pattern.matches(pattern, yearValueStr);
                }
                if (!patternFlag) break block10;
                year = Integer.parseInt(yearValueStr);
                if (!c.getKey().toLowerCase().startsWith("preyear")) break block11;
                int lastyear = year - 1;
                if (this.isSetCalendarAtYear(lastyear)) {
                    String idr = this.getFocusId();
                    if (idr.contains("calendar")) {
                        String id = idr.replace("calendar", "").trim();
                        this.loadCalendarData(lastyear, id);
                        this.setCurYear(lastyear);
                    }
                    break block10;
                } else {
                    if (this.getFocusId() != null && this.getFocusId().contains("calendar")) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%1$s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386", (String)"ProductCalendarerList_18", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), year - 1));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5386", (String)"ProductCalendarerList_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (c.getKey().toLowerCase().startsWith("nextyear")) {
                int lastyear = year + 1;
                if (this.isSetCalendarAtYear(lastyear)) {
                    String idr = this.getFocusId();
                    if (idr.contains("calendar")) {
                        String id = idr.replace("calendar", "").trim();
                        this.loadCalendarData(lastyear, id);
                        this.setCurYear(lastyear);
                    }
                } else {
                    if (this.getFocusId() != null && this.getFocusId().contains("calendar")) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%1$s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386", (String)"ProductCalendarerList_18", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), year + 1));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5386", (String)"ProductCalendarerList_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        if (this.getFocusId() == null) return;
        if (!workCalendar.equals(c)) return;
        this.markWorkCalendar(workCalendar, this.getFocusId());
    }

    private void markWorkCalendar(WorkCalendar workCalendar, String orgId) {
        if (!this.getFocusId().contains("calendar")) {
            return;
        }
        ArrayList dateList = workCalendar.getDateList();
        if (!this.markDateValidate(dateList)) {
            return;
        }
        String calendarId = this.getFocusId().replaceAll("calendar", "").trim();
        QFilter calendarid = new QFilter("id", "=", (Object)Long.valueOf(calendarId));
        QFilter[] qfilters = new QFilter[]{calendarid};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mpdm_calendar", (String)"id,name,createorg", (QFilter[])qfilters);
        if (dynamicObjects.length <= 0) {
            return;
        }
        String dateType = workCalendar.getDateType();
        this.recordMarkCalendar(dateList, dateType, calendarId, workCalendar);
    }

    private void recordMarkCalendar(List<String> dateList, String dateType, String calendarId, WorkCalendar workCalendar) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(calendarId))};
        ORM orm = ORM.create();
        DynamicObjectCollection workCalendarDb = orm.query("mpdm_calendar", "id,status,enable ,dateentry.*", filters);
        DynamicObject calendarInfo = (DynamicObject)workCalendarDb.get(0);
        String status = (String)calendarInfo.get("status");
        if ("2".equals(workCalendar.getDateType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u534a\u5de5\u4f5c\u65e5", (String)"ProductCalendarerList_14", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (workCalendarDb.size() == 1) {
            DynamicObjectCollection dateentry = ((DynamicObject)workCalendarDb.get(0)).getDynamicObjectCollection("dateentry");
            for (int i = 0; i < dateentry.size(); ++i) {
                DynamicObject dateEntryInfo = (DynamicObject)dateentry.get(i);
                Date date = (Date)dateEntryInfo.get("workdate");
                String dateString = this.SDF.format(date);
                if (!dateString.equals(dateList.get(0))) continue;
                dateEntryInfo.set("datetype", (Object)dateType);
            }
            orm.update(new DynamicObject[]{(DynamicObject)workCalendarDb.get(0)});
        }
        workCalendar.setDateTypeCallBack(dateList, dateType);
    }

    private boolean markDateValidate(List<String> dateList) {
        if (dateList == null || dateList.size() == 0) {
            return false;
        }
        boolean isSucess = true;
        String startDateStr = dateList.get(0);
        Calendar today = Calendar.getInstance();
        try {
            Date startDate = this.SDF.parse(startDateStr);
            if (today.getTime().getTime() > startDate.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u5f53\u524d\u65e5\u671f\u4e4b\u524d\u7684\u65e5\u5386!", (String)"ProductCalendarerList_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                isSucess = false;
            } else {
                String endDateStr = dateList.get(dateList.size() - 1);
                Date endDate = this.SDF.parse(endDateStr);
                Date startvaliddate = (Date)this.getModel().getValue("startvaliddate");
                Date endvaliddate = (Date)this.getModel().getValue("endvaliddate");
                if (startvaliddate == null || endvaliddate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u5de5\u4f5c\u65e5\u5386\u7684\u6709\u6548\u671f\u95f4\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u5de5\u4f5c\u65e5\u5386", (String)"ProductCalendarerList_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    isSucess = false;
                    return isSucess;
                }
                if (startvaliddate.getTime() > startDate.getTime() || endvaliddate.getTime() < endDate.getTime()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u5f53\u524d\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u6709\u6548\u671f\u95f4\u4e4b\u5916\u7684\u65e5\u5386!", (String)"ProductCalendarerList_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    isSucess = false;
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return isSucess;
    }

    private boolean loadCalendarData(int year, String calendarId) {
        boolean isLoaded = false;
        QFilter calendarid = new QFilter("id", "=", (Object)Long.valueOf(calendarId));
        QFilter[] qfilters = new QFilter[]{calendarid};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mpdm_calendar", (String)"id,name,createorg", (QFilter[])qfilters);
        DynamicObject calendarInfo = dynamicObjects[0];
        DynamicObject orgId = (DynamicObject)calendarInfo.get("createorg");
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put("org", orgId.getPkValue().toString());
        orgMap.put("calendarId", calendarId);
        List<Map<String, String>> workDataList = ProductCalendarerList.loadWorkCalendar(orgMap, year);
        this.getModel().setValue("dataorg", orgMap.get("dataorg"));
        if (workDataList != null && workDataList.size() > 0) {
            isLoaded = true;
            this.getModel().setValue("id", orgMap.get("id"));
            this.getModel().setValue("startvaliddate", (Object)workDataList.get(0).get("workDate"));
            this.getModel().setValue("endvaliddate", (Object)workDataList.get(workDataList.size() - 1).get("workDate"));
            WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
            workCalendar.setYear(year);
            workCalendar.setWorkDataList(workDataList);
            workCalendar.setData();
        } else {
            this.getModel().setValue("id", (Object)"");
        }
        this.setCurYear(year);
        return isLoaded;
    }

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, int year) {
        if (orgMap == null || !orgMap.containsKey("org")) {
            return new ArrayList<Map<String, String>>();
        }
        String dateFrom = year + "-01-01";
        String dateTo = year + "-12-31";
        return ProductCalendarerList.loadWorkCalendar(orgMap, dateFrom, dateTo);
    }

    public static List<Map<String, String>> loadWorkCalendar(Map<String, String> orgMap, String dateFrom, String dateTo) {
        if (orgMap == null || !orgMap.containsKey("org") || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> workDataList = new ArrayList<Map<String, String>>();
        orgMap.put("dataorg", orgMap.get("org"));
        ProductCalendarerList.load(workDataList, orgMap, dateFrom, dateTo);
        if (workDataList.size() == 0) {
            return workDataList;
        }
        ProductCalendarerList.fillFullYear(workDataList, orgMap, dateFrom, dateTo);
        return workDataList;
    }

    private static void fillFullYear(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFrom, String dateTo) {
        String minDateFrom = workDataList.get(0).get("workDate");
        String maxDateFrom = workDataList.get(workDataList.size() - 1).get("workDate");
        Date fDate = null;
        Date tDate = null;
        Date minDate = null;
        Date maxDate = null;
        try {
            Calendar cal;
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            fDate = SDF.parse(dateFrom);
            tDate = SDF.parse(dateTo);
            minDate = SDF.parse(minDateFrom);
            maxDate = SDF.parse(maxDateFrom);
            if (fDate.compareTo(minDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(minDate);
                cal.add(5, -1);
                workDataList.addAll(ProductCalendarerList.fillDate(orgMap.get("org"), orgMap.get("dataorg"), dateFrom, SDF.format(cal.getTime())));
            }
            if (maxDate.compareTo(tDate) < 0) {
                cal = Calendar.getInstance();
                cal.setTime(maxDate);
                cal.add(5, 1);
                workDataList.addAll(ProductCalendarerList.fillDate(orgMap.get("org"), orgMap.get("dataorg"), SDF.format(cal.getTime()), dateTo));
            }
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
    }

    private static List<Map<String, String>> fillDate(String org, String dataOrg, String dateFrom, String dateTo) {
        ArrayList<Map<String, String>> tempWorkDataList = new ArrayList<Map<String, String>>();
        if (StringUtils.isBlank((CharSequence)org) || "0".equals(org)) {
            return tempWorkDataList;
        }
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put("org", org);
        orgMap.put("dataorg", ProductCalendarerList.getOrgPrentId(dataOrg));
        ProductCalendarerList.load(tempWorkDataList, orgMap, dateFrom, dateTo);
        return tempWorkDataList;
    }

    private void refshList() {
        BillList list = (BillList)this.getControl("billlistap");
        list.refresh();
    }

    private static void load(List<Map<String, String>> workDataList, Map<String, String> orgMap, String dateFromStr, String dateToStr) {
        String orgId = orgMap.get("dataorg");
        if (StringUtils.isBlank((CharSequence)orgId)) {
            return;
        }
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateTo = dateFormat.parse(dateToStr);
            dateFrom = dateFormat.parse(dateFromStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] qf = new QFilter[4];
        String calendarId = orgMap.get("calendarId");
        Long calendarLong = 0L;
        if (calendarId != null) {
            String calendarString = calendarId.toString();
            calendarLong = Long.valueOf(calendarString);
        }
        qf[0] = new QFilter("id", "=", (Object)calendarLong);
        qf[1] = new QFilter("isindividuation", "=", (Object)0);
        qf[2] = new QFilter("dateentry.workdate", ">=", (Object)dateFrom);
        qf[3] = new QFilter("dateentry.workdate", "<=", (Object)dateTo);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_calendar", (QFilter[])qf);
        if (obj != null) {
            Map<String, Object> markDateMap = ProductCalendarerList.getMarkDateMap(orgMap.get("org"), dateFromStr, dateToStr);
            String selectOrgId = orgMap.get("org");
            if (StringUtils.isNotBlank((CharSequence)selectOrgId) && !orgId.equals(selectOrgId)) {
                markDateMap = ProductCalendarerList.getMarkDateMap(selectOrgId, dateFromStr, dateToStr);
            }
            DynamicObjectCollection entry = obj.getDynamicObjectCollection("dateentry");
            orgMap.put("id", String.valueOf(obj.getPkValue()));
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            for (DynamicObject workday : entry) {
                HashMap<String, String> data = new HashMap<String, String>();
                String dateKey = SDF.format(workday.getDate("workDate"));
                data.put("workDate", dateKey);
                Object dateType = markDateMap.get(dateKey);
                if (dateType == null) {
                    data.put("dateType", workday.getString("dateType"));
                } else {
                    data.put("dateType", dateType.toString());
                }
                workDataList.add(data);
            }
        } else {
            String parentId = ProductCalendarerList.getOrgPrentId(orgId);
            if (StringUtils.isNotBlank((CharSequence)parentId) && !"0".equals(parentId)) {
                orgMap.put("dataorg", parentId);
                ProductCalendarerList.load(workDataList, orgMap, dateFromStr, dateToStr);
            }
        }
    }

    public static Map<String, Object> getMarkDateMap(String orgId, String dateFrom, String dateTo) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return markDateMap;
        }
        ProductCalendarerList.findAllMarkDate(markDateMap, orgId, dateFrom, dateTo);
        return markDateMap;
    }

    private static void findAllMarkDate(Map<String, Object> markDateMap, String orgId, String dateFromStr, String dateToStr) {
        String parentOrgId;
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff01" + px);
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(orgId)), new QFilter("isindividuation", "=", (Object)1), new QFilter("dateentry.workdate", ">=", (Object)dateFrom), new QFilter("dateentry.workdate", "<=", (Object)dateTo)};
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)"mpdm_calendar", (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(parentOrgId = ProductCalendarerList.getOrgPrentId(orgId))) && !"0".equals(parentOrgId)) {
            ProductCalendarerList.findAllMarkDate(markDateMap, parentOrgId, dateFromStr, dateToStr);
        }
    }

    private static String getOrgPrentId(String id) {
        String parentId = "";
        QFilter[] qf = new QFilter[]{new QFilter("view.isdefault", "=", (Object)"1"), new QFilter("view.treetype", "=", (Object)"01"), new QFilter("org", "=", (Object)Long.valueOf(id))};
        DynamicObject parentObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])qf);
        if (parentObj == null) {
            return parentId;
        }
        return parentObj.getString("parent");
    }

    private String getFocusId() {
        BillList bill = (BillList)this.getControl("billlistap");
        String id = bill.getFocusRowPkId() + "calendar";
        if (!id.equals("nullcalendar")) {
            return id;
        }
        return this.getPageCache().get("calendar");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("submit".equals(operateKey) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            BillList grid = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = grid.getSelectedRows();
            HashSet<Long> ids = new HashSet<Long>(selectedRows.size());
            for (int i = 0; i < selectedRows.size(); ++i) {
                long ruleId = (Long)selectedRows.get(i).getPrimaryKeyValue();
                ids.add(ruleId);
            }
            QFilter idFilter = new QFilter("id", "in", ids);
            QFilter[] qfilters = new QFilter[]{idFilter};
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mpdm_calendar", (String)"id,name,number,status,enable,createorg,isfault", (QFilter[])qfilters);
            for (int i = 0; i < dynamicObjects.length; ++i) {
                dynamicObjects[i].set("status", (Object)"C");
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        } else if ("reflsh".equals(operateKey)) {
            // empty if block
        }
        this.refshList();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        ListSelectedRowCollection selectedRows;
        BillList bill = (BillList)this.getControl("billlistap");
        Long id = (Long)bill.getFocusRowPkId();
        if (id == null && (selectedRows = bill.getSelectedRows()) != null) {
            id = (Long)selectedRows.get(0).getPrimaryKeyValue();
        }
        if (evt.getNewRows().size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap11"});
            return;
        }
        if (evt.getNewRows().size() > 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap11"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1", "flexpanelap11"});
        QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mpdm_calendar", (String)"id,name,createorg,expiringyearfrom", (QFilter[])qfilters);
        DynamicObject dy = dynamicObjects[0];
        this.getPageCache().put("calendar", id + "calendar");
        String calendarId = this.getFocusId();
        if (calendarId != null && calendarId.contains("calendar")) {
            String calendar = calendarId.replaceAll("calendar", "");
            int year = dy.getInt("expiringyearfrom");
            this.loadCalendarData(year, calendar);
        }
    }

    private void autoSaveDefaultOrg(DynamicObject org, DynamicObject calendar, String operateKey) {
        QFilter qFilter = new QFilter("createorg", "=", org.getPkValue());
        boolean exists = QueryServiceHelper.exists((String)"fmm_defaultorg", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            DeleteServiceHelper.delete((String)"fmm_defaultorg", (QFilter[])new QFilter[]{qFilter});
        }
        if ("new".equals(operateKey)) {
            RequestContext requestContext = RequestContext.get();
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"fmm_defaultorg");
            newDynamicObject.set("createorg", (Object)org);
            newDynamicObject.set("org", (Object)org);
            newDynamicObject.set("calendar", (Object)calendar);
            newDynamicObject.set("status", (Object)"C");
            newDynamicObject.set("enable", (Object)"1");
            newDynamicObject.set("creator", (Object)requestContext.getUid());
            newDynamicObject.set("createtime", (Object)TimeServiceHelper.now());
            newDynamicObject.set("modifier", (Object)requestContext.getUid());
            newDynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
            newDynamicObject.set("ctrlstrategy", (Object)"5");
            OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"save", (String)"fmm_defaultorg", (DynamicObject[])new DynamicObject[]{newDynamicObject}, (OperateOption)OperateOption.create());
            if (saveOperate.isSuccess()) {
                newDynamicObject.set("masterid", newDynamicObject.getPkValue());
                SaveServiceHelper.update((DynamicObject)newDynamicObject);
            } else {
                StringBuilder errormsg = new StringBuilder();
                errormsg.append(ResManager.loadKDString((String)"\u81ea\u52a8\u4fdd\u5b58\u751f\u4ea7\u7ec4\u7ec7\u8bbe\u7f6e\u5931\u8d25\uff1a", (String)"ProductCalendarerList_16", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                ValidateResultCollection validateResultCollection = saveOperate.getValidateResult();
                List validateErrors = validateResultCollection.getValidateErrors();
                for (ValidateResult validateResult : validateErrors) {
                    List allErrorInfo = validateResult.getAllErrorInfo();
                    for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                        errormsg.append(operateErrorInfo.getMessage());
                    }
                }
                this.getView().showTipNotification(errormsg.toString());
            }
        }
    }
}

