/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.routebasedata;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class WorkShiftEdit
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("workstarttime".equals(propertyName)) {
            this.calculateWorkTime();
            this.calculateWorkShiftTime();
        }
        if ("workendtime".equals(propertyName)) {
            this.calculateWorkTime();
            this.calculateWorkShiftTime();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        IDataModel model = this.getModel();
        if ("save".equals(operateKey) && e.getOperationResult().isSuccess()) {
            DynamicObject workshift = model.getDataEntity();
            if (workshift == null) {
                return;
            }
            workshift.set("status", (Object)"A");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{workshift});
            this.getView().updateView();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e == null || e.getEntryProp() == null) {
            return;
        }
        String key = e.getEntryProp().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)ENTRYENTITY, (CharSequence)key)) {
            this.calculateWorkShiftTime();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private void calculateWorkTime() {
        BigDecimal workTime;
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        String workStartTime = this.getModel().getValue("workstarttime").toString();
        String workEndTime = this.getModel().getValue("workendtime").toString();
        if (StringUtils.equals((CharSequence)"-1", (CharSequence)workStartTime)) {
            return;
        }
        if (StringUtils.equals((CharSequence)"-1", (CharSequence)workEndTime)) {
            return;
        }
        BigDecimal startTime = new BigDecimal(workStartTime);
        BigDecimal endTime = new BigDecimal(workEndTime);
        BigDecimal help = new BigDecimal(3600);
        if (startTime.compareTo(endTime) < 0) {
            workTime = endTime.subtract(startTime).divide(help, 2, 1);
            this.getModel().setValue("iscrossday", (Object)Boolean.FALSE, rowIndex);
        } else {
            workTime = endTime.add(new BigDecimal(86400)).subtract(startTime).divide(help, 2, 1);
            this.getModel().setValue("iscrossday", (Object)Boolean.TRUE, rowIndex);
        }
        this.getModel().setValue("worktime", (Object)workTime, rowIndex);
    }

    private void calculateWorkShiftTime() {
        int rowCounts = this.getModel().getEntryRowCount(ENTRYENTITY);
        BigDecimal workShiftTime = BigDecimal.ZERO;
        for (int i = 0; i < rowCounts; ++i) {
            String workTimeStr = this.getModel().getValue("worktime", i).toString();
            BigDecimal workTime = new BigDecimal(workTimeStr);
            workShiftTime = workShiftTime.add(workTime);
        }
        this.getModel().setValue("workshifttime", (Object)workShiftTime);
    }
}

