/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.state;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ParameterPlugin
extends AbstractFormPlugin {
    public static final String KEY_BTNOK = "btnok";
    public static final String KEY_BTNCANCEL = "btncancel";
    public static final String ENTRYENTITY = "entryentity";
    public static final String KEY_MAP = "key";
    public static final String VALUE = "value";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParm = (Map)this.getView().getFormShowParameter().getCustomParam("treenodes");
        String parameters = (String)customParm.get("parameter");
        if (parameters != null && parameters.length() > 0) {
            Map parameterMap = new HashMap(8);
            try {
                parameterMap = (Map)SerializationUtils.fromJsonString((String)parameters, Map.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (parameterMap != null && !parameterMap.isEmpty()) {
                int i = 0;
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, parameterMap.size());
                for (Map.Entry button : parameterMap.entrySet()) {
                    this.getModel().setValue(KEY_MAP, button.getKey(), i);
                    this.getModel().setValue(VALUE, button.getValue(), i);
                    ++i;
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTNOK.equalsIgnoreCase(ctlSource.getKey())) {
            DynamicObjectCollection dyns = this.getModel().getEntryEntity(ENTRYENTITY);
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            for (DynamicObject dyn : dyns) {
                String key = dyn.getString(KEY_MAP);
                String value = dyn.getString(VALUE);
                if (key == null || key.length() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ParameterPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                    return;
                }
                parameterMap.put(key, value);
            }
            String parameters = SerializationUtils.toJsonString(parameterMap);
            if (parameters.length() > 1800) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c5e\u6027\u914d\u7f6e\u8d85\u8fc7\u603b\u957f\uff0c\u8bf7\u7b80\u5316\u5c5e\u6027\u914d\u7f6e\u3002", (String)"ParameterPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)parameters);
            this.getView().close();
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }
}

