/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.state;

import java.util.EventObject;
import kd.bd.mpdm.business.state.helper.StateHelper;
import kd.bd.mpdm.common.state.utils.StateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class StateStrategyEdit
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"conditiondesc"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control srcCtrl = (Control)e.getSource();
        if (srcCtrl.getKey().equalsIgnoreCase("conditiondesc")) {
            this.conditionClick();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDatas;
        String propertyName;
        if (e == null) {
            return;
        }
        super.propertyChanged(e);
        IDataEntityProperty dataEntityProperty = e.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = e.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String number = (String)this.getModel().getValue("number");
        DynamicObject modifier = (DynamicObject)this.getModel().getValue("modifier");
        if (StateUtils.isPrefabricatedData((String)number).booleanValue() && modifier == null) {
            this.getModel().setValue("desc", (Object)ResManager.loadKDString((String)"\u6807\u51c6\u9879\u76ee\u72b6\u6001\u7b56\u7565", (String)"StateStrategyEdit_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"bill")) {
            this.billChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"conditiondesc")) {
            this.conditionDescchange(oldObject, newObject, propertyValueCDDE, rowIndex);
        }
    }

    private void conditionDescchange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject == null || newObject.toString().length() == 0) {
            this.getModel().setValue("condition_tag", null);
        }
    }

    private void billChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (oldObject != newObject) {
            this.getModel().setValue("condition_tag", null);
            this.getModel().setValue("conditiondesc", null);
        }
    }

    private void conditionClick() {
        DynamicObject billDy = (DynamicObject)this.getModel().getValue("bill");
        if (billDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u3002", (String)"StateStrategyEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        String conditionJson = (String)this.getModel().getValue("condition_tag");
        MainEntityType billMainType = StateUtils.getMainEntityType((DynamicObject)billDy);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(billMainType);
        parameter.setIncludePKField(true);
        String entityNumber = billDy.getString("number");
        TreeNode billTreeNode = StateHelper.buildCalTreeNodes((BillTreeBuildParameter)parameter);
        String fieldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        StateUtils.showConditionForm((String)conditionJson, (String)entityNumber, (String)fieldNodes, (String)"conditiondesc", (IFormView)this.getView(), (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equalsIgnoreCase("conditiondesc")) {
            StateUtils.receiveCondition((String)((String)e.getReturnData()), null, (String)"condition_tag", (String)"conditiondesc", (IDataModel)this.getModel());
        }
    }
}

