/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.stockchange;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.MetaDataHelper;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockChangeTplEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
ClickListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private String[] xstockfields = new String[]{"biztime", "reason", "remarks", "billno", "org", "mftdeptorgid", "transactiontypeid", "billtype"};
    private String[] entryLockfields = new String[]{"materialid", "bomreversion", "qtytype", "stockno", "iscannegative", "entryconfiguredcode"};
    private String[] xentryfields = new String[]{"supplymodefield", "supplierfield", "supplyorgfield", "demanddatefield", "setuplocationfield", "isbulkmaterialfield", "issuemodefield", "outorgunitfield", "outwarehousefield", "warehousefield", "locationfield", "considerminbatchfield", "iskeypartfield", "overissuecontrlfield", "childremarksfield", "issinhighlimitfield", "extraratioqtyfield", "issinlowlimitfield", "lackraitioqtyfield", "oprnofield", "processseqfield"};
    private static final String ISSTOCKCHANGEX = "isStockChangeX";
    private static final String FALSE = "false";
    private static final String OLDXSTOCKOBJ = "oldXStockObj";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"stockno"});
        this.addClickListeners(new String[]{"transactiontypeid"});
        BasedataEdit tranEdit = (BasedataEdit)this.getView().getControl("transactiontypeid");
        tranEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        int billEntryCount = this.getModel().getEntryRowCount("stockentry");
        for (int i = 0; i < billEntryCount; ++i) {
            if (!"B".equals(this.getModel().getValue("entrychangetype", i))) continue;
            this.getView().setEnable(Boolean.FALSE, i, this.entryLockfields);
        }
        if (StringUtils.equals((CharSequence)"stockentry", (CharSequence)entryGrid.getKey())) {
            this.showEntryDetial(this.getSelectEntryRowIndex());
        }
    }

    private void showEntryDetial(int i) {
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"stockentry");
        String[] billEntry2 = MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt);
        String[] billEntry4 = this.getDifferentFromString(billEntry2, this.xentryfields);
        if ("B".equals(this.getModel().getValue("entrychangetype", i))) {
            this.getView().setEnable(Boolean.FALSE, i, this.entryLockfields);
            this.getView().setEnable(Boolean.FALSE, billEntry4);
            this.setEntryEnableByStatus(i);
        } else if ("C".equals(this.getModel().getValue("entrychangetype", i))) {
            this.getView().setEnable(Boolean.FALSE, i, billEntry1);
            this.getView().setEnable(Boolean.FALSE, billEntry2);
        }
        this.getView().setEnable(Boolean.TRUE, this.xstockfields);
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void beforeBindData(EventObject e) {
        this.updatePID();
        ORM orm = ORM.create();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("stockentry");
        String stockName = StockChangeUtils.getEntityName((int)3, (int)1, (String)this.getModel().getDataEntityType().getName());
        long[] genLongIds = orm.genLongIds(stockName + ".stockentry", dynamicObjectCollection.size());
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Long rowid = dynamicObject.getLong("id");
            if (rowid != 0L) continue;
            dynamicObject.set("id", (Object)genLongIds[i]);
        }
        Object billType = this.getModel().getValue("billtype");
        if (null == billType) {
            this.getModel().setValue("billtype", (Object)MPDMMftGenStocksUtils.getDefalutBillType((String)this.getModel().getDataEntityType().getName()));
            super.beforeBindData(e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().clearNoDataRow();
        this.getModel().forceClearNoDataRow();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        this.getView().setEnable(Boolean.FALSE, MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt));
        this.getView().setEnable(Boolean.TRUE, this.xstockfields);
        int billEntryCount = this.getModel().getEntryRowCount("stockentry");
        IFormView view = this.getView();
        for (int i = 0; i < billEntryCount; ++i) {
            if (!"B".equals(this.getModel().getValue("entrychangetype", i))) continue;
            view.setEnable(Boolean.FALSE, i, this.entryLockfields);
            if (i != 0) continue;
            this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
        }
        this.setEntryEnable();
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("stockentry");
        grid.setCollapse(false);
    }

    private void updatePID() {
        DynamicObject xBill = this.getModel().getDataEntity();
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("stockentry");
        for (DynamicObject xBillEntryRow : xBillEntry) {
            DynamicObject srcBillEntryRow;
            Object newPID;
            String srcEntryID = (String)xBillEntryRow.get("stockentryid");
            if (srcEntryID.isEmpty() || "0".equals(xBillEntryRow.get("parentid").toString())) continue;
            QFilter qFilter = new QFilter("stockentry.id", "=", (Object)Long.valueOf(srcEntryID));
            DynamicObjectCollection query = QueryServiceHelper.query((String)StockChangeUtils.getEntityName((int)3, (int)1, (String)this.getModel().getDataEntityType().getName()), (String)"stockentry.pid", (QFilter[])new QFilter[]{qFilter});
            if (query.isEmpty() || (newPID = this.getNewPID(srcBillEntryRow = (DynamicObject)query.get(0))) == null) continue;
            xBillEntryRow.set("pid", newPID);
        }
    }

    private Object getNewPID(DynamicObject srcBillEntryRow) {
        DynamicObject xBill = this.getModel().getDataEntity();
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("stockentry");
        for (DynamicObject xBillEntryRow : xBillEntry) {
            Long srcPID;
            Long srcLongEntryID;
            String srcEntryID = (String)xBillEntryRow.get("stockentryid");
            if (srcEntryID.isEmpty() || !(srcLongEntryID = Long.valueOf(Long.parseLong(srcEntryID))).equals(srcPID = (Long)srcBillEntryRow.get("stockentry.pid"))) continue;
            return xBillEntryRow.getPkValue();
        }
        return null;
    }

    private void setEntryEnableByStatus(int i) {
        BigDecimal actissueqty = (BigDecimal)this.getModel().getValue("actissueqty", i);
        BigDecimal rejectedqty = (BigDecimal)this.getModel().getValue("rejectedqty", i);
        BigDecimal feedingqty = (BigDecimal)this.getModel().getValue("feedingqty", i);
        BigDecimal allotqty = (BigDecimal)this.getModel().getValue("allotqty", i);
        Boolean s = actissueqty.compareTo(BigDecimal.ZERO) != 0 || rejectedqty.compareTo(BigDecimal.ZERO) != 0 || feedingqty.compareTo(BigDecimal.ZERO) != 0 || allotqty.compareTo(BigDecimal.ZERO) != 0;
        if (s.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isbulkmaterialfield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"issuemodefield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"outorgunitfield"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"outwarehousefield"});
        } else if (!this.isJumpLevel(i)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isbulkmaterialfield"});
        }
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    private void setEntryEnable() {
        DynamicObjectCollection stockentry = this.getModel().getEntryEntity("stockentry");
        for (int i = 0; i < stockentry.size(); ++i) {
            DynamicObject stockentrydym = (DynamicObject)stockentry.get(i);
            this.setEntryEnable(stockentrydym, i);
        }
    }

    private void setEntryEnable(DynamicObject stockentrydym, int i) {
        DynamicObject trandym = stockentrydym.getDynamicObject("producttransid");
        if (trandym != null) {
            if (trandym.getBoolean("isconsiderloss")) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"wastagerateformula"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"scraprate"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"fixscrap"});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"fixscrap"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"scraprate"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"wastagerateformula"});
            }
            if (this.isJumpLevel(i)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"fixscrap"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"scraprate"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"wastagerateformula"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"draw", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontypeid");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a%s", (String)"StockChangeTplEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\uff0c"));
            }
            if (tran == null) {
                err.append(String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a%s", (String)"StockChangeTplEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\uff0c"));
            }
            if (err.length() > 0) {
                err.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u9009\u5355%s", (String)"StockChangeTplEdit_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\u3002"));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"newentry", (CharSequence)op.getOperateKey())) {
            Object org = this.getModel().getValue("org");
            Object tran = this.getModel().getValue("transactiontypeid");
            StringBuilder err = new StringBuilder();
            if (org == null) {
                err.append(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a%s", (String)"StockChangeTplEdit_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\uff0c"));
            }
            if (tran == null) {
                err.append(String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a%s", (String)"StockChangeTplEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), "\uff0c"));
            }
            if (err.length() > 0) {
                err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u589e\u884c\u3002", (String)"StockChangeTplEdit_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(err.toString());
                e.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)"copyentryrow", (CharSequence)op.getOperateKey()) && selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u3002", (String)"StockChangeTplEdit_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)op.getOperateKey())) {
            OperateOption option = op.getOption();
            option.setVariableValue("mtSave", "1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)"copyentryrow", (CharSequence)op.getOperateKey())) {
            if (selectRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u3002", (String)"StockChangeTplEdit_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            } else if (selectRows.length == 1) {
                int addRow = this.getModel().getEntryRowCount("stockentry");
                this.getModel().setValue("entrychangetype", (Object)"A", addRow - 1);
            }
        } else if (StringUtils.equals((CharSequence)"audit", (CharSequence)op.getOperateKey())) {
            this.getView().updateView();
            this.getView().invokeOperation("refresh");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Object stockid;
        if (StringUtils.equals((CharSequence)"stockno", (CharSequence)arg0.getFieldName()) && (stockid = this.getModel().getValue("stockid", arg0.getRowIndex())) != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(StockChangeUtils.getEntityName((int)3, (int)1, (String)this.getModel().getDataEntityType().getName()));
            showParameter.setPkId(stockid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get(ISSTOCKCHANGEX))) {
            return;
        }
        this.getPageCache().put(ISSTOCKCHANGEX, "true");
        int changeIndex = e.getChangeSet()[0].getRowIndex();
        int currentSelectIndex = this.getSelectEntryRowIndex();
        if ("transactiontypeid".equals(key)) {
            DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
            String oldtran = "";
            if (newObj == null) {
                this.getPageCache().put(ISSTOCKCHANGEX, "true");
                this.getModel().setValue("transactiontypeid", (Object)oldObj);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"StockChangeTplEdit_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
                return;
            }
            String newtran = newObj.getPkValue().toString();
            if (oldObj != null) {
                oldtran = oldObj.getPkValue().toString();
            }
            this.getPageCache().put("newXStockObj", newtran);
            this.getPageCache().put(OLDXSTOCKOBJ, oldtran);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("stockentry");
            if (oldObj != null && entryEntity != null && !entryEntity.isEmpty() && !newtran.equals(this.getPageCache().get(OLDXSTOCKOBJ))) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tranChange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u7ec4\u4ef6\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"StockChangeTplEdit_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        } else if ("stockno".equals(key)) {
            String stockno = (String)this.getModel().getValue("stockno", changeIndex);
            if (!StringUtils.isBlank((CharSequence)stockno)) {
                QFilter filter = new QFilter("billno", "=", (Object)stockno);
                List filters = StockChangeUtils.getStockFilter((IDataModel)this.getModel());
                filters.add(filter);
                QFilter[] filterArray = new QFilter[filters.size()];
                String entityName = StockChangeUtils.getEntityName((int)3, (int)1, (String)this.getModel().getDataEntityType().getName());
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"", (QFilter[])filters.toArray(filterArray));
                if (stock == null) {
                    StockChangeUtils.setStockInfo(null, (int)changeIndex, (int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
                } else {
                    DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((Object)stock.getPkValue(), (String)entityName);
                    StockChangeUtils.setStockInfo((DynamicObject)stockdym, (int)changeIndex, (int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
                }
            } else {
                StockChangeUtils.setStockInfo(null, (int)changeIndex, (int)currentSelectIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
            }
        }
        this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"tranChange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int entryNum = this.getModel().getEntryRowCount("stockentry");
                for (int i = 0; i < entryNum; ++i) {
                    this.getModel().deleteEntryRow("stockentry", 0);
                }
                this.showEntryDetial();
                this.getModel().setValue("transactiontypeid", (Object)this.getPageCache().get("newXStockObj"));
            } else {
                this.getPageCache().put(ISSTOCKCHANGEX, "true");
                this.getModel().setValue("transactiontypeid", (Object)this.getPageCache().get(OLDXSTOCKOBJ));
                this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
            }
        }
    }

    private void setControlState(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"bomversionfield", "auxpropertyfield", "supplymodefield", "supplierfield", "supplyorgfield", "warehousefield", "locationfield", "outorgunitfield", "outwarehousefield", "issuemodefield", "backflushfield", "backflushtimefield", "iskeypartfield", "overissuecontrlfield", "considerminbatchfield", "issinhighlimitfield", "extraratioqtyfield", "issinlowlimitfield", "lackraitioqtyfield", "leadtimefield", "demanddatefield", "workprocedurefield", "setuplocationfield", "childremarksfield", "rejectedqtyfield", "feedingqtyfield", "scrapqtyfield", "wipqtyfield", "oprnofield", "processseqfield", "oprworkcenterfield", "outsupplyfield", "machiningtypefield", "cansendqtyfield"});
    }

    protected void showEntryDetial() {
        IDataModel model = this.getModel();
        model.setValue("seqfield", null);
        model.setValue("materielfield", null);
        model.setValue("materialunitidfield", null);
        model.setValue("bomversionfield", null);
        model.setValue("auxpropertyfield", null);
        model.setValue("supplymodefield", null);
        model.setValue("supplierfield", null);
        model.setValue("supplyorgfield", null);
        model.setValue("warehousefield", null);
        model.setValue("locationfield", null);
        model.setValue("outorgunitfield", null);
        model.setValue("outwarehousefield", null);
        model.setValue("issuemodefield", null);
        model.setValue("backflushfield", null);
        model.setValue("backflushtimefield", null);
        model.setValue("iskeypartfield", (Object)Boolean.FALSE);
        model.setValue("considerminbatchfield", (Object)Boolean.FALSE);
        model.setValue("overissuecontrlfield", null);
        model.setValue("issinhighlimitfield", null);
        model.setValue("extraratioqtyfield", null);
        model.setValue("issinlowlimitfield", null);
        model.setValue("lackraitioqtyfield", null);
        model.setValue("leadtimefield", null);
        model.setValue("demanddatefield", null);
        model.setValue("setuplocationfield", null);
        model.setValue("childremarksfield", null);
        model.setValue("seqfield_qty", null);
        model.setValue("materielfield_qty", null);
        model.setValue("materialunitidfield_qty", null);
        model.setValue("standqtyfield_qty", null);
        model.setValue("demandqtyfield", null);
        model.setValue("actissueqtyfield", null);
        model.setValue("rejectedqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("feedingqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("scrapqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("wipqtyfield", (Object)BigDecimal.ZERO);
        model.setValue("cansendqtyfield", (Object)BigDecimal.ZERO);
        this.setControlState(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"transactiontypeid", (CharSequence)fieldKey)) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("isstockchange", "=", (Object)"1");
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    public void click(EventObject evt) {
        Control sourceField = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)"stockno")) {
            this.showBillList(sourceField.getKey());
        }
    }

    private void showBillList(String sourcekey) {
        String entityNumber = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)sourcekey, (CharSequence)"stockno")) {
            entityNumber = StockChangeUtils.getEntityName((int)3, (int)1, (String)this.getModel().getDataEntityType().getName());
        }
        if (!StringUtils.isEmpty(entityNumber)) {
            List filters = StockChangeUtils.getStockFilter((IDataModel)this.getModel());
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
            showParameter.getListFilterParameter().setQFilters(filters);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sourcekey);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        int currentRowIndex = this.getSelectEntryRowIndex();
        if (e.getReturnData() != null) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
            Object pk = rows.get(0).getPrimaryKeyValue();
            if (StringUtils.equalsIgnoreCase((CharSequence)"stockno", (CharSequence)actionKey)) {
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)pk, (String)StockChangeUtils.getEntityName((int)3, (int)1, (String)this.getModel().getDataEntityType().getName()));
                if (stock != null) {
                    this.getPageCache().put(ISSTOCKCHANGEX, "true");
                    StockChangeUtils.setStockInfo((DynamicObject)stock, (int)currentRowIndex, (int)currentRowIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
                    this.getPageCache().put(ISSTOCKCHANGEX, FALSE);
                } else {
                    StockChangeUtils.setStockInfo(null, (int)currentRowIndex, (int)currentRowIndex, (IDataModel)this.getModel(), (IFormView)this.getView());
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public boolean isJumpLevel(int rowIndex) {
        if (rowIndex == -1) {
            return false;
        }
        return (Boolean)this.getModel().getValue("isjumplevel", rowIndex);
    }

    public boolean isJumpLevel(DynamicObject stockEntry) {
        return stockEntry.getBoolean("isjumplevel");
    }
}

