/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.util.EventObject;
import kd.bd.mpdm.common.utils.QueryNameByEntityUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CardExpEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit functionlocation = (BasedataEdit)this.getView().getControl("functionlocation");
        functionlocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("cardnum".equals(name)) {
            ChangeData cd = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)cd.getNewValue();
            if (newValue == null) {
                return;
            }
            DynamicObject material = newValue.getDynamicObject("material");
            if (material != null) {
                this.setunit(material);
            }
        } else if ("l1mpd".equals(name)) {
            ChangeData cd = e.getChangeSet()[0];
            int index = cd.getRowIndex();
            this.getModel().setValue("functionlocation", null, index);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.ShowBaseUnit();
    }

    private void ShowBaseUnit() {
        DynamicObject material;
        DynamicObject card = (DynamicObject)this.getModel().getValue("cardnum");
        if (card != null && (material = card.getDynamicObject("material")) != null) {
            this.setunit(material);
        }
    }

    private void setunit(DynamicObject material) {
        DynamicObject mater = BusinessDataServiceHelper.loadSingleFromCache((Object)material.getPkValue(), (String)"bd_material", (String)"baseunit");
        DynamicObject baseunit = mater.getDynamicObject("baseunit");
        this.getModel().setValue("baseunit", (Object)baseunit);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = (String)this.getModel().getValue("status");
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            e.setCheckDataChange(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("functionlocation".equals(source)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            DynamicObject materialtype = (DynamicObject)this.getModel().getValue("materialtype");
            if (materialtype != null) {
                QFilter qf = new QFilter("enable", "=", (Object)"1");
                qf.and("materialtype.id", "=", materialtype.getPkValue());
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(qf);
            } else {
                String materialtypename = QueryNameByEntityUtils.queryName((String)"l1mpd", (String)"mpdm_cardimpexperience");
                String info = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9%1$s\u3002", (String)"CardExpEdit_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), materialtypename);
                this.getView().showTipNotification(info);
                evt.setCancel(true);
                return;
            }
        }
    }
}

