/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.workcardinfo.CardBusinessUtils;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.helper.WarehouseHelper;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.wordcard.utils.WorkCardUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class CardMaterialCommandEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    public static final String[] FIELD_SHOW_ARRAT = new String[]{"cardoperationno", "issuemode", "supplyorg", "warehouse", "location", "isstockalloc", "outorg", "outwarehouse", "outlocation", "isbackflush", "entryiskey", "isreplacement", "entryownertype", "entryowner", "entryresptype", "entryresp", "entryprofessiona", "entryremark", "materielmtc", "entrysn"};
    public static final String[] FIELD_BATCH_FILL_ARRAT = new String[]{"entryprofessiona"};

    public void registerListener(EventObject e) {
        BasedataEdit cardOperationNoShowEdit;
        BasedataEdit outLocationShowEdit;
        BasedataEdit outWarehouseShowEdit;
        BasedataEdit locationShowEdit;
        BasedataEdit warehouseShowEdit;
        BasedataEdit enrtyUnitEdit;
        BasedataEdit professionnaEdit;
        BasedataEdit professionnaShowEdit;
        BasedataEdit materialMTCShowEdit;
        BasedataEdit entryRespShowEdit;
        BasedataEdit entryOwnerShowEdit;
        BasedataEdit supplyorgShowEdit;
        BasedataEdit entryMftMaterialEdit;
        EntryGrid entryGrid;
        BasedataEdit cabinConfig;
        BasedataEdit materialTypeEdit;
        super.registerListener(e);
        BasedataEdit workCardEdit = (BasedataEdit)this.getControl("workcard");
        if (workCardEdit != null) {
            workCardEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialTypeEdit = (BasedataEdit)this.getControl("materialtype")) != null) {
            materialTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((cabinConfig = (BasedataEdit)this.getControl("cabinconfig")) != null) {
            cabinConfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getControl("entryentity")) != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((entryMftMaterialEdit = (BasedataEdit)this.getControl("entrymftmaterial")) != null) {
            entryMftMaterialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplyorgShowEdit = (BasedataEdit)this.getControl("supplyorg_show")) != null) {
            supplyorgShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryOwnerShowEdit = (BasedataEdit)this.getControl("entryowner_show")) != null) {
            entryOwnerShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryRespShowEdit = (BasedataEdit)this.getControl("entryresp_show")) != null) {
            entryRespShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialMTCShowEdit = (BasedataEdit)this.getControl("materielmtc_show")) != null) {
            materialMTCShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((professionnaShowEdit = (BasedataEdit)this.getControl("entryprofessiona_show")) != null) {
            professionnaShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((professionnaEdit = (BasedataEdit)this.getControl("entryprofessiona")) != null) {
            professionnaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((enrtyUnitEdit = (BasedataEdit)this.getControl("enrtyunit")) != null) {
            enrtyUnitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouseShowEdit = (BasedataEdit)this.getControl("warehouse_show")) != null) {
            warehouseShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((locationShowEdit = (BasedataEdit)this.getControl("location_show")) != null) {
            locationShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((outWarehouseShowEdit = (BasedataEdit)this.getControl("outwarehouse_show")) != null) {
            outWarehouseShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((outLocationShowEdit = (BasedataEdit)this.getControl("outlocation_show")) != null) {
            outLocationShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((cardOperationNoShowEdit = (BasedataEdit)this.getControl("cardoperationno_show")) != null) {
            cardOperationNoShowEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"modelmpdone"});
    }

    private DynamicObject getAndValidCreateOrg() {
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue(this.getOrgFiledName());
        if (createOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7!", (String)"CardMaterialCommandEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        return createOrg;
    }

    private DynamicObject getAndValidWorkCard() {
        DynamicObject workCard = (DynamicObject)this.getModel().getValue("workcard");
        if (workCard == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5de5\u5361\u4fe1\u606f!", (String)"CardMaterialCommandEditPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        return workCard;
    }

    private DynamicObject getAndValidMaterialType() {
        DynamicObject materialType = (DynamicObject)this.getModel().getValue("materialtype");
        if (materialType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u68c0\u4fee\u8bbe\u5907\u578b\u53f7\u3002", (String)"CardMaterialCommandEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        return materialType;
    }

    private DynamicObject getAndValidProductMaterial() {
        DynamicObject productMaterial = (DynamicObject)this.getModel().getValue("productmaterial");
        if (productMaterial == null) {
            // empty if block
        }
        return productMaterial;
    }

    private DynamicObject getAndValidMaterial(int rowIndex) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("entrymaterial", rowIndex);
        if (material == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7b2c%1$s\u884c\u5206\u5f55\u7684\u7ec4\u4ef6\u4fe1\u606f!", (String)"CardMaterialCommandEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        return material;
    }

    private Set<Object> getMaterialMulUnitIDSet(DynamicObject material) {
        HashSet<Object> unitIDSet = new HashSet<Object>(16);
        QFilter matFilter = new QFilter("materialid", "=", material.getPkValue());
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{matFilter});
        if (unitMap == null) {
            return Collections.emptySet();
        }
        for (Map.Entry entry : unitMap.entrySet()) {
            DynamicObject mulUnit = (DynamicObject)entry.getValue();
            DynamicObject unit = mulUnit.getDynamicObject("measureunitid");
            unitIDSet.add(unit.getPkValue());
        }
        return unitIDSet;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Long orgId;
        ArrayList<Object> array;
        DynamicObject sypplyorgfield;
        String ownerType;
        QFilter filter;
        Set<Long> locationIds;
        DynamicObject wareHouseObj;
        ArrayList<Long> ids;
        QFilter warehouseids;
        QFilter filter2;
        QFilter filter3;
        DynamicObject createOrg;
        ListShowParameter listShowPrams;
        IDataModel model = this.getModel();
        FormShowParameter showParams = e.getFormShowParameter();
        ListShowParameter listShowParameter = listShowPrams = showParams instanceof ListShowParameter ? (ListShowParameter)showParams : null;
        if (listShowPrams == null) {
            return;
        }
        ListFilterParameter listParams = listShowPrams.getListFilterParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        String fieldName = e.getProperty().getName();
        int rowIndex = e.getRow();
        if ("workcard".equals(fieldName)) {
            createOrg = this.getAndValidCreateOrg();
            if (createOrg == null) {
                e.setCancel(true);
                return;
            }
            filter3 = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_mrocardroute", (Long)createOrg.getLong("id"));
            String entityNum = this.getModel().getDataEntityType().getName();
            Set jobCardTypeIdSet = WorkCardUtils.getWorkCardTypeFromEntity((String)entityNum);
            filter3.and(new QFilter("cardtype.id", "in", (Object)jobCardTypeIdSet));
            listShowPrams.setShowApproved(false);
            qFilterList.add(filter3);
        }
        if ("cabinconfig".equals(fieldName)) {
            createOrg = this.getAndValidCreateOrg();
            if (createOrg == null) {
                e.setCancel(true);
                return;
            }
            filter3 = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_cabinconfig", (Long)createOrg.getLong("id"));
            qFilterList.add(filter3);
        }
        if ("entrymftmaterial".equals(fieldName)) {
            createOrg = this.getAndValidCreateOrg();
            if (createOrg == null) {
                e.setCancel(true);
                return;
            }
            filter3 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)createOrg.getLong("id"));
            qFilterList.add(filter3);
            DynamicObject productMaterial = this.getAndValidProductMaterial();
            if (productMaterial != null) {
                QFilter matFilter = new QFilter("masterid.id", "!=", productMaterial.getPkValue());
                qFilterList.add(matFilter);
            }
        }
        if ("enrtyunit".equals(fieldName)) {
            DynamicObject entrymaterial = this.getAndValidMaterial(rowIndex);
            if (entrymaterial == null) {
                e.setCancel(true);
                return;
            }
            Set<Object> unitIdSet = this.getMaterialMulUnitIDSet(entrymaterial);
            Object baseUnit = model.getValue("entrybaseunit", rowIndex);
            if (baseUnit != null) {
                unitIdSet.add(((DynamicObject)baseUnit).getPkValue());
            }
            filter2 = new QFilter("id", "in", unitIdSet);
            qFilterList.add(filter2);
        }
        if ("warehouse_show".equals(fieldName)) {
            DynamicObject supplyOrg = (DynamicObject)model.getValue("supplyorg_show");
            if (supplyOrg != null) {
                warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)Long.parseLong(supplyOrg.getPkValue().toString()));
                ids = new ArrayList<Long>();
                for (Long warehouseid : warehouseids) {
                    if (warehouseid == null) continue;
                    ids.add(warehouseid);
                }
                if (!ids.isEmpty()) {
                    filter2 = new QFilter("id", "in", ids);
                    qFilterList.add(filter2);
                } else {
                    filter2 = new QFilter("id", "=", (Object)Long.valueOf("0"));
                    qFilterList.add(filter2);
                }
            } else {
                filter3 = new QFilter("id", "=", (Object)Long.valueOf("0"));
                qFilterList.add(filter3);
            }
        }
        if ("location_show".equals(fieldName)) {
            wareHouseObj = (DynamicObject)model.getValue("warehouse_show");
            locationIds = this.getLocationFilter(wareHouseObj);
            filter = new QFilter("id", "in", locationIds);
            qFilterList.add(filter);
        }
        if ("outwarehouse_show".equals(fieldName)) {
            DynamicObject outOrg = (DynamicObject)model.getValue("outorg_show");
            if (outOrg != null) {
                warehouseids = WarehouseHelper.getAllWarehouseIDs((Long)Long.parseLong(outOrg.getPkValue().toString()));
                ids = new ArrayList();
                for (Long warehouseid : warehouseids) {
                    if (warehouseid == null) continue;
                    ids.add(warehouseid);
                }
                if (!ids.isEmpty()) {
                    filter2 = new QFilter("id", "in", ids);
                    qFilterList.add(filter2);
                } else {
                    filter2 = new QFilter("id", "=", (Object)Long.valueOf("0"));
                    qFilterList.add(filter2);
                }
            } else {
                filter3 = new QFilter("id", "=", (Object)Long.valueOf("0"));
                qFilterList.add(filter3);
            }
        }
        if ("outlocation_show".equals(fieldName)) {
            wareHouseObj = (DynamicObject)model.getValue("outwarehouse_show");
            locationIds = this.getLocationFilter(wareHouseObj);
            filter = new QFilter("id", "in", locationIds);
            qFilterList.add(filter);
        }
        if ("entryowner_show".equals(fieldName)) {
            ownerType = (String)this.getModel().getValue("entryownertype_show");
            sypplyorgfield = (DynamicObject)this.getModel().getValue("supplyorg_show");
            if (sypplyorgfield != null && "bos_org".equals(ownerType)) {
                array = new ArrayList<Object>();
                orgId = (Long)sypplyorgfield.getPkValue();
                List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
                array.addAll(ownerArray);
                sypplyorgfield = OrgQueryHelper.getDataCacheByID((Object)sypplyorgfield.getPkValue());
                if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                    array.add(sypplyorgfield.get("id"));
                }
                QFilter filter4 = new QFilter("id", "in", array);
                qFilterList.add(filter4);
            }
        }
        if ("entryresp_show".equals(fieldName)) {
            ownerType = (String)this.getModel().getValue("entryresptype_show");
            sypplyorgfield = (DynamicObject)this.getModel().getValue("supplyorg_show");
            if (sypplyorgfield != null && "bos_org".equals(ownerType)) {
                array = new ArrayList();
                orgId = (Long)sypplyorgfield.getPkValue();
                List ownerArray = MPDMMftGenStocksUtils.getOwners((Long)orgId);
                array.addAll(ownerArray);
                sypplyorgfield = OrgQueryHelper.getDataCacheByID((Object)sypplyorgfield.getPkValue());
                if (((Boolean)sypplyorgfield.get("fisaccounting")).booleanValue()) {
                    array.add(sypplyorgfield.get("id"));
                }
                QFilter filter5 = new QFilter("id", "in", array);
                qFilterList.add(filter5);
            }
        }
        if ("supplyorg_show".equals(fieldName)) {
            createOrg = this.getAndValidCreateOrg();
            if (createOrg == null) {
                e.setCancel(true);
                return;
            }
            createOrg = OrgQueryHelper.getDataCacheByID((Object)createOrg.getPkValue());
            boolean isinventory = createOrg.getBoolean("fisinventory");
            List stockOrgList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)createOrg.getLong("id"));
            if (!isinventory) {
                stockOrgList.remove(createOrg.getLong("id"));
            }
            e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            if (!stockOrgList.isEmpty()) {
                filter2 = new QFilter("id", "in", (Object)stockOrgList);
                qFilterList.add(filter2);
            }
        }
        if ("entryprofessiona_show".equals(fieldName)) {
            // empty if block
        }
        if ("materielmtc_show".equals(fieldName)) {
            DynamicObject cabinconfig;
            String modelmpdone;
            createOrg = this.getAndValidCreateOrg();
            if (createOrg == null) {
                e.setCancel(true);
                return;
            }
            QFilter filter6 = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialmtcinfo", (Long)createOrg.getLong("id"));
            qFilterList.add(filter6);
            DynamicObject materialType = (DynamicObject)this.getModel().getValue("materialtype");
            if (materialType != null && !StringUtils.isEmpty((String)(modelmpdone = materialType.getString("modelmpdone")))) {
                QFilter filter22 = new QFilter("mratype.modelmpdone", "=", (Object)modelmpdone);
                qFilterList.add(filter22);
            }
            String modelones = "";
            Object modelone = this.getModel().getValue("modelmpdone");
            if (modelone != null) {
                modelones = modelone.toString();
            }
            if (!"".equals(modelones)) {
                QFilter filter32 = new QFilter("mratype.modelone", "=", (Object)modelones);
                qFilterList.add(filter32);
            }
            if ((cabinconfig = (DynamicObject)this.getModel().getValue("cabinconfig")) != null) {
                QFilter filter4 = new QFilter("cabinconfig.id", "=", (Object)cabinconfig.getLong("id"));
                qFilterList.add(filter4);
            }
        }
        if ("cardoperationno_show".equals(fieldName) || "cardoperationno".equals(fieldName)) {
            DynamicObject workCard = this.getAndValidWorkCard();
            if (workCard == null) {
                e.setCancel(true);
                return;
            }
            QFilter filter7 = new QFilter("cardid", "=", workCard.getPkValue());
            qFilterList.add(filter7);
        }
        if (!qFilterList.isEmpty()) {
            for (int i = 0; i < qFilterList.size(); ++i) {
                listParams.getQFilters().add(qFilterList.get(i));
            }
        }
    }

    private Set<Long> getLocationFilter(DynamicObject warehouse) {
        HashSet<Long> locationIds = new HashSet<Long>(16);
        if (warehouse == null) {
            return locationIds;
        }
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : col) {
            DynamicObject location = obj.getDynamicObject("location");
            locationIds.add(location.getLong("id"));
        }
        return locationIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeDatas;
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        for (ChangeData changeData : changeDatas = e.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            if (oldObject != null && newObject != null && oldObject.equals(newObject)) continue;
            this.propertyChanged(proName, changeData);
        }
    }

    private void workCardPropertyChange(IDataModel model, DynamicObject workCard) {
        this.clearMaterialMTC();
        if (workCard == null) {
            model.setValue("productmaterial", null);
            model.setValue("auxproperty", null);
            model.setValue("materialtype", null);
            model.setValue("modelmpdone", null);
        } else {
            String selectFields = "id,number,auxproperty,createorg,material,unit,materialtype,materialtype.number,materialtype.name";
            workCard = BusinessDataServiceHelper.loadSingleFromCache((Object)workCard.getPkValue(), (String)"mpdm_mrocardroute", (String)selectFields);
            DynamicObject matObjTmp = workCard.getDynamicObject("material");
            model.setValue("materialtype", (Object)workCard.getDynamicObject("materialtype"));
            model.setValue("modelmpdone", null);
            model.setValue("productmaterial", (Object)matObjTmp);
            model.setValue("auxproperty", matObjTmp == null ? null : workCard.get("auxproperty"));
        }
    }

    private void entryMaterialMftPropertyChange(IDataModel model, DynamicObject materialMftObj, int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        DynamicObject materialMftInfo = MaterialMftQueryHelper.getDataCacheByID((Object)materialMftObj.getPkValue());
        DynamicObject materialInfo = materialMftInfo.getDynamicObject("masterid");
        model.setValue("entrymaterial", (Object)materialInfo, rowIndex);
        model.setValue("entrybaseunit", (Object)materialInfo.getDynamicObject("baseunit"), rowIndex);
        model.setValue("enrtyunit", (Object)materialMftInfo.getDynamicObject("mftunit"), rowIndex);
        model.setValue("isbackflush", materialMftInfo.get("isbackflush"), rowIndex);
        model.setValue("entryiskey", (Object)materialMftInfo.getBoolean("iskeypart"), rowIndex);
        model.setValue("isentryqtylimit", (Object)materialMftInfo.getBoolean("isquotacontrol"), rowIndex);
        model.setValue("entrylimittop", (Object)materialMftInfo.getBigDecimal("issinhighlimit"), rowIndex);
        model.setValue("entrylimitlow", (Object)materialMftInfo.getBigDecimal("issinlowlimit"), rowIndex);
        model.setValue("materialattr", (Object)materialMftInfo.getString("materialattr"), rowIndex);
        model.setValue("issuemode", (Object)materialMftInfo.getString("issuemode"), rowIndex);
        model.setValue("supplyorg", (Object)materialMftInfo.getDynamicObject("supplyorgunitid"), rowIndex);
        model.setValue("warehouse", (Object)materialMftInfo.getDynamicObject("warehouse"), rowIndex);
        model.setValue("location", (Object)materialMftInfo.getDynamicObject("location"), rowIndex);
        model.setValue("isstockalloc", (Object)materialMftInfo.getBoolean("isstockallot"), rowIndex);
        model.setValue("outorg", (Object)materialMftInfo.getDynamicObject("outstorageunit"), rowIndex);
        model.setValue("outwarehouse", (Object)materialMftInfo.getDynamicObject("outwarehouse"), rowIndex);
        model.setValue("outlocation", (Object)materialMftInfo.getDynamicObject("outwarelocation"), rowIndex);
    }

    protected void propertyChanged(String propertyName, Object propertyValue) {
        HashSet<String> filedNameSet;
        ChangeData changeData;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData changeData2 = changeData = propertyValue instanceof ChangeData ? (ChangeData)propertyValue : null;
        if (changeData == null) {
            return;
        }
        if ("workcard".equals(propertyName)) {
            DynamicObject workCard = (DynamicObject)changeData.getNewValue();
            this.workCardPropertyChange(model, workCard);
        }
        int rowIndex = changeData.getRowIndex();
        if ("entrymftmaterial".equals(propertyName)) {
            DynamicObject materialMftObj = (DynamicObject)changeData.getNewValue();
            if (materialMftObj == null) {
                return;
            }
            this.entryMaterialMftPropertyChange(model, materialMftObj, rowIndex);
            this.setShowValue(rowIndex, Collections.emptySet());
            this.enableData_init();
        }
        if ("needmaterial".equals(propertyName)) {
            boolean needMaterial = (Boolean)changeData.getNewValue();
            this.initNeedMaterial(needMaterial);
        }
        if ("enrtyunit".equals(propertyName) || "entryqty".equals(propertyName)) {
            DynamicObject entrymaterial = this.getAndValidMaterial(rowIndex);
            if (entrymaterial == null) {
                return;
            }
            BigDecimal entryQty = BigDecimal.ZERO;
            BigDecimal baseQty = BigDecimal.ZERO;
            DynamicObject entryunit = null;
            entryunit = "enrtyunit".equals(propertyName) ? (DynamicObject)changeData.getNewValue() : (DynamicObject)model.getValue("enrtyunit");
            entryQty = "entryqty".equals(propertyName) ? (BigDecimal)changeData.getNewValue() : (BigDecimal)model.getValue("entryqty");
            DynamicObject basicUnit = entrymaterial.getDynamicObject("baseunit");
            baseQty = entryunit != null && basicUnit != null && entryQty.compareTo(BigDecimal.ZERO) != 0 ? BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)entrymaterial, (DynamicObject)entryunit, (BigDecimal)entryQty, (DynamicObject)basicUnit) : entryQty;
            model.setValue("baseqty", (Object)baseQty, rowIndex);
        }
        if ("warehouse_show".equals(propertyName)) {
            model.setValue("location_show", null);
            filedNameSet = new HashSet<String>(2);
            filedNameSet.add("warehouse");
            filedNameSet.add("location");
            this.updateGridValue(filedNameSet);
            this.enableData_Location();
        }
        if ("outwarehouse_show".equals(propertyName)) {
            model.setValue("outlocation_show", null);
            filedNameSet = new HashSet(2);
            filedNameSet.add("outwarehouse");
            filedNameSet.add("outlocation");
            this.updateGridValue(filedNameSet);
            this.enableData_OutLocation();
        }
        if ("location_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("location");
            this.updateGridValue(filedNameSet);
        }
        if ("outlocation_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("outlocation");
            this.updateGridValue(filedNameSet);
        }
        if ("issuemode_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("issuemode");
            this.updateGridValue(filedNameSet);
        }
        if ("isbackflush_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("isbackflush");
            this.updateGridValue(filedNameSet);
        }
        if ("cardoperationno_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("cardoperationno");
            this.updateGridValue(filedNameSet);
        }
        if ("supplyorg_show".equals(propertyName)) {
            model.setValue("warehouse_show", null);
            model.setValue("location_show", null);
            filedNameSet = new HashSet(16);
            filedNameSet.add("supplyorg");
            filedNameSet.add("warehouse");
            filedNameSet.add("location");
            this.updateGridValue(filedNameSet);
            this.enableData_Warehouse();
            this.enableData_Location();
        }
        if ("outorg_show".equals(propertyName)) {
            model.setValue("outwarehouse_show", null);
            model.setValue("outlocation_show", null);
            filedNameSet = new HashSet(16);
            filedNameSet.add("outorg");
            filedNameSet.add("outwarehouse");
            filedNameSet.add("outlocation");
            this.updateGridValue(filedNameSet);
            this.enableData_OutWarehouse();
            this.enableData_OutLocation();
        }
        if ("isstockalloc_show".equals(propertyName)) {
            if (!((Boolean)changeData.getNewValue()).booleanValue()) {
                model.setValue("outorg_show", null);
                model.setValue("outwarehouse_show", null);
                model.setValue("outlocation_show", null);
            }
            view.setEnable((Boolean)changeData.getNewValue(), new String[]{"outorg_show"});
            view.setEnable((Boolean)changeData.getNewValue(), new String[]{"outwarehouse_show"});
            view.setEnable((Boolean)changeData.getNewValue(), new String[]{"outlocation_show"});
            filedNameSet = new HashSet(16);
            filedNameSet.add("isstockalloc");
            filedNameSet.add("outorg");
            filedNameSet.add("outwarehouse");
            filedNameSet.add("outlocation");
            this.updateGridValue(filedNameSet);
            this.enableData_Outorg();
            this.enableData_OutWarehouse();
            this.enableData_OutLocation();
        }
        if ("entryiskey_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryiskey");
            this.updateGridValue(filedNameSet);
        }
        if ("isreplacement_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("isreplacement");
            this.updateGridValue(filedNameSet);
        }
        if ("entryprofessiona_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryprofessiona");
            this.updateGridValue(filedNameSet);
        }
        if ("entryprofessiona".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryprofessiona");
            this.updateGridNextRowValue(filedNameSet, rowIndex);
            this.setShowValue(rowIndex, filedNameSet);
        }
        if ("materielmtc_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("materielmtc");
            this.updateGridValue(filedNameSet);
        }
        if ("entryremark_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryremark");
            this.updateGridValue(filedNameSet);
        }
        if ("entryownertype_show".equals(propertyName)) {
            model.setValue("entryowner_show", null);
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryownertype");
            filedNameSet.add("entryowner");
            this.updateGridValue(filedNameSet);
        }
        if ("entryowner_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryowner");
            this.updateGridValue(filedNameSet);
        }
        if ("entryresptype_show".equals(propertyName)) {
            model.setValue("entryresp_show", null);
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryresptype");
            filedNameSet.add("entryresp");
            this.updateGridValue(filedNameSet);
        }
        if ("entryresp_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("entryresp");
            this.updateGridValue(filedNameSet);
        }
        if ("entrysn_show".equals(propertyName)) {
            filedNameSet = new HashSet(2);
            filedNameSet.add("entrysn");
            this.updateGridValue(filedNameSet);
        }
        if ("cabinconfig".equals(propertyName) || "modelmpdone".equals(propertyName)) {
            this.clearMaterialMTC();
        }
    }

    private void setShowValue(int rowIndex, Set<String> filedNameSet) {
        IDataModel model = this.getModel();
        if (rowIndex == -1) {
            model.beginInit();
            for (int i = 0; i < FIELD_SHOW_ARRAT.length; ++i) {
                if (filedNameSet != null && !filedNameSet.isEmpty() && !filedNameSet.contains(FIELD_SHOW_ARRAT[i])) continue;
                model.setValue(FIELD_SHOW_ARRAT[i] + "_show", null);
            }
            model.endInit();
            this.getView().updateView("fs_showform");
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int seq_show = model.getValue("seq_show") == null ? -1 : Integer.parseInt(model.getValue("seq_show").toString());
        DynamicObject entry = model.getEntryRowEntity("entryentity", rowIndex);
        int seq = entry.getInt("seq");
        model.beginInit();
        for (int i = 0; i < FIELD_SHOW_ARRAT.length; ++i) {
            if (filedNameSet != null && !filedNameSet.isEmpty() && !filedNameSet.contains(FIELD_SHOW_ARRAT[i])) continue;
            model.setValue(FIELD_SHOW_ARRAT[i] + "_show", model.getValue(FIELD_SHOW_ARRAT[i], rowIndex));
        }
        model.setValue("seq_show", (Object)seq);
        model.endInit();
        this.getView().updateView("fs_showform");
    }

    public void entryRowClick(RowClickEvent e) {
        IDataModel model = this.getModel();
        int rowIndex = e.getRow();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedIndex = entryGrid.getSelectRows();
        if (selectedIndex == null || selectedIndex.length <= 0) {
            this.setShowValue(-1, Collections.emptySet());
            this.enableData_init();
            return;
        }
        this.setShowValue(rowIndex, Collections.emptySet());
        this.enableData_init();
    }

    private void updateGridValue(Set<String> filedNameSet) {
        int i;
        IDataModel model = this.getModel();
        int seq_show = model.getValue("seq_show") == null ? -1 : Integer.parseInt(model.getValue("seq_show").toString());
        int entrySize = model.getEntryRowCount("entryentity");
        if (seq_show == -1 || entrySize <= 0) {
            return;
        }
        DynamicObject updateEntry = null;
        HashSet<Integer> updateRowSet = new HashSet<Integer>(entrySize);
        for (i = 0; i < entrySize; ++i) {
            DynamicObject entry = model.getEntryRowEntity("entryentity", i);
            if (!entry.get("seq").toString().equals(String.valueOf(seq_show))) continue;
            updateEntry = entry;
            updateRowSet.add(i);
            break;
        }
        if (updateEntry == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u7269\u6599\u4fe1\u606f!", (String)"CardMaterialCommandEditPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        model.beginInit();
        for (i = 0; i < FIELD_SHOW_ARRAT.length; ++i) {
            if (filedNameSet != null && !filedNameSet.isEmpty() && !filedNameSet.contains(FIELD_SHOW_ARRAT[i])) continue;
            updateEntry.set(FIELD_SHOW_ARRAT[i], model.getValue(FIELD_SHOW_ARRAT[i] + "_show"));
        }
        Set<String> unionUpdateFieldSet = this.getUnionUpdateFieldSet(filedNameSet);
        if (!unionUpdateFieldSet.isEmpty()) {
            for (int i2 = 0; i2 < entrySize; ++i2) {
                DynamicObject entry = model.getEntryRowEntity("entryentity", i2);
                if (entry.get("seq") == null || Integer.parseInt(entry.get("seq").toString()) <= seq_show) continue;
                for (String filedName : unionUpdateFieldSet) {
                    if (updateEntry.get(filedName) == null || entry.get(filedName) != null) continue;
                    entry.set(filedName, updateEntry.get(filedName));
                    updateRowSet.add(i2);
                }
            }
        }
        model.endInit();
        if (filedNameSet != null && !filedNameSet.isEmpty()) {
            for (String filedName : filedNameSet) {
                Iterator<Object> iterator = updateRowSet.iterator();
                while (iterator.hasNext()) {
                    int i3 = (Integer)iterator.next();
                    this.getView().updateView(filedName, i3);
                }
            }
        }
    }

    private void updateGridNextRowValue(Set<String> filedNameSet, int rowIndex) {
        if (this.isChangeBill()) {
            return;
        }
        IDataModel model = this.getModel();
        int entrySize = model.getEntryRowCount("entryentity");
        model.beginInit();
        DynamicObject updateEntry = null;
        HashSet<Integer> updateRowSet = new HashSet<Integer>(entrySize);
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entry = model.getEntryRowEntity("entryentity", i);
            if (i == rowIndex) {
                updateEntry = entry;
                updateRowSet.add(i);
            }
            if (i <= rowIndex || updateEntry == null) continue;
            for (String filedName : filedNameSet) {
                if (updateEntry.get(filedName) == null || entry.get(filedName) != null) continue;
                entry.set(filedName, updateEntry.get(filedName));
                updateRowSet.add(i);
            }
        }
        model.endInit();
        for (String filedName : filedNameSet) {
            Iterator<Object> iterator = updateRowSet.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.getView().updateView(filedName, i);
            }
        }
    }

    private Set<String> getUnionUpdateFieldSet(Set<String> filedNameSet) {
        if (filedNameSet == null || filedNameSet.isEmpty()) {
            return Collections.emptySet();
        }
        if (FIELD_BATCH_FILL_ARRAT != null && FIELD_BATCH_FILL_ARRAT.length > 0) {
            HashSet<String> unionFiledNameSet = new HashSet<String>(filedNameSet.size());
            for (int j = 0; j < FIELD_BATCH_FILL_ARRAT.length; ++j) {
                if (!filedNameSet.contains(FIELD_BATCH_FILL_ARRAT[j])) continue;
                unionFiledNameSet.add(FIELD_BATCH_FILL_ARRAT[j]);
            }
            return unionFiledNameSet;
        }
        return Collections.emptySet();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().beginInit();
        this.enableData_init();
        this.initNeedMaterialEnable();
        this.initVersionNo();
        this.getModel().endInit();
    }

    public void enableData_init() {
        this.enableData_Warehouse();
        this.enableData_Location();
        this.enableData_Outorg();
        this.enableData_OutWarehouse();
        this.enableData_OutLocation();
    }

    private void enableData_Warehouse() {
        Object value = this.getModel().getValue("supplyorg_show");
        boolean isEnable = false;
        if (value != null) {
            isEnable = true;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"warehouse_show"});
    }

    private void enableData_Location() {
        DynamicObject warehouse;
        Object value = this.getModel().getValue("warehouse_show");
        boolean isEnable = false;
        if (value != null && (warehouse = (DynamicObject)value).getBoolean("isopenlocation")) {
            isEnable = true;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"location_show"});
    }

    private void enableData_Outorg() {
        Object value = this.getModel().getValue("isstockalloc_show");
        boolean isEnable = false;
        if (((Boolean)value).booleanValue()) {
            isEnable = true;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"outorg_show"});
    }

    private void enableData_OutWarehouse() {
        Object value = this.getModel().getValue("outorg_show");
        boolean isEnable = false;
        if (value != null) {
            isEnable = true;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"outwarehouse_show"});
    }

    private void enableData_OutLocation() {
        DynamicObject warehouse;
        Object value = this.getModel().getValue("outwarehouse_show");
        boolean isEnable = false;
        if (value != null && (warehouse = (DynamicObject)value).getBoolean("isopenlocation")) {
            isEnable = true;
        }
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"outlocation_show"});
    }

    public void click(EventObject event) {
        super.click(event);
        if (this.isChangeBill()) {
            return;
        }
        if (event == null) {
            return;
        }
        Object srcObj = event.getSource();
        Control srcC = srcObj instanceof Control ? (Control)srcObj : null;
        String srcKey = srcC == null ? null : srcC.getKey();
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        if (StringUtils.isBlank((String)srcKey)) {
            return;
        }
        if ("modelmpdone".equalsIgnoreCase(srcKey)) {
            DynamicObject materialType = this.getAndValidMaterialType();
            if (materialType == null) {
                return;
            }
            List modeloneList = CardBusinessUtils.getModelOneList((DynamicObject)materialType);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("list", modeloneList);
            params.put("formId", "mpdm_mrtype_modelone_f7");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "querymodelonef7"));
            fv.showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "querymodelonef7": {
                Map result = (Map)returnData;
                this.getModel().setValue("modelmpdone", result.get("modelone"));
                break;
            }
        }
    }

    private void initNeedMaterialEnable() {
        boolean value = (Boolean)this.getModel().getValue("needmaterial");
        this.initNeedMaterial(value);
    }

    private void initNeedMaterial(Boolean needmaterial) {
        if (this.isChangeBill()) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        fv.setVisible(needmaterial, new String[]{"newentry", "insertentry", "deleteentry"});
        if (!needmaterial.booleanValue()) {
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
        }
    }

    private void clearMaterialMTC() {
        if (this.isChangeBill()) {
            return;
        }
        IDataModel model = this.getModel();
        int entrySize = model.getEntryRowCount("entryentity");
        model.beginInit();
        for (int i = 0; i < entrySize; ++i) {
            DynamicObject entry = model.getEntryRowEntity("entryentity", i);
            entry.set("materielmtc", null);
        }
        model.setValue("materielmtc_show", null);
        model.endInit();
        this.getView().updateView("entryentity");
        this.getView().updateView("materielmtc_show");
    }

    public boolean isAddNewStatus() {
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        return opStatus.equals((Object)OperationStatus.ADDNEW);
    }

    public void initVersionNo() {
        Object verionObj;
        IBillModel billModel;
        if (this.isChangeBill()) {
            return;
        }
        if (this.getModel() instanceof IBillModel && (billModel = (IBillModel)this.getModel()).isFromImport()) {
            return;
        }
        if (this.isAddNewStatus() && ((verionObj = this.getModel().getValue("version")) == null || StringUtils.isEmpty((String)verionObj.toString()))) {
            String version = CardBusinessUtils.getVersion((String)"mpdm_cardmatcommand", (String)"");
            this.getModel().setValue("version", (Object)version);
            this.getModel().setValue("isnewversion", (Object)Boolean.TRUE);
        }
    }

    private String getOrgFiledName() {
        if (this.isChangeBill()) {
            return "org";
        }
        return "createorg";
    }

    public boolean isChangeBill() {
        return "mpdm_cmatcmdchange".equals(this.getView().getEntityId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }
}

