/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CardMaterialCommandImportPlugin
extends AbstractBillPlugIn {
    private static final String KEY_NUMBER = "number";
    private static final String KEY_STATUS = "status";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_WORKCARD = "workcard";
    private static final String KEY_CARDOPERATIONNO = "cardoperationno";
    private static final String KEY_WORKCARDENTRY = "processentry";
    private static final String KEY_QTY = "entryqty";
    private static final String KEY_BASEQTY = "baseqty";
    private Map<Integer, String> errorMap = new HashMap<Integer, String>(16);

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        if (null != sourceDataList && sourceDataList.size() > 0) {
            for (Map sourceData : sourceDataList) {
                Object objEntry = sourceData.get(KEY_ENTRYENTITY);
                Object objWorkCard = sourceData.get(KEY_WORKCARD);
                DynamicObject workCard = null;
                String workCardNumber = "";
                if (objWorkCard != null) {
                    String selectProperties = "processentry,processentry.operationno";
                    JSONObject jsonWorkCard = (JSONObject)objWorkCard;
                    if (null != jsonWorkCard) {
                        workCardNumber = jsonWorkCard.getString(KEY_NUMBER);
                        QFilter workCardQFilter = new QFilter(KEY_NUMBER, "=", (Object)workCardNumber);
                        workCard = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_mrocardroute", (String)selectProperties, (QFilter[])new QFilter[]{workCardQFilter});
                    }
                }
                int rowNum = (Integer)sourceData.get("rowNum");
                if (workCard == null) {
                    this.errorMap.put(rowNum, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u65e0\u6cd5\u627e\u5230\u7f16\u7801\u4e3a%2$s\u7684\u5de5\u5361\u57fa\u7840\u8d44\u6599\u6570\u636e!", (String)"CardMaterialCommandImportPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowNum, workCardNumber));
                    continue;
                }
                JSONArray arrEntrys = (JSONArray)objEntry;
                for (int i = 0; i < arrEntrys.size(); ++i) {
                    DynamicObject unit;
                    BigDecimal qty;
                    JSONObject entryObj = arrEntrys.getJSONObject(i);
                    if (entryObj == null) continue;
                    JSONObject jsonOperationno = (JSONObject)entryObj.get((Object)KEY_CARDOPERATIONNO);
                    if (jsonOperationno != null) {
                        String operationNo = jsonOperationno.getString("operationno");
                        Long wcOperationID = this.getMroCardProcessID(workCard, operationNo);
                        if (wcOperationID.equals(0L)) {
                            this.errorMap.put(rowNum, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u65e0\u6cd5\u627e\u5230\u5de5\u5e8f\u53f7\u4e3a%2$s\u7684\u5de5\u5361\u5de5\u4f5c\u6e05\u5355\u6570\u636e!", (String)"CardMaterialCommandImportPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowNum, operationNo));
                            continue;
                        }
                        HashMap<String, Object> wcOperationDO = new HashMap<String, Object>();
                        wcOperationDO.put("importprop", "id");
                        wcOperationDO.put("operationno", operationNo);
                        wcOperationDO.put("id", wcOperationID);
                        wcOperationDO.put("operationdesc", jsonOperationno.getString("operationdesc"));
                        JSONObject cardOperationNoJson = new JSONObject(wcOperationDO);
                        entryObj.put(KEY_CARDOPERATIONNO, (Object)cardOperationNoJson);
                    }
                    BigDecimal baseQty = qty = this.getEntryQty(entryObj);
                    DynamicObject baseUnit = unit = this.getEntryUnit(entryObj);
                    DynamicObject material = this.getEntryMaterial(entryObj);
                    if (material == null) {
                        this.errorMap.put(rowNum, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u9700\u8981\u914d\u7f6e\u5206\u5f55\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u7f16\u7801[entrymftmaterial.number]\u4f5c\u4e3a\u5bfc\u5165\u5b57\u6bb5!", (String)"CardMaterialCommandImportPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowNum));
                        continue;
                    }
                    HashMap<String, String> materialDO = new HashMap<String, String>();
                    materialDO.put("importprop", KEY_NUMBER);
                    materialDO.put(KEY_NUMBER, material.getString(KEY_NUMBER));
                    materialDO.put("name", material.getString("name"));
                    JSONObject materialJson = new JSONObject(materialDO);
                    entryObj.put("entrymaterial", (Object)materialJson);
                    if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                        DynamicObject dynamicObject = baseUnit = material == null ? null : material.getDynamicObject("baseunit");
                        if (baseUnit == null) {
                            baseUnit = unit;
                        }
                        if (baseUnit != null && unit != null) {
                            baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                        }
                    }
                    if (baseUnit != null) {
                        HashMap<String, Object> baseUnitDO = new HashMap<String, Object>();
                        baseUnitDO.put("importprop", "id");
                        baseUnitDO.put("id", baseUnit.getPkValue());
                        baseUnitDO.put(KEY_NUMBER, baseUnit.getString(KEY_NUMBER));
                        baseUnitDO.put("name", baseUnit.getString("name"));
                        JSONObject baseUitJson = new JSONObject(baseUnitDO);
                        entryObj.put("entrybaseunit", (Object)baseUitJson);
                    }
                    entryObj.put(KEY_BASEQTY, (Object)baseQty);
                }
            }
        }
    }

    private DynamicObject getEntryMaterial(JSONObject entryObj) {
        JSONObject materialmft = (JSONObject)entryObj.get((Object)"entrymftmaterial");
        if (materialmft == null) {
            return null;
        }
        String materialNumber = materialmft.getString(KEY_NUMBER);
        QFilter qfilter = new QFilter(KEY_NUMBER, "=", (Object)materialNumber);
        DynamicObject material = MaterialQueryHelper.getSingleDataCacheByQFilter((QFilter[])new QFilter[]{qfilter});
        return material;
    }

    private DynamicObject getEntryUnit(JSONObject entryObj) {
        JSONObject unitJson = (JSONObject)entryObj.get((Object)"enrtyunit");
        if (unitJson == null) {
            return null;
        }
        String unitNumber = unitJson.getString(KEY_NUMBER);
        QFilter qfilter = new QFilter(KEY_NUMBER, "=", (Object)unitNumber);
        DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (QFilter[])new QFilter[]{qfilter});
        return unit;
    }

    private BigDecimal getEntryQty(JSONObject entryObj) {
        return entryObj.getBigDecimal(KEY_QTY);
    }

    public Long getMroCardProcessID(DynamicObject workCard, String operationno) {
        for (int i = 0; i < workCard.getDynamicObjectCollection(KEY_WORKCARDENTRY).size(); ++i) {
            DynamicObject entry = (DynamicObject)workCard.getDynamicObjectCollection(KEY_WORKCARDENTRY).get(i);
            if (!entry.getString("operationno").equals(operationno)) continue;
            return (Long)entry.getPkValue();
        }
        return 0L;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        JSONArray entryJsonArray;
        int rowNum;
        String errorMsg;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        if (sourceData.get("rowNum") != null && (errorMsg = this.errorMap.get(rowNum = ((Integer)sourceData.get("rowNum")).intValue())) != null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), errorMsg);
            e.setFireAfterImportData(false);
        }
        String status = String.valueOf(sourceData.get(KEY_STATUS));
        if (sourceData.get(KEY_STATUS) != null && !"A".equals(status)) {
            e.setCancel(true);
            String strinfo = String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u201c\u6682\u5b58\u201d\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"CardMaterialCommandImportPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), strinfo);
            e.setFireAfterImportData(false);
        }
        if ((entryJsonArray = (JSONArray)JSON.toJSON(sourceData.get(KEY_ENTRYENTITY))) != null && !entryJsonArray.isEmpty()) {
            this.validataEntry(e, sourceData);
        }
    }

    private boolean validataEntry(BeforeImportDataEventArgs e, Map<String, Object> sourceData) {
        JSONArray entryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get(KEY_ENTRYENTITY));
        for (int i = 0; i < entryJsonArray.size(); ++i) {
            JSONObject entryJson = (JSONObject)entryJsonArray.get(i);
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal baseQty = BigDecimal.ZERO;
            if (entryJson.containsKey((Object)KEY_QTY)) {
                qty = entryJson.getBigDecimal(KEY_QTY);
            }
            if (!entryJson.containsKey((Object)KEY_BASEQTY)) continue;
            baseQty = entryJson.getBigDecimal(KEY_BASEQTY);
        }
        return true;
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        if (model.getValue(KEY_WORKCARD) != null) {
            DynamicObject workCard = (DynamicObject)model.getValue(KEY_WORKCARD);
            String SelectFields = "id,number,auxproperty,createorg,material,unit,materialtype,materialtype.number,materialtype.name";
            workCard = BusinessDataServiceHelper.loadSingleFromCache((Object)workCard.getPkValue(), (String)"mpdm_mrocardroute", (String)SelectFields);
            DynamicObject matObjTmp = workCard.getDynamicObject("material");
            model.setValue("materialtype", (Object)workCard.getDynamicObject("materialtype"));
            model.setValue("productmaterial", (Object)matObjTmp);
            model.setValue("auxproperty", workCard.get("auxproperty"));
        }
        DynamicObjectCollection entrys = model.getEntryEntity(KEY_ENTRYENTITY);
        for (DynamicObject entry : entrys) {
            if (entry.getDynamicObject("entrymaterial") != null) continue;
            DynamicObject materialMft = entry.getDynamicObject("entrymftmaterial");
            entry.set("entrymaterial", (Object)materialMft.getDynamicObject("masterid"));
        }
    }
}

