/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.QueryMaterialUnit;
import kd.bd.mpdm.common.utils.WareHouseLocationQFilter;
import kd.bd.mpdm.common.wordcard.utils.WorkCardUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class CardToolDemandEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener {
    private static final String CREATEORG = "createorg";
    private static final String CARD_NO = "workcard";
    private static final String CARD_MODELTYPE = "materialtype";
    private static final String MATERIAL_UNIT = "materialunit";
    private static final String ENTRY_UNIT = "enrtyunit";
    private static final String ENTRY_MATERIAL = "entrymaterial";
    private static final String ENTRY_OWNTYPE = "entryownertype";
    public static final String ENTRY_OWNTYPE_SUP = "bd_supplier";
    public static final String ENTRY_OWNTYPE_CUS = "bd_customer";
    private static final String ENTRY_OWNER = "entryowner";
    private static final String ENTRY_QTY = "entryqty";
    private static final String ENTRY_WAREHOUSE = "warehouse";
    private static final String ENTRY_TOOLSUBGROUP = "toolsubgroup";
    private static final String OP_PREROW = "previousentry";
    private static final String OP_LASTROW = "nextentry";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SUB_ENTRY_ENTITY = "entryentity1";
    private static final String ISNEEDTOOL = "isneedtool";
    private static final String ENTRY_MODELTOW = "entrymodeltow";
    private static final String ENTRY_MATERIALTYPE = "entrymaterialtype";
    private static final String ENTRY_TOOLLEVEL = "toollevel";
    private static final String REPDELETEROW = "repdeleterow";
    public static final String MPDM_MRTYPR = "mpdm_mrtype";
    private static final String MRTYPE = "mrtype";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Boolean isNeedTool;
        FieldEdit fieldEdit;
        String fieldKey;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object source = e.getSource();
        if (source instanceof FieldEdit && ISNEEDTOOL.equals(fieldKey = (fieldEdit = (FieldEdit)source).getFieldKey()) && (isNeedTool = Boolean.valueOf(model.getDataEntity().getBoolean(ISNEEDTOOL))).booleanValue()) {
            this.setTip();
            e.setCancel(true);
        }
    }

    private void setTip() {
        ConfirmCallBackListener listener = new ConfirmCallBackListener(ISNEEDTOOL, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u9700\u8981\u5de5\u5177\u201d\u4e3a\u5426\uff0c\u4f1a\u540c\u65f6\u5220\u9664\u5de5\u5177\u6e05\u5355\u3001\u624b\u518c\u4fe1\u606f\uff0c\u662f\u5426\u5c06\u201c\u9700\u8981\u5de5\u5177\u201d\u8bbe\u4e3a\u5426\uff1f", (String)"CardToolDemandEditPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        this.recodeChangeAction(proName);
        switch (proName) {
            case "workcard": {
                this.setCardNoInfo(changeSet, MATERIAL_UNIT);
                break;
            }
            case "entrymaterial": {
                break;
            }
            case "enrtyunit": 
            case "entryqty": {
                this.setEntryBaseQty(changeSet);
                break;
            }
            case "toolsubgroup": {
                this.doAfterToolGroup(changeSet);
                break;
            }
        }
    }

    private void recodeChangeAction(String proName) {
        if (!(StringUtils.equals((CharSequence)proName, (CharSequence)"entryseq_show") || StringUtils.equals((CharSequence)proName, (CharSequence)"entrymaterial_show") || StringUtils.equals((CharSequence)proName, (CharSequence)"entrymaterialname_show") || StringUtils.equals((CharSequence)proName, (CharSequence)"entryqty_show") || StringUtils.equals((CharSequence)proName, (CharSequence)"enrtyunit_show") || StringUtils.equals((CharSequence)proName, (CharSequence)"meanstype_show") || StringUtils.equals((CharSequence)proName, (CharSequence)"useorg"))) {
            this.getPageCache().put("isDataChange", "true");
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit workcard;
        BasedataEdit toolsubgroup;
        EntryGrid entryGrid;
        BasedataEdit locationEdit;
        BasedataEdit warehouseEdit;
        BasedataEdit supplyorgEdit;
        ItemClassEdit entryOwner;
        super.registerListener(e);
        UnitEdit headUnit = (UnitEdit)this.getView().getControl(ENTRY_UNIT);
        if (headUnit != null) {
            headUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryOwner = (ItemClassEdit)this.getView().getControl(ENTRY_OWNER)) != null) {
            entryOwner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplyorgEdit = (BasedataEdit)this.getControl("supplyorg")) != null) {
            supplyorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouseEdit = (BasedataEdit)this.getControl(ENTRY_WAREHOUSE)) != null) {
            warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((locationEdit = (BasedataEdit)this.getControl("location")) != null) {
            locationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY)) != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if (null != (toolsubgroup = (BasedataEdit)this.getControl(ENTRY_TOOLSUBGROUP))) {
            toolsubgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (workcard = (BasedataEdit)this.getView().getControl(CARD_NO))) {
            workcard.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        IDataModel model = this.getModel();
        switch (filedKey) {
            case "enrtyunit": {
                QFilter qFilter = this.getUnitQFilter();
                qFilters.add(qFilter);
                break;
            }
            case "entryowner": {
                DynamicObject createOrg = (DynamicObject)model.getValue(CREATEORG);
                String entryownertype = (String)model.getValue(ENTRY_OWNTYPE);
                long pkValue = 0L;
                if (createOrg != null) {
                    pkValue = createOrg.getLong("id");
                }
                if (ENTRY_OWNTYPE_SUP.equals(entryownertype)) {
                    QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)ENTRY_OWNTYPE_SUP, (Long)pkValue);
                    qFilters.add(filter);
                    break;
                }
                if (!ENTRY_OWNTYPE_CUS.equals(entryownertype)) break;
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)ENTRY_OWNTYPE_CUS, (Long)pkValue);
                qFilters.add(filter);
                break;
            }
            case "warehouse": {
                DynamicObject supplyOrg = (DynamicObject)model.getValue("supplyorg");
                Set enableSet = WareHouseLocationQFilter.getWareHouseFilter((DynamicObject)supplyOrg);
                QFilter filter = new QFilter("id", "in", (Object)enableSet);
                qFilters.add(filter);
                break;
            }
            case "toolsubgroup": {
                QFilter toolSubGroupFilter = this.getToolSubGroupQFilter();
                if (null != toolSubGroupFilter) {
                    qFilters.add(toolSubGroupFilter);
                } else {
                    beforeF7SelectEvent.setCancel(true);
                }
                ListShowParameter showPara = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showPara.setMultiSelect(false);
                break;
            }
            case "supplyorg": {
                QFilter supplyOrgFilter = this.getsupplyOrgQFilter();
                if (null == supplyOrgFilter) break;
                qFilters.add(supplyOrgFilter);
                break;
            }
            case "location": {
                QFilter locationFilter;
                DynamicObject wareHouseObj = (DynamicObject)model.getValue(ENTRY_WAREHOUSE);
                Set<Long> locationIds = this.getLocationFilter(wareHouseObj);
                if (null == locationIds || null == (locationFilter = new QFilter("id", "in", locationIds))) break;
                qFilters.add(locationFilter);
                break;
            }
            case "workcard": {
                String entityNum = this.getModel().getDataEntityType().getName();
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                DynamicObject createOrgInfo = this.getAndValidCreateOrg();
                if (createOrgInfo == null) {
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter wordCardFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_mrocardroute", (Long)createOrgInfo.getLong("id"));
                Set jobCardTypeIdSet = WorkCardUtils.getWorkCardTypeFromEntity((String)entityNum);
                wordCardFilter.and(new QFilter("cardtype.id", "in", (Object)jobCardTypeIdSet));
                wordCardFilter.and(new QFilter("enable", "=", (Object)"1"));
                wordCardFilter.and(new QFilter("cardintegrity", "!=", (Object)"A"));
                formShowParameter.setShowApproved(false);
                formShowParameter.getListFilterParameter().getQFilters().add(wordCardFilter);
                break;
            }
        }
    }

    private void doAfterToolGroup(ChangeData[] changeSet) {
        for (ChangeData changeData : changeSet) {
            Object newValue = changeData.getNewValue();
            if (null == newValue) continue;
            Object toolGrpId = ((DynamicObject)newValue).getPkValue();
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)toolGrpId, (String)"mpdm_toolsubgroup");
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection(ENTRY_ENTITY);
            String groupversion = obj.getString("groupversion");
            int selectCur = changeData.getRowIndex();
            for (DynamicObject entry : entrys) {
                int seq = entry.getInt("seq");
                if (seq == 1) {
                    this.setEntryRow(selectCur, entry, obj);
                    this.getModel().setValue("groupversion", (Object)groupversion, selectCur);
                    continue;
                }
                this.getView().invokeOperation("newentry");
                int size = this.getModel().getEntryEntity(ENTRY_ENTITY).size();
                this.setEntryRow(size - 1, entry, obj);
                this.getModel().setValue("groupversion", (Object)groupversion, size - 1);
            }
        }
    }

    private void setEntryRow(int selectCur, DynamicObject entry, DynamicObject obj) {
        this.getModel().setValue(ENTRY_MATERIAL, (Object)entry.getDynamicObject("material"), selectCur);
        this.getModel().setValue("entrybaseunit", (Object)entry.getDynamicObject("baseunit"), selectCur);
        this.getModel().setValue("entrybaseqty", (Object)entry.getBigDecimal("baseqty"), selectCur);
        this.getModel().setValue(ENTRY_UNIT, entry.get("unit"), selectCur);
        this.getModel().setValue(ENTRY_QTY, entry.get("qty"), selectCur);
        this.getModel().setValue(ENTRY_OWNTYPE, entry.get(ENTRY_OWNTYPE), selectCur);
        this.getModel().setValue(ENTRY_OWNER, entry.get(ENTRY_OWNER), selectCur);
        this.getModel().setValue(ENTRY_MATERIALTYPE, entry.get(ENTRY_MATERIALTYPE), selectCur);
        this.getModel().beginInit();
        this.getModel().setValue(ENTRY_TOOLSUBGROUP, (Object)obj.getLong("id"), selectCur);
        this.getModel().endInit();
        this.getView().updateView(ENTRY_TOOLSUBGROUP, selectCur);
        this.getModel().setValue("repgrpentryid", entry.get("id"), selectCur);
    }

    private Set<Long> getLocationFilter(DynamicObject warehouse) {
        HashSet<Long> locationIds = new HashSet<Long>(16);
        if (warehouse == null) {
            return locationIds;
        }
        DynamicObjectCollection col = warehouse.getDynamicObjectCollection(ENTRY_ENTITY);
        for (DynamicObject obj : col) {
            DynamicObject location = obj.getDynamicObject("location");
            locationIds.add(location.getLong("id"));
        }
        return locationIds;
    }

    public QFilter getsupplyOrgQFilter() {
        QFilter resultQFilter = null;
        DynamicObject createOrg = this.getAndValidCreateOrg();
        if (createOrg == null) {
            return resultQFilter;
        }
        boolean isinventory = createOrg.getBoolean("fisinventory");
        List stockOrgList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)createOrg.getLong("id"));
        if (!isinventory) {
            stockOrgList.remove(createOrg.getLong("id"));
        }
        if (!stockOrgList.isEmpty()) {
            resultQFilter = new QFilter("id", "in", (Object)stockOrgList);
        }
        return resultQFilter;
    }

    private DynamicObject getAndValidCreateOrg() {
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
        if (createOrg == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7!", (String)"CardToolDemandEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        return createOrg;
    }

    public QFilter getToolSubGroupQFilter() {
        List dynList;
        Object invokeBizService;
        List modelTwoList;
        DynamicObject obj = this.getModel().getDataEntity().getDynamicObject(CARD_NO);
        if (null == obj) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5de5\u5361\u7f16\u7801\u201d\u3002", (String)"CardToolDemandEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject materialtype = obj.getDynamicObject(CARD_MODELTYPE);
        Long loneMpd = materialtype == null ? 0L : materialtype.getLong("id");
        QFilter filter = new QFilter("1", "=", (Object)1);
        if (loneMpd > 0L && (modelTwoList = (List)(invokeBizService = DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMrTypeConfigModelService", (String)"getChilds", (Object[])new Object[]{loneMpd}))) != null && !modelTwoList.isEmpty()) {
            filter.and(new QFilter("entryentity.entrymaterialtypetwo.fbasedataid", "in", (Object)modelTwoList).or(new QFilter("entryentity.entrymaterialtypetwo.fbasedataid", "=", (Object)0L)).or(new QFilter("entryentity.entrymaterialtypetwo.fbasedataid", "is null", null)));
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY_ENTITY);
        Set<Object> idSet = new HashSet();
        if (!entry.isEmpty() && !(dynList = entry.stream().filter(o -> o.getDynamicObject(ENTRY_TOOLSUBGROUP) != null).collect(Collectors.toList())).isEmpty()) {
            idSet = dynList.stream().map(o -> o.getDynamicObject(ENTRY_TOOLSUBGROUP).getLong("id")).collect(Collectors.toSet());
        }
        if (!idSet.isEmpty()) {
            filter.and("id", "not in", idSet);
        }
        EntryGrid gird = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] sel = gird.getSelectRows();
        Object entrymaterial = this.getModel().getValue(ENTRY_MATERIAL, sel[0]);
        if (null != entrymaterial) {
            DynamicObject materObj = (DynamicObject)entrymaterial;
            filter.and("entryentity.material.id", "=", (Object)materObj.getLong("id"));
        }
        return filter;
    }

    public void setCardNoInfo(ChangeData[] changeSet, String relationFiled) {
        if (changeSet == null) {
            return;
        }
        IDataModel dm = this.getModel();
        Map<Long, DynamicObject> materialMap = this.getMaterialUnit(changeSet, relationFiled);
        for (int i = 0; i < changeSet.length; ++i) {
            DynamicObject materialDO;
            ChangeData changeData = changeSet[i];
            Object cardInfo = changeData.getNewValue();
            long materialID = 0L;
            DynamicObject baseUnitDO = null;
            if (cardInfo instanceof DynamicObject) {
                DynamicObject cardInfoDO = (DynamicObject)cardInfo;
                switch (relationFiled) {
                    case "materialunit": {
                        Object pkValue;
                        Object materialObj = cardInfoDO.get("material");
                        if (!(materialObj instanceof DynamicObject) || !((pkValue = ((DynamicObject)materialObj).getPkValue()) instanceof Long)) break;
                        materialID = (Long)pkValue;
                        break;
                    }
                    case "enrtyunit": {
                        Object pkValue = cardInfoDO.getPkValue();
                        if (!(pkValue instanceof Long)) break;
                        materialID = (Long)pkValue;
                        break;
                    }
                }
            }
            if ((materialDO = materialMap.get(materialID)) != null) {
                baseUnitDO = materialDO.getDynamicObject("baseunit");
            }
            dm.setValue(relationFiled, (Object)baseUnitDO);
            if (!StringUtils.equals((CharSequence)ENTRY_UNIT, (CharSequence)relationFiled)) continue;
            dm.setValue("entrybaseunit", (Object)baseUnitDO);
        }
    }

    public Map<Long, DynamicObject> getMaterialUnit(ChangeData[] changeSet, String relationFiled) {
        ArrayList<Object> materilPKList = new ArrayList<Object>(1);
        block8: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object cardInfo = changeData.getNewValue();
            if (!(cardInfo instanceof DynamicObject)) continue;
            DynamicObject cardInfoDO = (DynamicObject)cardInfo;
            switch (relationFiled) {
                case "materialunit": {
                    Object materialObj = cardInfoDO.get("material");
                    if (!(materialObj instanceof DynamicObject)) continue block8;
                    Object pkValue = ((DynamicObject)materialObj).getPkValue();
                    materilPKList.add(pkValue);
                    continue block8;
                }
                case "enrtyunit": {
                    Object pkValue = cardInfoDO.getPkValue();
                    materilPKList.add(pkValue);
                }
            }
        }
        QFilter qFilter = new QFilter("id", "in", materilPKList);
        DynamicObject[] materials = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,number,baseunit.id,baseunit.number,baseunit.name,baseunit.precision,baseunit.precisionaccount", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> materilMap = new HashMap<Long, DynamicObject>();
        if (materials != null && materials.length > 0) {
            for (int i = 0; i < materials.length; ++i) {
                Object pkValue = materials[i].getPkValue();
                if (!(pkValue instanceof Long)) continue;
                materilMap.put((Long)pkValue, materials[i]);
            }
        }
        return materilMap;
    }

    public QFilter getUnitQFilter() {
        List unitList;
        Object cardInfo = this.getModel().getValue(ENTRY_MATERIAL);
        Object pkValue = null;
        if (cardInfo instanceof DynamicObject) {
            DynamicObject cardInfoDO = (DynamicObject)cardInfo;
            pkValue = cardInfoDO.getPkValue();
        }
        QFilter resultQFilter = (unitList = QueryMaterialUnit.getMaterialMultiUnit(pkValue)).size() == 0 ? new QFilter("id", "in", (Object)0L) : new QFilter("id", "in", (Object)unitList);
        return resultQFilter;
    }

    public void setEntryBaseQty(ChangeData[] changeSet) {
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object cardInfo = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            if (cardInfo == null) continue;
            this.setBaseQty(rowIndex);
        }
    }

    public void setBaseQty(int rowIndex) {
        BigDecimal bigDecimal = new BigDecimal(0);
        IDataModel model = this.getModel();
        DynamicObject entrymaterial = (DynamicObject)model.getValue(ENTRY_MATERIAL, rowIndex);
        if (entrymaterial == null) {
            return;
        }
        BigDecimal entryQty = (BigDecimal)model.getValue(ENTRY_QTY);
        DynamicObject basicUnit = entrymaterial.getDynamicObject("baseunit");
        DynamicObject entryunit = (DynamicObject)model.getValue(ENTRY_UNIT);
        long entryUnitId = 0L;
        if (entryunit != null) {
            entryUnitId = entryunit.getLong("id");
        }
        BigDecimal basicRate = BigDecimal.ZERO;
        BigDecimal souceRate = BigDecimal.ZERO;
        long matId = entrymaterial.getLong("id");
        QFilter matFilter = new QFilter("materialid", "=", (Object)matId);
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (QFilter[])new QFilter[]{matFilter});
        Set set = unitMap.entrySet();
        for (Map.Entry entry : set) {
            DynamicObject mulUnit = (DynamicObject)entry.getValue();
            DynamicObject unit = mulUnit.getDynamicObject("measureunitid");
            long unitId = unit.getLong("id");
            BigDecimal numerator = mulUnit.getBigDecimal("numerator");
            BigDecimal denominator = mulUnit.getBigDecimal("denominator");
            if (entryUnitId == 0L || entryUnitId != unitId) continue;
            basicRate = numerator;
            souceRate = denominator;
        }
        RoundingMode roundModel = RoundingMode.HALF_UP;
        String precisionaccount = basicUnit.getString("precisionaccount");
        BigDecimal precision = basicUnit.getBigDecimal("precision");
        if ("1".equals(precisionaccount)) {
            roundModel = RoundingMode.HALF_UP;
        } else if ("2".equals(precisionaccount)) {
            roundModel = RoundingMode.DOWN;
        } else if ("3".equals(precisionaccount)) {
            roundModel = RoundingMode.UP;
        }
        if (entryunit != null && basicUnit != null && basicUnit.getLong("id") == entryunit.getLong("id")) {
            model.setValue("entrybaseqty", (Object)entryQty.setScale(precision.intValue(), roundModel), rowIndex);
        } else if (souceRate.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal retbasicQty = entryQty.multiply(basicRate).divide(souceRate, precision.intValue(), roundModel);
            model.setValue("entrybaseqty", (Object)retbasicQty, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("deleteentry".equals(key)) {
            this.doDeleteEntry(args);
        }
    }

    private void doDeleteEntry(BeforeDoOperationEventArgs args) {
        Object object;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] gridSel = grid.getSelectRows();
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashSet<Integer> intSet = new HashSet<Integer>();
        for (DynamicObject obj : entryCol) {
            object = gridSel;
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                DynamicObject toolgroup;
                Integer i2 = object[i];
                if (!i2.equals(obj.getInt("seq") - 1) || null == (toolgroup = obj.getDynamicObject(ENTRY_TOOLSUBGROUP))) continue;
                intSet.add(obj.getInt("seq"));
            }
        }
        if (!intSet.isEmpty()) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener("deleteentry", (IFormPlugin)this);
            StringBuilder sb = new StringBuilder();
            object = intSet.iterator();
            while (object.hasNext()) {
                Integer flag = (Integer)object.next();
                sb.append(flag);
                sb.append(",");
            }
            String out = sb.substring(0, sb.length() - 1);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5de5\u5177\u4ef6\u53f7\u5b58\u5728\u66ff\u4ee3\u7ec4\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"CardToolDemandEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[]{out}), MessageBoxOptions.OKCancel, listener);
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "save": {
                this.getPageCache().put("isDataChange", "false");
                break;
            }
            case "repdeleterow": {
                this.repDeleteRow();
                break;
            }
        }
    }

    private void repDeleteRow() {
        IDataModel model = this.getModel();
        EntryGrid gird = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] rows = gird.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u5220\u9664\u7684\u884c\u3002", (String)"CardToolDemandEditPlugin_4", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY_ENTITY);
        boolean flag = this.judgeToolGroup(entry, rows);
        if (!flag) {
            return;
        }
        int[] deleteRows = this.getDeleteRows(rows, entry);
        model.deleteEntryRows(ENTRY_ENTITY, deleteRows);
    }

    private int[] getDeleteRows(int[] rows, DynamicObjectCollection entry) {
        HashSet<Long> repSet = new HashSet<Long>();
        for (DynamicObject obj : entry) {
            int[] nArray = rows;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer i2 = nArray[i];
                if (!i2.equals(obj.getInt("seq") - 1)) continue;
                Long id = obj.getDynamicObject(ENTRY_TOOLSUBGROUP).getLong("id");
                repSet.add(id);
            }
        }
        ArrayList<Integer> delList = new ArrayList<Integer>();
        for (DynamicObject obj : entry) {
            Long id;
            DynamicObject groupObj = obj.getDynamicObject(ENTRY_TOOLSUBGROUP);
            if (null == groupObj || !repSet.contains(id = Long.valueOf(groupObj.getLong("id")))) continue;
            Integer delrow = obj.getInt("seq") - 1;
            delList.add(delrow);
        }
        return delList.stream().mapToInt(Integer::valueOf).toArray();
    }

    private boolean judgeToolGroup(DynamicObjectCollection entry, int[] rows) {
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        for (Object obj : entry) {
            int[] nArray = rows;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject toolgroup;
                Integer i2 = nArray[i];
                if (!i2.equals(obj.getInt("seq") - 1) || null != (toolgroup = obj.getDynamicObject(ENTRY_TOOLSUBGROUP))) continue;
                arrList.add(obj.getInt("seq"));
            }
        }
        if (!arrList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Integer flag : arrList) {
                sb.append(flag);
                sb.append(",");
            }
            String out = sb.substring(0, sb.length() - 1);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u201c\u66ff\u4ee3\u7ec4\u201d\u4e3a\u7a7a\uff0c\u8bf7\u4f7f\u7528\u201c\u5220\u9664\u884c\u201d\u8fdb\u884c\u884c\u5220\u9664\u3002", (String)"CardToolDemandEditPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[]{out}));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String confirmStr = messageBoxClosedEvent.getCallBackId();
        if (ISNEEDTOOL.equals(confirmStr)) {
            switch (messageBoxClosedEvent.getResult()) {
                case Yes: {
                    this.getModel().setValue(ISNEEDTOOL, (Object)false);
                    this.getModel().deleteEntryData(ENTRY_ENTITY);
                    this.getModel().deleteEntryData(SUB_ENTRY_ENTITY);
                    break;
                }
                case Cancel: {
                    this.getModel().setValue(ISNEEDTOOL, (Object)true);
                    this.getView().updateView(ISNEEDTOOL);
                }
            }
        }
        if ("deleteentry".equals(confirmStr)) {
            switch (messageBoxClosedEvent.getResult()) {
                case Yes: {
                    this.doDeleteAll();
                    break;
                }
                case Cancel: {
                    this.doDeleteSome();
                    break;
                }
            }
        }
    }

    private void doDeleteSome() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] sel = grid.getSelectRows();
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashSet<Integer> set = new HashSet<Integer>();
        for (DynamicObject obj : entry) {
            int[] nArray = sel;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject toolGroup;
                Integer i2 = nArray[i];
                if (!i2.equals(obj.getInt("seq") - 1) || null != (toolGroup = obj.getDynamicObject(ENTRY_TOOLSUBGROUP))) continue;
                set.add(i2);
            }
        }
        int[] res = set.stream().mapToInt(Integer::valueOf).toArray();
        this.getModel().deleteEntryRows(ENTRY_ENTITY, res);
    }

    private void doDeleteAll() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] sel = grid.getSelectRows();
        this.getModel().deleteEntryRows(ENTRY_ENTITY, sel);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object object = evt.getReturnData();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object statusObj = model.getValue("status");
        String status = "";
        if (statusObj instanceof String) {
            status = statusObj.toString();
        }
        String isDataChange = this.getPageCache().get("isDataChange");
        if (StringUtils.equals((CharSequence)status, (CharSequence)"A") && StringUtils.equalsIgnoreCase((CharSequence)isDataChange, (CharSequence)"true")) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
    }
}

