/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import kd.bd.mpdm.common.utils.QueryMaterialUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CardWorkDetailEditPlgin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CARD_NO = "cardno";
    private static final String PROCESS_NO = "processno";
    private static final String OPRCTRL_STATEGY = "oprctrlstrategy";
    private static final String MACHINING_TYPE = "machiningtype";
    private static final String CHECK_TYPE = "checktype";
    private static final String WORK_CENTER = "workcenter";
    private static final String OPERATION = "operation";
    private static final String BASE_BATCH_QTY = "basebatchqty";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (proName) {
            case "cardno": {
                this.setCardNoInfo(changeSet);
                break;
            }
            case "processno": {
                this.setProcessNo(changeSet);
                break;
            }
            case "oprctrlstrategy": {
                this.setOprCtrlStategyInfo(changeSet);
                break;
            }
            case "workcenter": {
                this.setWorkCenterInfo(changeSet);
                break;
            }
            case "operation": {
                this.setOperationInfo(changeSet);
                break;
            }
            case "workhours": {
                this.calcWorkHours();
            }
        }
    }

    public void setCardNoInfo(ChangeData[] changeSet) {
        if (changeSet == null) {
            return;
        }
        IDataModel dm = this.getModel();
        dm.setValue("materialunit", null);
        ArrayList<Object> materilPKList = new ArrayList<Object>(1);
        for (int i = 0; i < changeSet.length; ++i) {
            DynamicObject cardInfoDO;
            Object materialObj;
            ChangeData changeData = changeSet[i];
            Object cardInfo = changeData.getNewValue();
            if (!(cardInfo instanceof DynamicObject) || !((materialObj = (cardInfoDO = (DynamicObject)cardInfo).get("material")) instanceof DynamicObject)) continue;
            Object pkValue = ((DynamicObject)materialObj).getPkValue();
            materilPKList.add(pkValue);
        }
        QFilter qFilter = new QFilter("id", "in", materilPKList);
        DynamicObject[] materials = BusinessDataServiceHelper.load((String)"bd_material", (String)"id,number,baseunit.id,baseunit.number,baseunit.name,baseunit.precision,baseunit.precisionaccount", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, DynamicObject> materilMap = new HashMap<Long, DynamicObject>();
        if (materials != null && materials.length > 0) {
            for (int i = 0; i < materials.length; ++i) {
                Object pkValue = materials[i].getPkValue();
                if (!(pkValue instanceof Long)) continue;
                materilMap.put((Long)pkValue, materials[i]);
            }
        }
        for (int i = 0; i < changeSet.length; ++i) {
            DynamicObject materialDO;
            Object pkValue;
            ChangeData changeData = changeSet[i];
            Object cardInfo = changeData.getNewValue();
            if (!(cardInfo instanceof DynamicObject)) continue;
            DynamicObject cardInfoDO = (DynamicObject)cardInfo;
            Object materialObj = cardInfoDO.get("material");
            long materialID = 0L;
            if (materialObj instanceof DynamicObject && (pkValue = ((DynamicObject)materialObj).getPkValue()) instanceof Long) {
                materialID = (Long)pkValue;
            }
            if ((materialDO = (DynamicObject)materilMap.get(materialID)) == null) continue;
            DynamicObject baseUnitDO = materialDO.getDynamicObject("baseunit");
            if (baseUnitDO != null) {
                dm.setValue("materialunit", (Object)baseUnitDO);
                continue;
            }
            dm.setValue("materialunit", null);
        }
    }

    public void setProcessNo(ChangeData[] changeSet) {
        if (changeSet == null) {
            return;
        }
        IDataModel dm = this.getModel();
        for (int i = 0; i < changeSet.length; ++i) {
            String optionFormat;
            ChangeData changeData = changeSet[i];
            Object processNoObj = changeData.getNewValue();
            boolean noFormat = false;
            if (!(processNoObj instanceof String) || !StringUtils.isNotEmpty((CharSequence)processNoObj.toString()) || (noFormat = Pattern.matches(optionFormat = "^[1-9][0-9]{0,3}$", String.valueOf(processNoObj)))) continue;
            Object oldValue = changeData.getOldValue();
            dm.setValue(PROCESS_NO, oldValue);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7[%1$s]\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"CardWorkDetailEditPlgin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), String.valueOf(processNoObj)));
        }
    }

    public void setOprCtrlStategyInfo(ChangeData[] changeSet) {
        if (changeSet == null) {
            return;
        }
        IDataModel dm = this.getModel();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            int rowIndex = changeData.getRowIndex();
            Object oprCtrlStategyObj = changeData.getNewValue();
            if (oprCtrlStategyObj instanceof DynamicObject) {
                DynamicObject opCtrlStategyDO = (DynamicObject)oprCtrlStategyObj;
                String promode = opCtrlStategyDO.getString("promode");
                String checkmethod = opCtrlStategyDO.getString("checkmethod");
                this.getModel().setValue(MACHINING_TYPE, (Object)promode, rowIndex);
                this.getModel().setValue(CHECK_TYPE, (Object)checkmethod, rowIndex);
                continue;
            }
            this.getModel().setValue(MACHINING_TYPE, null, rowIndex);
            this.getModel().setValue(CHECK_TYPE, null, rowIndex);
        }
    }

    public void setWorkCenterInfo(ChangeData[] changeSet) {
        if (changeSet == null) {
            return;
        }
        IDataModel dm = this.getModel();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            int rowIndex = changeData.getRowIndex();
            Object workCenterObj = changeData.getNewValue();
            if (workCenterObj instanceof DynamicObject) {
                DynamicObject workCenterDO = (DynamicObject)workCenterObj;
                Object workshop = workCenterDO.get("workshop");
                this.getModel().setValue("productionworkshop", workshop, rowIndex);
                continue;
            }
            this.getModel().setValue("productionworkshop", null, rowIndex);
        }
    }

    public void setOperationInfo(ChangeData[] changeSet) {
        if (changeSet == null) {
            return;
        }
        IDataModel dm = this.getModel();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            int rowIndex = changeData.getRowIndex();
            Object operationObj = changeData.getNewValue();
            if (operationObj instanceof DynamicObject) {
                DynamicObject operationDO = (DynamicObject)operationObj;
                String specName = operationDO.getString("name");
                boolean collaborAtive = operationDO.getBoolean("collaborative");
                boolean bottleProcedure = operationDO.getBoolean("bottleprocedure");
                boolean ismileStoneProcess = operationDO.getBoolean("ismilestoneprocess");
                if (StringUtils.isNotEmpty((CharSequence)specName)) {
                    this.getModel().setValue("operationdesc", (Object)specName, rowIndex);
                    this.setEnableControl("operationdesc", false, rowIndex);
                } else {
                    this.setEnableControl("operationdesc", true, rowIndex);
                }
                this.getModel().setValue("collaborative", (Object)collaborAtive, rowIndex);
                this.getModel().setValue("bottleprocedure", (Object)bottleProcedure, rowIndex);
                this.getModel().setValue("ismilestoneprocess", (Object)ismileStoneProcess, rowIndex);
                continue;
            }
            this.setEnableControl("operationdesc", true, rowIndex);
            this.getModel().setValue("operationdesc", null, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void sortEntry() {
        IDataModel dm = this.getModel();
        DynamicObjectCollection entryDOC = dm.getEntryEntity("entryentity");
        DynamicObjectCollection sortEntry = new DynamicObjectCollection();
        if (entryDOC != null && entryDOC.size() > 0) {
            String processno;
            HashMap entryDOMap = new HashMap(4);
            boolean isSort = true;
            for (DynamicObject entryDO : entryDOC) {
                processno = entryDO.getString(PROCESS_NO);
                int seq = entryDO.getInt("seq");
                if (StringUtils.isEmpty((CharSequence)processno)) {
                    isSort = false;
                    break;
                }
                String optionFormat = "^[1-9][0-9]{0,3}$";
                boolean noFormat = Pattern.matches(optionFormat, processno);
                if (!noFormat) {
                    isSort = false;
                    break;
                }
                if (!entryDOMap.containsKey(processno)) continue;
                isSort = false;
                break;
            }
            if (isSort) {
                for (int i = 0; i < entryDOC.size() - 1; ++i) {
                    for (int j = 0; j < entryDOC.size() - 1 - i; ++j) {
                        String processno1;
                        processno = ((DynamicObject)entryDOC.get(j)).getString(PROCESS_NO);
                        if (processno.compareTo(processno1 = ((DynamicObject)entryDOC.get(j + 1)).getString(PROCESS_NO)) <= 0) continue;
                        this.getModel().moveEntryRowDown("entryentity", j);
                    }
                }
                this.getView().updateView("entryentity");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("newentry".equals(opKey)) {
            int count = this.getModel().getEntryRowCount("entryentity");
            String prevalue = String.valueOf(count * 10);
            String index = String.valueOf(count);
            DynamicObjectCollection col = this.getView().getModel().getEntryEntity("entryentity");
            this.initRowData(count);
            for (DynamicObject obj : col) {
                if (index.equals(obj.getString("seq")) || !prevalue.equals(obj.get(PROCESS_NO))) continue;
                this.getModel().setValue(PROCESS_NO, (Object)(count * 10 + 10), count - 1);
                return;
            }
            this.getModel().setValue(PROCESS_NO, (Object)(count * 10), count - 1);
        } else if ("deleteentry".equals(opKey)) {
            this.calcWorkHours();
        } else if ("save".equals(opKey) || "submit".equals(opKey)) {
            this.sortEntry();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryDescEnable();
    }

    public void setEntryDescEnable() {
        IDataModel dm = this.getModel();
        DynamicObjectCollection entryDOC = dm.getEntryEntity("entryentity");
        if (entryDOC != null && entryDOC.size() > 0) {
            for (int i = 0; i < entryDOC.size(); ++i) {
                DynamicObject entryDO = (DynamicObject)entryDOC.get(i);
                if (entryDO == null) continue;
                String opDesc = entryDO.getString("operationdesc");
                DynamicObject operation = entryDO.getDynamicObject(OPERATION);
                if (operation == null) {
                    this.setEnableControl("operationdesc", true, i);
                    continue;
                }
                String opName = operation.getString("name");
                if (StringUtils.isNotEmpty((CharSequence)opDesc) && StringUtils.equals((CharSequence)opDesc, (CharSequence)opName)) {
                    this.setEnableControl("operationdesc", false, i);
                    continue;
                }
                this.setEnableControl("operationdesc", true, i);
            }
        }
    }

    public void initRowData(int rowIndex) {
        Object createorg = this.getModel().getValue("createorg");
        this.getModel().setValue("productionorg", createorg, rowIndex - 1);
        Object baseUnit = this.getModel().getValue("materialunit");
        this.getModel().setValue("headunit", baseUnit, rowIndex - 1);
        this.getModel().setValue("operationunit", baseUnit, rowIndex - 1);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        UnitEdit headUnit = (UnitEdit)this.getView().getControl("headunit");
        headUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        UnitEdit operationUnit = (UnitEdit)this.getView().getControl("operationunit");
        operationUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        switch (filedKey) {
            case "headunit": 
            case "operationunit": {
                QFilter qFilter = this.getUnitQFilter();
                qFilters.add(qFilter);
            }
        }
    }

    public QFilter getUnitQFilter() {
        List unitList;
        DynamicObject cardInfoDO;
        Object materialObj;
        Object cardInfo = this.getModel().getValue(CARD_NO);
        Object pkValue = null;
        if (cardInfo instanceof DynamicObject && (materialObj = (cardInfoDO = (DynamicObject)cardInfo).get("material")) instanceof DynamicObject) {
            pkValue = ((DynamicObject)materialObj).getPkValue();
        }
        QFilter resultQFilter = (unitList = QueryMaterialUnit.getMaterialMultiUnit(pkValue)).size() == 0 ? new QFilter("id", "in", (Object)0L) : new QFilter("id", "in", (Object)unitList);
        return resultQFilter;
    }

    public void calcWorkHours() {
        IDataModel dm = this.getModel();
        DynamicObjectCollection processEntry = dm.getEntryEntity("entryentity");
        BigDecimal sumHours = new BigDecimal(0);
        if (processEntry != null && processEntry.size() > 0) {
            for (DynamicObject entryDO : processEntry) {
                BigDecimal workhours = entryDO.getBigDecimal("workhours");
                sumHours = sumHours.add(workhours);
            }
        }
        dm.setValue("sumhours", (Object)sumHours);
    }

    public void setEnableControl(String filedName, boolean flag, int row) {
        IDataModel dm = this.getModel();
        IFormView fv = this.getView();
        fv.setEnable(Boolean.valueOf(flag), row, new String[]{filedName});
        fv.updateView(filedName, row);
    }
}

