/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.formplugin.workcardinfo.WorkCardDataHelp;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaintenancePlanFormPlugin
extends AbstractBasePlugIn
implements TabSelectListener {
    private static Log logger = LogFactory.getLog(MaintenancePlanFormPlugin.class);
    public static final String TABPAGEAP = "tabpageap";
    public static final String CREATEORG = "createorg";
    public static final String USEORG = "useorg";
    public static final String PGCACHE_CURSELTABKEY = "CurSelTabKey";
    public static final String TABPAGEAP_RPTMATCOMMAND = "rptmatcommand";
    public static final String TABPAGEAP_REPAIRPLANTOOL = "repairplantool";
    public static final String TABPAGEAP_BASEINFO = "tabpage_baseinfo";
    public static final String OPENFROMWORKCARD = "openfromworkcard";
    public static final String STATUS_A = "A";
    public static final String STATUS_B = "B";
    public static final String STATUS_C = "C";
    private static Set<String> tabpageapSet = Sets.newHashSet((Object[])new String[]{"rptmatcommand", "repairplantool"});
    private static Set<String> opKeySet = Sets.newHashSet((Object[])new String[]{"audit", "unaudit", "disable", "enable"});
    private static Map<String, String> tabPlanFieldMap = new HashMap<String, String>(16);
    private static Map<String, String> pageEntityMap = new HashMap<String, String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{"tabap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs adoe) {
        String curSelTabKey;
        String operateKey = adoe.getOperateKey();
        if (("refresh".equals(operateKey) || "unaudit".equals(operateKey) || "disable".equals(operateKey)) && tabpageapSet.contains(curSelTabKey = this.getPageCache().get(PGCACHE_CURSELTABKEY))) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab(TABPAGEAP_BASEINFO);
            tabpageapSet.forEach(ee -> this.getPageCache().put(ee, null));
        }
        if (adoe.getOperationResult() != null && adoe.getOperationResult().isSuccess() && opKeySet.contains(operateKey)) {
            this.setMaterialBizInfoVisibility();
        }
        super.afterDoOperation(adoe);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        if (tabpageapSet.contains(itemKey)) {
            try (TraceSpan span = Tracer.create((String)"MaintenancePlanFormPlugin", (String)"handleTabInfo");){
                this.handleTabInfo(itemKey, operationKey);
            }
        }
    }

    private void handleTabInfo(String itemKey, String operationKey) {
        String pageId = this.getPageCache().get(itemKey);
        String entityNumber = this.getEntityNumber(itemKey);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            this.setVisible(itemKey, STATUS_A, null);
            return;
        }
        switch (operationKey) {
            case "save_rptmatcommand": 
            case "save_ccardriskdef": 
            case "save_cbreaker": 
            case "save_cardimpexperience": 
            case "save_cardskills": 
            case "save_repairplantool": {
                this.handleOperate("save", "47156aff000000ac", pageId, entityNumber, itemKey, null);
                break;
            }
            case "submit_rptmatcommand": 
            case "submit_ccardriskdef": 
            case "submit_cbreaker": 
            case "submit_cardimpexperience": 
            case "submit_cardskills": 
            case "submit_repairplantool": {
                this.handleOperate("submit", "804f6478000000ac", pageId, entityNumber, itemKey, STATUS_B);
                break;
            }
            case "unsubmit_rptmatcommand": 
            case "unsubmit_ccardriskdef": 
            case "unsubmit_cbreaker": 
            case "unsubmit_cardimpexperience": 
            case "unsubmit_cardskills": 
            case "unsubmit_repairplantool": {
                this.handleOperate("unsubmit", "80513207000000ac", pageId, entityNumber, itemKey, STATUS_A);
                break;
            }
            case "audit_rptmatcommand": 
            case "audit_ccardriskdef": 
            case "audit_cbreaker": 
            case "audit_cardimpexperience": 
            case "audit_cardskills": 
            case "audit_repairplantool": {
                this.handleOperate("audit", "47162f66000000ac", pageId, entityNumber, itemKey, STATUS_C);
                break;
            }
            case "unaudit_rptmatcommand": 
            case "unaudit_ccardriskdef": 
            case "unaudit_cbreaker": 
            case "unaudit_cardimpexperience": 
            case "unaudit_cardskills": 
            case "unaudit_repairplantool": {
                this.handleOperate("unaudit", "47165e8e000000ac", pageId, entityNumber, itemKey, STATUS_A);
                break;
            }
        }
    }

    private void handleOperate(String operate, String permItem, String pageId, String entityNumber, String itemKey, String status) {
        DynamicObject showcreateorg;
        boolean checkPermResult;
        IFormView materialBizView = this.getView().getView(pageId);
        if (pageId != null && materialBizView != null) {
            DynamicObject data = this.getView().getView(pageId).getModel().getDataEntity();
            Object pkValue = data.getPkValue();
            if ("save".equals(operate) && pkValue != null && Long.parseLong(pkValue.toString()) != 0L) {
                permItem = "4715a0df000000ac";
            }
        }
        if (!(checkPermResult = this.checkPerm(operate, permItem, pageId, entityNumber))) {
            return;
        }
        if (pageId != null && materialBizView != null && (showcreateorg = materialBizView.getModel().getDataEntity().getDynamicObject(CREATEORG)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"MaintenancePlanFormPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (pageId != null && materialBizView != null) {
            OperationResult invokeOperation = this.getView().getView(pageId).invokeOperation(operate);
            this.getView().sendFormAction(this.getView().getView(pageId));
            if (invokeOperation.isSuccess() && StringUtils.isNotBlank((CharSequence)status)) {
                this.setVisible(itemKey, status, null);
            }
        }
    }

    private boolean checkPerm(String operate, String permItem, String pageId, String entityNumber) {
        boolean result = true;
        IFormView materialBizInfoView = this.getView().getView(pageId);
        long dimObjId = 0L;
        if (materialBizInfoView == null || "new".equals(operate)) {
            dimObjId = RequestContext.get().getOrgId();
        } else {
            DynamicObject createOrg = materialBizInfoView.getModel().getDataEntity().getDynamicObject(CREATEORG);
            if (createOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"MaintenancePlanFormPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                result = false;
                return result;
            }
            dimObjId = createOrg.getLong("id");
        }
        String appNumber = this.getView().getFormShowParameter().getAppId();
        int checkPermissionResult = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)entityNumber, (String)permItem);
        if (checkPermissionResult == 0) {
            String operateName = WorkCardDataHelp.getOperteName(permItem);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0b\u6ca1\u6709%s\u6743\u9650\u3002", (String)"MaintenancePlanFormPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), operateName));
            result = false;
        }
        return result;
    }

    public void tabSelected(TabSelectEvent evt) {
        String curSelTabKey = evt.getTabKey();
        this.getPageCache().put(PGCACHE_CURSELTABKEY, curSelTabKey);
        if (TABPAGEAP.equals(curSelTabKey)) {
            return;
        }
        String formid = this.getModel().getDataEntityType().getName();
        Object wordcardid = this.getModel().getDataEntity().getPkValue();
        DynamicObject useOrg = this.getModel().getDataEntity().getDynamicObject(USEORG);
        Long useOrgId = useOrg == null ? 0L : useOrg.getLong("id");
        String entityNumber = this.getEntityNumber(curSelTabKey);
        String pageId = this.getPageCache().get(curSelTabKey);
        if (pageId != null && this.getView().getView(pageId) != null) {
            return;
        }
        if (tabPlanFieldMap.containsKey(entityNumber)) {
            QFilter filter = new QFilter(tabPlanFieldMap.get(entityNumber), "=", wordcardid);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)useOrgId);
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
            }
            Map<String, Long> enableMap = this.getWorkCardInfo(filter, entityNumber);
            String appNumber = this.getView().getFormShowParameter().getAppId();
            if (enableMap.isEmpty()) {
                Boolean hasNewOperPermission = WorkCardDataHelp.hasOperPermission(useOrgId, appNumber, entityNumber, "47156aff000000ac");
                boolean hasOrgPermission = WorkCardDataHelp.hasOrgPermission(useOrgId, entityNumber);
                OperationStatus operStatus = hasNewOperPermission != false && hasOrgPermission ? OperationStatus.EDIT : OperationStatus.VIEW;
                this.setVisible(curSelTabKey, STATUS_A, operStatus);
                if (!hasOrgPermission) {
                    LocaleString entityName = EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName();
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0%1$s\u521b\u5efa\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u7684\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"MaintenancePlanFormPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), entityName.getLocaleValue()));
                    return;
                }
                this.openInfoPage(wordcardid, entityNumber, curSelTabKey, pageId, null, OperationStatus.ADDNEW);
            } else {
                Long bizInfoId = 0L;
                String status = STATUS_C;
                if (enableMap.containsKey(STATUS_C)) {
                    bizInfoId = enableMap.get(STATUS_C);
                } else if (enableMap.containsKey(STATUS_B)) {
                    bizInfoId = enableMap.get(STATUS_B);
                    status = STATUS_B;
                } else {
                    bizInfoId = enableMap.get(STATUS_A);
                    status = STATUS_A;
                }
                Boolean hasEditOperPermission = WorkCardDataHelp.hasOperPermission(useOrgId, appNumber, entityNumber, "4715a0df000000ac");
                OperationStatus operStatus = hasEditOperPermission != false ? OperationStatus.EDIT : OperationStatus.VIEW;
                this.setVisible(curSelTabKey, status, operStatus);
                this.openInfoPage(wordcardid, entityNumber, curSelTabKey, pageId, bizInfoId, operStatus);
            }
        }
    }

    private void openInfoPage(Object wordcardid, String entityNumber, String curSelTabKey, String pageId, Object dataId, OperationStatus operationStatus) {
        BaseShowParameter lsp = new BaseShowParameter();
        pageId = lsp.getPageId();
        if (StringUtils.isNotBlank((Object)dataId)) {
            lsp.setPkId(dataId);
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        lsp.setAppId(baseShowParameter.getAppId());
        lsp.setFormId(pageEntityMap.get(entityNumber));
        lsp.getOpenStyle().setTargetKey(curSelTabKey);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put(OPENFROMWORKCARD, Boolean.TRUE);
        params.put("wordcardid", wordcardid);
        params.put("wordcardfield", tabPlanFieldMap.get(entityNumber) == null ? "repairplancard" : tabPlanFieldMap.get(entityNumber));
        params.put(CREATEORG, this.getModel().getDataEntity().getDynamicObject(CREATEORG).getPkValue());
        DynamicObject userorg = this.getModel().getDataEntity().getDynamicObject(USEORG);
        params.put(USEORG, userorg == null ? Long.valueOf(0L) : userorg.getPkValue());
        params.put("entityNumber", entityNumber);
        lsp.setCustomParams(params);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        lsp.setStatus(operationStatus);
        this.getPageCache().put(curSelTabKey, pageId);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"new_rptmatcommand", "save_rptmatcommand", "submit_rptmatcommand", "unsubmit_rptmatcommand", "audit_rptmatcommand", "unaudit_rptmatcommand", "new_repairplantool", "save_repairplantool", "submit_repairplantool", "unsubmit_repairplantool", "audit_repairplantool", "unaudit_repairplantool", "new_cardskills", "save_cardskills", "submit_cardskills", "unsubmit_cardskills", "audit_cardskills", "unaudit_cardskills"});
        this.setMaterialBizInfoVisibility();
        super.afterBindData(e);
    }

    private void setMaterialBizInfoVisibility() {
        DynamicObject workcard = this.getModel().getDataEntity();
        String status = workcard.getString("status");
        String enable = workcard.getString("enable");
        String[] arr = new String[tabpageapSet.size()];
        if (STATUS_C.equals(status) && "1".equals(enable)) {
            this.getView().setVisible(Boolean.TRUE, tabpageapSet.toArray(arr));
        } else {
            this.getView().setVisible(Boolean.FALSE, tabpageapSet.toArray(arr));
        }
    }

    private void setVisible(String tabpageap, String status, OperationStatus operationStatus) {
        String newOp = "new_" + tabpageap;
        String saveOp = "save_" + tabpageap;
        String submitOp = "submit_" + tabpageap;
        String unsubmitOp = "unsubmit_" + tabpageap;
        String auditOp = "audit_" + tabpageap;
        String unauditOp = "unaudit_" + tabpageap;
        if (OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, saveOp, submitOp, unsubmitOp, auditOp, unauditOp});
        } else if (STATUS_A.equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{saveOp, submitOp});
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, unsubmitOp, auditOp, unauditOp});
        } else if (STATUS_B.equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{auditOp, unsubmitOp});
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, saveOp, submitOp, unauditOp});
        } else if (STATUS_C.equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{unauditOp});
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, submitOp, saveOp, auditOp, auditOp, unsubmitOp});
        }
        this.getView().updateView(tabpageap);
    }

    private String getEntityNumber(String context) {
        if (TABPAGEAP_RPTMATCOMMAND.equals(context)) {
            return "mpdm_rptmatcommand";
        }
        if (TABPAGEAP_REPAIRPLANTOOL.equals(context)) {
            return "mpdm_repairplantool";
        }
        return null;
    }

    private long getWorktypectrlId(DynamicObject cardtype) {
        QFilter filter2 = new QFilter("id", "=", cardtype.getPkValue());
        Map mpdmTypeMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{cardtype.getPkValue()}, (String)"mpdm_jobcardtype");
        if (mpdmTypeMap == null || mpdmTypeMap.isEmpty()) {
            return 0L;
        }
        DynamicObject mpdmType = (DynamicObject)mpdmTypeMap.get(cardtype.getPkValue());
        if (mpdmType == null) {
            return 0L;
        }
        return (Long)mpdmType.getDynamicObject("worktypectrl").getPkValue();
    }

    private Map<String, Long> getWorkCardInfo(QFilter filter, String entityNum) {
        HashMap<String, Long> enableMap = new HashMap<String, Long>(16);
        filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryWorkCard", (String)entityNum, (String)"id,status", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String status = row.getString("status");
                if (enableMap.containsKey(status)) continue;
                enableMap.put(status, row.getLong("id"));
            }
        }
        return enableMap;
    }

    static {
        pageEntityMap.put("mpdm_rptmatcommand", "mpdm_rrptmatcommand");
        pageEntityMap.put("mpdm_repairplantool", "mpdm_rrepairplantool");
        tabPlanFieldMap.put("mpdm_rptmatcommand", "repairplancard");
        tabPlanFieldMap.put("mpdm_repairplantool", "repairplancard");
    }
}

