/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.formplugin.workcardinfo.SelectCardPhotoMain;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ClientActions;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class MroPlanCardPhotoPlugin
extends AbstractFormPlugin {
    private static final String NEXTPHOTO = "nextphoto";
    private static final String PREPHOTO = "prephoto";
    private static final String MAXPHOTOID = "maxphotoid";
    private static final String MINPHOTOID = "minphotoid";
    private static final String MAXPHOTOCATCH = "maxphotoid";
    private static final String MINPHOTOCATCH = "minPhotoCatch";
    private static final String ANALYSIS = "analysis";
    private static String FASTPHOTO_ENTITY = "mpdm_maintenanceplan_h";
    private static String CARD_ENTRYID = "cardentryid";
    private static final String MPDM_PHOTOSELECT = "mpdm_mentaincardselect";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{NEXTPHOTO});
        this.addClickListeners(new String[]{PREPHOTO});
    }

    public void beforeBindData(EventObject e) {
        Object analysis;
        BillShowParameter lsp = (BillShowParameter)this.getView().getFormShowParameter();
        if (lsp != null && (analysis = lsp.getCustomParam(ANALYSIS)) != null && ANALYSIS.equals(analysis.toString())) {
            Object maxPhotoCatch = lsp.getCustomParam("maxphotoid");
            Object minPhotoCatch = lsp.getCustomParam(MINPHOTOID);
            this.getPageCache().put("maxphotoid", maxPhotoCatch.toString());
            this.getPageCache().put(MINPHOTOCATCH, minPhotoCatch.toString());
            this.getPageCache().put(ANALYSIS, ANALYSIS);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            Object cphotoid = lsp.getCustomParam("cphotoid");
            HashMap<String, Object> photoMap = new HashMap<String, Object>(8);
            photoMap.put("photo1", pkValue);
            photoMap.put("photo2", cphotoid);
            this.showColor(photoMap);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        String analysis = this.getPageCache().get(ANALYSIS);
        String maxPhotoCatch = this.getPageCache().get("maxphotoid");
        String minPhotoCatch = this.getPageCache().get(MINPHOTOCATCH);
        switch (operateKey) {
            case "nextphoto": {
                if (StringUtils.isNotBlank((CharSequence)analysis) && ANALYSIS.equals(analysis)) {
                    HashMap<String, String> paramMap = new HashMap<String, String>(8);
                    paramMap.put("maxphotoid", maxPhotoCatch);
                    paramMap.put(MINPHOTOID, minPhotoCatch);
                    paramMap.put("cphotoid", minPhotoCatch);
                    paramMap.put(ANALYSIS, ANALYSIS);
                    BillShowParameter createBillShowParam = SelectCardPhotoMain.createBillShowParam(FASTPHOTO_ENTITY, NumberUtils.toLong((String)maxPhotoCatch), ShowType.InCurrentForm);
                    createBillShowParam.setCustomParams(paramMap);
                    this.getView().showForm((FormShowParameter)createBillShowParam);
                    break;
                }
                OperationResult result = this.getView().invokeOperation("next");
                if (!result.isSuccess()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5207\u6362\u6210\u529f\u3002", (String)"MroPlanCardPhotoPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "prephoto": {
                if (StringUtils.isNotBlank((CharSequence)analysis) && ANALYSIS.equals(analysis)) {
                    HashMap<String, String> paramMap = new HashMap<String, String>(8);
                    paramMap.put("maxphotoid", maxPhotoCatch);
                    paramMap.put(MINPHOTOID, minPhotoCatch);
                    paramMap.put("cphotoid", maxPhotoCatch);
                    paramMap.put(ANALYSIS, ANALYSIS);
                    BillShowParameter createBillShowParam = SelectCardPhotoMain.createBillShowParam(FASTPHOTO_ENTITY, NumberUtils.toLong((String)minPhotoCatch), ShowType.InCurrentForm);
                    createBillShowParam.setCustomParams(paramMap);
                    this.getView().showForm((FormShowParameter)createBillShowParam);
                    break;
                }
                OperationResult result = this.getView().invokeOperation("previous");
                if (!result.isSuccess()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5207\u6362\u6210\u529f\u3002", (String)"MroPlanCardPhotoPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String maxPhotoCatch = this.getPageCache().get("maxphotoid");
        String minPhotoCatch = this.getPageCache().get(MINPHOTOCATCH);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        switch (operateKey) {
            case "nextphoto": {
                if (!StringUtils.isNotBlank((CharSequence)maxPhotoCatch) || !maxPhotoCatch.equals(pkValue.toString())) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u4e3a\u6700\u5927\u7248\u672c\uff0c\u65e0\u4e0b\u4e00\u7248\u672c\u6570\u636e\u3002", (String)"MroPlanCardPhotoPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "prephoto": {
                if (!StringUtils.isNotBlank((CharSequence)minPhotoCatch) || !minPhotoCatch.equals(pkValue.toString())) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u5df2\u4e3a\u6700\u5c0f\u7248\u672c\uff0c\u65e0\u4e0a\u4e00\u7248\u672c\u6570\u636e\u3002", (String)"MroPlanCardPhotoPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
    }

    private void showColor(Map<String, Object> photoMap) {
        Map photoCache = BusinessDataServiceHelper.loadFromCache((Object[])photoMap.values().toArray(), (String)FASTPHOTO_ENTITY);
        if (photoCache != null && !photoCache.isEmpty()) {
            DynamicObject photoData1 = (DynamicObject)photoCache.get(NumberUtils.toLong((String)photoMap.get("photo1").toString()));
            DynamicObject photoData2 = (DynamicObject)photoCache.get(NumberUtils.toLong((String)photoMap.get("photo2").toString()));
            Map allFieldMap = EntityMetadataCache.getDataEntityType((String)FASTPHOTO_ENTITY).getAllFields();
            Set allFieldSet = allFieldMap.entrySet();
            HashMap<String, Set> entryMap = new HashMap<String, Set>(16);
            for (Map.Entry entry : allFieldSet) {
                String fieldNum = (String)entry.getKey();
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entry.getValue();
                IDataEntityType dataEntityType = dataEntityProperty.getParent();
                String pFieldNum = dataEntityType.getName();
                if ((pFieldNum == null || pFieldNum.equals(FASTPHOTO_ENTITY)) && !fieldNum.equals(FASTPHOTO_ENTITY)) {
                    this.setCellFiledColor(fieldNum, photoData1, photoData2, 0, FASTPHOTO_ENTITY, "0");
                    continue;
                }
                if (FASTPHOTO_ENTITY.equals(pFieldNum)) continue;
                if (entryMap.containsKey(pFieldNum)) {
                    Set set = (Set)entryMap.get(pFieldNum);
                    set.add(fieldNum);
                    entryMap.put(pFieldNum, set);
                    continue;
                }
                HashSet<String> set2 = new HashSet<String>(16);
                set2.add(fieldNum);
                entryMap.put(pFieldNum, set2);
            }
            if (!entryMap.isEmpty()) {
                for (Map.Entry mentry : entryMap.entrySet()) {
                    String key = (String)mentry.getKey();
                    Set value = (Set)mentry.getValue();
                    DynamicObjectCollection photoEntry1 = photoData1.getDynamicObjectCollection(key);
                    DynamicObjectCollection photoEntry2 = photoData2.getDynamicObjectCollection(key);
                    if (photoEntry1 == null || photoEntry1.isEmpty()) continue;
                    this.setEntryColor(photoEntry1, photoEntry2, value, key);
                }
            }
        }
    }

    private void setEntryColor(DynamicObjectCollection photoEntry1, DynamicObjectCollection photoEntry2, Set<String> value, String key) {
        ArrayList<Integer> unmatch = new ArrayList<Integer>();
        for (int i = 0; i < photoEntry1.size(); ++i) {
            DynamicObject row1 = (DynamicObject)photoEntry1.get(i);
            String exitflag = "0";
            for (DynamicObject row2 : photoEntry2) {
                if (!row1.get(CARD_ENTRYID).equals(row2.get(CARD_ENTRYID))) continue;
                exitflag = "1";
                for (String field : value) {
                    this.setCellFiledColor(field, row1, row2, i, key, "1");
                }
            }
            if (!"0".equals(exitflag)) continue;
            unmatch.add(i);
        }
        if (!unmatch.isEmpty()) {
            int[] array = unmatch.stream().mapToInt(x -> x).toArray();
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            ClientActions.createRowStyleBuilder().setRows(array).setBackColor("#FFFF00").buildStyle().build().invokeControlMethod(proxy, key);
        }
    }

    private void setDataStyleInfo(String field, int row, String entryNum, String type) {
        if ("1".equals(type)) {
            this.setEntryStyleInfo(field, row, entryNum);
        } else {
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("bc", "#FFFF00");
            this.getView().updateControlMetadata(field, params);
        }
    }

    private void setEntryStyleInfo(String field, int row, String entryNum) {
        ArrayList<CellStyle> style = new ArrayList<CellStyle>();
        CellStyle c1 = new CellStyle();
        c1.setBackColor("#FFFF00");
        c1.setFieldKey(field);
        c1.setRow(row);
        style.add(c1);
        EntryGrid entryGrid1 = (EntryGrid)this.getControl(entryNum);
        entryGrid1.setCellStyle(style);
    }

    private boolean compareDynamicObject(DynamicObject data1, DynamicObject data2) {
        boolean flag = false;
        if (data1 == null && data2 != null || data1 != null && data2 == null) {
            flag = true;
        } else if (data1 != null && data2 != null && !data1.getPkValue().equals(data2.getPkValue())) {
            flag = true;
        }
        return flag;
    }

    private void setCellFiledColor(String fieldNum, DynamicObject photoData1, DynamicObject photoData2, int row, String entryNum, String type) {
        Object object = photoData1.get(fieldNum);
        if (object instanceof DynamicObject) {
            DynamicObject data1 = (DynamicObject)object;
            DynamicObject data2 = (DynamicObject)photoData2.get(fieldNum);
            if (this.compareDynamicObject(data1, data2)) {
                this.setDataStyleInfo(fieldNum, row, entryNum, type);
            }
        } else if (object instanceof OrmLocaleValue) {
            String ormlocale2;
            String ormlocale1 = ((OrmLocaleValue)object).getLocaleValue();
            if (StringUtils.equals((CharSequence)ormlocale1, (CharSequence)(ormlocale2 = ((OrmLocaleValue)photoData2.get(fieldNum)).getLocaleValue()))) {
                this.setDataStyleInfo(fieldNum, row, entryNum, type);
            }
        } else {
            Object object2 = photoData2.get(fieldNum);
            if (!Objects.equal((Object)object, (Object)object2)) {
                this.setDataStyleInfo(fieldNum, row, entryNum, type);
            }
        }
    }
}

