/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.QueryMaterialUnit;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RepairPlanCardEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ENTRY_MATERIAL = "material";
    private static final String ENTRY_UNIT = "enrtyunit";
    private static final String ENTRY_QTY = "entryqty";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit enrtyunit = (BasedataEdit)this.getControl(ENTRY_UNIT);
        if (null != enrtyunit) {
            enrtyunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (ENTRY_MATERIAL.equals(proName)) {
            this.materialChanged(changeSet);
        } else if (ENTRY_UNIT.equals(proName) || ENTRY_QTY.equals(proName)) {
            this.setEntryBaseqty(changeSet);
        }
    }

    private void materialChanged(ChangeData[] changeSet) {
        if (changeSet == null) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        if (null != newValue) {
            int rowIndex = changeSet[0].getRowIndex();
            Object baseunit = ((DynamicObject)newValue).get("baseunit");
            this.getModel().setValue(ENTRY_UNIT, baseunit, rowIndex);
        }
    }

    private void setEntryBaseqty(ChangeData[] changeSet) {
        IDataModel model = this.getModel();
        if (changeSet == null) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject unit = (DynamicObject)model.getValue(ENTRY_UNIT, rowIndex);
        BigDecimal entryQty = (BigDecimal)model.getValue(ENTRY_QTY, rowIndex);
        if (null != unit && null != entryQty) {
            this.setBaseQty(rowIndex);
        }
    }

    public void setBaseQty(int rowIndex) {
        BigDecimal bigDecimal = new BigDecimal(0);
        IDataModel model = this.getModel();
        DynamicObject entrymaterial = (DynamicObject)model.getValue(ENTRY_MATERIAL, rowIndex);
        if (entrymaterial == null) {
            return;
        }
        BigDecimal entryQty = (BigDecimal)model.getValue(ENTRY_QTY);
        DynamicObject basicUnit = entrymaterial.getDynamicObject("baseunit");
        DynamicObject entryunit = (DynamicObject)model.getValue(ENTRY_UNIT);
        long entryUnitId = 0L;
        if (entryunit != null) {
            entryUnitId = entryunit.getLong("id");
        }
        BigDecimal basicRate = BigDecimal.ZERO;
        BigDecimal souceRate = BigDecimal.ZERO;
        long matId = entrymaterial.getLong("id");
        QFilter matFilter = new QFilter("materialid", "=", (Object)matId);
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (QFilter[])new QFilter[]{matFilter});
        Set set = unitMap.entrySet();
        for (Map.Entry entry : set) {
            DynamicObject mulUnit = (DynamicObject)entry.getValue();
            DynamicObject unit = mulUnit.getDynamicObject("measureunitid");
            long unitId = unit.getLong("id");
            BigDecimal numerator = mulUnit.getBigDecimal("numerator");
            BigDecimal denominator = mulUnit.getBigDecimal("denominator");
            if (entryUnitId == 0L || entryUnitId != unitId) continue;
            basicRate = numerator;
            souceRate = denominator;
        }
        RoundingMode roundModel = RoundingMode.HALF_UP;
        String precisionaccount = basicUnit.getString("precisionaccount");
        BigDecimal precision = basicUnit.getBigDecimal("precision");
        if ("1".equals(precisionaccount)) {
            roundModel = RoundingMode.HALF_UP;
        } else if ("2".equals(precisionaccount)) {
            roundModel = RoundingMode.DOWN;
        } else if ("3".equals(precisionaccount)) {
            roundModel = RoundingMode.UP;
        }
        if (entryunit != null && basicUnit != null && basicUnit.getLong("id") == entryunit.getLong("id")) {
            model.setValue("entrybaseqty", (Object)entryQty.setScale(precision.intValue(), roundModel), rowIndex);
        } else if (souceRate.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal retbasicQty = entryQty.multiply(basicRate).divide(souceRate, precision.intValue(), roundModel);
            model.setValue("entrybaseqty", (Object)retbasicQty, rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (ENTRY_UNIT.equals(filedKey)) {
            QFilter qFilter = this.getUnitQFilter();
            qFilters.add(qFilter);
        }
    }

    public QFilter getUnitQFilter() {
        List unitList;
        QFilter resultQFilter = null;
        Object materialInfo = this.getModel().getValue(ENTRY_MATERIAL);
        Object pkValue = null;
        if (materialInfo instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)materialInfo;
            pkValue = material.getPkValue();
        }
        resultQFilter = (unitList = QueryMaterialUnit.getMaterialMultiUnit(pkValue)).size() == 0 ? new QFilter("id", "in", (Object)0L) : new QFilter("id", "in", (Object)unitList);
        return resultQFilter;
    }
}

