/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import org.apache.commons.lang.math.NumberUtils;

public class SelectCardPhotoMain {
    private static final Log logger = LogFactory.getLog(SelectCardPhotoMain.class);

    public static void showPageLotMainfileList(IFormPlugin form, IFormView view, Object cardid, String selectEntityNum) {
        QFilter filter = new QFilter("cardid", "=", (Object)NumberUtils.toLong((String)cardid.toString()));
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("formId", selectEntityNum);
        paramMap.put("filter", filter.toSerializedString());
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(paramMap);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(form, selectEntityNum));
        view.showForm(showParameter);
    }

    public static String getMaxCardVersion(QFilter filter, String entityNum) {
        String maxV = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMaxCardVersion", (String)entityNum, (String)"max(photoversion) as photoversion", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                maxV = row.getString("photoversion");
            }
        }
        return maxV;
    }

    public static Map<Long, String> getCardVersion(QFilter filter, String entityNum) {
        HashMap<Long, String> cardVersion = new HashMap<Long, String>(8);
        String maxV = "";
        Long pid = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryCardVersion", (String)entityNum, (String)"photoversion,id", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String version = row.getString("photoversion");
                if (StringUtils.isBlank((CharSequence)maxV)) {
                    maxV = version;
                    pid = row.getLong("id");
                    continue;
                }
                if (maxV.compareTo(version) > 0) continue;
                maxV = version;
                pid = row.getLong("id");
            }
        }
        cardVersion.put(pid, maxV);
        return cardVersion;
    }

    public static String createToolGroupVersion(String lastVersion) {
        String lastDate;
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String now = df.format(cal.getTime());
        DecimalFormat g1 = new DecimalFormat("00000");
        int startindex = 0;
        if (StringUtils.isNotBlank((CharSequence)lastVersion) && lastVersion.length() > 4 && StringUtils.equals((CharSequence)(lastDate = lastVersion.substring(0, 8)), (CharSequence)now)) {
            String versionStr = lastVersion.substring(8);
            startindex = Integer.parseInt(versionStr);
        }
        String startZeroStr = now + g1.format((long)startindex + 1L);
        return startZeroStr;
    }

    public static List<Long> getAllCardVersion(QFilter filter, String entityNum) {
        ArrayList<Long> cardVersion = new ArrayList<Long>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAllCardVersion", (String)entityNum, (String)"photoversion,id", (QFilter[])new QFilter[]{filter}, (String)"photoversion");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                cardVersion.add(row.getLong("id"));
            }
        }
        return cardVersion;
    }

    public static BillShowParameter createBillShowParam(String entityNum, Long pkid, ShowType type) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNum);
        showParameter.setPkId((Object)pkid);
        showParameter.getOpenStyle().setShowType(type);
        showParameter.setStatus(OperationStatus.VIEW);
        return showParameter;
    }

    public static String getPhotoVersion(Object cardid, String entityNum) {
        Date starttime = SelectCardPhotoMain.getCurrentDate();
        Date endtime = SelectCardPhotoMain.getDayEndTime(starttime);
        Calendar cal = Calendar.getInstance();
        QFilter filter = new QFilter("cardid", "=", cardid);
        filter.and(new QFilter("moddate", ">=", (Object)starttime));
        filter.and(new QFilter("moddate", "<", (Object)endtime));
        String maxVersion = SelectCardPhotoMain.getMaxCardVersion(filter, entityNum);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String format = df.format(cal.getTime());
        int startindex = 0;
        DecimalFormat g1 = new DecimalFormat("00000");
        if (StringUtils.isNotBlank((CharSequence)maxVersion) && maxVersion.indexOf(format) >= 0) {
            String updateid2 = maxVersion.substring(8, maxVersion.length());
            startindex = Integer.parseInt(updateid2);
        }
        String startZeroStr = format + g1.format((long)startindex + 1L);
        return startZeroStr;
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        Date time = calendar.getTime();
        return time;
    }

    public static Date getDayEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Set<String> getDataDiffField(IDataModel model) {
        HashSet<String> diffField = new HashSet<String>();
        String entityNum = model.getDataEntityType().getName();
        Object pkValue = model.getDataEntity().getPkValue();
        DynamicObject photoData2 = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entityNum);
        DynamicObject photoData1 = model.getDataEntity();
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields();
        Set allFieldSet = allFieldMap.entrySet();
        HashMap<String, Set<String>> entryMap = new HashMap<String, Set<String>>(16);
        for (Map.Entry entry : allFieldSet) {
            String fieldNum = (String)entry.getKey();
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entry.getValue();
            IDataEntityType dataEntityType = dataEntityProperty.getParent();
            String pFieldNum = dataEntityType.getName();
            if ((pFieldNum == null || pFieldNum.equals(entityNum)) && !fieldNum.equals(entityNum)) {
                boolean diffCellField = SelectCardPhotoMain.compareDiffCellField(fieldNum, photoData1, photoData2);
                if (!diffCellField) continue;
                logger.debug("diffField----" + fieldNum);
                diffField.add(fieldNum);
                continue;
            }
            if (entityNum.equals(pFieldNum)) continue;
            Set set = (Set)entryMap.get(pFieldNum);
            if (set != null) {
                set.add(fieldNum);
                entryMap.put(pFieldNum, set);
                continue;
            }
            HashSet<String> set2 = new HashSet<String>(16);
            set2.add(fieldNum);
            entryMap.put(pFieldNum, set2);
        }
        if (!entryMap.isEmpty()) {
            for (Map.Entry mentry : entryMap.entrySet()) {
                boolean compareSubEntry;
                String key = (String)mentry.getKey();
                Set value = (Set)mentry.getValue();
                if ("subentryentity".equals(key) || "actentryentity".equals(key) || "processentry1".equals(key)) continue;
                DynamicObjectCollection photoEntry1 = model.getEntryEntity(key);
                DynamicObjectCollection photoEntry2 = photoData2.getDynamicObjectCollection(key);
                if (photoEntry1 == null || photoEntry1.isEmpty()) continue;
                boolean flag = SelectCardPhotoMain.compareEntry(photoEntry1, photoEntry2, value, key);
                if (flag) {
                    diffField.add(key);
                    logger.debug("diffField----" + key);
                }
                if (!"processentry".equals(key) || !(compareSubEntry = SelectCardPhotoMain.compareSubEntry(photoEntry1, photoEntry2, key, entryMap))) continue;
                diffField.add(key);
            }
        }
        return diffField;
    }

    public static boolean compareDiffCellField(String fieldNum, DynamicObject photoData1, DynamicObject photoData2) {
        Object object2;
        Object object;
        boolean flag = false;
        if ("useorg".equals(fieldNum)) {
            return flag;
        }
        if ("largemajordesc".equals(fieldNum)) {
            Object object22 = photoData2.get("largemajordesc_tag");
            Object object11 = photoData1.get("largemajordesc_tag");
            if (!Objects.equal((Object)object11, (Object)object22)) {
                return true;
            }
        }
        if ((object = photoData1.get(fieldNum)) instanceof DynamicObject) {
            DynamicObject data1 = (DynamicObject)object;
            DynamicObject data2 = (DynamicObject)photoData2.get(fieldNum);
            if (SelectCardPhotoMain.compareDynamicObject(data1, data2)) {
                flag = true;
            }
        } else if (object instanceof OrmLocaleValue) {
            String ormlocale1 = ((OrmLocaleValue)object).getLocaleValue();
            String ormlocale2 = ((OrmLocaleValue)photoData2.get(fieldNum)).getLocaleValue();
            if (ormlocale1 != null && !ormlocale1.equals(ormlocale2)) {
                flag = true;
            }
        } else if (object instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection sourceColl = (MulBasedataDynamicObjectCollection)object;
            MulBasedataDynamicObjectCollection object23 = (MulBasedataDynamicObjectCollection)photoData2.get(fieldNum);
            if (sourceColl.isEmpty() && !object23.isEmpty() || !sourceColl.isEmpty() && object23.isEmpty()) {
                flag = true;
            } else if (!sourceColl.isEmpty() && !object23.isEmpty()) {
                flag = SelectCardPhotoMain.compareMulBasedataDynamicObject(sourceColl, object23);
            }
        } else if (object instanceof Date) {
            long time2;
            long time;
            object2 = (Date)photoData2.get(fieldNum);
            Date object1 = (Date)object;
            if (object2 != null && (time = object1.getTime()) != (time2 = ((Date)object2).getTime())) {
                flag = true;
            }
        } else if (object instanceof BigDecimal) {
            BigDecimal object1 = (BigDecimal)object;
            object2 = (BigDecimal)photoData2.get(fieldNum);
            if (object1.compareTo((BigDecimal)object2) != 0) {
                flag = true;
            }
        } else {
            object2 = photoData2.get(fieldNum);
            if (!Objects.equal((Object)object, (Object)object2)) {
                flag = true;
            }
        }
        return flag;
    }

    public static boolean compareMulBasedataDynamicObject(MulBasedataDynamicObjectCollection sourceColl, MulBasedataDynamicObjectCollection object2) {
        boolean flag = false;
        if (sourceColl.size() != object2.size()) {
            flag = true;
        } else if (sourceColl.size() == 0) {
            flag = false;
        } else {
            HashSet<Object> baseDataObjectList = new HashSet<Object>(sourceColl.size());
            for (int i = 0; i < sourceColl.size(); ++i) {
                DynamicObject dy = (DynamicObject)sourceColl.get(i);
                if (dy == null || dy.getDynamicObject("fbasedataid") == null) continue;
                baseDataObjectList.add(dy.getDynamicObject("fbasedataid").getPkValue());
            }
            for (DynamicObject o2 : object2) {
                DynamicObject dyo2 = o2.getDynamicObject("fbasedataid");
                if (dyo2 == null || baseDataObjectList.contains(dyo2.getPkValue())) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean compareDynamicObject(DynamicObject data1, DynamicObject data2) {
        boolean flag = false;
        if (data1 == null && data2 != null || data1 != null && data2 == null) {
            flag = true;
        } else if (data1 != null && data2 != null && !data1.getPkValue().equals(data2.getPkValue())) {
            flag = true;
        }
        return flag;
    }

    public static boolean compareEntry(DynamicObjectCollection photoEntry1, DynamicObjectCollection photoEntry2, Set<String> value, String key) {
        boolean flag = false;
        ArrayList<Integer> unmatch = new ArrayList<Integer>(10);
        for (int i = 0; i < photoEntry1.size(); ++i) {
            DynamicObject row1 = (DynamicObject)photoEntry1.get(i);
            String exitflag = "0";
            for (DynamicObject row2 : photoEntry2) {
                if (!row1.getPkValue().equals(row2.getPkValue())) continue;
                exitflag = "1";
                for (String field : value) {
                    if ("vid".equals(field) || "relation".equals(field) || !(flag = SelectCardPhotoMain.compareDiffCellField(field, row1, row2))) continue;
                    return flag;
                }
            }
            if (!"0".equals(exitflag)) continue;
            unmatch.add(i);
        }
        if (!unmatch.isEmpty()) {
            flag = true;
        }
        return flag;
    }

    public static boolean compareSubEntry(DynamicObjectCollection photoEntry1, DynamicObjectCollection photoEntry2, String key, Map<String, Set<String>> entryMap) {
        boolean flag = false;
        block0: for (int i = 0; i < photoEntry1.size(); ++i) {
            DynamicObject sub1 = (DynamicObject)photoEntry1.get(i);
            DynamicObjectCollection subentryentity = sub1.getDynamicObjectCollection("subentryentity");
            DynamicObjectCollection actentryentity = sub1.getDynamicObjectCollection("actentryentity");
            if (subentryentity == null || subentryentity.isEmpty()) continue;
            for (DynamicObject sub2 : photoEntry2) {
                if (!sub2.getPkValue().equals(sub1.getPkValue())) continue;
                DynamicObjectCollection subentryentity2 = sub2.getDynamicObjectCollection("subentryentity");
                boolean compareEntry = SelectCardPhotoMain.compareEntry(subentryentity, subentryentity2, entryMap.get("subentryentity"), "subentryentity");
                DynamicObjectCollection actentryentity2 = sub2.getDynamicObjectCollection("actentryentity");
                boolean compareEntry2 = SelectCardPhotoMain.compareEntry(actentryentity, actentryentity2, entryMap.get("actentryentity"), "actentryentity");
                if (!compareEntry && !compareEntry2) continue block0;
                return true;
            }
        }
        return flag;
    }

    public static boolean isSameCardToolVersion(DynamicObjectCollection cardToolDemands) {
        if (null != cardToolDemands) {
            HashSet<Long> idSet = new HashSet<Long>(16);
            for (DynamicObject cardTool : cardToolDemands) {
                long pkValue = cardTool.getLong("id");
                idSet.add(pkValue);
            }
            Map mpdm_cardtooldemand = BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (String)"mpdm_cardtooldemand");
            Collection values = mpdm_cardtooldemand.values();
            if (null != values) {
                for (DynamicObject cardTool : values) {
                    DynamicObjectCollection entryentity = cardTool.getDynamicObjectCollection("entryentity");
                    if (null == entryentity) continue;
                    for (DynamicObject entry : entryentity) {
                        String entryGversion;
                        String groupversion;
                        DynamicObject toolsubgroup = entry.getDynamicObject("toolsubgroup");
                        if (null == toolsubgroup || StringUtils.equals((CharSequence)(groupversion = toolsubgroup.getString("groupversion")), (CharSequence)(entryGversion = entry.getString("groupversion")))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static void createToCardToolDemand(String stockname, DynamicObjectCollection loads, IFormView view) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber("mpdm_ctoolchange");
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1495546577241014272");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSourceEntityNumber("mpdm_cardtooldemand");
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        HashSet<Long> loadIds = new HashSet<Long>(16);
        for (DynamicObject m : loads) {
            long loadId = m.getLong("id");
            if (!loadIds.add(loadId)) continue;
            ListSelectedRow srcBill = new ListSelectedRow((Object)m.getLong("id"));
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (result.isSuccess() && !result.getCachePageIds().isEmpty()) {
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)stockname);
            List targetBillObjs = result.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            if (targetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)result, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)view, (PushArgs)pushArgs, (ConvertOperationResult)result, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)result);
        }
    }
}

