/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.formplugin.workcardinfo.SelectCardPhotoMain;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;

public class SelectCardPhotoPlugin
extends AbstractFormPlugin
implements SetFilterListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String CONFIRM = "btnok";
    private static final String ANALYSIS = "analysis";
    private static Map<String, String> selectPhotoMap = new HashMap<String, String>(16);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM});
        this.addClickListeners(new String[]{ANALYSIS});
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addSetFilterListener((SetFilterListener)this);
    }

    public void setFilter(SetFilterEvent paramSetFilterEvent) {
        QFilter filter = this.getQFilter();
        if (filter != null) {
            paramSetFilterEvent.setCustomQFilters(Collections.singletonList(filter));
        }
    }

    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        QFilter filter = this.getQFilter();
        if (filter != null) {
            billList.getFilterParameter().setFilter(filter);
        }
    }

    private QFilter getQFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object filterObj = customParams.get("filter");
        if (filterObj != null) {
            QFilter filter = QFilter.fromSerializedString((String)((String)filterObj));
            return filter;
        }
        return null;
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control c = (Control)e.getSource();
        switch (key = c.getKey()) {
            case "btnok": 
            case "analysis": {
                this.returnSelectedResult(key);
                break;
            }
        }
    }

    private void returnSelectedResult(String key) {
        String entityId = this.getView().getEntityId();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5206\u5f55", (String)"SelectCardPhotoPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (ANALYSIS.equals(key) && selectedRows.size() != 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u6790\u5fc5\u987b\u4e14\u53ea\u80fd\u9009\u62e9\u4e24\u6761\u6570\u636e\u8fdb\u884c\u5dee\u5f02\u5206\u6790\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SelectCardPhotoPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        if (CONFIRM.equals(key) && selectedRows.size() != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u786e\u8ba4\u67e5\u770b\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SelectCardPhotoPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> photoAttr = new HashMap<String, Object>(4);
        HashSet<Object> photoid = new HashSet<Object>(8);
        photoAttr.put("operatekey", key);
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Object object = listSelectedRow.getPrimaryKeyValue();
            photoid.add(object);
        }
        Long maxPhotoid = 0L;
        if (photoid.size() > 1) {
            QFilter filter = new QFilter("id", "in", photoid);
            Map<Long, String> map = SelectCardPhotoMain.getCardVersion(filter, selectPhotoMap.get(entityId));
            for (Object e : photoid) {
                if (!map.containsKey(e)) {
                    photoAttr.put("cphotoid", e);
                    continue;
                }
                maxPhotoid = e;
            }
        } else {
            for (Object e : photoid) {
                maxPhotoid = e;
            }
        }
        photoAttr.put("maxphotoid", maxPhotoid);
        this.getView().returnDataToParent(photoAttr);
        this.getView().close();
    }

    static {
        selectPhotoMap.put("mpdm_photoselect", "mpdm_mrocardroute_h");
        selectPhotoMap.put("mpdm_mentaincardselect", "mpdm_maintenanceplan_h");
    }
}

