/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.QueryMaterialUnit;
import kd.bd.mpdm.formplugin.workcardinfo.SelectCardPhotoMain;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ToolSubGroupEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener,
ClickListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String OPR_NEWENTRY = "newentry";
    private static final String OPR_INSERTENTRY = "insertentry";
    private static final String MRTYPE = "mrtype";

    public void afterBindData(EventObject e) {
        String modifycg = this.getPageCache().get("modifycg");
        if (StringUtils.equals((CharSequence)modifycg, (CharSequence)"1")) {
            this.getModel().setValue("status", (Object)"A");
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete", "baritemap", "bar_submit"});
        }
        String status = (String)this.getModel().getValue("status");
        if (StringUtils.equals((CharSequence)modifycg, (CharSequence)"0") && StringUtils.equals((CharSequence)"A", (CharSequence)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_delete", "baritemap", "bar_submit"});
        }
        super.afterBindData(e);
        long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == 0L) {
            this.getModel().setValue("groupversion", (Object)SelectCardPhotoMain.createToolGroupVersion(null));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("material".equals(proName)) {
            this.materialChanged(changeSet);
        } else if ("unit".equals(proName) || "qty".equals(proName)) {
            this.setEntryBaseqty(changeSet);
        }
    }

    private void setEntryBaseqty(ChangeData[] changeSet) {
        IDataModel model = this.getModel();
        if (changeSet == null) {
            return;
        }
        ChangeData changeData = changeSet[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
        BigDecimal entryQty = (BigDecimal)model.getValue("qty", rowIndex);
        if (null != unit && null != entryQty) {
            this.setBaseQty(rowIndex);
        }
    }

    private void materialChanged(ChangeData[] changeSet) {
        if (changeSet == null) {
            return;
        }
        Object newValue = changeSet[0].getNewValue();
        if (null != newValue) {
            int rowIndex = changeSet[0].getRowIndex();
            Object baseunit = ((DynamicObject)newValue).get("baseunit");
            this.getModel().setValue("unit", baseunit, rowIndex);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        UnitEdit unit = (UnitEdit)this.getView().getControl("unit");
        if (unit != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        switch (operateKey) {
            case "modifytool": {
                this.getModel().setValue("status", (Object)"A");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_delete", "baritemap", "bar_submit"});
                this.getView().invokeOperation("refresh");
                this.getPageCache().put("modifycg", "1");
                break;
            }
            case "save": {
                if (!args.getOperationResult().isSuccess()) break;
                String modifycg = this.getPageCache().get("modifycg");
                if (StringUtils.equals((CharSequence)modifycg, (CharSequence)"1")) {
                    String modifyFlag = this.getPageCache().get("modifyFlag");
                    this.getModel().setValue("status", (Object)"C");
                    DynamicObject newdataEntity = this.getModel().getDataEntity();
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newdataEntity});
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)modifyFlag)) {
                        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("modifyCardTool", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u540c\u6b65\u751f\u6210\u53d8\u66f4\u5355\uff0c\u66f4\u65b0\u5de5\u5361\u5de5\u5177\u9700\u6c42\uff1f", (String)"ToolSubGroupEditPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                    }
                }
                this.getPageCache().put("modifycg", "0");
                this.getView().invokeOperation("refresh");
                break;
            }
            case "updatectd": {
                this.queryCardToolDemandsPush(pkValue);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)"modifyCardTool", (CharSequence)callBackId)) {
            if (null != result && result == MessageBoxResult.Yes) {
                long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
                this.queryCardToolDemandsPush(pkValue);
            }
            this.getPageCache().put("modifycg", "0");
            this.getPageCache().put("modifyFlag", "0");
        }
    }

    public void queryCardToolDemandsPush(long pkValue) {
        QFilter cardToolDataFilter = new QFilter("status", "=", (Object)"C");
        cardToolDataFilter.and(new QFilter("enable", "=", (Object)"1"));
        cardToolDataFilter.and(new QFilter("entryentity.toolsubgroup", "=", (Object)pkValue));
        DynamicObjectCollection cardToolDemands = QueryServiceHelper.query((String)"mpdm_cardtooldemand", (String)"id", (QFilter[])cardToolDataFilter.toArray());
        if (null != cardToolDemands && cardToolDemands.size() > 0) {
            if (!SelectCardPhotoMain.isSameCardToolVersion(cardToolDemands)) {
                SelectCardPhotoMain.createToCardToolDemand("mpdm_ctoolchange", cardToolDemands, this.getView());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f15\u7528\u8be5\u5de5\u5177\u66ff\u4ee3\u7ec4\u7248\u672c\u4e0d\u4e00\u81f4\u7684\u5de5\u5361\u5de5\u5177\u9700\u6c42\u3002", (String)"ToolSubGroupEditPlugin_2", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f15\u7528\u8be5\u5de5\u5177\u66ff\u4ee3\u7ec4\u7684\u5de5\u5361\u5de5\u5177\u9700\u6c42\u3002", (String)"ToolSubGroupEditPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject mpdm_toolsubgroup;
        long pkValue;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("modifytool".equals(operateKey)) {
            DynamicObject createorg;
            long createorgid;
            long useorgid;
            DynamicObject useorg;
            String enable = (String)this.getModel().getValue("enable");
            if (!"1".equals(enable)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ToolSubGroupEditPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((useorg = (DynamicObject)this.getModel().getValue("useorg")) != null && (useorgid = ((Long)useorg.getPkValue()).longValue()) != (createorgid = ((Long)(createorg = (DynamicObject)this.getModel().getValue("createorg")).getPkValue()).longValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u57fa\u7840\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7,\u4fee\u6539\u5931\u8d25\u3002", (String)"ToolSubGroupEditPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        String modifycg = this.getPageCache().get("modifycg");
        if ("save".equals(operateKey) && (pkValue = ((Long)this.getModel().getDataEntity().getPkValue()).longValue()) != 0L && null != (mpdm_toolsubgroup = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"mpdm_toolsubgroup"))) {
            boolean modifyFlag = this.isModifyData(mpdm_toolsubgroup.getDynamicObjectCollection(ENTRY_ENTITY), this.getModel().getEntryEntity(ENTRY_ENTITY));
            if (modifyFlag) {
                this.getModel().setValue("groupversion", (Object)SelectCardPhotoMain.createToolGroupVersion(this.getModel().getValue("groupversion").toString()));
                if (StringUtils.equals((CharSequence)"1", (CharSequence)modifycg)) {
                    this.getPageCache().put("modifyFlag", "1");
                }
            } else {
                this.getPageCache().put("modifyFlag", "0");
            }
        }
    }

    public boolean isModifyData(DynamicObjectCollection oldEntryentity, DynamicObjectCollection newEntryentity) {
        if (null == oldEntryentity || null == newEntryentity) {
            return true;
        }
        if (oldEntryentity.size() != newEntryentity.size()) {
            return true;
        }
        for (DynamicObject newEntry : newEntryentity) {
            Object pkValue = newEntry.getPkValue();
            if (null == pkValue) {
                return true;
            }
            long materialId = (Long)newEntry.getDynamicObject("material").getPkValue();
            long unitId = (Long)newEntry.getDynamicObject("unit").getPkValue();
            int qty = newEntry.getInt("qty");
            String entryownertype = newEntry.getString("entryownertype");
            DynamicObject entryowner = newEntry.getDynamicObject("entryowner");
            DynamicObjectCollection entrymaterialtype = newEntry.getDynamicObjectCollection("entrymaterialtype");
            for (int i = 0; i < oldEntryentity.size(); ++i) {
                long newEntryId;
                DynamicObject oldEntry = (DynamicObject)oldEntryentity.get(i);
                long oldEntryId = (Long)oldEntry.getPkValue();
                if (oldEntryId == (newEntryId = ((Long)pkValue).longValue())) {
                    long entryownerPk;
                    long entryownerPk1;
                    long oldMaterial = (Long)oldEntry.getDynamicObject("material").getPkValue();
                    int oldQty = oldEntry.getInt("qty");
                    long oldUnitId = (Long)oldEntry.getDynamicObject("unit").getPkValue();
                    String entryownertype1 = oldEntry.getString("entryownertype");
                    if (materialId != oldMaterial || oldQty != qty || oldUnitId != unitId || !StringUtils.equals((CharSequence)entryownertype, (CharSequence)entryownertype1)) {
                        return true;
                    }
                    DynamicObject entryowner1 = oldEntry.getDynamicObject("entryowner");
                    DynamicObjectCollection entrymaterialtype1 = oldEntry.getDynamicObjectCollection("entrymaterialtype");
                    if (null == entryowner && null != entryowner1 || null != entryowner && null == entryowner1 || null == entrymaterialtype && null != entrymaterialtype1 || null != entrymaterialtype && null == entrymaterialtype1) {
                        return true;
                    }
                    if (null != entryowner1 && null != entryowner && (entryownerPk1 = ((Long)entryowner1.getPkValue()).longValue()) == (entryownerPk = ((Long)entryowner.getPkValue()).longValue())) {
                        return true;
                    }
                    if (null == entrymaterialtype || null == entrymaterialtype1) continue;
                    HashSet<Long> entrymaterialtypeIdSet = new HashSet<Long>(16);
                    for (DynamicObject dynamicObject : entrymaterialtype) {
                        long pkValue1 = (Long)dynamicObject.getPkValue();
                        entrymaterialtypeIdSet.add(pkValue1);
                    }
                    HashSet<Long> entrymaterialtype1IdSet = new HashSet<Long>(16);
                    for (DynamicObject dynamicObject : entrymaterialtype1) {
                        long pkValue1 = (Long)dynamicObject.getPkValue();
                        entrymaterialtype1IdSet.add(pkValue1);
                    }
                    if (entrymaterialtypeIdSet.size() == entrymaterialtype1IdSet.size() && entrymaterialtypeIdSet.containsAll(entrymaterialtype1IdSet)) continue;
                    return true;
                }
                if (newEntryId != 0L) continue;
                return true;
            }
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if ("unit".equals(filedKey)) {
            QFilter qFilter = this.getUnitQFilter();
            qFilters.add(qFilter);
        }
        if ("entryowner".equals(filedKey)) {
            this.getSupplyer(qFilters);
        }
    }

    private void getSupplyer(List<QFilter> qFilters) {
        QFilter filter;
        String ownerType = (String)this.getModel().getValue("entryownertype");
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        long id = 0L;
        if (null != createOrg) {
            id = createOrg.getLong("id");
        }
        if ("bd_supplier".equals(ownerType)) {
            filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)id);
            qFilters.add(filter);
        }
        if ("bd_customer".equals(ownerType)) {
            filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)id);
            qFilters.add(filter);
        }
    }

    public QFilter getUnitQFilter() {
        List unitList;
        QFilter resultQFilter = null;
        Object materialInfo = this.getModel().getValue("material");
        Object pkValue = null;
        if (materialInfo instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)materialInfo;
            pkValue = material.getPkValue();
        }
        resultQFilter = (unitList = QueryMaterialUnit.getMaterialMultiUnit(pkValue)).size() == 0 ? new QFilter("id", "in", (Object)0L) : new QFilter("id", "in", (Object)unitList);
        return resultQFilter;
    }

    public void setBaseQty(int rowIndex) {
        BigDecimal bigDecimal = new BigDecimal(0);
        IDataModel model = this.getModel();
        DynamicObject entrymaterial = (DynamicObject)model.getValue("material", rowIndex);
        if (entrymaterial == null) {
            return;
        }
        BigDecimal entryQty = (BigDecimal)model.getValue("qty");
        DynamicObject basicUnit = entrymaterial.getDynamicObject("baseunit");
        DynamicObject entryunit = (DynamicObject)model.getValue("unit");
        long entryUnitId = 0L;
        if (entryunit != null) {
            entryUnitId = entryunit.getLong("id");
        }
        BigDecimal basicRate = BigDecimal.ZERO;
        BigDecimal souceRate = BigDecimal.ZERO;
        long matId = entrymaterial.getLong("id");
        QFilter matFilter = new QFilter("materialid", "=", (Object)matId);
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (QFilter[])new QFilter[]{matFilter});
        Set set = unitMap.entrySet();
        for (Map.Entry entry : set) {
            DynamicObject mulUnit = (DynamicObject)entry.getValue();
            DynamicObject unit = mulUnit.getDynamicObject("measureunitid");
            long unitId = unit.getLong("id");
            BigDecimal numerator = mulUnit.getBigDecimal("numerator");
            BigDecimal denominator = mulUnit.getBigDecimal("denominator");
            if (entryUnitId == 0L || entryUnitId != unitId) continue;
            basicRate = numerator;
            souceRate = denominator;
        }
        RoundingMode roundModel = RoundingMode.HALF_UP;
        String precisionaccount = basicUnit.getString("precisionaccount");
        BigDecimal precision = basicUnit.getBigDecimal("precision");
        if ("1".equals(precisionaccount)) {
            roundModel = RoundingMode.HALF_UP;
        } else if ("2".equals(precisionaccount)) {
            roundModel = RoundingMode.DOWN;
        } else if ("3".equals(precisionaccount)) {
            roundModel = RoundingMode.UP;
        }
        if (entryunit != null && basicUnit != null && basicUnit.getLong("id") == entryunit.getLong("id")) {
            model.setValue("baseqty", (Object)entryQty.setScale(precision.intValue(), roundModel), rowIndex);
        } else if (souceRate.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal retbasicQty = entryQty.multiply(basicRate).divide(souceRate, precision.intValue(), roundModel);
            model.setValue("baseqty", (Object)retbasicQty, rowIndex);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }
}

