/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;

public class VersionGenerateRuleEditPlugin
extends AbstractFormPlugin {
    private static final String VERSON_SERIAL = "versionserial";
    private static final String SEPARATOR = "separator";
    private static final String RULE_ENTRY = "ruleentry";
    private static final String SERIAL_ENTRY = "serialentry";
    private static final String SERIAL_NUMBER = "serialumber";
    private static final String PREVIEW = "preview";
    private static final String OP_DELETEENTRY = "deleteentry";
    private static final String OP_BAR_DELETE = "bar_delete";
    private static final String TYPE_ENTRY = "type";
    private static final String CONTCHAR_ENTRY = "contchar";

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        String previewStr = "";
        IFormView view = this.getView();
        switch (propName) {
            case "versionserial": {
                previewStr = this.getPreView();
                model.setValue(PREVIEW, (Object)previewStr);
                break;
            }
            case "separator": {
                previewStr = this.getPreView();
                model.setValue(PREVIEW, (Object)previewStr);
                break;
            }
            case "type": {
                Object typeObj = changeSet[0].getNewValue();
                int rowIndex = changeSet[0].getRowIndex();
                if (typeObj != null && "A".equals(typeObj.toString())) {
                    model.setValue(VERSON_SERIAL, null, rowIndex);
                } else {
                    model.setValue(CONTCHAR_ENTRY, null, rowIndex);
                }
                this.initEntryEnable(rowIndex);
                previewStr = this.getPreView();
                model.setValue(PREVIEW, (Object)previewStr);
                break;
            }
            case "contchar": {
                previewStr = this.getPreView();
                model.setValue(PREVIEW, (Object)previewStr);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().beginInit();
        this.initEntryEnable(-1);
        this.getModel().endInit();
    }

    private void initEntryEnable(int updateRow) {
        IDataModel model = this.getModel();
        int entrySize = model.getEntryRowCount(RULE_ENTRY);
        IFormView view = this.getView();
        for (int i = 0; i < entrySize; ++i) {
            if (updateRow >= 0 && updateRow != i) continue;
            DynamicObject entry = model.getEntryRowEntity(RULE_ENTRY, i);
            String type = entry.getString(TYPE_ENTRY);
            if (type != null && "A".equals(type)) {
                view.setEnable(Boolean.FALSE, i, new String[]{VERSON_SERIAL});
                view.setEnable(Boolean.TRUE, i, new String[]{CONTCHAR_ENTRY});
                continue;
            }
            view.setEnable(Boolean.TRUE, i, new String[]{VERSON_SERIAL});
            view.setEnable(Boolean.FALSE, i, new String[]{CONTCHAR_ENTRY});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)OP_DELETEENTRY, (CharSequence)operateKey)) {
            String previewStr = this.getPreView();
            model.setValue(PREVIEW, (Object)previewStr);
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) && (operationResult = afterDoOperationEventArgs.getOperationResult()).isSuccess()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{OP_BAR_DELETE});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int updateRow = e.getInsertRow();
        this.initEntryEnable(updateRow);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            // empty if block
        }
    }

    public String getPreView() {
        IDataModel model = this.getModel();
        DynamicObjectCollection ruleEntryDOC = model.getEntryEntity(RULE_ENTRY);
        if (ruleEntryDOC == null || ruleEntryDOC.isEmpty()) {
            return "";
        }
        StringBuilder previewStr = new StringBuilder();
        for (int i = 0; i < ruleEntryDOC.size(); ++i) {
            DynamicObject ruleDO = (DynamicObject)ruleEntryDOC.get(i);
            String type = ruleDO.getString(TYPE_ENTRY);
            Object versionSerialObj = ruleDO.get(VERSON_SERIAL);
            String contChar = ruleDO.getString(CONTCHAR_ENTRY);
            if ("A".equals(type)) {
                previewStr.append(contChar == null ? "" : contChar);
            } else {
                DynamicObjectCollection serialEntryDOC = null;
                if (versionSerialObj instanceof DynamicObject) {
                    DynamicObject versionSerialDO = (DynamicObject)versionSerialObj;
                    serialEntryDOC = versionSerialDO.getDynamicObjectCollection(SERIAL_ENTRY);
                }
                if (serialEntryDOC != null && !serialEntryDOC.isEmpty()) {
                    DynamicObject serialEntryDO = (DynamicObject)serialEntryDOC.get(0);
                    String serialNumber = serialEntryDO.getString(SERIAL_NUMBER);
                    previewStr.append(serialNumber);
                }
            }
            if (i >= ruleEntryDOC.size() - 1) continue;
            String separatorStr = ruleDO.getString(SEPARATOR);
            previewStr.append(separatorStr);
        }
        String result = previewStr.toString();
        return result;
    }
}

