/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.common.utils.WorkcardDataInfoUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class WorkCardDataBizPlugin
extends AbstractBasePlugIn {
    public static final String OPENFROMWORKCARD = "openfromworkcard";
    public static final String CURSELTABKEY = "curseltabkey";
    public static final String CREATEORG = "createorg";
    public static final String ORG = "org";
    public static final String USERORG = "useorg";
    private static String worktypectrlpk = "0";
    private static Map<String, String> tabpageCardMap = new HashMap<String, String>(16);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        BaseShowParameter lsp = (BaseShowParameter)this.getView().getFormShowParameter();
        if (lsp == null) {
            return;
        }
        if (lsp.getCustomParam(OPENFROMWORKCARD) instanceof Boolean) {
            boolean openFromWorkCard = (Boolean)lsp.getCustomParam(OPENFROMWORKCARD);
            if (!openFromWorkCard) {
                return;
            }
            switch (operate.getOperateKey()) {
                case "unaudit": {
                    Object useOrgId = lsp.getCustomParam(USERORG);
                    this.getModel().beginInit();
                    this.getModel().setValue(USERORG, useOrgId);
                    this.getModel().endInit();
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String entityNumber = this.getModel().getDataEntityType().getName();
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        String cardName = tabpageCardMap.get(entityNumber);
        if (propertyName.endsWith(cardName)) {
            DynamicObject cardnumber;
            ChangeData cd = e.getChangeSet()[0];
            DynamicObject dynamicObject = cardnumber = null == cd.getNewValue() ? null : (DynamicObject)cd.getNewValue();
            if (null != cardnumber) {
                DynamicObject cardtype = cardnumber.getDynamicObject("cardtype");
                if (cardtype == null) {
                    return;
                }
                DynamicObject loadcardtype = BusinessDataServiceHelper.loadSingleFromCache((Object)cardtype.getPkValue(), (String)"mpdm_jobcardtype");
                if (loadcardtype != null) {
                    Object worktypectrlId = loadcardtype.getDynamicObject("worktypectrl").getPkValue();
                    WorkcardDataInfoUtils.showDataWithCardType((IDataModel)this.getModel(), (IFormView)this.getView(), (Object)worktypectrlId, (String)entityNumber);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BaseShowParameter lsp = (BaseShowParameter)this.getView().getFormShowParameter();
        if (lsp == null) {
            return;
        }
        if (lsp.getCustomParam(OPENFROMWORKCARD) instanceof Boolean) {
            boolean openFromWorkCard = (Boolean)lsp.getCustomParam(OPENFROMWORKCARD);
            if (!openFromWorkCard) {
                return;
            }
            this.setInitializeData(lsp);
        }
    }

    public void afterLoadData(EventObject e) {
        Object source = e.getSource();
        super.afterLoadData(e);
        BaseShowParameter lsp = (BaseShowParameter)this.getView().getFormShowParameter();
        if (lsp == null) {
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String entityNumber = this.getModel().getDataEntityType().getName();
        BaseShowParameter lsp = (BaseShowParameter)this.getView().getFormShowParameter();
        if (lsp == null) {
            return;
        }
        if (lsp.getCustomParam(OPENFROMWORKCARD) instanceof Boolean) {
            boolean openFromWorkCard = (Boolean)lsp.getCustomParam(OPENFROMWORKCARD);
            if (openFromWorkCard) {
                Object worktypectrlId = lsp.getCustomParam("worktypectrlId");
                entityNumber = (String)lsp.getCustomParam("entityNumber");
                WorkcardDataInfoUtils.showDataWithCardType((IDataModel)this.getModel(), (IFormView)this.getView(), (Object)worktypectrlId, (String)entityNumber);
            }
        } else if (tabpageCardMap.get(entityNumber) != null) {
            DynamicObject cardnumber = (DynamicObject)this.getModel().getValue(tabpageCardMap.get(entityNumber));
            if (cardnumber == null) {
                return;
            }
            DynamicObject cardtype = cardnumber.getDynamicObject("cardtype");
            if (cardtype == null) {
                return;
            }
            DynamicObject loadcardtype = BusinessDataServiceHelper.loadSingleFromCache((Object)cardtype.getPkValue(), (String)"mpdm_jobcardtype");
            if (loadcardtype != null) {
                Object worktypectrlId = loadcardtype.getDynamicObject("worktypectrl").getPkValue();
                WorkcardDataInfoUtils.showDataWithCardType((IDataModel)this.getModel(), (IFormView)this.getView(), (Object)worktypectrlId, (String)entityNumber);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseShowParameter lsp = (BaseShowParameter)this.getView().getFormShowParameter();
        if (lsp == null) {
            return;
        }
        if (lsp.getCustomParam(OPENFROMWORKCARD) instanceof Boolean) {
            boolean bl = (Boolean)lsp.getCustomParam(OPENFROMWORKCARD);
        }
    }

    protected void setInitializeData(BaseShowParameter lsp) {
        String entityNumber;
        Object wordcardid = lsp.getCustomParam("wordcardid");
        String wordcardfield = (String)lsp.getCustomParam("wordcardfield");
        if (wordcardid != null) {
            this.getModel().setValue(wordcardfield, wordcardid);
        }
        if ("mpdm_cardmatcommand".equals(entityNumber = (String)lsp.getCustomParam("entityNumber"))) {
            this.setMaterialInfo(wordcardid);
        }
        Object useOrgId = lsp.getCustomParam(USERORG);
        Object materialType = lsp.getCustomParam("materialType");
        this.getPageCache().put(CREATEORG, useOrgId.toString());
        this.getModel().beginInit();
        this.getModel().setValue(USERORG, useOrgId);
        this.getModel().setValue(CREATEORG, useOrgId);
        this.getModel().setValue("materialType", materialType);
        String fctrlstrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityNumber, (String)useOrgId.toString());
        this.getModel().setValue("ctrlstrategy", (Object)fctrlstrategy);
        this.getModel().endInit();
    }

    private void setMaterialInfo(Object wordcardid) {
        String selectFields = "id,number,auxproperty,createorg,material,unit,materialtype,materialtype.number,materialtype.name";
        DynamicObject workCard = BusinessDataServiceHelper.loadSingleFromCache((Object)wordcardid, (String)"mpdm_mrocardroute", (String)selectFields);
        if (workCard != null) {
            DynamicObject matObjTmp = workCard.getDynamicObject("material");
            this.getModel().setValue("materialtype", (Object)workCard.getDynamicObject("materialtype"));
            this.getModel().setValue("modelmpdone", null);
            if (matObjTmp == null) {
                this.getModel().setValue("productmaterial", null);
                this.getModel().setValue("auxproperty", null);
                return;
            }
            this.getModel().setValue("productmaterial", (Object)matObjTmp);
            this.getModel().setValue("auxproperty", workCard.get("auxproperty"));
        }
    }

    static {
        tabpageCardMap.put("mpdm_cardtooldemand", "workcard");
        tabpageCardMap.put("mpdm_cardmatcommand", "workcard");
        tabpageCardMap.put("mpdm_cardriskdef", "card");
        tabpageCardMap.put("mpdm_cbreaker", "cardnumber");
        tabpageCardMap.put("mpdm_cardimpexperience", "cardnum");
        tabpageCardMap.put("mpdm_cardskills", "cardnumber");
    }
}

