/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.QueryNameByEntityUtils;
import kd.bd.mpdm.common.utils.WorkcardDataInfoUtils;
import kd.bd.mpdm.common.wordcard.consts.FileCodeEntity;
import kd.bd.mpdm.formplugin.workcardinfo.SelectCardPhotoMain;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class WorkCardDataImportPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(WorkCardDataImportPlugin.class);
    private static final String KEY_PAGEENTITY = "pageentity";
    private static final String KEY_PROCESSENTRY = "processentry";
    private Map<Integer, String> errorMap = new HashMap<Integer, String>(16);
    private Map<String, DynamicObject> maintenequipmodelMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> functionlocationMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> panelNumberMap = new HashMap<String, DynamicObject>(16);
    private Map<String, DynamicObject> customerMap = new HashMap<String, DynamicObject>(16);
    private Map<String, BigDecimal> paneldefMap = new HashMap<String, BigDecimal>(16);
    private Map<String, FileCodeEntity> fileCodeEntityMap = new HashMap<String, FileCodeEntity>(16);

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        Map option = e.getOption();
        if (WorkCardDataImportPlugin.isfromapi(option)) {
            return;
        }
        List sourceDataList = e.getSourceDataList();
        this.maintenequipmodelMap = new HashMap<String, DynamicObject>(16);
        this.functionlocationMap = new HashMap<String, DynamicObject>(16);
        this.customerMap = new HashMap<String, DynamicObject>(16);
        this.fileCodeEntityMap = new HashMap<String, FileCodeEntity>(16);
        this.panelNumberMap = new HashMap<String, DynamicObject>(16);
        if (null != sourceDataList && sourceDataList.size() > 0) {
            HashSet filedSet = Sets.newHashSet((Object[])new String[]{"materialtype", "zone", "mulzone", "ata", "panelnumber"});
            Map MroCardMap = QueryNameByEntityUtils.queryNameMap((Set)filedSet, (String)"mpdm_mrocardroute");
            Long docType = 1539125409843563520L;
            for (Map sourceData : sourceDataList) {
                Object objEntry;
                Object objEntry1;
                String ata;
                Map mulzoneMap;
                String zoneName;
                Map zoneMap;
                int rowNum = (Integer)sourceData.get("rowNum");
                Map materialtypeMap = (Map)sourceData.get("materialtype");
                DynamicObject materialtype = null;
                if (materialtypeMap != null) {
                    String materialtypenumber = (String)materialtypeMap.get("number");
                    DynamicObject maintenequipmodel = this.getMaintenEquipModel(materialtypenumber);
                    if (maintenequipmodel == null) {
                        String materialtypeName = (String)MroCardMap.get("materialtype");
                        String format = String.format(ResManager.loadKDString((String)"%1$s%2$s\u672a\u5339\u914d\u5230\u5c42\u7ea7\u7c7b\u522bL1MPD\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_10", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), materialtypeName, materialtypenumber);
                        this.errorMap.put(rowNum, format);
                        continue;
                    }
                    HashMap<String, Object> materialtypeDO = new HashMap<String, Object>();
                    materialtypeDO.put("importprop", "id");
                    materialtypeDO.put("id", maintenequipmodel.getPkValue());
                    materialtypeDO.put("number", maintenequipmodel.getString("number"));
                    materialtypeDO.put("name", maintenequipmodel.getString("name"));
                    JSONObject materialtypeJson = new JSONObject(materialtypeDO);
                    sourceData.put("materialtype", materialtypeJson);
                    materialtype = maintenequipmodel;
                }
                if ((zoneMap = (Map)sourceData.get("zone")) != null) {
                    String zonenumber = (String)zoneMap.get("number");
                    DynamicObject zoneData = this.getFunctionLocation(zonenumber, materialtype);
                    if (zoneData == null) {
                        zoneName = (String)MroCardMap.get("zone");
                        String format = String.format(ResManager.loadKDString((String)"%1$s%2$s\u672a\u5339\u914d\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), zoneName, zonenumber);
                        this.errorMap.put(rowNum, format);
                        continue;
                    }
                    HashMap<String, Object> zoneDataDO = new HashMap<String, Object>();
                    zoneDataDO.put("importprop", "id");
                    zoneDataDO.put("id", zoneData.getPkValue());
                    zoneDataDO.put("number", zoneData.getString("number"));
                    zoneDataDO.put("name", zoneData.getString("name"));
                    JSONObject zoneDataJson = new JSONObject(zoneDataDO);
                    sourceData.put("zone", zoneDataJson);
                }
                if ((mulzoneMap = (Map)sourceData.get("mulzone")) != null) {
                    String zonenumber = (String)mulzoneMap.get("number");
                    zoneName = (String)mulzoneMap.get("name");
                    String[] split = zonenumber.split(",");
                    HashSet<String> mulzoneSet = new HashSet<String>(split.length);
                    for (String str : split) {
                        mulzoneSet.add(str);
                    }
                    Map<Object, DynamicObject> loadFromCache = this.getMulFunctionLocation(mulzoneSet, materialtype);
                    if (loadFromCache == null) {
                        String mulzoneName = (String)MroCardMap.get("mulzone");
                        String format = String.format(ResManager.loadKDString((String)"%1$s%2$s\u672a\u5339\u914d\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowNum, mulzoneName, zonenumber);
                        this.errorMap.put(rowNum, format);
                        continue;
                    }
                    if (loadFromCache.size() != split.length) {
                        HashSet<String> queryMulzone = new HashSet<String>(8);
                        for (Map.Entry<Object, DynamicObject> emap : loadFromCache.entrySet()) {
                            DynamicObject zoneval = emap.getValue();
                            queryMulzone.add(zoneval.getString("number"));
                        }
                        boolean removeAll = mulzoneSet.removeAll(queryMulzone);
                        if (mulzoneSet != null && mulzoneSet.size() > 0) {
                            String mulzoneName = (String)MroCardMap.get("mulzone");
                            String format = String.format(ResManager.loadKDString((String)"%1$s%2$s\u672a\u5339\u914d\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), rowNum, mulzoneName, zonenumber);
                            this.errorMap.put(rowNum, format);
                            continue;
                        }
                    } else {
                        HashMap<String, String> zoneDataDO = new HashMap<String, String>();
                        zoneDataDO.put("importprop", "id");
                        String collect = loadFromCache.keySet().stream().map(String::valueOf).collect(Collectors.joining(","));
                        zoneDataDO.put("id", collect);
                        zoneDataDO.put("number", zonenumber);
                        zoneDataDO.put("name", zoneName);
                        JSONObject zoneDataJson = new JSONObject(zoneDataDO);
                        sourceData.put("mulzone", zoneDataJson);
                    }
                }
                if ((ata = (String)sourceData.get("ata")) != null && ata.length() > 0) {
                    FileCodeEntity fileCode;
                    String customernumber;
                    DynamicObject bdcustomer;
                    Map customer = (Map)sourceData.get("customer");
                    String strCustomer = null;
                    if (customer != null && (bdcustomer = this.getCustomer(customernumber = (String)customer.get("number"))) != null) {
                        strCustomer = bdcustomer.getString("id");
                    }
                    if ((fileCode = this.getFileCodeEntity(ata, materialtype, strCustomer, docType)) == null) continue;
                    if (!fileCode.isAllowed()) {
                        String errMsg = fileCode.getErrMsg();
                        String ataName = (String)MroCardMap.get("ata");
                        this.errorMap.put(rowNum, String.format("%1$s%2$s", ataName, errMsg));
                        continue;
                    }
                    sourceData.put("ata", fileCode.getReturnMsg());
                }
                if ((objEntry1 = sourceData.get("entryentity1")) != null) {
                    JSONArray arrEntrys1 = (JSONArray)objEntry1;
                    ArrayList<JSONObject> panelEntity = new ArrayList<JSONObject>(arrEntrys1.size());
                    for (int i = 0; i < arrEntrys1.size(); ++i) {
                        Map panelnumberMap;
                        JSONObject entryObj = arrEntrys1.getJSONObject(i);
                        if (entryObj == null || !entryObj.containsKey((Object)"panelnumber") || (panelnumberMap = (Map)entryObj.get((Object)"panelnumber")) == null) continue;
                        String panelnum = (String)panelnumberMap.get("number");
                        DynamicObject panelnumData = this.getPanelNumber(panelnum, materialtype);
                        if (panelnumData == null) {
                            String zoneName2 = (String)MroCardMap.get("panelnumber");
                            String format = String.format(ResManager.loadKDString((String)"%1$s%2$s\u672a\u5339\u914d\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_9", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), zoneName2, panelnum);
                            this.errorMap.put(rowNum, format);
                            continue;
                        }
                        HashMap<String, Object> panelnumDO = new HashMap<String, Object>();
                        panelnumDO.put("importprop", "id");
                        panelnumDO.put("id", panelnumData.getPkValue());
                        panelnumDO.put("number", panelnumData.getString("number"));
                        panelnumDO.put("name", panelnumData.getString("name"));
                        JSONObject panelnumJson = new JSONObject(panelnumDO);
                        entryObj.put("panelnumber", (Object)panelnumJson);
                        panelEntity.add(entryObj);
                    }
                    if (!panelEntity.isEmpty()) {
                        sourceData.put("entryentity1", JSONArray.parseArray((String)JSON.toJSONString(panelEntity)));
                    }
                }
                if ((objEntry = sourceData.get(KEY_PAGEENTITY)) == null) continue;
                JSONArray arrEntrys = (JSONArray)objEntry;
                ArrayList<JSONObject> pageEntity = new ArrayList<JSONObject>(arrEntrys.size());
                String keystr = "";
                for (int i = 0; i < arrEntrys.size(); ++i) {
                    JSONObject entryObj = arrEntrys.getJSONObject(i);
                    Boolean issame = Boolean.TRUE;
                    if (entryObj == null) continue;
                    if (entryObj.containsKey((Object)"pageseq")) {
                        String pageseq = entryObj.getString("pageseq");
                        BigDecimal salehours = BigDecimal.ZERO;
                        if (entryObj.containsKey((Object)"salehours")) {
                            salehours = entryObj.getBigDecimal("salehours");
                        }
                        BigDecimal customesumhours = BigDecimal.ZERO;
                        if (entryObj.containsKey((Object)"customesumhours")) {
                            customesumhours = entryObj.getBigDecimal("customesumhours");
                        }
                        String pageremark = "";
                        if (entryObj.containsKey((Object)"pageremark")) {
                            pageremark = entryObj.getString("pageremark");
                        }
                        String key2 = pageseq + "@@" + salehours + "@@" + customesumhours + "@@" + pageremark;
                        if (keystr.length() <= 0) {
                            keystr = key2;
                            issame = Boolean.FALSE;
                        } else if (!keystr.equals(key2)) {
                            keystr = key2;
                            issame = Boolean.FALSE;
                        }
                    }
                    if (issame.booleanValue()) continue;
                    pageEntity.add(entryObj);
                }
                if (pageEntity.isEmpty()) continue;
                sourceData.put(KEY_PAGEENTITY, JSONArray.parseArray((String)JSON.toJSONString(pageEntity)));
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        JSONArray entryJsonArray;
        int rowNum;
        String errorMsg;
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        Map option = e.getOption();
        if (WorkCardDataImportPlugin.isfromapi(option)) {
            return;
        }
        if (sourceData.get("rowNum") != null && (errorMsg = this.errorMap.get(rowNum = ((Integer)sourceData.get("rowNum")).intValue())) != null) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), errorMsg);
            e.setFireAfterImportData(false);
        }
        if ((entryJsonArray = (JSONArray)JSON.toJSON(sourceData.get(KEY_PAGEENTITY))) != null && !entryJsonArray.isEmpty()) {
            this.validataEntry(e, sourceData);
        }
    }

    private boolean validataEntry(BeforeImportDataEventArgs e, Map<String, Object> sourceData) {
        HashSet filedSet = Sets.newHashSet((Object[])new String[]{"pageseq", "pageseq1"});
        Map MroCardMap = QueryNameByEntityUtils.queryNameMap((Set)filedSet, (String)"mpdm_mrocardroute");
        StringBuilder sb2 = new StringBuilder();
        JSONArray entryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get(KEY_PAGEENTITY));
        HashMap tempMap = new HashMap(16);
        HashMap<String, Long> pageidMap = new HashMap<String, Long>(16);
        for (int i = 0; i < entryJsonArray.size(); ++i) {
            ArrayList<String> tList;
            JSONObject entryJson = (JSONObject)entryJsonArray.get(i);
            if (!entryJson.containsKey((Object)"pageseq")) continue;
            int n = entryJson.getInteger("rowNum");
            String pageseq = entryJson.getString("pageseq");
            boolean flag = true;
            int j = pageseq.length();
            while (--j >= 0) {
                if (Character.isDigit(pageseq.charAt(j))) continue;
                flag = false;
                break;
            }
            if (!flag) {
                sb2.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\u4e0d\u4e3a\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MroCardMap.get("pageseq"), n + 1));
                continue;
            }
            int newValue = NumberUtils.toInt((String)pageseq);
            if (newValue <= 0) {
                sb2.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\u4e0d\u4e3a\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_7", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MroCardMap.get("pageseq"), n + 1));
                continue;
            }
            if (tempMap.containsKey(pageseq)) {
                tList = (ArrayList<String>)tempMap.get(pageseq);
                tList.add(String.valueOf(n + 1));
                tempMap.put(pageseq, tList);
            } else {
                tList = new ArrayList<String>(8);
                tList.add(String.valueOf(n + 1));
                tempMap.put(pageseq, tList);
            }
            if (!entryJson.containsKey((Object)"id")) continue;
            Long pageentityid = entryJson.getLong("id");
            pageidMap.put(pageseq, pageentityid);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : tempMap.entrySet()) {
            List value = (List)entry.getValue();
            if (value.size() <= 1) continue;
            String join = String.join((CharSequence)"\u3001", value);
            String sub = join.substring(2, join.length());
            sb.append(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u4e0e\u7b2c%3$s\u884c\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_8", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MroCardMap.get("pageseq"), value.get(0), sub));
        }
        if (sb2.toString().length() > 0) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), sb2.toString());
            e.setFireAfterImportData(false);
        }
        if (sb.toString().length() > 0) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), sb.toString());
            e.setFireAfterImportData(false);
        }
        e.getOption().put("cardpage", tempMap);
        e.getOption().put("pagename", MroCardMap);
        if (!pageidMap.isEmpty()) {
            e.getOption().put("pageid", pageidMap);
        }
        if (!tempMap.isEmpty()) {
            HashSet<String> pageSeqSet = new HashSet<String>(16);
            HashMap<String, String> hashMap = new HashMap<String, String>(16);
            JSONArray processentryJsonArray = (JSONArray)JSON.toJSON((Object)sourceData.get(KEY_PROCESSENTRY));
            if (processentryJsonArray == null) {
                return true;
            }
            for (int i = 0; i < processentryJsonArray.size(); ++i) {
                JSONObject rowJson = (JSONObject)processentryJsonArray.get(i);
                int rowNum2 = rowJson.getInteger("rowNum");
                String pageseq2 = rowJson.getString("pageseq1");
                if (pageseq2 == null || pageseq2.isEmpty()) {
                    pageSeqSet.add(String.valueOf(rowNum2 + 1));
                    continue;
                }
                if (tempMap.containsKey(pageseq2)) continue;
                hashMap.put(String.valueOf(rowNum2 + 1), pageseq2);
            }
            if (!pageSeqSet.isEmpty()) {
                e.setCancel(true);
                StringBuilder error = new StringBuilder();
                String join = String.join((CharSequence)"\u3001", pageSeqSet);
                error.append(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5fc5\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_5", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MroCardMap.get("pageseq1"), join));
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), error.toString());
                e.setFireAfterImportData(false);
            }
            if (!hashMap.isEmpty()) {
                e.setCancel(true);
                StringBuilder error = new StringBuilder();
                for (Map.Entry row : hashMap.entrySet()) {
                    String key = (String)row.getKey();
                    String value = (String)row.getValue();
                    error.append(String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u3010%3$s\u3011\u4e0e%4$s\u884c\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_6", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MroCardMap.get("pageseq1"), key, value, MroCardMap.get("pageseq")));
                }
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), error.toString());
                e.setFireAfterImportData(false);
            }
        }
        return true;
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map option = e.getOption();
        Boolean generatePthoto = Boolean.FALSE;
        String importtype = (String)e.getOption().get("importtype");
        IDataModel model = this.getModel();
        long cardid = (Long)model.getDataEntity().getPkValue();
        boolean fromDatabase = model.getDataEntity().getDataEntityState().getFromDatabase();
        if (cardid != 0L && fromDatabase) {
            Set<String> diffFieldSet = SelectCardPhotoMain.getDataDiffField(this.getModel());
            logger.info("diffFieldSet----import---" + diffFieldSet);
            DynamicObject cardtype = (DynamicObject)model.getValue("cardtype");
            String photodimension = (String)cardtype.get("photodimension");
            logger.info("cardversion--photodimension----import----" + photodimension);
            if ("B".equals(photodimension) && diffFieldSet.contains("cardversion") || diffFieldSet.size() > 0 && "A".equals(photodimension)) {
                generatePthoto = Boolean.TRUE;
            }
        } else {
            generatePthoto = Boolean.TRUE;
        }
        if (generatePthoto.booleanValue()) {
            model.setValue("isgeneratephoto", (Object)Boolean.TRUE);
        } else {
            model.setValue("isgeneratephoto", (Object)Boolean.FALSE);
        }
        DynamicObjectCollection pageentity = model.getEntryEntity(KEY_PAGEENTITY);
        if (pageentity == null || pageentity.isEmpty()) {
            return;
        }
        if (("overridenew".equals(importtype) || "override".equals(importtype)) && e.getOption().containsKey("cardpage")) {
            Map tempMap = (Map)e.getOption().get("cardpage");
            Map MroCardMap = (Map)e.getOption().get("pagename");
            if (tempMap != null && !tempMap.isEmpty()) {
                String checkRepeatPage;
                Map<String, Long> pageidMap = new HashMap<String, Long>(16);
                if (e.getOption().containsKey("pageid")) {
                    pageidMap = (Map)e.getOption().get("pageid");
                }
                if ((checkRepeatPage = this.checkRepeatPage(tempMap, pageentity, MroCardMap, pageidMap)).length() > 0) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), checkRepeatPage);
                    return;
                }
            }
        }
        ORM orm = ORM.create();
        long[] ids = orm.genLongIds("mpdm_processversion", pageentity.size());
        int pindex = 0;
        HashMap<String, Long> pageMap = new HashMap<String, Long>(pageentity.size());
        this.getModel().deleteEntryData("entryentity");
        for (int index = 0; index < pageentity.size(); ++index) {
            DynamicObject pagerow = (DynamicObject)pageentity.get(index);
            String pageseq = (String)model.getValue("pageseq", index);
            Long pkValue = (Long)pagerow.getPkValue();
            if ("overridenew".equals(importtype) && pkValue == 0L || "new".equals(importtype)) {
                model.setValue("pageentity.id", (Object)ids[pindex], index);
                this.initEntryentityVersion(ids[pindex], true);
                pkValue = ids[pindex];
            } else if (pkValue == 0L) {
                model.setValue("pageentity.id", (Object)ids[pindex], index);
                this.initEntryentityVersion(ids[pindex], true);
                pkValue = ids[pindex];
            } else {
                this.initEntryentityVersion(pkValue, true);
            }
            pageMap.put(pageseq, pkValue);
            ++pindex;
        }
        DynamicObjectCollection processentry = model.getEntryEntity(KEY_PROCESSENTRY);
        if (processentry == null || processentry.isEmpty()) {
            return;
        }
        HashMap pagehourmap = new HashMap(pageentity.size());
        HashMap pagehourmap2 = new HashMap(pageentity.size());
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        Long previd = 0L;
        int preindex = 0;
        for (int index = 0; index < processentry.size(); ++index) {
            Long vid;
            DynamicObject processrow = (DynamicObject)processentry.get(index);
            String pageseq1 = processrow.getString("pageseq1");
            BigDecimal standardhours = processrow.getBigDecimal("standardhours");
            BigDecimal customhours = processrow.getBigDecimal("customhours");
            if ("new".equals(importtype) && customhours.compareTo(BigDecimal.ZERO) <= 0) {
                model.setValue("customhours", (Object)standardhours, index);
                customhours = standardhours;
            }
            if ((vid = (Long)pageMap.get(pageseq1)) != null && vid > 0L) {
                if (preindex == 0) {
                    previd = vid;
                }
                if (!previd.equals(vid)) {
                    preindex = 0;
                    previd = vid;
                }
                model.setValue("versionid", (Object)vid, index);
                String entryProcessseq = WorkcardDataInfoUtils.getEntryProcessseq((DynamicObjectCollection)entryentity, (Long)vid);
                model.setValue("parent", (Object)entryProcessseq, index);
                if (processrow.get("machiningtype") == null) {
                    model.setValue("machiningtype", (Object)"1001", index);
                }
                if (processrow.get("productionorg") == null) {
                    model.setValue("productionorg", model.getValue("createorg"), index);
                }
                if (processrow.get("oprctrlstrategy") == null) {
                    model.setValue("oprctrlstrategy", (Object)1426881277977454592L, index);
                }
                model.setValue("operationno", (Object)((preindex + 1) * 10), index);
                WorkcardDataInfoUtils.getPageHour(pagehourmap, (Long)vid, (BigDecimal)standardhours);
                WorkcardDataInfoUtils.getPageHour(pagehourmap2, (Long)vid, (BigDecimal)customhours);
                ++preindex;
            }
            this.dealProcessActivity(processrow, model, index);
        }
        if (!pagehourmap.isEmpty()) {
            for (DynamicObject pagerow : pageentity) {
                int index = pagerow.getInt("seq") - 1;
                Long pkValue = (Long)pagerow.getPkValue();
                BigDecimal pagesumhours = (BigDecimal)pagehourmap.get(pkValue);
                BigDecimal customesumhours = (BigDecimal)pagehourmap2.get(pkValue);
                model.setValue("pagesumhours", (Object)(pagesumhours == null ? BigDecimal.ZERO : pagesumhours), index);
                model.setValue("customesumhours", (Object)(customesumhours == null ? BigDecimal.ZERO : customesumhours), index);
                model.setValue("calsumhours", (Object)(customesumhours == null ? BigDecimal.ZERO : customesumhours), index);
            }
        }
        this.dealPanelsumhours();
    }

    private void initEntryentityVersion(Long versionID, boolean isadd) {
        IDataModel model = this.getModel();
        int count = this.getModel().getEntryRowCount("entryentity");
        boolean isfind = false;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        for (int i = 0; i < count; ++i) {
            Object pageversionid = model.getValue("pageversionid", i);
            if (isadd) {
                if (pageversionid != null && !"0".equals(pageversionid.toString())) continue;
                model.setValue("processseqname", (Object)ResManager.loadKDString((String)"\u4e3b\u5e8f\u5217", (String)"WorkCardDataImportPlugin_3", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), i);
                model.setValue("pageversionid", (Object)versionID, i);
                model.setValue("processseqtype", (Object)"A", i);
                model.setValue("processseq", (Object)(i + 1), i);
                isfind = true;
                break;
            }
            if (pageversionid == null || !pageversionid.toString().equals(versionID.toString())) continue;
            entryGrid.selectRows(i);
            this.getView().invokeOperation("deleteentry_seq");
        }
        if (isadd && !isfind) {
            this.getView().invokeOperation("newentry_seq");
            this.initEntryentityVersion(versionID, isadd);
        }
    }

    private void dealProcessActivity(DynamicObject processrow, IDataModel model, int index) {
        DynamicObjectCollection actentryentity = processrow.getDynamicObjectCollection("actentryentity");
        if (actentryentity.size() < 1) {
            DynamicObject addNew = actentryentity.addNew();
            int rowNumber = actentryentity.size() - 1;
            model.setValue("activity", (Object)1253659859950239744L, rowNumber, index);
            model.setValue("processstage", (Object)"A", rowNumber, index);
            model.setValue("standardformula", (Object)1001265111022772224L, rowNumber, index);
            model.setValue("standardformula1", (Object)1004164543855059968L, rowNumber, index);
        } else {
            for (int i = 0; i < actentryentity.size(); ++i) {
                DynamicObject row = (DynamicObject)actentryentity.get(i);
                DynamicObject activity = row.getDynamicObject("activity");
                if (activity != null) continue;
                model.setValue("activity", (Object)1253659859950239744L, i, index);
                model.setValue("processstage", (Object)"A", i, index);
                model.setValue("standardformula", (Object)1001265111022772224L, i, index);
                model.setValue("standardformula1", (Object)1004164543855059968L, i, index);
            }
        }
    }

    private void dealPanelsumhours() {
        DynamicObjectCollection panel = this.getModel().getEntryEntity("entryentity1");
        for (DynamicObject rowpanel : panel) {
            DynamicObject panelnumber = rowpanel.getDynamicObject("panelnumber");
            if (panelnumber == null) continue;
            BigDecimal totalhours = this.getPaneldefWorkhours(panelnumber.getLong("id"));
            int rowIndex = rowpanel.getInt("seq") - 1;
            this.getModel().setValue("panelsumhours", (Object)totalhours, rowIndex);
        }
    }

    private String checkRepeatPage(Map<String, List<String>> tempMap, DynamicObjectCollection pageentity, Map<String, String> MroCardMap, Map<String, Long> pageidMap) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject pagerow : pageentity) {
            String pageseq = pagerow.getString("pageseq");
            Long pageimportid = pageidMap.get(pageseq);
            Long pageid = (Long)pagerow.getPkValue();
            if (pageid == 0L || pageid.equals(pageimportid) || !tempMap.containsKey(pageseq)) continue;
            List<String> list = tempMap.get(pageseq);
            sb.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\u6570\u636e%3$s\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataImportPlugin_11", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), MroCardMap.get("pageseq"), String.join((CharSequence)"\u3001", list), pageseq));
        }
        return sb.toString();
    }

    private static boolean isfromapi(Map<String, Object> option) {
        return option != null && option.isEmpty() || RequestContext.get().getClient().equals("api");
    }

    private DynamicObject getMaintenEquipModel(String number) {
        DynamicObject data = this.maintenequipmodelMap.get(number);
        if (data == null && !this.maintenequipmodelMap.containsKey(number)) {
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            qFilter.and(new QFilter("group.number", "=", (Object)"modelmpdone"));
            data = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_maintenequipmodel", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
            this.maintenequipmodelMap.put(number, data);
        }
        return data;
    }

    private BigDecimal getPaneldefWorkhours(Long pkID) {
        String keyString = String.valueOf(pkID);
        BigDecimal data = this.paneldefMap.get(keyString);
        if (data == null && !this.paneldefMap.containsKey(keyString)) {
            data = BigDecimal.ZERO;
            DynamicObject paneldef = BusinessDataServiceHelper.loadSingleFromCache((Object)pkID, (String)"mpdm_paneldef");
            if (paneldef != null) {
                DynamicObjectCollection paneltimes = paneldef.getDynamicObjectCollection("paneltimes");
                for (DynamicObject row : paneltimes) {
                    String paneltimetype;
                    DynamicObject progroup = row.getDynamicObject("progroup");
                    if (progroup == null || !"A".equals(paneltimetype = progroup.getString("paneltimetype")) && !"B".equals(paneltimetype)) continue;
                    data = data.add(row.getBigDecimal("workhours"));
                }
            }
            this.paneldefMap.put(keyString, data);
        }
        return data;
    }

    private DynamicObject getCustomer(String number) {
        DynamicObject data = this.customerMap.get(number);
        if (data == null && !this.customerMap.containsKey(number)) {
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            data = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
            this.customerMap.put(number, data);
        }
        return data;
    }

    private DynamicObject getPanelNumber(String number, DynamicObject materialtype) {
        String keyString = number + "_" + (materialtype == null ? "" : materialtype.getPkValue());
        DynamicObject data = this.panelNumberMap.get(keyString);
        if (data == null && !this.panelNumberMap.containsKey(keyString)) {
            QFilter qf = new QFilter("enable", "=", (Object)"1");
            qf.and(new QFilter("status", "=", (Object)"C"));
            if (materialtype == null) {
                qf.and(new QFilter("materialtype", "=", (Object)0L).or("materialtype", "is null", null));
            } else {
                qf.and(new QFilter("materialtype", "=", materialtype.getPkValue()));
            }
            qf.and(new QFilter("number", "=", (Object)number));
            data = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_paneldef", (String)"id,number", (QFilter[])new QFilter[]{qf});
            this.panelNumberMap.put(keyString, data);
        }
        return data;
    }

    private DynamicObject getFunctionLocation(String number, DynamicObject materialtype) {
        String keyString = number + "_" + (materialtype == null ? "" : materialtype.getPkValue());
        DynamicObject data = this.functionlocationMap.get(keyString);
        if (data == null && !this.functionlocationMap.containsKey(keyString)) {
            QFilter qf = new QFilter("enable", "=", (Object)"1");
            qf.and(new QFilter("status", "=", (Object)"C"));
            if (materialtype == null) {
                qf.and(new QFilter("materialtype", "=", (Object)0L).or("materialtype", "is null", null));
            } else {
                qf.and(new QFilter("materialtype", "=", materialtype.getPkValue()));
            }
            qf.and(new QFilter("number", "=", (Object)number));
            data = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_functionlocation", (String)"id,number", (QFilter[])new QFilter[]{qf});
            this.functionlocationMap.put(keyString, data);
        }
        return data;
    }

    private Map<Object, DynamicObject> getMulFunctionLocation(Set<String> numberSet, DynamicObject materialtype) {
        HashMap<Object, DynamicObject> datas = new HashMap<Object, DynamicObject>(numberSet.size());
        for (String number : numberSet) {
            DynamicObject data = this.getFunctionLocation(number, materialtype);
            if (data == null) continue;
            datas.put(data.getPkValue(), data);
        }
        return datas;
    }

    private FileCodeEntity getFileCodeEntity(String ata, DynamicObject materialtype, String strCustomer, Long docType) {
        String keyString = ata + "_" + (materialtype == null ? "" : materialtype.getPkValue()) + "_" + (strCustomer == null ? "" : strCustomer) + "_" + String.valueOf(docType);
        FileCodeEntity data = this.fileCodeEntityMap.get(keyString);
        if (data == null && !this.fileCodeEntityMap.containsKey(keyString)) {
            Object invokeBizService;
            HashSet<String> mroModels = new HashSet<String>(4);
            if (materialtype != null) {
                mroModels.add(materialtype.getString("id"));
            }
            if ((invokeBizService = DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"FileCodeRuleService", (String)"getValidStrByTextInput", (Object[])new Object[]{ata, mroModels, strCustomer, null, docType, "mpdm_mrocardroute"})) != null) {
                data = (FileCodeEntity)invokeBizService;
            }
            this.fileCodeEntityMap.put(keyString, data);
        }
        return data;
    }
}

