/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workcardinfo;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.WorkcardDataInfoUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.servicehelper.BillTypeDifferentialHelper;

public class WorkCardTypeControlEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String proName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        for (int i = 0; i < changeData.length; ++i) {
            ChangeData dataObj = changeData[i];
            if (!"basedata".equals(proName)) continue;
            int index = model.getEntryCurrentRowIndex("entryentity");
            DynamicObjectCollection entryCol = model.getEntryEntity("entryentity");
            this.loadField(view, model, (DynamicObject)entryCol.get(index), dataObj, index);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        if (entryGrid.getSelectRows() != null && entryGrid.getSelectRows().length > 0) {
            this.getModel().setEntryCurrentRowIndex("entryentity", 0);
            entryGrid.selectRows(0);
            this.enableCurrentEntryData(model);
        } else {
            int count = this.getModel().getEntryRowCount("entryentity");
            if (count > 0) {
                this.getModel().setEntryCurrentRowIndex("entryentity", 0);
                entryGrid.selectRows(0);
                this.enableCurrentEntryData(model);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)entryGrid.getKey())) {
            if (entryGrid.getSelectRows() != null && entryGrid.getSelectRows().length > 0) {
                this.enableCurrentEntryData(model);
            } else {
                this.getModel().setEntryCurrentRowIndex("entryentity", 0);
                entryGrid.selectRows(0);
                this.enableCurrentEntryData(model);
            }
        }
    }

    public String getPreStr(IDataEntityType dataEntityType, String formNum, String retFieldNum) {
        String pFieldNum = dataEntityType.getName();
        if (pFieldNum == null || pFieldNum.equals(formNum)) {
            return retFieldNum;
        }
        String newFielNum = pFieldNum + "." + retFieldNum;
        IDataEntityType pDataEntityType = dataEntityType.getParent();
        return this.getPreStr(pDataEntityType, formNum, newFielNum);
    }

    public void loadField(IFormView view, IDataModel model, DynamicObject entryObj, ChangeData dataObj, int index) {
        Object newObj = dataObj.getNewValue();
        Object oldObj = dataObj.getOldValue();
        if (newObj == null) {
            this.getModel().setValue("basedata", oldObj, index);
            return;
        }
        DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
        model.deleteEntryData("subentryentity");
        DynamicObject object = entryObj.getDynamicObject("basedata");
        String formNum = object.getString("number");
        Map fieldMap = BillTypeDifferentialHelper.getFullControlInfos((String)formNum);
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)formNum).getAllFields();
        Set allFieldSet = allFieldMap.entrySet();
        for (Map.Entry entry : allFieldSet) {
            String fieldNum = (String)entry.getKey();
            BillTypeControlInfo info = (BillTypeControlInfo)fieldMap.get(fieldNum);
            if (info == null) continue;
            String fieldName = info.getFieldName();
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entry.getValue();
            IDataEntityType dataEntityType = dataEntityProperty.getParent();
            String pFieldNum = dataEntityType.getName();
            DynamicObject newSubEntry = subEntryCol.addNew();
            if (pFieldNum == null || pFieldNum.equals(formNum)) {
                newSubEntry.set("fieldname", (Object)fieldName);
                newSubEntry.set("field", (Object)fieldNum);
            } else {
                fieldNum = this.getPreStr(dataEntityType, formNum, fieldNum);
                newSubEntry.set("fieldname", (Object)fieldName);
                newSubEntry.set("field", (Object)fieldNum);
            }
            if (!info.isMustInput()) continue;
            newSubEntry.set("mustinput", (Object)Boolean.TRUE);
            int rowCount = subEntryCol.getRowCount();
            if (rowCount > 0) {
                --rowCount;
            }
            this.getView().setEnable(Boolean.FALSE, rowCount, new String[]{"mustinput"});
        }
        view.updateView("subentryentity");
    }

    private void enableCurrentEntryData(IDataModel model) {
        int index = model.getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entryCol = model.getEntryEntity("entryentity");
        DynamicObject entryObj = (DynamicObject)entryCol.get(index);
        DynamicObject entryRow = entryObj.getDynamicObject("basedata");
        if (entryRow != null) {
            DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
            int rowCount = subEntryCol.getRowCount();
            String entityNum = entryRow.getString("number");
            Map mustInputKeys = WorkcardDataInfoUtils.getMustInputKeys((String)entityNum);
            for (int i = rowCount - 1; i >= 0; --i) {
                DynamicObject row = (DynamicObject)subEntryCol.get(i);
                if (!mustInputKeys.containsKey(row.getString("field"))) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"mustinput"});
                row.set("mustinput", (Object)Boolean.TRUE);
            }
        }
    }
}

